/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.models.IWithDisposable;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.cache.CacheEventResource;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import com.semarchy.xdi.designer.core.services.cache.ICacheState;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.index.Activator;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.CacheListenerServiceTrackerCustomizer;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CacheState
implements ICacheState,
IWithDisposable.IDisposable {
    private ServiceTracker<ICacheListener, ICacheListener> cacheListenerTracker;
    private CacheListenerServiceTrackerCustomizer cacheListeners;
    private Set<Elt> elementInexistent = Collections.synchronizedSet(new HashSet());
    private Set<Elt> elementWithRefToElementInexistent = new HashSet<Elt>();
    private Set<Source> sourceWithElementInexistent = new HashSet<Source>();
    private Set<Source> sourceWithRefToElementInexistent = new HashSet<Source>();
    private Set<Source> sourceWithfeatureNotFound = Collections.synchronizedSet(new HashSet());
    private Set<URI> sourceWithBrokenRequirement = Collections.synchronizedSet(new HashSet());
    private Set<URI> unbuiltResources = new HashSet<URI>();
    private HashMap<URI, Integer> sourceInError = new HashMap();
    private Map<URI, ICacheState.IUnparsedResourceInfo> unparseableResources = Collections.synchronizedMap(new HashMap());
    private Map<URI, ICacheState.IUnparsedResourceInfo> invalidXMLResources = Collections.synchronizedMap(new HashMap());
    private Set<URI> outdatedResources = Collections.synchronizedSet(new HashSet());
    private Map<URI, IComponentService.IComponent> resourceDiscardedByMissingRole = Collections.synchronizedMap(new HashMap());
    private Map<URI, ICacheState.IUnparsedResourceInfo> resourcesWithDuplicatedID = Collections.synchronizedMap(new HashMap());
    private Job triggerJob = new Job("CacheState Trigger"){

        private List<ICacheListener> getRegisteredListeners() {
            if (CacheState.this.cacheListeners == null) {
                return Collections.emptyList();
            }
            return CacheState.this.cacheListeners.getListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ArrayList events = new ArrayList();
            List list = CacheState.this.cachedEvent;
            synchronized (list) {
                events.addAll(CacheState.this.cachedEvent);
                CacheState.this.cachedEvent.clear();
            }
            for (Object o : events) {
                if (!monitor.isCanceled()) {
                    for (ICacheListener l : this.getRegisteredListeners()) {
                        try {
                            if (o instanceof CacheEventResource && l.handleEvent((CacheEventResource)o)) {
                                CacheEventResource.EventType eventType = ((CacheEventResource)o).getEventType();
                                if (eventType == CacheEventResource.EventType.UNBUILT) {
                                    l.resourceBuildStateChanged((CacheEventResource)o);
                                    continue;
                                }
                                if (eventType != CacheEventResource.EventType.ERROR) continue;
                                l.resourceErrorStateChanged((CacheEventResource)o);
                                continue;
                            }
                            if (!(o instanceof CacheEventURI) || !l.handleEvent((CacheEventURI)o)) continue;
                            l.handleCacheSourceChanged((CacheEventURI)o);
                        }
                        catch (Exception t) {
                            CacheState.this.logger.error(Messages.CacheState_6, (Throwable)t);
                        }
                    }
                    for (ICacheListener l : this.getRegisteredListeners()) {
                        try {
                            l.handleEventsTriggered();
                        }
                        catch (Exception t) {
                            CacheState.this.logger.error(Messages.CacheState_6, (Throwable)t);
                        }
                    }
                    continue;
                }
                CacheState.this.cachedEvent.addAll(events.subList(events.indexOf(o), events.size()));
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private static final int PARSE = 1;
    private static final int CROSSREF = 2;
    private static final int ERROR = 3;
    private static final int BROKEN_REQUIREMENT = 3;
    private static final int LICENSED = 4;
    private List<Object> cachedEvent = Collections.synchronizedList(new ArrayList());
    private boolean eventsTriggerLocked = false;
    private Logger logger = LogManager.getLogger(CacheState.class);

    public Map<URI, ICacheState.IUnparsedResourceInfo> getInvalidXMLResources() {
        return this.invalidXMLResources;
    }

    public void addInvalidResource(URI resource, ICacheState.IUnparsedResourceInfo info) {
        if (resource != null) {
            this.invalidXMLResources.put(resource, info);
        }
    }

    public ICacheState.IUnparsedResourceInfo removeInvalidResource(URI resource) {
        if (resource != null) {
            return this.invalidXMLResources.remove(resource);
        }
        return null;
    }

    public void addUnparsedResource(URI resource, ICacheState.IUnparsedResourceInfo info) {
        if (resource != null) {
            this.unparseableResources.put(resource, info);
            this.handleErrorAdded(resource, 1, null);
        }
    }

    public ICacheState.IUnparsedResourceInfo removeUnparsedResource(URI resource) {
        if (resource != null) {
            ICacheState.IUnparsedResourceInfo i = this.unparseableResources.remove(resource);
            this.handleErrorRemoved(resource, 1, null);
            return i;
        }
        return null;
    }

    public Map<URI, IComponentService.IComponent> getDiscardedByLicense() {
        return this.resourceDiscardedByMissingRole;
    }

    public Map<URI, ICacheState.IUnparsedResourceInfo> getUnparsedResources() {
        return this.unparseableResources;
    }

    public Collection<URI> getUnbuiltResources() {
        return this.unbuiltResources;
    }

    public Collection<URI> getOutdatedResources() {
        return this.outdatedResources;
    }

    public boolean addOutdated(URI r) {
        return this.outdatedResources.add(r);
    }

    public boolean removeOutdated(URI r) {
        return this.outdatedResources.remove(r);
    }

    public boolean addUnbuilt(URI r) {
        if (r != null && this.unbuiltResources.add(r)) {
            this.notifyListeners(new CacheEventResource(1, CacheEventResource.EventType.UNBUILT, r, null));
            return true;
        }
        return false;
    }

    public boolean removeUnbuilt(URI r) {
        if (r != null && this.unbuiltResources.remove(r)) {
            this.notifyListeners(new CacheEventResource(2, CacheEventResource.EventType.UNBUILT, r, null));
            return true;
        }
        return false;
    }

    public CacheState() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        this.cacheListeners = new CacheListenerServiceTrackerCustomizer(context);
        this.cacheListenerTracker = new ServiceTracker(context, ICacheListener.class.getName(), (ServiceTrackerCustomizer)this.cacheListeners);
        this.cacheListenerTracker.open();
    }

    public void dispose() {
        this.cacheListenerTracker.close();
    }

    public void lockEventTrigger() {
        this.eventsTriggerLocked = true;
    }

    public void unlockEventTrigger() {
        if (this.eventsTriggerLocked) {
            this.eventsTriggerLocked = false;
            this.handleEventTriggered();
        }
    }

    private void notifyListeners(CacheEventResource event) {
        this.cachedEvent.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyseProblem(CacheImpl cache) {
        try {
            HashSet<Elt> localElementInexistent = new HashSet<Elt>();
            HashSet<Elt> localElementWithRefToElementInexistent = new HashSet<Elt>();
            HashSet<Source> localSourceWithElementInexistent = new HashSet<Source>();
            HashSet<Source> localSourceWithRefToElementInexistent = new HashSet<Source>();
            ArrayList<Elt> cacheElt = new ArrayList<Elt>();
            ArrayList<URI> cacheUnbuilt = new ArrayList<URI>();
            ArrayList<URI> cacheUnparsable = new ArrayList<URI>();
            ArrayList<URI> cacheBroken = new ArrayList<URI>();
            CacheImpl cacheImpl = cache;
            synchronized (cacheImpl) {
                cacheElt.addAll((Collection<Elt>)cache.getSuper().getElt());
                this.sourceWithfeatureNotFound = Collections.synchronizedSet(cache.getSuper().getResource().stream().filter(s -> s.getRemark().get((Object)"com.stambia.resource.marker.featureNotFound") != null).collect(Collectors.toSet()));
                Set<Source> set = this.sourceWithRefToElementInexistent;
                synchronized (set) {
                    localSourceWithRefToElementInexistent.addAll(this.sourceWithRefToElementInexistent);
                }
            }
            cacheUnbuilt.addAll(this.getUnbuiltResources());
            cacheUnparsable.addAll(this.getUnparsedResources().keySet());
            cacheBroken.addAll(this.getBrokenSource());
            for (Elt elt : cacheElt) {
                if (!elt.getState().equals((Object)StateType.INEXISTENT)) continue;
                localElementInexistent.add(elt);
                localElementWithRefToElementInexistent.addAll((Collection<Elt>)elt.getUsage());
                if (elt.getSource() != null) {
                    localSourceWithElementInexistent.add(elt.getSource());
                }
                for (Elt ref : elt.getUsage()) {
                    if (ref.getSource() == null) continue;
                    localSourceWithRefToElementInexistent.add(ref.getSource());
                }
            }
            this.elementInexistent = localElementInexistent;
            this.elementWithRefToElementInexistent = localElementWithRefToElementInexistent;
            this.updateSourceWithElementInexistent(localSourceWithElementInexistent);
            this.updateSourceWithRefToElementInexistent(localSourceWithRefToElementInexistent);
            this.updateBrokenResource(cacheBroken);
            if (!this.eventsTriggerLocked) {
                this.handleEventTriggered();
            }
        }
        catch (Exception ex) {
            this.logger.error(Messages.CacheState_2, (Throwable)ex);
        }
    }

    private Collection<URI> getBrokenSource() {
        return (Collection)E4InjectorHelper.consumeServiceWithResult(ICacheState.IBrokenSourceProvider.class, s -> s.getSourceWithBrokenRequirement());
    }

    private void handleEventTriggered() {
        this.triggerJob.cancel();
        this.triggerJob.schedule(100L);
    }

    private void updateBrokenResource(Collection<URI> brokenSource) {
        Iterator<URI> it = this.sourceWithBrokenRequirement.iterator();
        while (it.hasNext()) {
            URI f = it.next();
            if (brokenSource.contains(f)) continue;
            it.remove();
            if (f == null) continue;
            this.handleErrorRemoved(f, 3, null);
        }
        for (URI s : brokenSource) {
            if (s == null || this.sourceWithBrokenRequirement.contains(s)) continue;
            this.sourceWithBrokenRequirement.add(s);
            this.handleErrorAdded(s, 3, null);
        }
    }

    private void handleErrorRemoved(URI s, int parse2, String sourceID) {
        Integer i = this.sourceInError.get(s);
        if (i != null) {
            int flag = i;
            if ((flag &= ~parse2) == 0) {
                this.sourceInError.remove(s);
                this.notifyListeners(new CacheEventResource(2, CacheEventResource.EventType.ERROR, s, sourceID));
            }
        }
    }

    private void handleErrorAdded(URI s, int parse2, String sourceID) {
        int flag;
        Integer i = this.sourceInError.get(s);
        int n = flag = i == null ? parse2 : i | parse2;
        if (flag != 0) {
            this.sourceInError.put(s, flag);
        }
        if (i == null) {
            this.notifyListeners(new CacheEventResource(1, CacheEventResource.EventType.ERROR, s, sourceID));
        }
    }

    private void updateSourceWithElementInexistent(Set<Source> sourceWithElementInexistent) {
        Iterator<Source> it = this.sourceWithElementInexistent.iterator();
        while (it.hasNext()) {
            Source s = it.next();
            if (s == null || s.eResource() != null && sourceWithElementInexistent.contains(s)) continue;
            it.remove();
            this.handleErrorRemoved(s.getURI(), 3, s.getId());
        }
        sourceWithElementInexistent.removeAll(this.sourceWithElementInexistent);
        for (Source s : sourceWithElementInexistent) {
            if (s == null || this.sourceWithElementInexistent.contains(s)) continue;
            this.sourceWithElementInexistent.add(s);
            this.handleErrorAdded(s.getURI(), 3, s.getId());
        }
    }

    private void updateSourceWithRefToElementInexistent(Set<Source> sourceWithRefToElementInexistent) {
        Iterator<Source> it = this.sourceWithRefToElementInexistent.iterator();
        while (it.hasNext()) {
            Source s = it.next();
            if (s.eResource() != null && sourceWithRefToElementInexistent.contains(s)) continue;
            it.remove();
            this.handleErrorRemoved(s.getURI(), 2, s.getId());
        }
        sourceWithRefToElementInexistent.removeAll(this.sourceWithRefToElementInexistent);
        for (Source s : sourceWithRefToElementInexistent) {
            if (s == null || this.sourceWithRefToElementInexistent.contains(s)) continue;
            this.sourceWithRefToElementInexistent.add(s);
            this.handleErrorAdded(s.getURI(), 2, s.getId());
        }
    }

    public Set<Elt> getElementInexistent() {
        return this.elementInexistent;
    }

    public Set<Source> getSourceWithRefToElementInexistent() {
        return this.sourceWithRefToElementInexistent;
    }

    public Set<Elt> getElementWithRefToElementInexistent() {
        return this.elementWithRefToElementInexistent;
    }

    public void handleCacheInited() {
        this.handleEventTriggered();
    }

    public void triggerCacheEvent(CacheEventURI event) {
        this.cachedEvent.add(event);
    }

    public Set<URI> getSourceWithBrokenRequirement() {
        return this.sourceWithBrokenRequirement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, String> getFeatureNotFoundResource() {
        HashMap<URI, String> l = new HashMap<URI, String>();
        Set<Source> set = this.sourceWithfeatureNotFound;
        synchronized (set) {
            for (Source s : this.sourceWithfeatureNotFound) {
                URI f = s.getURI();
                if (f == null) continue;
                l.put(f, (String)s.getRemark().get((Object)"com.stambia.resource.marker.featureNotFound"));
            }
        }
        return l;
    }

    public void updateFeatureNotFound(Source source) {
        if (source.getRemark().get((Object)"com.stambia.resource.marker.featureNotFound") != null) {
            this.sourceWithfeatureNotFound.add(source);
        } else {
            this.sourceWithfeatureNotFound.remove(source);
        }
    }

    public void removeDiscardedByLicense(URI file, IComponentService.IComponent component) {
        this.resourceDiscardedByMissingRole.remove(file);
        this.handleErrorRemoved(file, 4, null);
    }

    public void addDiscardedByLicense(URI file, IComponentService.IComponent component) {
        if (file != null) {
            this.resourceDiscardedByMissingRole.put(file, component);
            this.handleErrorAdded(file, 4, null);
        }
    }

    public Map<URI, ICacheState.IUnparsedResourceInfo> getXMLResourcesWithDuplicatedId() {
        return this.resourcesWithDuplicatedID;
    }

    public void addResourceWithDuplicateIds(URI resource, ICacheState.IUnparsedResourceInfo info) {
        if (resource != null) {
            this.resourcesWithDuplicatedID.put(resource, info);
        }
    }

    public ICacheState.IUnparsedResourceInfo removeResourceWithDuplicateIds(URI resource) {
        if (resource != null) {
            return this.resourcesWithDuplicatedID.remove(resource);
        }
        return null;
    }
}

