/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.cache.IDependencyHelper;
import com.semarchy.xdi.designer.core.services.registry.TechExtension;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.osgi.service.log.LogService;

public class DependencyHelper
implements IDependencyHelper {
    private CacheImpl cache;

    DependencyHelper(CacheImpl cache) {
        this.cache = cache;
    }

    public List<EObject> getUsage(ResourceSet rs, EObject obj) {
        ArrayList<EObject> retour = new ArrayList<EObject>();
        if (obj != null) {
            String eltID = CacheHelper.extractEltID((EObject)obj);
            String fileID = CacheHelper.extractFileID((EObject)obj);
            Elt elt = this.cache.getSuper().findElt(eltID, fileID);
            if (elt != null) {
                for (Elt usage : elt.getUsage()) {
                    retour.add(usage.getTargetObject(rs));
                }
            }
        }
        return retour;
    }

    public boolean hasUsage(EObject obj, String sourceURIPattern) {
        if (obj != null) {
            String eltID = CacheHelper.extractEltID((EObject)obj);
            String fileID = CacheHelper.extractFileID((EObject)obj);
            Elt elt = this.cache.getSuper().findElt(eltID, fileID);
            if (elt != null) {
                for (Elt usage : elt.getUsage()) {
                    if (usage.getSource() == null || usage.getSource().getURI() == null) continue;
                    if (sourceURIPattern != null && !sourceURIPattern.isEmpty()) {
                        if (!usage.getSource().getURI().toString().matches(sourceURIPattern)) continue;
                        return true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public List<String> getReferenceEltID(String eltID, String fileID) {
        ArrayList<String> l = new ArrayList<String>();
        Elt elt = this.cache.getSuper().findElt(eltID, fileID);
        if (elt != null) {
            for (Elt e : elt.getReference()) {
                l.add(e.getId());
            }
        }
        return l;
    }

    public List<EObject> getReference(ResourceSet rs, EObject obj) {
        ArrayList<EObject> retour = new ArrayList<EObject>();
        if (obj != null) {
            String eltID = CacheHelper.extractEltID((EObject)obj);
            String fileID = CacheHelper.extractFileID((EObject)obj);
            Elt elt = this.cache.getSuper().findElt(eltID, fileID);
            if (elt != null) {
                for (Elt ref : elt.getReference()) {
                    retour.add(ref.getTargetObject(rs));
                }
            }
        }
        return retour;
    }

    public boolean hasUsage(EObject obj) {
        if (obj != null) {
            String eltID = CacheHelper.extractEltID((EObject)obj);
            String fileID = CacheHelper.extractFileID((EObject)obj);
            Elt elt = this.cache.getSuper().findElt(eltID, fileID);
            return elt != null && elt.getUsage().size() > 0;
        }
        return false;
    }

    public List<URI> getUsageFiles4UDF(String udfId) {
        Source s = this.cache.getSuper().getSource("UUID_REGISTRY_UDF");
        ArrayList<URI> l = new ArrayList<URI>();
        for (Elt elt : s.getElt()) {
            if (!udfId.equals(elt.getRealId())) continue;
            for (Elt u : elt.getUsage()) {
                if (u.getSource() == null || u.getSource().getURI() == null || l.contains(u.getSource().getURI())) continue;
                l.add(u.getSource().getURI());
            }
        }
        return l;
    }

    public List<URI> getUsage(URI uri) {
        HashSet<URI> l;
        block5: {
            Source s;
            block4: {
                s = this.cache.getSuper().getSource(uri);
                l = new HashSet<URI>();
                if (s == null) break block4;
                for (Elt elt : s.getElt()) {
                    for (Elt u : elt.getUsage()) {
                        if (u.getSource() == null || u.getState() == StateType.DUPLICATE || u.getState() == StateType.INEXISTENT) continue;
                        l.add(u.getSource().getURI());
                    }
                }
                break block5;
            }
            if (!uri.segment(1).equals("UUID_REGISTRY_UDF")) break block5;
            s = this.cache.getSuper().getSource("UUID_REGISTRY_UDF");
            for (Elt elt : s.getElt()) {
                for (Elt u : elt.getUsage()) {
                    if (u.getSource() == null || u.getSource().getURI() == null || l.contains(u.getSource().getURI())) continue;
                    l.add(u.getSource().getURI());
                }
            }
        }
        return new ArrayList<URI>(l);
    }

    public Collection<String> getMandatoryMainRequiredSourcesId(String sourceId) {
        HashSet<String> res = new HashSet<String>();
        Source s = this.cache.getSuper().getSource(sourceId);
        if (s == null) {
            return res;
        }
        Elt rootElt = this.cache.getSuper().findElt(sourceId, sourceId);
        if (rootElt == null) {
            return res;
        }
        Elt mainRef = s.getMainReference();
        if (mainRef == null) {
            return res;
        }
        if (res.add(mainRef.getSource().getId())) {
            res.addAll(this.getMandatoryMainRequiredSourcesId(mainRef.getSource().getId()));
        }
        return res;
    }

    public synchronized List<URI> getDependancies(URI file) {
        ArrayList<URI> l = new ArrayList<URI>();
        Source s = this.cache.getSuper().getSource(file);
        if (s != null) {
            HashSet<Source> handledSources = new HashSet<Source>();
            handledSources.addAll(this.getSourceRequirement(s, new ArrayList<Source>()));
            l.add(s.getURI());
            for (Source ss : handledSources) {
                if (ss == null) continue;
                l.add(ss.getURI());
            }
        }
        return l;
    }

    protected Collection<Source> getSourceRequirement(final Source s, Collection<Source> toDiscard) {
        HashSet<Source> handledSources = new HashSet<Source>();
        if (s != null && s.getState() != StateType.INEXISTENT) {
            if (s.getURI() != null && "md".equals(s.getURI().fileExtension())) {
                IRegistryService.IRegistry techExtensionRegistry = this.cache.registryService.getRegistry(TechExtension.class);
                List techExtensionList = techExtensionRegistry.find(new IRegistryService.IRegistryMatcher(){

                    public boolean match(Object o) {
                        return o instanceof TechExtension.TechExtensionKey && ((TechExtension.TechExtensionKey)o).getExtendedTechId().equals(DependencyHelper.this.cache.getSourceId(s.getURI()));
                    }
                });
                handledSources.addAll(techExtensionList.stream().map(techExt -> this.cache.getSuper().getSource(techExt.getRegistrationKey().getProviderFileID())).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            for (Elt e : s.getElt()) {
                for (Elt r : e.getReference()) {
                    if (r.getSource() == null || handledSources.contains(r.getSource()) || toDiscard.contains(r.getSource())) continue;
                    if (r.getSource().getURI() != null && r.getSource().getURI().scheme().equals("udf")) {
                        try {
                            Source udfProviderSrc;
                            String udfRealID;
                            String[] p;
                            List res;
                            IRegistryService.IRegistry registry = this.cache.registryService.getRegistry(UDF.class);
                            if (registry == null || (res = registry.find((IRegistryService.IRegistryMatcher)new UDF.UDFMatcher(String.valueOf((p = (udfRealID = r.getRealId()).split("!"))[0]) + "::" + p[1], Integer.valueOf(p[2]).intValue()))) == null || res.isEmpty() || (udfProviderSrc = this.cache.getSuper().getSource(((UDF)res.get(0)).getRegistrationKey().getProviderFileID())) == null) continue;
                            handledSources.add(udfProviderSrc);
                        }
                        catch (Exception ex) {
                            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").warn(Messages.CacheImpl_91, (Object)ex);
                        }
                        continue;
                    }
                    handledSources.add(r.getSource());
                }
            }
        }
        toDiscard.addAll(handledSources);
        ArrayList<Source> toAdd = new ArrayList<Source>();
        for (Source ss : handledSources) {
            for (Source d : this.getSourceRequirement(ss, toDiscard)) {
                if (d == null) continue;
                toAdd.add(d);
            }
        }
        handledSources.addAll(toAdd);
        return handledSources;
    }

    public List<URI> getUsageElements(URI eltURI) {
        Source src = this.cache.getSuper().getSource(CacheHelper.extractFileID((String)eltURI.fragment()));
        if (src == null) {
            return Collections.EMPTY_LIST;
        }
        String eltID = CacheHelper.extractEltID((String)eltURI.fragment());
        ArrayList<URI> res = new ArrayList<URI>();
        for (Elt elt : src.getElt()) {
            if (!elt.getRealId().equals(eltID)) continue;
            for (Elt e : elt.getUsage()) {
                if (e.getSource() == null || e.getSource().getURI() == null) continue;
                String fragment = String.valueOf(e.getId()) + "?fileId=" + e.getSource().getId() + "?";
                res.add(e.getSource().getURI().appendFragment(fragment));
            }
        }
        return res;
    }
}

