/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IMappingBuildJobFactory;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.MappingBuildDelegate;
import com.semarchy.xdi.designer.index.internal.MappingBuildHandler;
import com.semarchy.xdi.designer.index.internal.MappingDeprecatedCleanDelegate;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.impl.SuperImpl;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class MappingBuildDelegateFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public Result createForceBuildDelegate(final MappingBuildHandler buildHandler, final Resource mappingResource) {
        String id = buildHandler.cacheService.getSourceId(mappingResource.getURI());
        LinkedList<String> queue = new LinkedList<String>();
        queue.add(id);
        MappingBuildDelegate delegate = new MappingBuildDelegate(queue, buildHandler){

            @Override
            protected boolean isForce() {
                return true;
            }

            private void cleanBuiltFiles(URI mappingURI, IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
                sub.subTask(Messages.MappingBuildHandler_138);
                for (URI u : URIUtils.getMappingBuiltFiles((URI)mappingURI, (XDIModelURIResolver)buildHandler.modelResolver, (boolean)false)) {
                    File f = buildHandler.modelResolver.resolve(u);
                    if (f == null) continue;
                    try {
                        Files.deleteIfExists(f.toPath());
                    }
                    catch (Exception e) {
                        MappingBuildDelegateFactory.this.logger.warn("com.semarchy.xdi.designer.index", (Object)(String.valueOf(Messages.MappingBuildHandler_139) + f), (Object)e);
                    }
                }
            }

            @Override
            public IStatus run(IProgressMonitor monitor) {
                try {
                    Source source = ((SuperImpl)((CacheImpl)buildHandler.cacheService).getSuper()).getSource((String)this.queue.peek());
                    MappingBuildDelegateFactory.this.logger.info("Forcing Build " + mappingResource.getURI() + "...");
                    if (buildHandler.delegateBuilder.canBeBuilt(mappingResource)) {
                        try {
                            try {
                                buildHandler.delegateBuilder.buildMapping(mappingResource);
                                MappingBuildDelegateFactory.this.logger.info("Generated built(force) files for " + mappingResource.getURI());
                            }
                            catch (Throwable ex) {
                                this.cleanBuiltFiles(mappingResource.getURI(), monitor);
                                MappingBuildDelegateFactory.this.logger.info("Failed to generate built files for " + mappingResource.getURI(), ex);
                                Status status = new Status(4, "com.semarchy.xdi.designer.index", String.valueOf(Messages.MappingBuildHandler_164) + mappingResource.getURI(), ex);
                                source.updateLastBuildAttempt();
                                Job.getJobManager().wakeUp((Object)"MAPPING_BUILD_JOB_FAMILY");
                                return status;
                            }
                        }
                        finally {
                            source.updateLastBuildAttempt();
                        }
                    }
                    MappingBuildDelegateFactory.this.logger.info("Skipper Forced Build " + mappingResource.getURI() + " cannot be built");
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    Job.getJobManager().wakeUp((Object)"MAPPING_BUILD_JOB_FAMILY");
                }
            }
        };
        ISchedulingRule rule = this.createSchedulingRule(buildHandler, delegate);
        return new Result(delegate, rule);
    }

    public Result createBuildDelegate(MappingBuildHandler buildHandler) {
        LinkedList<String> queue = new LinkedList<String>(buildHandler.mappingIdToBuild);
        buildHandler.mappingIdToBuild.removeAll(queue);
        queue.remove(null);
        MappingBuildDelegate delegate = new MappingBuildDelegate(queue, buildHandler);
        ISchedulingRule rule = this.createSchedulingRule(buildHandler, delegate);
        return new Result(delegate, rule);
    }

    public Result createTriggeredBuildDelegate(MappingBuildHandler buildHandler, Collection<URI> filesToBuild) {
        LinkedList<String> queue = new LinkedList<String>();
        for (URI f : filesToBuild) {
            String srcId = buildHandler.cacheService.getSourceId(f);
            ICacheService.SourceState s = buildHandler.cacheService.getSourceState(f);
            if (s == null || !s.isSync()) continue;
            queue.add(srcId);
        }
        MappingBuildDelegate delegate = new MappingBuildDelegate(queue, buildHandler){

            @Override
            public IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus iStatus = super.run(monitor);
                    return iStatus;
                }
                finally {
                    Job.getJobManager().wakeUp((Object)"MAPPING_BUILD_JOB_FAMILY");
                }
            }

            @Override
            protected boolean isForce() {
                return true;
            }
        };
        ISchedulingRule rule = this.createSchedulingRule(buildHandler, delegate);
        return new Result(delegate, rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createCleanDeprecatedDelegate(MappingBuildHandler buildHandler) {
        ISchedulingRule combinedRule = buildHandler.mutexRule;
        HashMap<URI, List<File>> toDelete = new HashMap<URI, List<File>>();
        ArrayList<File> artefactToDelete = new ArrayList<File>();
        ICacheService iCacheService = buildHandler.cacheService;
        synchronized (iCacheService) {
            for (URI u : buildHandler.mappingToClean) {
                ICacheService.SourceState srcSt = buildHandler.cacheService.getSourceState(u);
                boolean handled = false;
                if (srcSt != null && !srcSt.isDuplicate()) {
                    if (toDelete.get(u) == null) {
                        toDelete.put(u, new ArrayList());
                    }
                    for (URI b : URIUtils.getMappingBuiltFiles((URI)u, (XDIModelURIResolver)buildHandler.modelResolver, (boolean)true)) {
                        ((List)toDelete.get(u)).add(buildHandler.modelResolver.resolve(b));
                        combinedRule = MultiRule.combine((ISchedulingRule)combinedRule, (ISchedulingRule)buildHandler.modelResolver.createSchedulingRule(b));
                    }
                    handled = true;
                }
                if (handled) continue;
                for (URI b : URIUtils.getMappingBuiltFiles((URI)u, (XDIModelURIResolver)buildHandler.modelResolver, (boolean)true)) {
                    artefactToDelete.add(buildHandler.modelResolver.resolve(b));
                    combinedRule = MultiRule.combine((ISchedulingRule)combinedRule, (ISchedulingRule)buildHandler.modelResolver.createSchedulingRule(b));
                }
            }
        }
        MappingDeprecatedCleanDelegate delegate = new MappingDeprecatedCleanDelegate(buildHandler, toDelete, artefactToDelete);
        return new Result(delegate, combinedRule);
    }

    private ISchedulingRule createSchedulingRule(MappingBuildHandler buildHandler, MappingBuildDelegate delegate) {
        ICacheService.SourceState state;
        URI uri;
        ISchedulingRule combinedRule = buildHandler.mutexRule;
        HashSet dependanciesId = new HashSet();
        for (String s : delegate.queue) {
            uri = delegate.getSourceURI(s);
            state = buildHandler.cacheService.getSourceState(uri);
            if (state == null || !state.isSync()) continue;
            dependanciesId.addAll(buildHandler.delegateBuilder.getAllDependancies(uri));
            ISchedulingRule r = buildHandler.modelResolver.createSchedulingRule(uri);
            combinedRule = MultiRule.combine((ISchedulingRule)r, (ISchedulingRule)combinedRule);
        }
        for (String id : dependanciesId) {
            uri = delegate.getSourceURI(id);
            state = buildHandler.cacheService.getSourceState(uri);
            if (state == null) continue;
            combinedRule = MultiRule.combine((ISchedulingRule)buildHandler.modelResolver.createSchedulingRule(uri), (ISchedulingRule)combinedRule);
        }
        return combinedRule;
    }

    public class Result {
        IMappingBuildJobFactory.IBuilderDelegate delegate;
        ISchedulingRule rule;

        Result(IMappingBuildJobFactory.IBuilderDelegate delegate, ISchedulingRule rule) {
            this.delegate = delegate;
            this.rule = rule;
        }

        public IMappingBuildJobFactory.IBuilderDelegate getDelegate() {
            return this.delegate;
        }

        public ISchedulingRule getSchedulingRule() {
            return this.rule;
        }
    }
}

