/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.IMappingBuildJobFactory;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.MappingBuildHandler;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.impl.SuperImpl;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;

class MappingDeprecatedCleanDelegate
implements IMappingBuildJobFactory.IBuilderDelegate {
    Map<URI, List<File>> toDelete;
    List<File> artefactToDelete;
    MappingBuildHandler buildHandler;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public MappingDeprecatedCleanDelegate(MappingBuildHandler buildHandler, Map<URI, List<File>> fileToDeletePerMappingURI, List<File> additionalFilesToDelete) {
        this.toDelete = fileToDeletePerMappingURI;
        this.artefactToDelete = additionalFilesToDelete;
        this.buildHandler = buildHandler;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.trace("Clean Job started");
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.artefactToDelete.size() + this.toDelete.size()));
            for (File f : this.artefactToDelete) {
                try {
                    Files.deleteIfExists(f.toPath());
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Deleted " + f);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Failed to delete " + f, (Throwable)ex);
                }
                sub.worked(1);
            }
            for (URI u : this.toDelete.keySet()) {
                for (File f : this.toDelete.get(u)) {
                    try {
                        Files.deleteIfExists(f.toPath());
                        if (!this.logger.isTraceEnabled()) continue;
                        this.logger.trace("Deleted " + f);
                    }
                    catch (Exception ex) {
                        this.logger.error(String.valueOf(Messages.MappingBuildHandler_158) + f, (Throwable)ex);
                    }
                }
                Source source = ((SuperImpl)((CacheImpl)this.buildHandler.cacheService).getSuper()).getSource(u);
                if (source != null) {
                    source.setLastBuildAttempt(null);
                }
                sub.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

