/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.indexation.IMdTechRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;

public class MdTechRegistry
implements IMdTechRegistry {
    private HashMap<String, List<URI>> mapMdUriByLevelCode;
    private List<URI> techUris;

    public MdTechRegistry(HashMap<String, List<URI>> mapMdUriByLevelCode, List<URI> techUris) {
        this.mapMdUriByLevelCode = mapMdUriByLevelCode;
        this.techUris = Collections.unmodifiableList(techUris);
    }

    public List<URI> getMdUriFor(String levelCode) {
        List<URI> l = this.mapMdUriByLevelCode.get(levelCode);
        if (l == null) {
            return Collections.EMPTY_LIST;
        }
        return l;
    }

    public List<URI> getTechUris() {
        return this.techUris;
    }

    public List<URI> getAllMdURI() {
        HashSet<URI> res = new HashSet<URI>();
        for (List<URI> l : this.mapMdUriByLevelCode.values()) {
            res.addAll(l);
        }
        return new ArrayList<URI>(res);
    }
}

