/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.index.internal.CacheState;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;

public class SourceStateImpl
implements ICacheService.SourceState {
    private boolean exist;
    private boolean canBeBuild;
    private boolean isBuilt;
    private boolean isOverride;
    private boolean invalidXML;
    private boolean isSync;
    private String internalVersion;
    private Map<String, String> remarks = new HashMap<String, String>();
    private boolean hasDuplicates;
    private boolean isDuplicate;
    private String srcId;
    private boolean hasMissingCrossRef;
    private boolean hasBrokenRequirements;
    private XMLGregorianCalendar lastScan;
    private XMLGregorianCalendar lastBuildAttempt;
    private XMLGregorianCalendar lastModification;
    private Collection<URI> duplicateURI;

    SourceStateImpl() {
    }

    SourceStateImpl(Source s, CacheState cacheState, long lastFileModification) {
        this.srcId = s.getId();
        this.exist = s.getState() != StateType.INEXISTENT;
        boolean bl = this.isSync = s.getState() == StateType.SYNCHRO;
        if (s.getURI() != null) {
            boolean bl2 = this.canBeBuild = "map".equals(s.getURI().fileExtension()) && !cacheState.getSourceWithBrokenRequirement().contains(s) && !cacheState.getSourceWithRefToElementInexistent().contains(s);
            this.isBuilt = "map".equals(s.getURI().fileExtension()) ? !cacheState.getUnbuiltResources().contains(s.getURI()) : false;
        }
        this.isOverride = s.getOverridenPluginUri() != null;
        this.invalidXML = cacheState.getInvalidXMLResources().containsKey(s.getURI());
        this.internalVersion = s.getInternalVersion();
        this.duplicateURI = s.getDuplicates().stream().map(d -> d.getURI()).collect(Collectors.toSet());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(lastFileModification));
        XMLCalendar xc = new XMLCalendar(gc.getTime(), 0);
        this.lastModification = xc;
        this.hasDuplicates = !s.getDuplicates().isEmpty();
        this.isDuplicate = s.getState() == StateType.DUPLICATE;
        s.getRemark().keySet().forEach(k -> {
            String string = this.remarks.put((String)k, (String)s.getRemark().get(k));
        });
        this.hasMissingCrossRef = cacheState.getSourceWithRefToElementInexistent().contains(s);
        this.hasBrokenRequirements = cacheState.getSourceWithRefToElementInexistent().contains(s);
        this.lastScan = s.getLastScan();
        this.lastBuildAttempt = s.getLastBuildAttempt();
    }

    public boolean isSync() {
        return this.isSync;
    }

    public boolean isInvalidXML() {
        return this.invalidXML;
    }

    public String getInternalVersion() {
        return this.internalVersion;
    }

    public boolean sourceExists() {
        return this.exist;
    }

    public boolean mayBeBuilt() {
        return this.canBeBuild;
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public boolean isOverridde() {
        return this.isOverride;
    }

    public long getLastModified() {
        return this.lastModification.toGregorianCalendar().getTime().getTime();
    }

    public String getRemark(String key) {
        return this.remarks.get(key);
    }

    public boolean hasDuplicate() {
        return this.hasDuplicates;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public boolean isMissingCrossReference() {
        return this.hasMissingCrossRef;
    }

    public boolean hasBrokenRequirements() {
        return this.hasBrokenRequirements;
    }

    public String getSourceId() {
        return this.srcId;
    }

    public XMLGregorianCalendar getLastBuildAttempt() {
        return this.lastBuildAttempt;
    }

    public XMLGregorianCalendar getLastScan() {
        return this.lastScan;
    }

    public XMLGregorianCalendar getDateFile() {
        return this.lastModification;
    }

    public Collection<URI> getDuplicates() {
        return this.duplicateURI;
    }
}

