/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StateType implements Enumerator
{
    SYNCHRO(0, "SYNCHRO", "SYNCHRO"),
    EXISTS(1, "EXISTS", "EXISTS"),
    UNDEFINED(2, "UNDEFINED", "UNDEFINED"),
    INEXISTENT(3, "INEXISTENT", "INEXISTENT"),
    DUPLICATE(4, "DUPLICATE", "DUPLICATE");

    public static final int SYNCHRO_VALUE = 0;
    public static final int EXISTS_VALUE = 1;
    public static final int UNDEFINED_VALUE = 2;
    public static final int INEXISTENT_VALUE = 3;
    public static final int DUPLICATE_VALUE = 4;
    private static final StateType[] VALUES_ARRAY;
    public static final List<StateType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StateType[]{SYNCHRO, EXISTS, UNDEFINED, INEXISTENT, DUPLICATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StateType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StateType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StateType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StateType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StateType get(int value) {
        switch (value) {
            case 0: {
                return SYNCHRO;
            }
            case 1: {
                return EXISTS;
            }
            case 2: {
                return UNDEFINED;
            }
            case 3: {
                return INEXISTENT;
            }
            case 4: {
                return DUPLICATE;
            }
        }
        return null;
    }

    private StateType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

