/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.model.impl;

import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.services.ILevelCodeProviderService;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.CacheState;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.model.CacheFactory;
import com.semarchy.xdi.designer.index.model.CachePackage;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import com.semarchy.xdi.designer.index.model.Super;
import com.semarchy.xdi.designer.index.model.impl.CacheFactoryImpl;
import com.semarchy.xdi.designer.index.model.impl.EltImpl;
import com.semarchy.xdi.designer.index.model.impl.SourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;

public class SuperImpl
extends EObjectImpl
implements Super {
    protected EList<Source> resource;
    protected EList<Elt> elt;
    protected static final String INTERNAL_VERSION_EDEFAULT = null;
    protected String internalVersion = INTERNAL_VERSION_EDEFAULT;
    private CacheState cacheState = new CacheState();

    protected SuperImpl() {
    }

    protected EClass eStaticClass() {
        return CachePackage.Literals.SUPER;
    }

    @Override
    public synchronized EList<Source> getResource() {
        if (this.resource == null) {
            this.resource = new EObjectContainmentEList(Source.class, (InternalEObject)this, 0);
        }
        return this.resource;
    }

    @Override
    public EList<Elt> getElt() {
        if (this.elt == null) {
            this.elt = new EObjectContainmentEList(Elt.class, (InternalEObject)this, 1);
        }
        return this.elt;
    }

    @Override
    public String getInternalVersion() {
        return this.internalVersion;
    }

    @Override
    public void setInternalVersion(String newInternalVersion) {
        String oldInternalVersion = this.internalVersion;
        this.internalVersion = newInternalVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldInternalVersion, (Object)this.internalVersion));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getResource()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getElt()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getResource();
            }
            case 1: {
                return this.getElt();
            }
            case 2: {
                return this.getInternalVersion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getResource().clear();
                this.getResource().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getElt().clear();
                this.getElt().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setInternalVersion((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getResource().clear();
                return;
            }
            case 1: {
                this.getElt().clear();
                return;
            }
            case 2: {
                this.setInternalVersion(INTERNAL_VERSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.resource != null && !this.resource.isEmpty();
            }
            case 1: {
                return this.elt != null && !this.elt.isEmpty();
            }
            case 2: {
                return INTERNAL_VERSION_EDEFAULT == null ? this.internalVersion != null : !INTERNAL_VERSION_EDEFAULT.equals(this.internalVersion);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (internalVersion: ");
        result.append(this.internalVersion);
        result.append(')');
        return result.toString();
    }

    @Override
    public Source addSource(String ID, URI uri, Date mappingBuildDate) throws Exception {
        Source s;
        Source source = s = uri == null ? null : this.getSource(uri);
        if (!(s == null || s.getState() == StateType.INEXISTENT || s.getState() == StateType.DUPLICATE && s.getContributedRegistry().contains((Object)"com.indy.ui.custom.out.udf.UDF"))) {
            throw new Exception(Messages.bind((String)Messages.SuperImpl_2, (Object)uri.toString()));
        }
        boolean isNew = false;
        if (s == null) {
            s = CacheFactoryImpl.eINSTANCE.createSource();
            isNew = true;
        }
        Source cur = this.getSource(ID);
        s.setId(ID);
        s.setURI(uri);
        if (isNew && uri != null && "map".equals(uri.fileExtension())) {
            try {
                if (mappingBuildDate != null) {
                    Long t = new Date().getTime();
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTimeInMillis(t);
                    s.setLastBuildAttempt((XMLGregorianCalendar)new XMLCalendar(gc.getTime(), 0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cur != null && cur.getState() != StateType.INEXISTENT) {
            s.setState(StateType.DUPLICATE);
        } else {
            s.setState(StateType.EXISTS);
        }
        if (cur != null) {
            s.setOverridenPluginUri(cur.getOverridenPluginUri());
        }
        this.getResource().add((Object)s);
        this.cacheState.triggerCacheEvent(new CacheEventURI(s.getId(), s.getURI(), CacheEventURI.Type.ADDED, false));
        s.setLastScan((XMLGregorianCalendar)new XMLCalendar(new Date(), 0));
        return s;
    }

    public Source addSource(String ID) throws Exception {
        Source s = this.addSource(ID, null, null);
        s.setState(StateType.INEXISTENT);
        return s;
    }

    @Override
    public Source getSource(String ID) {
        if (ID != null) {
            Source retour = SourceImpl.REGISTRY.getIdMapCache(ID);
            if (retour == null) {
                retour = SourceImpl.REGISTRY.getIdMap(ID);
                if (retour != null) {
                    SourceImpl.REGISTRY.putIdMapCache(ID, retour);
                    return retour;
                }
            } else {
                return retour;
            }
            for (Source s : this.getResource()) {
                if (!s.getId().equals(ID) || s.getState() == StateType.DUPLICATE) continue;
                SourceImpl.REGISTRY.putIdMap(ID, s);
                SourceImpl.REGISTRY.putIdMapCache(ID, s);
                return s;
            }
        }
        return null;
    }

    @Override
    public synchronized Source getSource(URI uri) {
        if (uri == null) {
            return null;
        }
        URI _uri = uri.trimFragment();
        Source retour = SourceImpl.REGISTRY.getUriMap(_uri);
        if (retour != null) {
            return retour;
        }
        if (SourceImpl.REGISTRY.isUnknown(_uri)) {
            return null;
        }
        SourceImpl.REGISTRY.addUnknown(_uri);
        return null;
    }

    public static void updateEltLevelCode(EObject obj, Elt elt) {
        try {
            String rootID;
            String rootElementId;
            if (!obj.eIsProxy() && elt.getLevelCode() == null && "md".equals(obj.eResource().getURI().fileExtension()) && (rootElementId = EltImpl.createEltID(rootID = EMFResourceUtil.getFirstId((Resource)obj.eResource()), rootID)).equals(elt.getId())) {
                ILevelCodeProviderService service = (ILevelCodeProviderService)E4InjectorHelper.getService(ILevelCodeProviderService.class);
                try {
                    elt.setLevelCode(service.getLevelCode(obj));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Elt getOrCreateElt(EObject object) throws Exception {
        String type;
        String name;
        Elt elt;
        String fragment = CacheHelper.getURIFragment((EObject)object);
        String eltID = CacheHelper.extractEltID((String)fragment);
        String fileID = CacheHelper.extractFileID((EObject)object);
        if (fileID == null && !object.eIsProxy() && object.eResource() instanceof IndyXMLResource) {
            fileID = ((IndyXMLResource)object.eResource()).getId();
        }
        if ((elt = this.findElt(eltID, fileID)) == null) {
            elt = this.createElt(eltID, fileID);
        }
        if ((name = CacheHelper.extractEltName((String)fragment)) != null) {
            elt.setName(name);
        }
        if ((type = CacheHelper.extractEltType((String)fragment)) != null) {
            elt.setType(type);
        }
        if (!object.eIsProxy()) {
            elt.setState(StateType.EXISTS);
            SuperImpl.updateEltLevelCode(object, elt);
        }
        elt.setInfo(null);
        return elt;
    }

    public Elt createElt(String eltID, String fileID) throws Exception {
        Elt elt = CacheFactory.eINSTANCE.createElt();
        elt.setRealId(eltID, fileID);
        this.getElt().add((Object)elt);
        elt.setState(StateType.INEXISTENT);
        if (fileID != null) {
            Source s2 = this.getSource(fileID);
            if (s2 == null) {
                try {
                    s2 = this.addSource(fileID);
                }
                catch (Exception e) {
                    throw new Exception(String.valueOf(Messages.SuperImpl_1) + fileID, e);
                }
            }
            elt.setSource(s2);
        }
        return elt;
    }

    @Override
    public int cleanSource(Source source) {
        int i = 0;
        if (source != null) {
            ArrayList<Elt> list = new ArrayList<Elt>((Collection<Elt>)source.getElt());
            boolean keepSource = false;
            for (Elt elt : list) {
                if (source.getState().equals((Object)StateType.INEXISTENT)) {
                    source.setMainReference(null);
                    if (elt.getUsage() == null || elt.getUsage().size() == 0 || elt.eResource() == null) {
                        this.removeElt(elt);
                        ++i;
                        continue;
                    }
                    elt.setState(StateType.INEXISTENT);
                    keepSource = true;
                    ++i;
                    continue;
                }
                if (elt.getUsage() != null && elt.getUsage().size() != 0 || elt.getReference() != null && elt.getReference().size() != 0) continue;
                this.removeElt(elt);
                ++i;
            }
            if (!keepSource && source.getState().equals((Object)StateType.INEXISTENT)) {
                ++i;
                for (Elt elt : list) {
                    this.removeElt(elt);
                }
                this.removeSource(source);
            }
            if (i > 0) {
                this.eResource().setModified(true);
            }
        }
        return i;
    }

    @Override
    public void removeSource(Source s) {
        s.getMandatoryElt().clear();
        this.getResource().remove((Object)s);
        if (s.getId() != null) {
            SourceImpl.REGISTRY.removeIdMapCache(s.getId());
            SourceImpl.REGISTRY.removeIdMap(s.getId());
        }
        if (s.getUriStr() != null) {
            SourceImpl.REGISTRY.removeUriMap(s.getURI());
        }
        this.cacheState.triggerCacheEvent(new CacheEventURI(s.getId(), s.getURI(), CacheEventURI.Type.REMOVED, false));
    }

    @Override
    public Elt findElt(String eltRealID, String fileID) {
        String ID = EltImpl.createEltID(eltRealID, fileID);
        if (ID != null) {
            Elt retour = EltImpl.getEltRegistry().getIdMapCache().get(ID);
            if (retour == null) {
                retour = EltImpl.getEltRegistry().getIdMap().get(ID);
                if (retour != null) {
                    EltImpl.getEltRegistry().getIdMapCache().put(ID, retour);
                    return retour;
                }
            } else {
                return retour;
            }
        }
        return null;
    }

    @Override
    public void removeElt(Elt element) {
        element.getDependantSource().clear();
        Source s = element.getSource();
        if (s != null) {
            s.getElt().remove((Object)element);
        }
        element.getReference().clear();
        this.getElt().remove((Object)element);
        element = null;
    }

    @Override
    public int cleanElt(Elt elt) {
        int i = 0;
        if (elt.getUsage() == null || elt.getUsage().size() == 0) {
            if ((elt.getState().equals((Object)StateType.INEXISTENT) || elt.getReference() == null || elt.getReference().size() == 0) && elt.getDependantSource().size() == 0) {
                this.removeElt(elt);
                ++i;
            }
        } else if (elt.getSource() == null) {
            if (elt.getUsage().size() == 0) {
                this.removeElt(elt);
                ++i;
            } else if (!elt.getState().equals((Object)StateType.INEXISTENT)) {
                elt.setState(StateType.INEXISTENT);
                ++i;
            }
        }
        if (++i > 0) {
            this.eResource().setModified(true);
        }
        return i;
    }

    private boolean ancestorInexistant(Elt elt) {
        String fileID;
        if (elt == null || elt.getContainerUri() == null) {
            return false;
        }
        String eltID = CacheHelper.extractEltID((String)elt.getContainerUri());
        Elt parent = this.findElt(eltID, fileID = CacheHelper.extractFileID((String)elt.getContainerUri()));
        if (parent != null) {
            for (Elt c : parent.getReference()) {
                if (this.cacheState.getElementInexistent().contains(c)) {
                    return true;
                }
                if (!this.ancestorInexistant(c)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Elt> getElementInexistent() {
        Set<Elt> c;
        HashSet<Elt> res = new HashSet<Elt>();
        Set<Elt> set = c = this.cacheState.getElementInexistent();
        synchronized (set) {
            for (Elt elt : c) {
                boolean add = true;
                for (Elt ref : elt.getUsage()) {
                    if (!this.ancestorInexistant(ref)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                res.add(elt);
            }
        }
        return res;
    }

    @Override
    public void analyseProblem(CacheImpl cache) {
        this.cacheState.analyseProblem(cache);
    }

    public void enableCacheTrigger(boolean triggerState) {
        if (triggerState) {
            this.cacheState.unlockEventTrigger();
        } else {
            this.cacheState.lockEventTrigger();
        }
    }

    @Override
    public CacheState getCacheState() {
        return this.cacheState;
    }
}

