/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.parsers;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.index.internal.InternalResourceFolderRegistry;
import com.semarchy.xdi.designer.index.internal.Messages;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StaxFastProxyResolver {
    private Set<String> proxies;
    private Set<String> resolved;
    private IRegistryService registryService;
    private ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);

    public StaxFastProxyResolver() {
        this.registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);
    }

    public Set<String> fastResolve(Collection<String> proxiesID, URI uri) throws Exception {
        URI cacheURI;
        String fileID;
        this.proxies = new HashSet<String>(proxiesID);
        this.resolved = new HashSet<String>(this.proxies.size());
        if (!(uri.isPlatformResource() || uri.isPlatformPlugin() || uri.equals(UDF.UDF_REGISTRY_SOURCE_URI) || (fileID = CacheHelper.extractFileID((String)uri.fragment())) == null || (cacheURI = this.cacheService.findResourceURIByFileId(fileID)) == null)) {
            uri = cacheURI.appendFragment(uri.fragment());
        }
        try (InputStream fis = null;){
            if (uri.isPlatformPlugin() && "com.indy.environment".equals(uri.segment(1))) {
                IInternalResourceRegistry.InternalResourceProvider p = InternalResourceFolderRegistry.INSTANCE.getProvider(uri);
                URI u = p.getPathRelativeToBundle(uri);
                StringBuilder s = new StringBuilder();
                int i = 0;
                while (i < u.segmentCount()) {
                    s.append("/");
                    s.append(URI.decode((String)u.segment(i)));
                    ++i;
                }
                Path relativePathToBundle = new Path(s.toString());
                try {
                    fis = FileLocator.openStream((Bundle)Platform.getBundle((String)p.getBundleName()), (IPath)relativePathToBundle, (boolean)false);
                }
                catch (Exception e) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").error(e.getMessage(), (Object)e);
                }
            } else if (uri.isPlatformResource()) {
                XDIModelURIResolver service = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
                if (!service.exists(uri)) {
                    Set set = Collections.EMPTY_SET;
                    return set;
                }
                fis = new BufferedInputStream(new FileInputStream(service.resolve(uri)));
            } else {
                if (uri.equals(UDF.UDF_REGISTRY_SOURCE_URI)) {
                    IRegistryService.IRegistry reg = this.registryService.getRegistry(UDF.class);
                    for (String s : proxiesID) {
                        String[] p = s.split("!");
                        try {
                            List l = reg.find((IRegistryService.IRegistryMatcher)new UDF.UDFMatcher(String.valueOf(p[0]) + "::" + p[1], Integer.valueOf(p[2]).intValue()));
                            if (l == null || l.isEmpty()) continue;
                            this.resolved.add(s);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    Set<String> set = this.resolved;
                    return set;
                }
                throw new Exception(String.valueOf(Messages.StaxFastProxyResolver_0) + uri);
            }
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader saxReader = parser.getXMLReader();
            RootIdContentHandler handler = new RootIdContentHandler("tech".equals(uri.fileExtension()) || "tech_ext".equals(uri.fileExtension()));
            saxReader.setContentHandler(handler);
            try {
                saxReader.parse(new InputSource(fis));
            }
            catch (NoMoreProxiesExeption noMoreProxiesExeption) {
                // empty catch block
            }
            Set<String> set = this.resolved;
            return set;
        }
    }

    private class NoMoreProxiesExeption
    extends SAXException {
        private NoMoreProxiesExeption() {
        }
    }

    private class RootIdContentHandler
    implements ContentHandler {
        private boolean isTech = false;

        RootIdContentHandler(boolean isTech) {
            this.isTech = isTech;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String id = atts.getValue("id");
            if (id == null && this.isTech && localName.equals("value")) {
                id = atts.getValue("code");
            }
            if (id != null && StaxFastProxyResolver.this.proxies.remove(id)) {
                StaxFastProxyResolver.this.resolved.add(id);
                if (StaxFastProxyResolver.this.proxies.isEmpty()) {
                    throw new NoMoreProxiesExeption();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

