/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.taskdefs.Copy;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;

public class AntCopy {
    Copy copy = new Copy();
    private FileSet fileSet;
    AntActionCodeTypeI actionCode = null;
    Connection jdbcConnection = null;
    String sqlSchemaName;
    private boolean defaultExcludes;
    boolean casesensitive;
    Set<String> includes = new HashSet<String>();
    Set<String> excludes = new HashSet<String>();

    public int getNumFile() {
        return this.copy.getNumFile();
    }

    public void setNumFile(int numFile) {
        this.copy.setNumFile(numFile);
    }

    public AntCopy(boolean casesensitive, boolean defaultExcludes) {
        this.casesensitive = casesensitive;
        this.defaultExcludes = defaultExcludes;
        this.copy = new Copy();
    }

    public void initFileSet() {
        this.fileSet = new FileSet();
        this.fileSet.setDefaultexcludes(this.defaultExcludes);
        this.fileSet.setCaseSensitive(this.casesensitive);
        this.copy.addFileset(this.fileSet);
    }

    public void setJdbcInformation(Connection pJdbcConnection, String schemaName) {
        this.jdbcConnection = pJdbcConnection;
        this.sqlSchemaName = schemaName;
        this.copy.setListener(new Copy.Listener(){

            @Override
            public void copyFile(int num, String sFFile, String sTFile) throws IOException {
                try {
                    AntCopy.this.logFileInTable(num, sFFile, sTFile);
                }
                catch (EngineExceptionI e) {
                    throw new IOException(e);
                }
            }
        });
    }

    void logFileInTable(int num, String sFFile, String sTFile) throws EngineExceptionI {
        try {
            String toFile;
            String toDir;
            String fromFile;
            String fromDir;
            this.actionCode.debugLog("lofFileInTable", "prepare table insert", 6, "DEBUG");
            File fFile = new File(sFFile);
            File tFile = new File(sTFile);
            if (fFile.isDirectory()) {
                fromDir = fFile.getCanonicalPath();
                fromFile = "";
            } else {
                fromFile = fFile.getCanonicalFile().getName();
                fromDir = fFile.getParentFile() != null ? fFile.getParentFile().getCanonicalPath() : "";
            }
            if (tFile.isDirectory()) {
                toDir = tFile.getCanonicalPath();
                toFile = "";
            } else {
                toFile = tFile.getCanonicalFile().getName();
                toDir = tFile.getParentFile() != null ? tFile.getParentFile().getCanonicalPath() : "";
            }
            this.actionCode.insertFileInTableFile(num, fromDir, fromFile, toDir, toFile, "Copy", new File(fromDir, fromFile), -1L);
        }
        catch (IOException e) {
            this.actionCode.publishVariable(VariableType.CORE_RET_MESS.getName(), "AntCopy=>lofFileInTable : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public void setActionCode(AntActionCodeTypeI act) {
        this.actionCode = act;
    }

    public void setAntProject(Project p) {
        this.copy.setProject(p);
    }

    public void setGlobalMapper(String from, String to, String sGlobMapperType) {
        Mapper mapper = this.copy.createMapper();
        mapper.setFrom(from);
        Mapper.MapperType mt = new Mapper.MapperType();
        mt.setValue(sGlobMapperType);
        mapper.setType(mt);
        mapper.setTo(to);
    }

    public void setIncludes(String pattern) {
        this.includes.add(pattern);
        String _includes = null;
        for (String str : this.includes) {
            _includes = _includes == null ? str : String.valueOf(_includes) + "," + str;
        }
        this.fileSet.setIncludes(_includes);
    }

    public void setExcludes(String pattern) {
        this.excludes.add(pattern);
        String _excludes = null;
        for (String str : this.excludes) {
            _excludes = _excludes == null ? str : String.valueOf(_excludes) + "," + str;
        }
        this.fileSet.setExcludes(_excludes);
    }

    public void setToDir(File f) {
        this.copy.setTodir(f);
    }

    public void setToFile(File f) {
        this.copy.setTofile(f);
    }

    public void setFromFile(File f) {
        this.copy.setFile(f);
    }

    public void setFromDir(File f) {
        this.fileSet.setDir(f);
    }

    public void setFromDir(String dir) {
        this.fileSet.setDir(new File(dir));
    }

    public void setFailOnError(boolean failsOnError) {
        this.copy.setFailOnError(failsOnError);
    }

    public void setFlatten(boolean bFlattenMode) {
        this.copy.setFlatten(bFlattenMode);
    }

    public void setIncludeEmptyDirs(boolean bIncludeEmpty) {
        this.copy.setIncludeEmptyDirs(bIncludeEmpty);
    }

    public void setPreserveLastModified(boolean bPreserveLastModified) {
        this.copy.setPreserveLastModified(bPreserveLastModified);
    }

    public void setOverwrite(boolean b) {
        this.copy.setOverwrite(b);
    }

    public void setGranularity(long lOverwriteDelay) {
        this.copy.setGranularity(lOverwriteDelay);
    }

    public void execute() {
        this.copy.execute();
    }

    public void addFileset(FileSet fileSet) {
        this.copy.addFileset(fileSet);
    }
}

