/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.taskdefs.Move;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;

public class AntMove {
    Move move = new Move();
    private FileSet fileSet;
    AntActionCodeTypeI actionCode = null;
    Connection jdbcConnection = null;
    String sqlSchemaName;
    private Boolean casesensitive;
    private boolean defaultExcludes;
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    Set<String> includes = new HashSet<String>();
    Set<String> excludes = new HashSet<String>();

    public int getNumFile() {
        return this.move.getNumFile();
    }

    public void setNumFile(int pNumFile) {
        this.move.setNumFile(pNumFile);
    }

    public AntMove(boolean casesensitive, boolean defaultExcludes) {
        this.casesensitive = casesensitive;
        this.defaultExcludes = defaultExcludes;
    }

    public void initFileSet() {
        this.fileSet = new FileSet();
        this.fileSet.setDefaultexcludes(this.defaultExcludes);
        this.fileSet.setCaseSensitive(this.casesensitive.booleanValue());
        this.move.addFileset(this.fileSet);
    }

    public void setJdbcInformation(Connection pJdbcConnection, String schemaName) {
        this.jdbcConnection = pJdbcConnection;
        this.sqlSchemaName = schemaName;
        this.move.setListener(new Move.Listener(){

            @Override
            public void moveFile(int numFile, File fromDir, File toDir) {
                try {
                    AntMove.this.logFileInTable(numFile, fromDir, toDir);
                }
                catch (EngineExceptionI e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    void logFileInTable(int num, File fFile, File tFile) throws EngineExceptionI {
        try {
            String toFile;
            String toDir;
            String fromFile;
            String fromDir;
            this.actionCode.debugLog("lofFileInTable", "prepare table insert", 6, "DEBUG");
            if (fFile.isDirectory()) {
                fromDir = fFile.getCanonicalPath();
                fromFile = "";
            } else {
                fromFile = fFile.getCanonicalFile().getName();
                fromDir = fFile.getParentFile() != null ? fFile.getParentFile().getCanonicalPath() : "";
            }
            if (tFile.isDirectory()) {
                toDir = tFile.getCanonicalPath();
                toFile = "";
            } else {
                toFile = tFile.getCanonicalFile().getName();
                toDir = tFile.getParentFile() != null ? tFile.getParentFile().getCanonicalPath() : "";
            }
            this.actionCode.insertFileInTableFile(num, fromDir, fromFile, toDir, toFile, "Move", new File(toDir, toFile), -1L);
        }
        catch (IOException e) {
            this.actionCode.publishVariable(VariableType.CORE_RET_MESS.getName(), "AntCopy=>lofFileInTable : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
    }

    void logFileInTable(int num, String sFFile, String sTFile) throws EngineExceptionI {
        try {
            this.actionCode.debugLog("lofFileInTable3", "prepare table insert", 6, "DEBUG");
            File fFile = new File(sFFile);
            File tFile = new File(sTFile);
            this.logFileInTable(num, fFile, tFile);
        }
        catch (NullPointerException e) {
            this.actionCode.publishVariable(VariableType.CORE_RET_MESS.getName(), "AntCopy=>lofFileInTable3 : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public void setActionCode(AntActionCodeTypeI act) {
        this.actionCode = act;
    }

    public void setAntProject(Project p) {
        this.move.setProject(p);
    }

    public void setGlobalMapper(String from, String to, String sGlobMapperType) {
        Mapper mapper = this.move.createMapper();
        mapper.setFrom(from);
        Mapper.MapperType mt = new Mapper.MapperType();
        mt.setValue(sGlobMapperType);
        mapper.setType(mt);
        mapper.setTo(to);
    }

    public void setIncludes(String pattern) {
        this.includes.add(pattern);
        String _includes = null;
        for (String str : this.includes) {
            _includes = _includes == null ? str : String.valueOf(_includes) + "," + str;
        }
        this.fileSet.setIncludes(_includes);
    }

    public void setExcludes(String pattern) {
        this.excludes.add(pattern);
        String _excludes = null;
        for (String str : this.excludes) {
            _excludes = _excludes == null ? str : String.valueOf(_excludes) + "," + str;
        }
        this.fileSet.setExcludes(_excludes);
    }

    public void setToDir(File f) {
        this.move.setTodir(f);
    }

    public void setToFile(File f) {
        this.move.setTofile(f);
    }

    public void setFromFile(File f) {
        this.move.setFile(f);
    }

    public void setFromDir(File f) {
        this.fileSet.setDir(f);
    }

    public void setFromDir(String dir) {
        this.fileSet.setDir(new File(dir));
    }

    public void setFailOnError(boolean failsOnError) {
        this.move.setFailOnError(failsOnError);
    }

    public void setFlatten(boolean bFlattenMode) {
        this.move.setFlatten(bFlattenMode);
    }

    public void setIncludeEmptyDirs(boolean bIncludeEmpty) {
        this.move.setIncludeEmptyDirs(bIncludeEmpty);
    }

    public void setPreserveLastModified(boolean bPreserveLastModified) {
        this.move.setPreserveLastModified(bPreserveLastModified);
    }

    public void setOverwrite(boolean b) {
        this.move.setOverwrite(b);
    }

    public void setGranularity(long lOverwriteDelay) {
        this.move.setGranularity(lOverwriteDelay);
    }

    public void execute() {
        this.move.execute();
    }

    public void addFileset(FileSet fileSet) {
        this.move.addFileset(fileSet);
    }
}

