/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant;

import com.indy.engine.action.ant.Messages;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileOperationsI {
    public static void copyOneFile(File in, File out, boolean overwrite) throws EngineExceptionI {
        block23: {
            try {
                FileChannel outChannel;
                FileChannel inChannel;
                if (!(overwrite | !out.exists())) break block23;
                try {
                    inChannel = new FileInputStream(in).getChannel();
                }
                catch (FileNotFoundException e1) {
                    throw new EngineExceptionI((Throwable)e1);
                }
                catch (SecurityException e1) {
                    throw new EngineExceptionI((Throwable)e1);
                }
                try {
                    outChannel = new FileOutputStream(out).getChannel();
                }
                catch (FileNotFoundException e1) {
                    throw new EngineExceptionI((Throwable)e1);
                }
                catch (SecurityException e1) {
                    throw new EngineExceptionI((Throwable)e1);
                }
                try {
                    try {
                        inChannel.transferTo(0L, inChannel.size(), outChannel);
                    }
                    catch (IOException e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                finally {
                    if (inChannel != null) {
                        try {
                            inChannel.close();
                        }
                        catch (IOException e) {
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                    if (outChannel != null) {
                        try {
                            outChannel.close();
                        }
                        catch (IOException e) {
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                }
            }
            catch (SecurityException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public static void recursiveDelete(File fFile) throws EngineExceptionI {
        File[] lstFiles = fFile.listFiles();
        if (lstFiles != null && lstFiles.length != 0) {
            int i = 0;
            while (i < lstFiles.length) {
                if (lstFiles[i].isDirectory()) {
                    FileOperationsI.recursiveDelete(lstFiles[i]);
                } else {
                    try {
                        lstFiles[i].delete();
                    }
                    catch (SecurityException e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                ++i;
            }
        }
        try {
            fFile.delete();
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static void moveOneFile(File srcFile, File trgFile, boolean overwrite) throws EngineExceptionI {
        try {
            boolean b;
            System.out.println(String.valueOf(Messages.getString("FileOperationsI.0")) + srcFile.getPath() + Messages.getString("FileOperationsI.1") + trgFile.getPath());
            if (overwrite && trgFile.exists()) {
                System.out.println(Messages.getString("FileOperationsI.2"));
                FileOperationsI.recursiveDelete(trgFile);
            }
            if (!(b = srcFile.renameTo(trgFile))) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("FileOperationsI.3")) + trgFile.getPath() + Messages.getString("FileOperationsI.4"));
            }
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static void createFolder(String folderName) throws EngineExceptionI {
        try {
            File f = new File(folderName);
            f.mkdirs();
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static int moveOrCopyFiles(String sSrcFile, String sTrgDir, String sTrgFile, boolean autoCreateFolders, boolean overwrite, boolean recurseMode, boolean deepResearch, String mode) throws EngineExceptionI {
        File trgFile;
        File srcFile;
        boolean bSrcIsDir = false;
        boolean bSrcIsPattern = false;
        String sSrcFolder = "";
        String srcFilePattern = "";
        boolean bTrgIsDir = false;
        boolean bTrgIsPattern = false;
        String sTrgFolder = "";
        String trgFilePattern = "";
        System.out.println(Messages.getString("FileOperationsI.5"));
        try {
            srcFile = new File(sSrcFile);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        if (srcFile.isDirectory()) {
            bSrcIsDir = true;
            sSrcFolder = srcFile.getPath();
        } else {
            sSrcFolder = srcFile.getParent();
            srcFilePattern = srcFile.getPath().substring(sSrcFolder.length() + 1);
            if (StringOperations.countMatchingGroup((String)srcFilePattern) > 0) {
                bSrcIsPattern = true;
            }
        }
        System.out.println(Messages.getString("FileOperationsI.6"));
        try {
            trgFile = new File(sTrgDir, sTrgFile);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        System.out.println(String.valueOf(Messages.getString("FileOperationsI.7")) + trgFile.getPath());
        if (sTrgFile.isEmpty()) {
            bTrgIsDir = true;
            sTrgFolder = trgFile.getPath();
        } else {
            sTrgFolder = trgFile.getParent();
            trgFilePattern = trgFile.getPath().substring(sTrgFolder.length() + 1);
            if (StringOperations.countMatchingGroup((String)trgFilePattern) > 0) {
                bTrgIsPattern = true;
            }
        }
        System.out.println(Messages.getString("FileOperationsI.8"));
        System.out.println("bSrcIsDir = " + bSrcIsDir);
        System.out.println("bSrcIsPattern = " + bSrcIsPattern);
        System.out.println("sSrcFolder = " + sSrcFolder);
        System.out.println("srcFilePattern = " + srcFilePattern);
        System.out.println("bTrgIsDir = " + bTrgIsDir);
        System.out.println("bTrgIsPattern = " + bTrgIsPattern);
        System.out.println("sTrgFolder = " + sTrgFolder);
        System.out.println("trgFilePattern = " + trgFilePattern);
        if (bSrcIsDir & !bTrgIsDir) {
            throw new EngineExceptionI(Messages.getString("FileOperationsI.9"));
        }
        int nbCopyOrMove = 0;
        if (bSrcIsDir & mode.equals("copy") | bSrcIsPattern) {
            File fSrcFolder;
            System.out.println(Messages.getString("FileOperationsI.10"));
            try {
                fSrcFolder = new File(sSrcFolder);
            }
            catch (NullPointerException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            File[] lstSrcFiles = fSrcFolder.listFiles();
            if (lstSrcFiles != null && lstSrcFiles.length != 0) {
                int i = 0;
                while (i < lstSrcFiles.length) {
                    String trgFileName;
                    Boolean deepResearchOn = false;
                    if (!bSrcIsPattern) {
                        trgFileName = lstSrcFiles[i].getName();
                    } else {
                        System.out.println("Match ? " + lstSrcFiles[i].getName());
                        Boolean matched = StringOperations.matchPattern((String)StringOperations.replaceWildCharsWithGroups((String)srcFilePattern), (String)lstSrcFiles[i].getName());
                        if (matched | deepResearch & lstSrcFiles[i].isDirectory()) {
                            if (matched.booleanValue()) {
                                System.out.println("Match !!! ");
                            } else if (deepResearch) {
                                System.out.println("Deep Research !!! ");
                                deepResearchOn = true;
                            }
                            if (bTrgIsDir) {
                                trgFileName = lstSrcFiles[i].getName();
                            } else if (bTrgIsPattern & deepResearchOn == false) {
                                trgFileName = StringOperations.getMatchingTargetString((String)srcFilePattern, (String)trgFilePattern, (String)lstSrcFiles[i].getName());
                                System.out.println("Match Target = " + trgFileName);
                                if (trgFileName.equals("")) {
                                    trgFileName = lstSrcFiles[i].getName();
                                }
                            } else {
                                trgFileName = lstSrcFiles[i].getName();
                            }
                        } else {
                            trgFileName = null;
                        }
                    }
                    if (trgFileName != null) {
                        if (!lstSrcFiles[i].isDirectory()) {
                            if (mode.equals("move")) {
                                if (autoCreateFolders) {
                                    FileOperationsI.createFolder(sTrgFolder);
                                }
                                FileOperationsI.moveOneFile(lstSrcFiles[i], new File(sTrgFolder, trgFileName), overwrite);
                                ++nbCopyOrMove;
                            } else if (mode.equals("copy")) {
                                if (autoCreateFolders) {
                                    FileOperationsI.createFolder(sTrgFolder);
                                }
                                FileOperationsI.copyOneFile(lstSrcFiles[i], new File(sTrgFolder, trgFileName), overwrite);
                                ++nbCopyOrMove;
                            }
                        } else if (recurseMode) {
                            if (mode.equals("move")) {
                                if (deepResearchOn.booleanValue()) {
                                    nbCopyOrMove += FileOperationsI.moveOrCopyFiles(new File(lstSrcFiles[i].getPath(), srcFilePattern).getPath(), new File(sTrgFolder, trgFileName).getPath(), trgFilePattern, autoCreateFolders, overwrite, recurseMode, deepResearch, mode);
                                } else {
                                    FileOperationsI.moveOneFile(lstSrcFiles[i], new File(sTrgFolder, trgFileName), overwrite);
                                    ++nbCopyOrMove;
                                }
                            } else if (mode.equals("copy")) {
                                try {
                                    nbCopyOrMove = deepResearchOn.booleanValue() ? (nbCopyOrMove += FileOperationsI.moveOrCopyFiles(new File(lstSrcFiles[i].getPath(), srcFilePattern).getPath(), new File(sTrgFolder, trgFileName).getPath(), trgFilePattern, autoCreateFolders, overwrite, recurseMode, deepResearch, mode)) : (nbCopyOrMove += FileOperationsI.moveOrCopyFiles(lstSrcFiles[i].getPath(), new File(sTrgFolder, trgFileName).getPath(), "", autoCreateFolders, overwrite, recurseMode, deepResearch, mode));
                                }
                                catch (NullPointerException e) {
                                    throw new EngineExceptionI((Throwable)e);
                                }
                                catch (IllegalArgumentException e) {
                                    throw new EngineExceptionI((Throwable)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            System.out.println("nbCopyOrMove : " + nbCopyOrMove);
        } else {
            System.out.println(Messages.getString("FileOperationsI.11"));
            if (bTrgIsPattern) {
                throw new EngineExceptionI(Messages.getString("FileOperationsI.12"));
            }
            if (autoCreateFolders) {
                FileOperationsI.createFolder(sTrgFolder);
            }
            if (mode.equals("move")) {
                if (bTrgIsDir) {
                    FileOperationsI.moveOneFile(srcFile, new File(trgFile, srcFilePattern), overwrite);
                } else {
                    FileOperationsI.moveOneFile(srcFile, trgFile, overwrite);
                }
                ++nbCopyOrMove;
            } else if (mode.equals("copy")) {
                if (bTrgIsDir) {
                    FileOperationsI.copyOneFile(srcFile, new File(trgFile, srcFilePattern), overwrite);
                } else {
                    FileOperationsI.copyOneFile(srcFile, trgFile, overwrite);
                }
                ++nbCopyOrMove;
            }
        }
        return nbCopyOrMove;
    }
}

