/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant.optional.ssh;

import com.indy.engine.action.ant.optional.ssh.Messages;
import com.indy.engine.action.ant.optional.ssh.SSHBase;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;
import org.apache.tools.ant.taskdefs.optional.ssh.LogListener;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessageBySftp;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessageBySftp;
import org.apache.tools.ant.types.FileSet;

public class Scp
extends SSHBase {
    private static final String[] FROM_ATTRS = new String[]{"file", "localfile", "remotefile"};
    private static final String[] TO_ATTRS = new String[]{"todir", "localtodir", "remotetodir", "localtofile", "remotetofile"};
    private String fromUri;
    private String toUri;
    private List fileSets = null;
    private boolean isFromRemote;
    private boolean isToRemote;
    private boolean isSftp = false;
    private boolean scpPreserveFileDate;
    private long maxwait = 0L;

    public void setPreserveFileDate(boolean yesOrNo) {
        this.scpPreserveFileDate = yesOrNo;
    }

    public void setFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = this.isRemoteUri(this.fromUri);
    }

    public void setTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = this.isRemoteUri(this.toUri);
    }

    public void setLocalFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = false;
    }

    public void setRemoteFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = true;
    }

    public void setLocalTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setRemoteTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    public void setLocalTofile(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setRemoteTofile(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    public void setSftp(boolean yesOrNo) {
        this.isSftp = yesOrNo;
    }

    public void addFileset(FileSet set) {
        if (this.fileSets == null) {
            this.fileSets = new LinkedList();
        }
        this.fileSets.add(set);
    }

    @Override
    public void init() throws BuildException {
        super.init();
        this.toUri = null;
        this.fromUri = null;
        this.fileSets = null;
    }

    public void execute() throws BuildException {
        block10: {
            if (this.toUri == null) {
                throw this.exactlyOne(TO_ATTRS);
            }
            if (this.fromUri == null && this.fileSets == null) {
                throw this.exactlyOne(FROM_ATTRS, Messages.getString("Scp.0"));
            }
            try {
                if (this.isFromRemote && !this.isToRemote) {
                    this.download(this.fromUri, this.toUri);
                    break block10;
                }
                if (!this.isFromRemote && this.isToRemote) {
                    if (this.fileSets != null) {
                        this.upload(this.fileSets, this.toUri);
                    } else {
                        this.upload(this.fromUri, this.toUri);
                    }
                    break block10;
                }
                if (this.isFromRemote && this.isToRemote) {
                    throw new BuildException(Messages.getString("Scp.1"));
                }
                throw new BuildException(String.valueOf(Messages.getString("Scp.2")) + Messages.getString("Scp.3") + Messages.getString("Scp.4"));
            }
            catch (Exception e) {
                if (this.getFailonerror()) {
                    throw new BuildException((Throwable)e);
                }
                this.log(String.valueOf(Messages.getString("Scp.5")) + e.getMessage(), 0);
            }
        }
    }

    private void download(String fromSshUri, String toPath) throws JSchException, IOException {
        String file = this.parseUri(fromSshUri);
        Session session = null;
        try {
            session = this.openSession();
            if (this.maxwait > 0L) {
                session.setTimeout((int)this.maxwait);
            }
            ScpFromMessage message = null;
            if (!this.isSftp) {
                message = new ScpFromMessage(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"), this.scpPreserveFileDate);
            } else {
                String remoteFile;
                block18: {
                    remoteFile = file;
                    if (file.charAt(0) == '/') {
                        if (file.length() > 1 && file.charAt(1) != '/') {
                            file = String.valueOf('/') + file;
                        }
                        remoteFile = file;
                    } else {
                        ChannelSftp channel = null;
                        try {
                            try {
                                channel = (ChannelSftp)session.openChannel("sftp");
                                channel.connect();
                                remoteFile = this.remoteAbsolutePath(channel, file);
                            }
                            catch (SftpException sftpException) {
                                if (channel != null) {
                                    channel.disconnect();
                                }
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                channel.disconnect();
                            }
                            throw throwable;
                        }
                        if (channel != null) {
                            channel.disconnect();
                        }
                    }
                }
                message = new ScpFromMessageBySftp(this.getVerbose(), session, remoteFile, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"), this.scpPreserveFileDate);
            }
            this.log(String.valueOf(Messages.getString("Scp.6")) + file);
            message.setLogListener((LogListener)this);
            message.execute();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private void upload(List fileSet, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            ArrayList<Directory> list = new ArrayList<Directory>(fileSet.size());
            for (FileSet set : fileSet) {
                Directory d = this.createDirectory(set);
                if (d == null) continue;
                list.add(d);
            }
            if (!list.isEmpty()) {
                session = this.openSession();
                if (this.maxwait > 0L) {
                    session.setTimeout((int)this.maxwait);
                }
                Object message = null;
                message = !this.isSftp ? new ScpToMessage(this.getVerbose(), session, list, file, this.scpPreserveFileDate) : new ScpToMessageBySftp(this.getVerbose(), session, list, file, this.scpPreserveFileDate);
                message.setLogListener((LogListener)this);
                message.execute();
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private void upload(String fromPath, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            session = this.openSession();
            if (this.maxwait > 0L) {
                session.setTimeout((int)this.maxwait);
            }
            Object message = null;
            message = !this.isSftp ? new ScpToMessage(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file, this.scpPreserveFileDate) : new ScpToMessageBySftp(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file, this.scpPreserveFileDate);
            message.setLogListener((LogListener)this);
            message.execute();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private String parseUri(String uri) {
        int indexOfAt = uri.lastIndexOf(64);
        int indexOfColon = uri.indexOf(58);
        if (indexOfColon > -1 && indexOfColon < indexOfAt) {
            this.setUsername(uri.substring(0, indexOfColon));
            this.setPassword(uri.substring(indexOfColon + 1, indexOfAt));
        } else {
            this.setUsername(uri.substring(0, indexOfAt));
        }
        if (this.getUserInfo().getPassword() == null && this.getUserInfo().getPassphrase() == null) {
            throw new BuildException(String.valueOf(Messages.getString("Scp.7")) + this.getUserInfo().getName() + Messages.getString("Scp.8") + Messages.getString("Scp.9"));
        }
        int indexOfPath = uri.indexOf(58, indexOfAt + 1);
        if (indexOfPath == -1) {
            throw new BuildException(String.valueOf(Messages.getString("Scp.10")) + uri);
        }
        this.setHost(uri.substring(indexOfAt + 1, indexOfPath));
        String remotePath = uri.substring(indexOfPath + 1);
        if (remotePath.equals("")) {
            remotePath = ".";
        }
        return remotePath;
    }

    private boolean isRemoteUri(String uri) {
        boolean isRemote = true;
        int indexOfAt = uri.indexOf(64);
        if (indexOfAt < 0) {
            isRemote = false;
        }
        return isRemote;
    }

    private Directory createDirectory(FileSet set) {
        DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
        Directory root = new Directory(scanner.getBasedir());
        String[] files = scanner.getIncludedFiles();
        if (files.length != 0) {
            int j = 0;
            while (j < files.length) {
                String[] path = Directory.getPath((String)files[j]);
                Directory current = root;
                File currentParent = scanner.getBasedir();
                int i = 0;
                while (i < path.length) {
                    File file = new File(currentParent, path[i]);
                    if (file.isDirectory()) {
                        current.addDirectory(new Directory(file));
                        current = current.getChild(file);
                        currentParent = current.getDirectory();
                    } else if (file.isFile()) {
                        current.addFile(file);
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            root = null;
        }
        return root;
    }

    private void setFromUri(String fromUri) {
        if (this.fromUri != null) {
            throw this.exactlyOne(FROM_ATTRS);
        }
        this.fromUri = fromUri;
    }

    private void setToUri(String toUri) {
        if (this.toUri != null) {
            throw this.exactlyOne(TO_ATTRS);
        }
        this.toUri = toUri;
    }

    private BuildException exactlyOne(String[] attrs) {
        return this.exactlyOne(attrs, null);
    }

    private BuildException exactlyOne(String[] attrs, String alt) {
        StringBuffer buf = new StringBuffer(Messages.getString("Scp.12")).append('[').append(attrs[0]);
        int i = 1;
        while (i < attrs.length) {
            buf.append('|').append(attrs[i]);
            ++i;
        }
        buf.append(']');
        if (alt != null) {
            buf.append(" or ").append(alt);
        }
        return new BuildException(buf.append(Messages.getString("Scp.11")).toString());
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    private String remoteAbsolutePath(ChannelSftp channel, String path) throws SftpException {
        if (path.charAt(0) == '/') {
            return path;
        }
        String cwd = channel.getHome();
        if (cwd.endsWith("/")) {
            return String.valueOf(cwd) + path;
        }
        return String.valueOf(cwd) + "/" + path;
    }
}

