/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant.taskdefs;

import com.indy.engine.action.ant.taskdefs.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    static final File NULL_FILE_PLACEHOLDER = new File("/NULL_FILE");
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector rcs = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    protected boolean failonerror = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Hashtable completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    protected FileUtils fileUtils;
    private Vector filterChains = new Vector();
    private Vector filterSets = new Vector();
    private String inputEncoding = null;
    private String outputEncoding = null;
    private long granularity = 0L;
    Listener listener;
    int numFile;

    public Copy() {
        this.fileUtils = FileUtils.getFileUtils();
        this.granularity = this.fileUtils.getFileTimestampGranularity();
    }

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File destFile) {
        this.destFile = destFile;
    }

    public void setTodir(File destDir) {
        this.destDir = destDir;
    }

    public FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return filterChain;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void setPreserveLastModified(String preserve) {
        this.setPreserveLastModified(Project.toBoolean((String)preserve));
    }

    public void setPreserveLastModified(boolean preserve) {
        this.preserveLastModified = preserve;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected Vector getFilterChains() {
        return this.filterChains;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setEnableMultipleMappings(boolean enableMultipleMappings) {
        this.enableMultipleMappings = enableMultipleMappings;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException(Messages.getString("Copy.0"), this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setEncoding(String encoding) {
        this.inputEncoding = encoding;
        if (this.outputEncoding == null) {
            this.outputEncoding = encoding;
        }
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    public void execute() throws BuildException {
        block24: {
            File savedFile = this.file;
            File savedDestFile = this.destFile;
            File savedDestDir = this.destDir;
            ResourceCollection savedRc = null;
            if (this.file == null && this.destFile != null && this.rcs.size() == 1) {
                savedRc = (ResourceCollection)this.rcs.elementAt(0);
            }
            this.validateAttributes();
            try {
                this.copySingleFile();
                HashMap filesByBasedir = new HashMap();
                HashMap dirsByBasedir = new HashMap();
                HashSet<File> baseDirs = new HashSet<File>();
                ArrayList<Resource> nonFileResources = new ArrayList<Resource>();
                int i = 0;
                while (i < this.rcs.size()) {
                    block23: {
                        ResourceCollection rc = (ResourceCollection)this.rcs.elementAt(i);
                        if (rc instanceof FileSet && rc.isFilesystemOnly()) {
                            FileSet fs = (FileSet)rc;
                            DirectoryScanner ds = null;
                            try {
                                ds = fs.getDirectoryScanner(this.getProject());
                            }
                            catch (BuildException e) {
                                if (this.failonerror || !this.getMessage((Exception)((Object)e)).endsWith(" not found.")) {
                                    throw e;
                                }
                                this.log(String.valueOf(Messages.getString("Copy.1")) + this.getMessage((Exception)((Object)e)), 0);
                                break block23;
                            }
                            File fromDir = fs.getDir(this.getProject());
                            String[] srcFiles = ds.getIncludedFiles();
                            String[] srcDirs = ds.getIncludedDirectories();
                            if (!this.flatten && this.mapperElement == null && ds.isEverythingIncluded() && !fs.hasPatterns()) {
                                this.completeDirMap.put(fromDir, this.destDir);
                            }
                            Copy.add(fromDir, srcFiles, filesByBasedir);
                            Copy.add(fromDir, srcDirs, dirsByBasedir);
                            baseDirs.add(fromDir);
                        } else {
                            if (!rc.isFilesystemOnly() && !this.supportsNonFileResources()) {
                                throw new BuildException(Messages.getString("Copy.2"));
                            }
                            for (Resource r : rc) {
                                if (!r.isExists()) continue;
                                File baseDir = NULL_FILE_PLACEHOLDER;
                                String name = r.getName();
                                if (r instanceof FileResource) {
                                    FileResource fr = (FileResource)r;
                                    baseDir = Copy.getKeyFile(fr.getBaseDir());
                                    if (fr.getBaseDir() == null) {
                                        name = fr.getFile().getAbsolutePath();
                                    }
                                }
                                if (r.isDirectory() || r instanceof FileResource) {
                                    Copy.add(baseDir, name, r.isDirectory() ? dirsByBasedir : filesByBasedir);
                                    baseDirs.add(baseDir);
                                    continue;
                                }
                                nonFileResources.add(r);
                            }
                        }
                    }
                    ++i;
                }
                this.iterateOverBaseDirs(baseDirs, dirsByBasedir, filesByBasedir);
                try {
                    this.doFileOperations();
                }
                catch (BuildException e) {
                    if (!this.failonerror) {
                        this.log(String.valueOf(Messages.getString("Copy.3")) + this.getMessage((Exception)((Object)e)), 0);
                    }
                    throw e;
                }
                if (nonFileResources.size() <= 0) break block24;
                Resource[] nonFiles = nonFileResources.toArray(new Resource[nonFileResources.size()]);
                Map map = this.scan(nonFiles, this.destDir);
                try {
                    this.doResourceOperations(map);
                }
                catch (BuildException e) {
                    if (!this.failonerror) {
                        this.log(String.valueOf(Messages.getString("Copy.4")) + this.getMessage((Exception)((Object)e)), 0);
                        break block24;
                    }
                    throw e;
                }
            }
            finally {
                this.file = savedFile;
                this.destFile = savedDestFile;
                this.destDir = savedDestDir;
                if (savedRc != null) {
                    this.rcs.insertElementAt(savedRc, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    private void copySingleFile() {
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                } else {
                    this.log(this.file + Messages.getString("Copy.5") + this.destFile + Messages.getString("Copy.6"), 3);
                }
            } else {
                String message = String.valueOf(Messages.getString("Copy.7")) + this.file.getAbsolutePath() + Messages.getString("Copy.8");
                if (!this.failonerror) {
                    this.log(message, 0);
                } else {
                    throw new BuildException(message);
                }
            }
        }
    }

    private void iterateOverBaseDirs(HashSet baseDirs, HashMap dirsByBasedir, HashMap filesByBasedir) {
        for (File f : baseDirs) {
            List files = (List)filesByBasedir.get(f);
            List dirs = (List)dirsByBasedir.get(f);
            String[] srcFiles = new String[]{};
            if (files != null) {
                srcFiles = files.toArray(srcFiles);
            }
            String[] srcDirs = new String[]{};
            if (dirs != null) {
                srcDirs = dirs.toArray(srcDirs);
            }
            this.scan(f == NULL_FILE_PLACEHOLDER ? null : f, this.destDir, srcFiles, srcDirs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.rcs.size() == 0) {
            throw new BuildException(Messages.getString("Copy.9"));
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException(Messages.getString("Copy.10"));
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException(Messages.getString("Copy.11"));
        }
        if (this.file != null && this.file.isDirectory()) {
            throw new BuildException(Messages.getString("Copy.12"));
        }
        if (this.destFile != null && this.rcs.size() > 0) {
            if (this.rcs.size() > 1) {
                throw new BuildException(Messages.getString("Copy.13"));
            }
            ResourceCollection rc = (ResourceCollection)this.rcs.elementAt(0);
            if (!rc.isFilesystemOnly()) {
                throw new BuildException(String.valueOf(Messages.getString("Copy.14")) + Messages.getString("Copy.15") + Messages.getString("Copy.16"));
            }
            if (rc.size() == 0) {
                throw new BuildException(Messages.getString("Copy.17"));
            }
            if (rc.size() != 1) throw new BuildException(Messages.getString("Copy.19"));
            FileResource r = (FileResource)rc.iterator().next();
            if (this.file != null) throw new BuildException(Messages.getString("Copy.18"));
            this.file = r.getFile();
            this.rcs.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.destFile.getParentFile();
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) {
        FileNameMapper mapper = this.getMapper();
        this.buildMap(fromDir, toDir, files, mapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(fromDir, toDir, dirs, mapper, this.dirCopyMap);
        }
    }

    protected Map scan(Resource[] fromResources, File toDir) {
        return this.buildMap(fromResources, toDir, this.getMapper());
    }

    protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable map) {
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < names.length) {
                if (mapper.mapFileName(names[i]) != null) {
                    v.addElement(names[i]);
                }
                ++i;
            }
            toCopy = new String[v.size()];
            v.copyInto(toCopy);
        } else {
            SourceFileScanner ds = new SourceFileScanner((Task)this);
            toCopy = ds.restrict(names, fromDir, toDir, mapper, this.granularity);
        }
        int i = 0;
        while (i < toCopy.length) {
            File src = new File(fromDir, (String)toCopy[i]);
            String[] mappedFiles = mapper.mapFileName((String)toCopy[i]);
            if (!this.enableMultipleMappings) {
                map.put(src.getAbsolutePath(), new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
            } else {
                int k = 0;
                while (k < mappedFiles.length) {
                    mappedFiles[k] = new File(toDir, mappedFiles[k]).getAbsolutePath();
                    ++k;
                }
                map.put(src.getAbsolutePath(), mappedFiles);
            }
            ++i;
        }
    }

    protected Map buildMap(Resource[] fromResources, final File toDir, FileNameMapper mapper) {
        HashMap<Object, String[]> map = new HashMap<Object, String[]>();
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<Resource> v = new Vector<Resource>();
            int i = 0;
            while (i < fromResources.length) {
                if (mapper.mapFileName(fromResources[i].getName()) != null) {
                    v.addElement(fromResources[i]);
                }
                ++i;
            }
            toCopy = new Resource[v.size()];
            v.copyInto(toCopy);
        } else {
            toCopy = ResourceUtils.selectOutOfDateSources((ProjectComponent)this, (Resource[])fromResources, (FileNameMapper)mapper, (ResourceFactory)new ResourceFactory(){

                public Resource getResource(String name) {
                    return new FileResource(toDir, name);
                }
            }, (long)this.granularity);
        }
        int i = 0;
        while (i < toCopy.length) {
            String[] mappedFiles = mapper.mapFileName(toCopy[i].getName());
            if (!this.enableMultipleMappings) {
                map.put(toCopy[i], new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
            } else {
                int k = 0;
                while (k < mappedFiles.length) {
                    mappedFiles[k] = new File(toDir, mappedFiles[k]).getAbsolutePath();
                    ++k;
                }
                map.put(toCopy[i], mappedFiles);
            }
            ++i;
        }
        return map;
    }

    protected void doFileOperations() {
        int i;
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log(String.valueOf(Messages.getString("Copy.20")) + this.fileCopyMap.size() + Messages.getString("Copy.21") + (this.fileCopyMap.size() == 1 ? "" : "s") + Messages.getString("Copy.22") + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                i = 0;
                while (i < toFiles.length) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log(String.valueOf(Messages.getString("Copy.23")) + fromFile, this.verbosity);
                    } else {
                        try {
                            this.log(String.valueOf(Messages.getString("Copy.24")) + fromFile + Messages.getString("Copy.25") + toFile, this.verbosity);
                            FilterSetCollection executionFilters = new FilterSetCollection();
                            if (this.filtering) {
                                executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                            }
                            Enumeration filterEnum = this.filterSets.elements();
                            while (filterEnum.hasMoreElements()) {
                                executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                            }
                            this.fileUtils.copyFile(fromFile, toFile, executionFilters, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                            ++this.numFile;
                            if (this.listener != null) {
                                this.listener.copyFile(this.numFile, fromFile, toFile);
                            }
                        }
                        catch (IOException ioe) {
                            String msg = String.valueOf(Messages.getString("Copy.26")) + fromFile + Messages.getString("Copy.27") + toFile + Messages.getString("Copy.28") + this.getDueTo(ioe);
                            File targetFile = new File(toFile);
                            if (targetFile.exists() && !targetFile.delete()) {
                                msg = String.valueOf(msg) + Messages.getString("Copy.29") + toFile;
                            }
                            if (this.failonerror) {
                                throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                            }
                            this.log(msg, 0);
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String[] dirs = (String[])e.nextElement();
                i = 0;
                while (i < dirs.length) {
                    File d = new File(dirs[i]);
                    if (!d.exists()) {
                        if (!d.mkdirs()) {
                            this.log(String.valueOf(Messages.getString("Copy.30")) + d.getAbsolutePath(), 0);
                        } else {
                            ++createCount;
                        }
                    }
                    ++i;
                }
            }
            if (createCount > 0) {
                this.log(String.valueOf(Messages.getString("Copy.31")) + this.dirCopyMap.size() + Messages.getString("Copy.32") + (this.dirCopyMap.size() == 1 ? "y" : "ies") + Messages.getString("Copy.33") + createCount + Messages.getString("Copy.34") + (createCount == 1 ? "y" : "ies") + Messages.getString("Copy.35") + this.destDir.getAbsolutePath());
            }
        }
    }

    protected void doResourceOperations(Map map) {
        if (map.size() > 0) {
            this.log(String.valueOf(Messages.getString("Copy.36")) + map.size() + Messages.getString("Copy.37") + (map.size() == 1 ? "" : "s") + Messages.getString("Copy.38") + this.destDir.getAbsolutePath());
            for (Resource fromResource : map.keySet()) {
                String[] toFiles = (String[])map.get(fromResource);
                int i = 0;
                while (i < toFiles.length) {
                    String toFile = toFiles[i];
                    try {
                        this.log(String.valueOf(Messages.getString("Copy.39")) + fromResource + Messages.getString("Copy.40") + toFile, this.verbosity);
                        FilterSetCollection executionFilters = new FilterSetCollection();
                        if (this.filtering) {
                            executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        Enumeration filterEnum = this.filterSets.elements();
                        while (filterEnum.hasMoreElements()) {
                            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                        }
                        ResourceUtils.copyResource((Resource)fromResource, (Resource)new FileResource(this.destDir, toFile), (FilterSetCollection)executionFilters, (Vector)this.filterChains, (boolean)this.forceOverwrite, (boolean)this.preserveLastModified, (String)this.inputEncoding, (String)this.outputEncoding, (Project)this.getProject());
                    }
                    catch (IOException ioe) {
                        String msg = String.valueOf(Messages.getString("Copy.41")) + fromResource + Messages.getString("Copy.42") + toFile + Messages.getString("Copy.43") + this.getDueTo(ioe);
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = String.valueOf(msg) + Messages.getString("Copy.44") + toFile;
                        }
                        if (this.failonerror) {
                            throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                        }
                        this.log(msg, 0);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean supportsNonFileResources() {
        return ((Object)((Object)this)).getClass().equals(Copy.class);
    }

    private static void add(File baseDir, String[] names, Map m) {
        if (names != null) {
            ArrayList<String> l = (ArrayList<String>)m.get(baseDir = Copy.getKeyFile(baseDir));
            if (l == null) {
                l = new ArrayList<String>(names.length);
                m.put(baseDir, l);
            }
            l.addAll(Arrays.asList(names));
        }
    }

    private static void add(File baseDir, String name, Map m) {
        if (name != null) {
            Copy.add(baseDir, new String[]{name}, m);
        }
    }

    private static File getKeyFile(File f) {
        return f == null ? NULL_FILE_PLACEHOLDER : f;
    }

    private FileNameMapper getMapper() {
        Object mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        return mapper;
    }

    private String getMessage(Exception ex) {
        return ex.getMessage() == null ? ex.toString() : ex.getMessage();
    }

    private String getDueTo(Exception ex) {
        boolean baseIOException = ex.getClass() == IOException.class;
        StringBuffer message = new StringBuffer();
        if (!baseIOException || ex.getMessage() == null) {
            message.append(ex.getClass().getName());
        }
        if (ex.getMessage() != null) {
            if (!baseIOException) {
                message.append(" ");
            }
            message.append(ex.getMessage());
        }
        if (ex.getClass().getName().indexOf("MalformedInput") != -1) {
            message.append(LINE_SEPARATOR);
            message.append(Messages.getString("Copy.45"));
            message.append(LINE_SEPARATOR);
            message.append(Messages.getString("Copy.46"));
            message.append(this.inputEncoding == null ? this.fileUtils.getDefaultEncoding() : this.inputEncoding);
            message.append(LINE_SEPARATOR);
        }
        return message.toString();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public int getNumFile() {
        return this.numFile;
    }

    public void setNumFile(int numFile) {
        this.numFile = numFile;
    }

    public static interface Listener {
        public void copyFile(int var1, String var2, String var3) throws IOException;
    }
}

