/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant.taskdefs;

import com.indy.engine.action.ant.taskdefs.Copy;
import com.indy.engine.action.ant.taskdefs.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    Listener listener;
    int numFile = 0;

    public Move() {
        this.setOverwrite(true);
    }

    @Override
    protected void validateAttributes() throws BuildException {
        if (this.file != null && this.file.isDirectory()) {
            if (this.destFile != null && this.destDir != null || this.destFile == null && this.destDir == null) {
                throw new BuildException(Messages.getString("Move.0"));
            }
            this.destFile = this.destFile == null ? new File(this.destDir, this.file.getName()) : this.destFile;
            this.destDir = this.destDir == null ? this.destFile.getParentFile() : this.destDir;
            this.completeDirMap.put(this.file, this.destFile);
            this.file = null;
        } else {
            super.validateAttributes();
        }
    }

    @Override
    protected void doFileOperations() {
        int moveCount;
        if (this.completeDirMap.size() > 0) {
            for (File fromDir : this.completeDirMap.keySet()) {
                File toDir = (File)this.completeDirMap.get(fromDir);
                boolean renamed = false;
                try {
                    this.log(String.valueOf(Messages.getString("Move.1")) + fromDir + Messages.getString("Move.2") + toDir, this.verbosity);
                    renamed = this.renameFile(fromDir, toDir, this.filtering, this.forceOverwrite);
                    ++this.numFile;
                    if (this.listener != null) {
                        this.listener.moveFile(this.numFile, fromDir, toDir);
                    }
                }
                catch (IOException ioe) {
                    String msg = String.valueOf(Messages.getString("Move.3")) + fromDir + Messages.getString("Move.4") + toDir + Messages.getString("Move.5") + ioe.getMessage();
                    throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                }
                if (renamed) continue;
                FileSet fs = new FileSet();
                fs.setProject(this.getProject());
                fs.setDir(fromDir);
                this.addFileset(fs);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                String[] dirs = ds.getIncludedDirectories();
                this.scan(fromDir, toDir, files, dirs);
            }
        }
        if ((moveCount = this.fileCopyMap.size()) > 0) {
            this.log(String.valueOf(Messages.getString("Move.6")) + moveCount + Messages.getString("Move.7") + (moveCount == 1 ? "" : "s") + Messages.getString("Move.8") + this.destDir.getAbsolutePath());
            for (String fromFile : this.fileCopyMap.keySet()) {
                File f = new File(fromFile);
                boolean selfMove = false;
                if (!f.exists()) continue;
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                int i = 0;
                while (i < toFiles.length) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log(String.valueOf(Messages.getString("Move.9")) + fromFile, this.verbosity);
                        selfMove = true;
                    } else {
                        File d = new File(toFile);
                        if (i + 1 == toFiles.length && !selfMove) {
                            this.moveFile(f, d, this.filtering, this.forceOverwrite);
                            ++this.numFile;
                            if (this.listener != null) {
                                this.listener.moveFile(this.numFile, f, d);
                            }
                        } else {
                            this.copyFile(f, d, this.filtering, this.forceOverwrite);
                            ++this.numFile;
                            if (this.listener != null) {
                                this.listener.moveFile(this.numFile, f, d);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.includeEmpty) {
            int createCount = 0;
            for (String fromDirName : this.dirCopyMap.keySet()) {
                String[] toDirNames = (String[])this.dirCopyMap.get(fromDirName);
                boolean selfMove = false;
                int i = 0;
                while (i < toDirNames.length) {
                    if (fromDirName.equals(toDirNames[i])) {
                        this.log(String.valueOf(Messages.getString("Move.10")) + fromDirName, this.verbosity);
                        selfMove = true;
                    } else {
                        File d = new File(toDirNames[i]);
                        if (!d.exists()) {
                            if (!d.mkdirs()) {
                                this.log(String.valueOf(Messages.getString("Move.11")) + d.getAbsolutePath(), 0);
                            } else {
                                ++createCount;
                            }
                        }
                    }
                    ++i;
                }
                File fromDir = new File(fromDirName);
                if (selfMove || !this.okToDelete(fromDir)) continue;
                this.deleteDir(fromDir);
            }
            if (createCount > 0) {
                this.log(String.valueOf(Messages.getString("Move.12")) + this.dirCopyMap.size() + Messages.getString("Move.13") + (this.dirCopyMap.size() == 1 ? "y" : "ies") + Messages.getString("Move.14") + createCount + Messages.getString("Move.15") + (createCount == 1 ? "y" : "ies") + Messages.getString("Move.16") + this.destDir.getAbsolutePath());
            }
        }
    }

    private void moveFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        boolean moved = false;
        try {
            this.log(String.valueOf(Messages.getString("Move.17")) + fromFile + Messages.getString("Move.18") + toFile, this.verbosity);
            moved = this.renameFile(fromFile, toFile, filtering, this.forceOverwrite);
        }
        catch (IOException ioe) {
            String msg = String.valueOf(Messages.getString("Move.19")) + fromFile + Messages.getString("Move.20") + toFile + Messages.getString("Move.21") + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe, this.getLocation());
        }
        if (!moved) {
            this.copyFile(fromFile, toFile, filtering, overwrite);
            if (!fromFile.delete()) {
                throw new BuildException(String.valueOf(Messages.getString("Move.22")) + Messages.getString("Move.23") + fromFile.getAbsolutePath());
            }
        }
    }

    private void copyFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        try {
            this.log(String.valueOf(Messages.getString("Move.24")) + fromFile + Messages.getString("Move.25") + toFile, this.verbosity);
            FilterSetCollection executionFilters = new FilterSetCollection();
            if (filtering) {
                executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
            }
            Iterator filterIter = this.getFilterSets().iterator();
            while (filterIter.hasNext()) {
                executionFilters.addFilterSet((FilterSet)filterIter.next());
            }
            this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), this.getEncoding(), this.getOutputEncoding(), this.getProject());
        }
        catch (IOException ioe) {
            String msg = String.valueOf(Messages.getString("Move.26")) + fromFile + Messages.getString("Move.27") + toFile + Messages.getString("Move.28") + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe, this.getLocation());
        }
    }

    protected boolean okToDelete(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                if (!this.okToDelete(f)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void deleteDir(File d) {
        this.deleteDir(d, false);
    }

    protected void deleteDir(File d, boolean deleteFiles) {
        String[] list = d.list();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (!f.isDirectory()) {
                if (deleteFiles && !f.delete()) {
                    throw new BuildException(String.valueOf(Messages.getString("Move.29")) + f.getAbsolutePath());
                }
                throw new BuildException(String.valueOf(Messages.getString("Move.30")) + f.getAbsolutePath() + Messages.getString("Move.31"));
            }
            this.deleteDir(f);
            ++i;
        }
        this.log(String.valueOf(Messages.getString("Move.32")) + d.getAbsolutePath(), this.verbosity);
        if (!d.delete()) {
            throw new BuildException(String.valueOf(Messages.getString("Move.33")) + d.getAbsolutePath());
        }
    }

    protected boolean renameFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException, BuildException {
        if (destFile.isDirectory() || filtering || this.getFilterSets().size() > 0 || this.getFilterChains().size() > 0) {
            return false;
        }
        File parent = destFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        } else if (destFile.isFile()) {
            sourceFile = this.getFileUtils().normalize(sourceFile.getAbsolutePath()).getCanonicalFile();
            destFile = this.getFileUtils().normalize(destFile.getAbsolutePath());
            if (destFile.equals(sourceFile)) {
                return true;
            }
            if (!sourceFile.equals(destFile.getCanonicalFile()) && !destFile.delete()) {
                throw new BuildException(String.valueOf(Messages.getString("Move.34")) + destFile);
            }
        }
        return sourceFile.renameTo(destFile);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public int getNumFile() {
        return this.numFile;
    }

    @Override
    public void setNumFile(int numFile) {
        this.numFile = numFile;
    }

    public static interface Listener {
        public void moveFile(int var1, File var2, File var3);
    }
}

