/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AbstractAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPAcknowledgePolicy;
import com.indy.engine.actionCodes.amqp.AMQPConnection;
import com.indy.engine.actionCodes.amqp.AMQPConnectionProperties;
import com.indy.engine.actionCodes.amqp.AMQPRuntimeConnection;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretValue;
import com.rabbitmq.client.Address;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AMQPBaseAction
extends AbstractAction {
    AMQPAcknowledgePolicy acknowLedgePolicy;
    private AMQPConnectionProperties properties;
    String amqpChannelName;
    int amqpChannelTimeout;
    protected String encoding;
    AMQPConnection amqpConnection;
    protected String amqpQueueName;
    protected String amqpExchangeName;
    protected String amqpRoutingKey;
    protected Boolean amqpCommit;

    public AMQPBaseAction(String actionCodeName, boolean bNullCodeAllowed) {
        super(actionCodeName, bNullCodeAllowed);
    }

    protected void setConnection() throws InterruptedException, EngineExceptionI, IOException, TimeoutException {
        String managerName = "AMQP." + this.connectionName;
        ReentrantLock lockObject = this.engineContext.getConnectionlock();
        lockObject.lockInterruptibly();
        try {
            RuntimeDatasource dataSource;
            ConnectionManagerI connManager;
            if (!this.actionContext.existsConnectionManager(managerName)) {
                this.actionContext.addNewConnectionManager(managerName, this.connectionName, "AMQP");
                connManager = this.actionContext.getConnectionManager(managerName);
            } else {
                connManager = this.actionContext.getConnectionManager(managerName);
            }
            if (!connManager.hasRuntimeDataSource()) {
                dataSource = new RuntimeDatasource<AMQPConnection>(){
                    private AMQPRuntimeConnection runtimeConnection = null;

                    public AMQPRuntimeConnection getConnection(String name) throws EngineExceptionI {
                        if (this.runtimeConnection == null) {
                            AMQPConnection c = new AMQPConnection(AMQPBaseAction.this.properties);
                            try {
                                c.connect(AMQPBaseAction.this);
                            }
                            catch (EngineExceptionI e) {
                                throw e;
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                            this.runtimeConnection = new AMQPRuntimeConnection(c);
                        }
                        return this.runtimeConnection;
                    }
                };
                connManager.setRuntimeDataSource(dataSource);
                lockObject.unlock();
                connManager.unlockAll();
            } else {
                dataSource = connManager.getRuntimeDataSource();
                lockObject.unlock();
            }
            this.amqpConnection = (AMQPConnection)dataSource.getConnection(managerName).getUnderlyingConnection();
        }
        finally {
            if (lockObject.isHeldByCurrentThread() && lockObject.isLocked()) {
                lockObject.unlock();
            }
        }
    }

    protected void initChannel() throws IOException, TimeoutException, InterruptedException, EngineExceptionI {
        this.amqpConnection.getChannel(this.amqpChannelName, this.amqpChannelTimeout, this.acknowLedgePolicy == AMQPAcknowledgePolicy.transacted, this);
        this.publishVariable("AMQP_CHANNEL_STATUS", "LOCKING");
        this.amqpConnection.lockChannel(this.amqpChannelName, this.getActionContext().getActionName());
        this.publishVariable("AMQP_CHANNEL_STATUS", "LOCKED");
    }

    protected void releaseChannel() throws IOException {
        this.publishVariable("AMQP_CHANNEL_STATUS", "RELEASING");
        this.amqpConnection.unlockChannel(this.amqpChannelName, this.getActionContext().getActionName());
        this.publishVariable("AMQP_CHANNEL_STATUS", "RELEASED");
    }

    @Override
    public void execute() throws Throwable {
        this.setConnection();
        this.initChannel();
        try {
            this._execute();
        }
        finally {
            this.releaseChannel();
        }
    }

    public abstract void _execute() throws Throwable;

    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        this.connectionName = this.getLocalStringBindedParameter(rSet, "AMQP_CONNECTION");
        String _acknowLedgeMode = this.getLocalStringBindedParameter(rSet, "AMQP_ACKNOWLEDGE_MODE", "SESSION_TRANSACTED");
        if (_acknowLedgeMode.equals("SESSION_TRANSACTED")) {
            this.acknowLedgePolicy = AMQPAcknowledgePolicy.transacted;
        } else if (_acknowLedgeMode.equals("AUTO_ACKNOWLEDGE")) {
            this.acknowLedgePolicy = AMQPAcknowledgePolicy.auto;
        } else {
            throw new EngineExceptionI(String.valueOf(Messages.getString("AMQP.ERROR_001")) + _acknowLedgeMode);
        }
        final ISecretValue addresses = this.getLocalSecretBindedParameter(rSet, "AMQP_ADDRESSES", null);
        this.properties = new AMQPConnectionProperties(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Address[] getAddresses(ISecretContext context) throws Exception {
                String[] split;
                ArrayList<Address> amqpAddress = new ArrayList<Address>();
                String[] stringArray = split = addresses.getString(context).split(",");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String address = stringArray[n2];
                    if (address.contains(":")) {
                        String[] adr = address.split(":");
                        if (adr.length != 2) throw new EngineExceptionI(String.valueOf(Messages.getString("AMQP.ERROR_002")) + address);
                        amqpAddress.add(new Address(adr[0].trim(), Integer.valueOf(adr[1].trim()).intValue()));
                    } else {
                        amqpAddress.add(new Address(address.trim()));
                    }
                    ++n2;
                }
                Address[] ret = new Address[amqpAddress.size()];
                amqpAddress.toArray(ret);
                return ret;
            }
        };
        this.properties.setAmqpLogin(this.getLocalSecretBindedParameter(rSet, "AMQP_LOGIN", null));
        this.properties.setAmqpPassword(this.getLocalSecretBindedParameter(rSet, "AMQP_PASSWORD", this.getLocalStringBindedParameter(rSet, "AMQP_UNCRYPTED_PASSWORD", null)));
        this.properties.setConnectionTimeout(this.getLocalIntegerBindedParameter(rSet, "AMQP_CONNECTION_TIMEOUT", null));
        this.properties.setHandShakeTimeout(this.getLocalIntegerBindedParameter(rSet, "AMQP_HANDSHAKE_TIMEOUT", null));
        this.properties.setVirtualHost(this.getLocalSecretBindedParameter(rSet, "AMQP_VIRTUAL_HOST", null));
        this.amqpChannelName = this.getLocalStringBindedParameter(rSet, "AMQP_SESSION_NAME", "T1");
        this.amqpQueueName = this.getLocalStringBindedParameter(rSet, "AMQP_QUEUE_NAME", null);
        this.amqpRoutingKey = this.getLocalStringBindedParameter(rSet, "AMQP_ROUTING_KEY", null);
        this.amqpExchangeName = this.getLocalStringBindedParameter(rSet, "AMQP_EXCHANGE_NAME", null);
        this.amqpCommit = this.getLocalBooleanBindedParameter(rSet, "AMQP_COMMIT", false);
        this.encoding = this.getLocalStringBindedParameter(rSet, "AMQP_CONTENT_ENCODING", null);
    }

    protected void commit() throws IOException {
        if (this.amqpCommit.booleanValue()) {
            this.amqpConnection.commit(this.amqpChannelName);
        }
    }

    public void stopAction(Thread th) {
        super.stopAction(th);
    }
}

