/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AMQPBaseAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class AMQPOperationActionCodeI
extends AMQPBaseAction {
    private Operation operation;
    String exchangeDeclareType;
    boolean exchangeDeclareDurable;
    boolean exchangeDeclareAutoDelete;
    boolean queueDeclareDurable;
    boolean queueDeclareAutoDelete;
    boolean queueDeclareExclusive;
    Map<String, Object> headers;

    public AMQPOperationActionCodeI() {
        super("JMSOperationActionCodeI", true);
    }

    @Override
    public void _execute() throws Throwable {
        if (this.operation == Operation.commit) {
            this.amqpConnection.commit(this.amqpChannelName);
        } else if (this.operation == Operation.rollback) {
            this.amqpConnection.rollback(this.amqpChannelName);
        } else if (this.operation == Operation.declareexchange) {
            this.amqpConnection.declareExchange(this.amqpChannelName, this.amqpExchangeName, this.exchangeDeclareType, this.exchangeDeclareDurable, this.exchangeDeclareAutoDelete);
        } else if (this.operation == Operation.declarequeue) {
            this.amqpConnection.declareQueue(this.amqpChannelName, this.amqpQueueName, this.queueDeclareDurable, this.queueDeclareExclusive, this.queueDeclareAutoDelete);
        } else if (this.operation == Operation.bindqueue) {
            this.amqpConnection.bindQueue(this.amqpChannelName, this.amqpExchangeName, this.amqpQueueName, this.amqpRoutingKey, this.headers);
        } else if (this.operation == Operation.closesession) {
            this.amqpConnection.closeChannel(this.amqpChannelName);
        } else if (this.operation == Operation.opensession) {
            this.amqpConnection.getChannel(this.amqpChannelName);
        } else if (this.operation != Operation.openconnection) {
            if (this.operation == Operation.closeconnection) {
                this.amqpConnection.close();
            } else if (this.operation == Operation.unbindqueue) {
                this.amqpConnection.unBind(this.amqpChannelName, this.amqpExchangeName, this.amqpQueueName, this.amqpRoutingKey, this.headers);
            } else if (this.operation == Operation.deletequeue) {
                this.amqpConnection.deleteQueue(this.amqpChannelName, this.amqpQueueName);
            } else if (this.operation == Operation.deleteexchange) {
                this.amqpConnection.deleteExchange(this.amqpChannelName, this.amqpExchangeName);
            }
        }
    }

    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        super.prepare(rSet);
        this.operation = Operation.valueOf(this.getLocalStringBindedParameter(rSet, "AMQP_OPERATION", "commit").toLowerCase());
        if (this.operation == Operation.deleteexchange || this.operation == Operation.declareexchange) {
            AMQPUtils._assert(this.amqpExchangeName != null, Messages.getString("AMQP.ERROR_003"));
        }
        if (this.operation == Operation.unbindqueue || this.operation == Operation.bindqueue || this.operation == Operation.declarequeue) {
            AMQPUtils._assert(this.amqpQueueName != null, Messages.getString("AMQP.ERROR_004"));
        }
        if (this.operation == Operation.unbindqueue || this.operation == Operation.bindqueue) {
            AMQPUtils._assert(this.amqpExchangeName != null, Messages.getString("AMQP.ERROR_003"));
        }
        if (this.operation == Operation.declareexchange) {
            this.exchangeDeclareType = this.getLocalStringBindedParameter(rSet, "AMQP_EXCHANGE_TYPE", "direct").toLowerCase();
            this.exchangeDeclareDurable = this.getLocalBooleanBindedParameter(rSet, "AMQP_EXCHANGE_DURABLE", false);
            this.exchangeDeclareAutoDelete = this.getLocalBooleanBindedParameter(rSet, "AMQP_EXCHANGE_AUTO_DELETE", false);
        }
        if (this.operation == Operation.declarequeue) {
            this.queueDeclareDurable = this.getLocalBooleanBindedParameter(rSet, "AMQP_QUEUE_DURABLE", false);
            this.queueDeclareExclusive = this.getLocalBooleanBindedParameter(rSet, "AMQP_QUEUE_EXCLUSIVE", false);
            this.queueDeclareAutoDelete = this.getLocalBooleanBindedParameter(rSet, "AMQP_QUEUE_AUTO_DELETE", false);
        }
        if (this.operation == Operation.bindqueue || this.operation == Operation.unbindqueue) {
            try {
                Map headers = this.getAllBindedParameter(rSet, "AMQP_HEADER_[A-Za-z0-9_]+");
                if (headers.size() > 0) {
                    this.headers = new HashMap<String, Object>();
                    for (String key : headers.keySet()) {
                        Object o = headers.get(key);
                        if (o instanceof String) {
                            this.headers.put(key.substring("AMQP_HEADER_".length()), o);
                            continue;
                        }
                        throw new EngineExceptionI(String.format(Messages.getString("AMQP.ERROR_006"), o.getClass().getName()));
                    }
                }
            }
            catch (SQLException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    static enum Operation {
        nothing,
        rollback,
        commit,
        declarequeue,
        declareexchange,
        bindqueue,
        closesession,
        opensession,
        openconnection,
        closeconnection,
        unbindqueue,
        deleteexchange,
        deletequeue;

    }
}

