/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.AntDelete;
import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class FileDeleteActionCodeI
extends AntActionCodeTypeI {
    AntDelete fileManager;
    public static final String FILE_SEPARATOR = ";";
    String delFile;
    String delDir;
    Boolean bIncludeEmpty = false;
    Boolean failsOnError = false;
    String sExcludes;
    String sIncludes;
    private boolean casesensitive;
    private boolean defaultExcludes;

    public FileDeleteActionCodeI() {
        this.actionCodeName = "Delete File Class";
        this.actionClassName = "FileDeleteActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", String.valueOf(this.actionName) + Messages.getString("FileDeleteActionCodeI.0"), 3, "DEBUG");
        this.connectionName = this.getLocalStringBindedParameter(rSet, "SQL_CONNECTION", "");
        this.sqlTransName = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_NAME", "T1");
        this.sqlTransType = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_TYPE", "AUTOCOMMIT");
        this.sqlTransType = "AUTOCOMMIT";
        this.sqlSchemaName = this.getLocalStringBindedParameter(rSet, "SQL_SCHEMA_NAME", "");
        if (!this.sqlSchemaName.equals("")) {
            this.sqlSchemaName = String.valueOf(this.sqlSchemaName) + ".";
        }
        this.failsOnError = this.getLocalBooleanBindedParameter(rSet, "DEL_FAILS_ON_ERROR", true);
        this.delDir = this.getLocalStringBindedParameter(rSet, "DEL_DIR", "");
        this.delFile = this.getLocalStringBindedParameter(rSet, "DEL_FILE", "");
        this.bIncludeEmpty = this.getLocalBooleanBindedParameter(rSet, "DEL_INCLUDE_EMPTY_DIRS", false);
        this.sIncludes = this.getLocalStringBindedParameter(rSet, "DEL_INCLUDES", "");
        this.sExcludes = this.getLocalStringBindedParameter(rSet, "DEL_EXCLUDES", "");
        this.casesensitive = this.getLocalBooleanBindedParameter(rSet, "DEL_CASE_SENSITIVE", true);
        this.defaultExcludes = this.getLocalBooleanBindedParameter(rSet, "DEL_DEFAULT_EXLUDES", true);
        this.debugLog("prepare", String.valueOf(this.actionName) + Messages.getString("FileDeleteActionCodeI.1"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        int prec = this.fileManager != null ? this.fileManager.getNumFile() : 0;
        this.fileManager = new AntDelete(this.casesensitive, this.defaultExcludes);
        this.fileManager.setAntProject(this.project);
        this.fileManager.setActionCode(this);
        this.fileManager.setNumFile(prec);
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("FileDeleteActionCodeI.2")) + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", String.valueOf(this.actionName) + Messages.getString("FileDeleteActionCodeI.3"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
            this.fileManager.setJdbcInformation(this.jdbcConnection, this.sqlSchemaName);
        }
        try {
            String[] lstExcludes;
            String[] lstIncludes;
            if (this.jdbcConnection != null) {
                if (this.sqlTransType.equals("AUTOCOMMIT") || this.sqlTransType.equals("AUTONOMOUS")) {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)true);
                } else {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)false);
                }
            }
            File fDelDir = new File(this.delDir);
            if (!this.delDir.isEmpty()) {
                if (this.sIncludes == null && this.sExcludes == null) {
                    this.fileManager.setDir(fDelDir);
                }
                if (this.sIncludes.isEmpty()) {
                    this.sIncludes = "**" + File.separator + "*";
                }
            }
            if (!this.delFile.isEmpty()) {
                this.fileManager.setFile(new File(this.delFile));
            }
            this.fileManager.setIncludeEmptyDirs(this.bIncludeEmpty);
            this.fileManager.setFailOnError(this.failsOnError);
            FileSet fileSet = new FileSet();
            fileSet.setDir(fDelDir);
            fileSet.setCaseSensitive(this.casesensitive);
            if (!this.sIncludes.isEmpty() && (lstIncludes = this.sIncludes.replace(",", FILE_SEPARATOR).split(FILE_SEPARATOR)) != null && lstIncludes.length > 0) {
                fileSet.appendIncludes(lstIncludes);
                this.fileManager.addFileset(fileSet);
            }
            if (!this.sExcludes.isEmpty() && (lstExcludes = this.sExcludes.replace(",", FILE_SEPARATOR).split(FILE_SEPARATOR)) != null && lstExcludes.length > 0) {
                if (!fileSet.hasPatterns()) {
                    this.fileManager.addFileset(fileSet);
                }
                fileSet.appendExcludes(lstExcludes);
            }
            this.fileManager.execute();
            this.publishCumulativeVariable("FILE_NB", String.valueOf(this.fileManager.getNumFile() - prec), "Integer", false);
        }
        catch (BuildException e) {
            if (this.failsOnError.booleanValue()) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FileDeleteActionCodeI.4") + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FileDeleteActionCodeI.5") + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

