/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.ftp.FtpActionCodeI;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FtpPutActionCodeI
extends FtpActionCodeI {
    Boolean ftpMultipleMode;
    String ftpRemoteFilename;
    String ftpRemotePath;
    String ftpLocalFilename;
    String ftpLocalPath;
    long maxMsg;
    int nbMessages = 0;
    private Boolean ftpMoveFile;
    private Boolean ftpAppend;
    public static final Map<String, Integer> map = new HashMap<String, Integer>();

    static {
        map.put("SOCKS5", 0);
        map.put("SOCKS4", 1);
        map.put("SOCKS", 3);
        map.put("HTTP", 2);
        map.put("DISABLE", -1);
    }

    public FtpPutActionCodeI() {
        this.actionCodeName = "Ftp Put Class";
        this.actionClassName = "FtpPutActionCodeI";
        this.bNullCodeAllowed = true;
    }

    void insertFileInTable(int num, String fromFile, String fromDir, String fileName, String fileFolder) throws EngineExceptionI {
        Statement sqlStatement = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        try {
            try {
                String txtCode = "INSERT into " + this.sqlSchemaName + "IND_SESSION_FILE_OP_LST (SESS_ID, SESS_NAME, ACT_ID, ACT_NAME, ACT_ITER, FILE_ID, FILE_OPERATION, FILE_FROM_FILE, FILE_FROM_DIR, FILE_TO_FILE, FILE_TO_DIR, FILE_OPERATION_DATE) " + " values (?,?,?,?,?,?,?,?,?,?,?,?) ";
                sqlStatement = this.jdbcConnection.prepareStatement(txtCode);
                this.debugLog("insertFileInTable", Messages.getString("FtpPutActionCodeI.0"), 3, "DEBUG");
                sqlStatement.setString(1, this.actionContext.getSessionId());
                sqlStatement.setString(2, this.sessionName);
                sqlStatement.setString(3, this.actionContext.getActionId());
                sqlStatement.setString(4, this.actionContext.getActionName());
                sqlStatement.setInt(5, this.actionContext.getNbExecution() + 1);
                sqlStatement.setInt(6, num);
                sqlStatement.setString(7, "Ftp Put");
                sqlStatement.setString(8, fromFile);
                sqlStatement.setString(9, fromDir);
                sqlStatement.setString(10, fileName);
                sqlStatement.setString(11, fileFolder);
                sqlStatement.setString(12, dateFormat.format(new Date()));
                sqlStatement.executeUpdate();
                this.debugLog("insertFileInTable", Messages.getString("FtpPutActionCodeI.1"), 3, "DEBUG");
                this.commit();
            }
            catch (SQLException e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>insertFileInTable : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (sqlStatement != null) {
                try {
                    sqlStatement.close();
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
    }

    protected void commit() throws SQLException {
        if (this.sqlTransType.equals("COMMIT")) {
            this.jdbcConnection.commit();
        }
    }

    @Override
    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("FtpPutActionCodeI.2"), 3, "DEBUG");
        this.ftpMoveFile = this.getLocalBooleanBindedParameter(rSet, "DELETE_FILE_AFTER_TRANSFERT", false);
        this.ftpHostname = this.getLocalSecretBindedParameter(rSet, "FTP_HOSTNAME", null);
        this.ftpUser = this.getLocalSecretBindedParameter(rSet, "FTP_USER", null);
        if (this.ftpHostname == null || this.ftpUser == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("FtpPutActionCodeI.3"), "String", false);
            throw new EngineExceptionI(Messages.getString("FtpPutActionCodeI.4"));
        }
        this.ftpPassword = this.getLocalSecretBindedParameter(rSet, "FTP_PASSWORD", this.getLocalStringBindedParameter(rSet, "FTP_UNCRYPTED_PASSWORD", ""));
        this.setStandardConnectionParameters(rSet);
        this.ftpMode = this.getLocalStringBindedParameter(rSet, "FTP_FILE_MODE", "ascii");
        this.ftpMode = this.ftpMode.toLowerCase(Locale.getDefault());
        if (!this.ftpMode.equals("binary") && !this.ftpMode.equals("ascii")) {
            this.ftpMode = "ascii";
        }
        this.ftpPassiveMode = this.getLocalBooleanBindedParameter(rSet, "FTP_PASSIVE_MODE", true);
        this.FTPSProtocol = this.getLocalStringBindedParameter(rSet, "FTP_SECURE_PROTOCOL", "NONE");
        this.implicitFTPS = this.getLocalBooleanBindedParameter(rSet, "FTP_IMPLICIT_FTPS", true);
        this.ftpPort = this.getLocalSecretBindedParameter(rSet, "FTP_PORT", null);
        if (this.ftpPort.isNull()) {
            int dftPort = this.FTPSProtocol.equals("NONE") ? 21 : (this.implicitFTPS != false ? 990 : 21);
            this.publishVariable("FTP_PORT", String.valueOf(dftPort), "Integer", false);
            this.ftpPort.setDefaultValue(String.valueOf(dftPort));
        }
        this.ftpMultipleMode = this.getLocalBooleanBindedParameter(rSet, "FTP_MULTIPLE_MODE", true);
        this.ftpRemoteFilename = this.getLocalStringBindedParameter(rSet, "FTP_REMOTE_FILENAME", "");
        this.ftpRemotePath = this.getLocalStringBindedParameter(rSet, "FTP_REMOTE_PATH", "");
        this.ftpLocalFilename = this.getLocalStringBindedParameter(rSet, "FTP_LOCAL_FILENAME", "");
        this.ftpLocalPath = this.getLocalStringBindedParameter(rSet, "FTP_LOCAL_PATH", "");
        this.ftpAppend = this.getLocalBooleanBindedParameter(rSet, "FTP_APPEND", false);
        this.maxMsg = this.getLocalLongBindedParameter(rSet, "FTP_NB_FILES", Long.MAX_VALUE);
        super.prepare(rSet);
        this.debugLog("prepare", Messages.getString("FtpPutActionCodeI.5"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    boolean acceptFilter(String filter, String attribute) throws EngineExceptionI {
        Boolean bFinded;
        block6: {
            block5: {
                bFinded = false;
                if (filter != null) break block5;
                return true;
            }
            if (!filter.equals("")) break block6;
            return true;
        }
        try {
            Pattern pDeb = Pattern.compile(filter);
            Matcher mDeb = pDeb.matcher(attribute);
            bFinded = mDeb.matches();
        }
        catch (PatternSyntaxException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.6"), "String", false);
            throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.7"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return bFinded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeSimpleCode() throws EngineExceptionI {
        int ret;
        block43: {
            ret = 0;
            this.nbMessages = 0;
            if (this.connectionName != null && !this.connectionName.equals("")) {
                this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("FtpPutActionCodeI.8")) + this.connectionName, 3, "DEBUG");
                this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                if (!this.existsFileTable()) {
                    this.debugLog("executeSimpleCode", Messages.getString("FtpPutActionCodeI.9"), 3, "DEBUG");
                    this.createFileTable();
                }
                this.isRdbmsLinked = true;
            }
            try {
                try {
                    if (this.jdbcConnection != null) {
                        if (this.sqlTransType.equals("AUTOCOMMIT") || this.sqlTransType.equals("AUTONOMOUS")) {
                            ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)true);
                        } else {
                            ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)false);
                        }
                    }
                    this.setProxySocketFactory();
                    if (!this.connect()) break block43;
                    Boolean changeDirOk = true;
                    if (!this.ftpRemotePath.isEmpty()) {
                        changeDirOk = this.ftp.changeWorkingDirectory(this.ftpRemotePath);
                    }
                    if (!changeDirOk.booleanValue()) {
                        this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.10") + this.ftpRemotePath, "String", false);
                        throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.11") + this.ftpRemotePath);
                    }
                    if (!this.ftpMultipleMode.booleanValue()) {
                        String filePath = "";
                        if (!this.ftpLocalPath.equals("")) {
                            filePath = String.valueOf(filePath) + this.ftpLocalPath + File.separator;
                        }
                        if (this.ftpLocalFilename.equals("")) {
                            this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.12"), "String", false);
                            throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.13"));
                        }
                        String localFileName = String.valueOf(filePath) + this.ftpLocalFilename;
                        File file = new File(localFileName);
                        try (FileInputStream input = new FileInputStream(file);){
                            if (!this.ftpRemoteFilename.equals("")) {
                                if (this.ftpAppend.booleanValue()) {
                                    this.ftp.appendFile(this.ftpRemoteFilename, (InputStream)input);
                                } else {
                                    this.ftp.storeFile(this.ftpRemoteFilename, (InputStream)input);
                                }
                            } else if (this.ftpAppend.booleanValue()) {
                                this.ftp.appendFile(file.getName(), (InputStream)input);
                            } else {
                                this.ftp.storeFile(file.getName(), (InputStream)input);
                            }
                            int replycode = this.ftp.getReplyCode();
                            if (replycode < 200 || replycode >= 300) {
                                throw new EngineExceptionI(this.ftp.getReplyString());
                            }
                        }
                        if (this.isRdbmsLinked.booleanValue()) {
                            this.insertFileInTableFile(this.nbMessages + 1, this.ftpLocalPath, this.ftpLocalFilename, this.ftpRemotePath, this.ftpRemoteFilename.isEmpty() ? this.ftpLocalFilename : this.ftpRemoteFilename, "FtpPut", file, -1L);
                        }
                        if (this.ftpMoveFile.booleanValue()) {
                            new File(localFileName).delete();
                        }
                        ++this.nbMessages;
                        this.publishVariable("FILE_NB", String.valueOf(this.nbMessages), "Integer", false);
                        break block43;
                    }
                    if (this.ftpLocalPath.isEmpty()) {
                        this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.14"), "String", false);
                        throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpPutActionCodeI.15"));
                    }
                    File localFolder = new File(this.ftpLocalPath);
                    File[] lstFiles = localFolder.listFiles();
                    if (lstFiles == null || lstFiles.length <= 0) break block43;
                    int NbMsg = 0;
                    int i = 0;
                    while (i < lstFiles.length && (long)NbMsg < this.maxMsg) {
                        if (this.acceptFilter(StringOperations.replaceWildChars((String)this.ftpLocalFilename), lstFiles[i].getName())) {
                            String fileName = lstFiles[i].getName();
                            String localFileName = String.valueOf(this.ftpLocalPath) + File.separator + fileName;
                            File file = new File(localFileName);
                            try (FileInputStream input = new FileInputStream(file);){
                                if (this.ftpAppend.booleanValue()) {
                                    this.ftp.appendFile(fileName, (InputStream)input);
                                } else {
                                    this.ftp.storeFile(fileName, (InputStream)input);
                                }
                                int replycode = this.ftp.getReplyCode();
                                if (replycode < 200 || replycode >= 300) {
                                    throw new EngineExceptionI(this.ftp.getReplyString());
                                }
                            }
                            if (this.ftpMoveFile.booleanValue()) {
                                file.delete();
                            }
                            if (this.isRdbmsLinked.booleanValue()) {
                                this.insertFileInTableFile(this.nbMessages + 1, this.ftpLocalPath, fileName, this.ftpRemotePath, fileName, "FtpPut", file, -1L);
                            }
                            ++this.nbMessages;
                            ++NbMsg;
                            this.publishVariable("FILE_NB", String.valueOf(this.nbMessages), "Integer", false);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>executeSimpleCode : " + e.getMessage(), "String", false);
                    if (e instanceof EngineExceptionI) {
                        throw (EngineExceptionI)((Object)e);
                    }
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            finally {
                try {
                    this.ftp.logout();
                    this.ftp.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        this.publishCumulativeVariable("FILE_NB", String.valueOf(this.nbMessages), "Integer", false);
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

