/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.JMSBaseAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.jms.JMSFileReceiver;
import com.indy.engine.actionCodes.jms.JMSFileSender;
import com.indy.engine.actionCodes.jms.JMSMessageListener;
import com.indy.engine.actionCodes.jms.JMSUtils;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.UtilsService;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.NamingException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JMSReceiveActionCodeI
extends JMSBaseAction {
    private JMSFileReceiver jfs;
    private Boolean commit;
    JMSFileSender.UserDefinedParameter contentPublication;
    List<JMSFileSender.UserDefinedParameter> userDefinedParameters = new ArrayList<JMSFileSender.UserDefinedParameter>();
    boolean askToClose = false;

    public JMSReceiveActionCodeI() {
        super("JMSReceiveActionCodeI", true);
    }

    @Override
    public void doExecute() throws Throwable {
        JdbcPreparedStatementToResultSet jpstrs = null;
        try {
            try {
                this.setConnection();
                this.setSession();
                IActionBind aBind = this.getActionContext().getActionBind();
                if (aBind != null) {
                    final JdbcPreparedStatementToResultSet jpstrs2 = jpstrs = (JdbcPreparedStatementToResultSet)this.getActionContext().createBindePreparedStatement();
                    int index = 1;
                    jpstrs.setColumnName(index, "JMSCorrelationID");
                    jpstrs.setColumnType(index, "VARCHAR");
                    jpstrs.setColumnPrecision(index, 255);
                    jpstrs.setColumnName(++index, "JMSMessageID");
                    jpstrs.setColumnType(index, "VARCHAR");
                    jpstrs.setColumnPrecision(index, 255);
                    jpstrs.setColumnName(++index, "JMSNormalizedMessageID");
                    jpstrs.setColumnType(index, "VARCHAR");
                    jpstrs.setColumnPrecision(index, 255);
                    jpstrs.setColumnName(++index, "JMSType");
                    jpstrs.setColumnType(index, "VARCHAR");
                    jpstrs.setColumnPrecision(index, 255);
                    jpstrs.setColumnName(++index, "JMSDeliveryMode");
                    jpstrs.setColumnType(index, "INTEGER");
                    jpstrs.setColumnPrecision(index, 10);
                    jpstrs.setColumnName(++index, "JMSExpiration");
                    jpstrs.setColumnType(index, "BIGINT");
                    jpstrs.setColumnPrecision(index, 10);
                    jpstrs.setColumnName(++index, "JMSPriority");
                    jpstrs.setColumnType(index, "INTEGER");
                    jpstrs.setColumnPrecision(index, 255);
                    jpstrs.setColumnName(++index, "JMSRedelivered");
                    jpstrs.setColumnType(index, "VARCHAR");
                    jpstrs.setColumnPrecision(index, 4);
                    jpstrs.setColumnName(++index, "JMSTimestamp");
                    jpstrs.setColumnType(index, "BIGINT");
                    jpstrs.setColumnPrecision(index, 255);
                    for (JMSFileSender.UserDefinedParameter userDefinedParameter : this.userDefinedParameters) {
                        jpstrs.setColumnName(++index, userDefinedParameter.alias != null ? userDefinedParameter.alias : userDefinedParameter.name);
                        if (userDefinedParameter.parameterType == JMSFileSender.TypeParameter.STRING) {
                            jpstrs.setColumnType(index, "VARCHAR");
                            jpstrs.setColumnPrecision(index, 255);
                            continue;
                        }
                        if (userDefinedParameter.parameterType == JMSFileSender.TypeParameter.INT) {
                            jpstrs.setColumnType(index, "INTEGER");
                            jpstrs.setColumnPrecision(index, 10);
                            continue;
                        }
                        if (userDefinedParameter.parameterType == JMSFileSender.TypeParameter.LONG) {
                            jpstrs.setColumnType(index, "BIGINT");
                            jpstrs.setColumnPrecision(index, 255);
                            continue;
                        }
                        throw new EngineExceptionI("Datatype: " + (Object)((Object)userDefinedParameter.parameterType) + " is not supported");
                    }
                    if (this.contentPublication != null) {
                        jpstrs.setColumnName(++index, this.contentPublication.alias != null ? this.contentPublication.alias : this.contentPublication.name);
                        jpstrs.setColumnType(index, "VARCHAR");
                    }
                    this.getActionContext().bindWithTarget(jpstrs.getNotFetchedResultSetBindI());
                    JMSMessageListener listener = new JMSMessageListener(){

                        @Override
                        public void onMessage(Message message, int count) throws JMSException {
                            try {
                                int index = 1;
                                jpstrs2.setString(index, message.getJMSCorrelationID());
                                jpstrs2.setString(++index, message.getJMSMessageID());
                                jpstrs2.setString(++index, JMSUtils.getJMSNormalizedMessageId(message));
                                jpstrs2.setString(++index, message.getJMSType());
                                jpstrs2.setInt(++index, message.getJMSDeliveryMode());
                                jpstrs2.setLong(++index, message.getJMSExpiration());
                                jpstrs2.setInt(++index, message.getJMSPriority());
                                jpstrs2.setString(++index, String.valueOf(message.getJMSRedelivered()));
                                jpstrs2.setLong(++index, message.getJMSTimestamp());
                                for (JMSFileSender.UserDefinedParameter userDefinedParameter : JMSReceiveActionCodeI.this.userDefinedParameters) {
                                    userDefinedParameter.addToPreparedStatement(++index, (PreparedStatement)jpstrs2, message);
                                }
                                if (JMSReceiveActionCodeI.this.contentPublication != null) {
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    JMSUtils.messageToOutputStream(message, baos, true);
                                    if (JMSReceiveActionCodeI.this.contentPublication.sqlType == 12) {
                                        String str = new String(baos.toByteArray());
                                        jpstrs2.setString(++index, str);
                                    } else {
                                        jpstrs2.setBytes(++index, baos.toByteArray());
                                    }
                                }
                                jpstrs2.executeUpdate();
                            }
                            catch (SQLException e) {
                                throw new JMSException(Messages.getString("JMSReceiveActionCodeI.0"));
                            }
                            catch (IOException e) {
                                throw new JMSException(Messages.getString("JMSReceiveActionCodeI.1"));
                            }
                        }
                    };
                    this.jfs.addListener(listener);
                }
                this.jfs.receive(this.jmsConnection);
                if (this.commit.booleanValue()) {
                    this.jmsConnection.commitSession(this.jmsSessionName);
                }
            }
            catch (JMSException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (NamingException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            this.jfs.clear();
            if (jpstrs != null) {
                jpstrs.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        super.prepare(rSet);
        assert (this.jmsDestinationName != null) : Messages.getString("JMSReceiveActionCodeI.2");
        this.jfs = new JMSFileReceiver();
        this.jfs.setDestinationName(this.jmsDestinationName);
        this.jfs.setSubscriberName(this.getLocalStringBindedParameter(rSet, "JMS_SUBSCRIBER_NAME", null));
        this.jfs.setNoLocal(this.getLocalBooleanBindedParameter(rSet, "JMS_NO_LOCAL", false));
        this.jfs.setMessageNumber(this.getLocalIntegerBindedParameter(rSet, "JMS_MESSAGE_COUNT", -1));
        this.jfs.setTimeout(this.getLocalIntegerBindedParameter(rSet, "JMS_RECEIVE_TIMEOUT", 1000));
        String outFileMask = this.getLocalStringBindedParameter(rSet, "OUT_FILE_PATTERN", null);
        String outFileDir = this.getLocalStringBindedParameter(rSet, "OUT_FILE_DIR", null);
        if (outFileMask != null) {
            if (outFileDir == null) {
                File file = new File(outFileMask);
                if (!file.isAbsolute()) throw new EngineExceptionI(String.valueOf(Messages.getString("JMSReceiveActionCodeI.3")) + "OUT_FILE_DIR" + Messages.getString("JMSReceiveActionCodeI.4"));
                this.jfs.setReceiveDirectory(file.getParent());
                this.jfs.setFileMask(file.getName());
            } else {
                this.jfs.setFileMask(outFileMask);
                this.jfs.setReceiveDirectory(outFileDir);
            }
            this.jfs.addListener(this.jfs);
        } else {
            IActionBind aBind = this.getActionContext().getActionBind();
            if (aBind == null) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("JMSReceiveActionCodeI.5")) + "OUT_FILE_PATTERN" + Messages.getString("JMSReceiveActionCodeI.6"));
            }
        }
        this.jfs.setSessionName(this.jmsSessionName);
        this.commit = this.getLocalBooleanBindedParameter(rSet, "JMS_COMMIT", false);
        String tmp = "";
        tmp = String.valueOf(tmp) + this.getLocalStringBindedParameter(rSet, "JMS_USER_DEFINED_PROPERTIES", "");
        tmp = String.valueOf(tmp) + this.getLocalStringBindedParameter(rSet, "JMS_MESSAGE_CONTENT", "");
        if (tmp == null || tmp.isEmpty()) return;
        String txt = "<root>" + tmp + "</root>";
        Document doc = null;
        try {
            doc = UtilsService.getXmlUtils().stringToDOMDocument(txt, this.runtimeContext.defaultDocumentBuilderFactoryClass);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        Node root = doc.getFirstChild();
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("getProperty") || nodeName.equals("getMessageContent")) {
                NamedNodeMap nnm = node.getAttributes();
                Node attrName = nnm.getNamedItem("name");
                assert (attrName != null) : String.valueOf(Messages.getString("JMSReceiveActionCodeI.7")) + nodeName + Messages.getString("JMSReceiveActionCodeI.8");
                String name = attrName.getNodeValue();
                assert (name != null && !name.isEmpty()) : String.valueOf(Messages.getString("JMSReceiveActionCodeI.9")) + nodeName + Messages.getString("JMSReceiveActionCodeI.10");
                String type = null;
                Node attrType = nnm.getNamedItem("type");
                if (attrType != null) {
                    type = attrType.getNodeValue();
                }
                String sqlType = null;
                Node attrSqlType = nnm.getNamedItem("sqlType");
                if (attrSqlType != null) {
                    sqlType = attrSqlType.getNodeValue();
                }
                Node attrAlias = nnm.getNamedItem("sqlAlias");
                String alias = null;
                if (attrAlias != null) {
                    alias = attrAlias.getNodeValue();
                }
                if (nodeName.equals("getMessageContent")) {
                    this.contentPublication = new JMSFileSender.UserDefinedParameter();
                    this.contentPublication.alias = alias;
                    this.contentPublication.name = name;
                    if (sqlType.toUpperCase().equals("VARCHAR")) {
                        this.contentPublication.sqlType = 12;
                    } else if (sqlType.toUpperCase().equals("VARBINARY")) {
                        this.contentPublication.sqlType = -3;
                    } else {
                        if (!sqlType.toUpperCase().equals("LONGVARBINARY")) throw new EngineExceptionI(String.valueOf(Messages.getString("JMSReceiveActionCodeI.11")) + sqlType + Messages.getString("JMSReceiveActionCodeI.12"));
                        this.contentPublication.sqlType = -4;
                    }
                } else {
                    this.addUserDefinedParmater(name, type, alias);
                }
            }
            ++i;
        }
    }

    public void addUserDefinedParmater(String name, String type, String alias) {
        JMSFileSender.UserDefinedParameter parameter = new JMSFileSender.UserDefinedParameter();
        parameter.name = name;
        parameter.alias = alias;
        parameter.parameterType = JMSFileSender.TypeParameter.valueOf(type == null ? "STRING" : type.toUpperCase());
        this.userDefinedParameters.add(parameter);
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (th != null) {
            th.interrupt();
        }
        if (!this.askToClose) {
            try {
                if (this.jfs != null) {
                    this.jfs.closeMessageConsumer();
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.askToClose = true;
        }
    }
}

