/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.JMSBaseAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.jms.JMSFileSender;
import com.indy.engine.core.UtilsService;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.ResultSet;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.NamingException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JMSSendActionCodeI
extends JMSBaseAction {
    private JMSFileSender jfs;
    private Boolean deleteSendFiles;
    private String doneDir;
    boolean commit;
    PostSentOperation postSentOperation;
    boolean askToClose = false;

    public JMSSendActionCodeI() {
        super("JMSSendActionCodeI", true);
    }

    @Override
    public void doExecute() throws Throwable {
        try {
            this.setConnection();
            this.setSession();
            this.jfs.send(this.jmsConnection);
            if (this.commit) {
                this.jmsConnection.commitSession(this.jmsSessionName);
            }
            if (this.postSentOperation == PostSentOperation.delete) {
                if (this.deleteSendFiles.booleanValue()) {
                    this.jfs.deleteSendFiles();
                }
            } else if (this.postSentOperation == PostSentOperation.copy) {
                this.jfs.copySentFiles(this.doneDir, false);
            } else if (this.postSentOperation == PostSentOperation.move) {
                this.jfs.copySentFiles(this.doneDir, true);
            }
        }
        catch (JMSException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (NamingException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        String jmsProperties;
        super.prepare(rSet);
        assert (this.jmsDestinationName != null) : Messages.getString("JMSSendActionCodeI.0");
        this.jfs = new JMSFileSender();
        this.jfs.setDestinationName(this.jmsDestinationName);
        String inFileMask = this.getLocalStringBindedParameter(rSet, "IN_FILE_MASK");
        String inFileDir = this.getLocalStringBindedParameter(rSet, "IN_FILE_DIR", null);
        if (inFileDir == null) {
            File file = new File(inFileMask);
            if (!file.isAbsolute()) throw new EngineExceptionI(Messages.getString("JMSSendActionCodeI.1"));
            this.jfs.setSendDirectory(file.getParent());
            this.jfs.setFileMask(file.getName());
        } else {
            this.jfs.setFileMask(inFileMask);
            this.jfs.setSendDirectory(inFileDir);
        }
        this.jfs.setSessionName(this.jmsSessionName);
        this.jfs.setMessageType(JMSFileSender.JMSMessageType.valueOf(this.getLocalStringBindedParameter(rSet, "JMS_MESSAGE_TYPE")));
        this.doneDir = this.getLocalStringBindedParameter(rSet, "JMS_SENT_FILES_DIR", null);
        this.postSentOperation = PostSentOperation.valueOf(this.getLocalStringBindedParameter(rSet, "JMS_SENT_FILES_BEHAVIOUR", this.doneDir != null ? "move" : "keep"));
        if ((this.postSentOperation == PostSentOperation.move || this.postSentOperation == PostSentOperation.copy) && this.doneDir == null) {
            throw new EngineExceptionI("JMS_SENT_FILES_DIR must be setted");
        }
        this.commit = this.getLocalBooleanBindedParameter(rSet, "JMS_COMMIT", false);
        String userDefinedProperties = this.getLocalStringBindedParameter(rSet, "JMS_USER_DEFINED_PROPERTIES", null);
        if (userDefinedProperties != null && !userDefinedProperties.isEmpty()) {
            String txt = "<root>" + userDefinedProperties + "</root>";
            Document doc = null;
            try {
                doc = UtilsService.getXmlUtils().stringToDOMDocument(txt, this.runtimeContext.defaultDocumentBuilderFactoryClass);
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
            Node root = doc.getFirstChild();
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.equals("setProperty")) {
                    NamedNodeMap nnm = node.getAttributes();
                    Node attrName = nnm.getNamedItem("name");
                    assert (attrName != null) : String.valueOf(Messages.getString("JMSSendActionCodeI.2")) + nodeName + Messages.getString("JMSSendActionCodeI.5");
                    String name = attrName.getNodeValue();
                    assert (name != null && !name.isEmpty()) : String.valueOf(Messages.getString("JMSSendActionCodeI.3")) + nodeName + Messages.getString("JMSSendActionCodeI.6");
                    String type = null;
                    Node attrType = nnm.getNamedItem("type");
                    if (attrType != null) {
                        type = attrType.getNodeValue();
                    }
                    String value = node.getTextContent();
                    assert (value != null && !value.isEmpty()) : String.valueOf(Messages.getString("JMSSendActionCodeI.4")) + nodeName + Messages.getString("JMSSendActionCodeI.7") + name;
                    if (nodeName.equals("setProperty")) {
                        this.jfs.addUserDefinedParmater(name, value, type);
                    }
                }
                ++i;
            }
        }
        if ((jmsProperties = this.getLocalStringBindedParameter(rSet, "JMS_PROPERTIES", null)) == null || jmsProperties.isEmpty()) return;
        String txt = "<root>" + jmsProperties + "</root>";
        Document doc = null;
        try {
            doc = UtilsService.getXmlUtils().stringToDOMDocument(txt, this.runtimeContext.defaultDocumentBuilderFactoryClass);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        Node root = doc.getFirstChild();
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("setProperty")) {
                NamedNodeMap nnm = node.getAttributes();
                Node attrName = nnm.getNamedItem("name");
                assert (attrName != null) : String.valueOf(Messages.getString("JMSSendActionCodeI.8")) + nodeName + Messages.getString("JMSSendActionCodeI.9");
                String name = attrName.getNodeValue();
                assert (name != null && !name.isEmpty()) : String.valueOf(Messages.getString("JMSSendActionCodeI.10")) + nodeName + Messages.getString("JMSSendActionCodeI.11");
                final String value = node.getTextContent();
                assert (value != null && !value.isEmpty()) : String.valueOf(Messages.getString("JMSSendActionCodeI.12")) + nodeName + Messages.getString("JMSSendActionCodeI.13") + name;
                if (name.equals("JMSMessageID")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException {
                            message.setJMSMessageID(value);
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSCorrelationID")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException {
                            message.setJMSCorrelationID(value);
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSDeliveryMode")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException {
                            message.setJMSDeliveryMode(Integer.valueOf(value).intValue());
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSDestination")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSDestination(JMSSendActionCodeI.this.jmsConnection.getDestination(value));
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSExpiration")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSExpiration(Long.valueOf(value).longValue());
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSPriority")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSPriority(Integer.valueOf(value).intValue());
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSRedelivered")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSRedelivered(Boolean.valueOf(value).booleanValue());
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSReplyTo")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSReplyTo(JMSSendActionCodeI.this.jmsConnection.getDestination(value));
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSTimestamp")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSTimestamp(Long.valueOf(value).longValue());
                        }
                    });
                } else if (name.equalsIgnoreCase("JMSType")) {
                    this.jfs.addJMSpropertySetter(new JMSFileSender.JMSPropertySetter(){

                        @Override
                        public void setProperty(Message message) throws JMSException, NamingException {
                            message.setJMSType(value);
                        }
                    });
                }
            }
            ++i;
        }
    }

    public void stopAction(Thread th) {
        super.stopAction(th);
        if (!this.askToClose) {
            try {
                this.jfs.closeMessageProducer(this.jmsConnection);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            this.askToClose = true;
        }
    }

    static enum PostSentOperation {
        keep,
        copy,
        move,
        delete;

    }
}

