/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.action.common.IAutomaticSemaphore;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.loader.JdbcBinder;
import com.indy.engine.common.sql.SqlUtils;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.common.KeyWord;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigInteger;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JdbcActionCodeI
extends ActionCodeTypeI
implements IAutomaticSemaphore {
    static long DEFAULT_POLLINT_VALUE = 10000L;
    String sqlActionType;
    Integer sqlBatchSize;
    Integer sqlTransCommitNb;
    Statement DMLStatement = null;
    PreparedStatement batchPreparedStatement;
    BindExpressionReplacer.BindedExpressionPlaceHolder trgSQLTxtCode;
    ArrayList lstColsToBind = null;
    boolean sqlWaitData = false;
    long sqlWaitTimeout = -1L;
    long sqlWaitPollint = DEFAULT_POLLINT_VALUE;
    int sqlWaitNbRows = 1;
    String sqlWaitCountSelect = null;
    int batchSize;
    int sqlNbRows = 0;
    String typeStatistiques;
    boolean isEmptyCode = false;
    private Boolean multiQuery;
    private String multiQuerySeparators;
    private String multiQueryExclusionsRules;
    boolean toBatch = false;
    JdbcBinder binder;
    private Boolean sqlDisableNbRowsStatistic;
    Set<Integer> sqlDisableNbRowsStatisticPosition = new HashSet<Integer>();
    int[] index = new int[0];
    long sqlNbRowsTotal = 0L;

    public JdbcActionCodeI() {
        this.actionCodeName = "JDBC Operation";
        this.actionClassName = "JdbcActionCodeI";
        this.connectionName = "";
        this.sqlActionType = "";
        this.sqlTransName = null;
        this.sqlTransType = null;
        this.sqlTransCommitNb = null;
        this.DMLStatement = null;
        this.batchPreparedStatement = null;
        this.batchSize = 0;
        this.bNullCodeAllowed = true;
        this.binder = new JdbcBinder(this);
    }

    private boolean isTimeOut(long debTime) {
        return BigInteger.valueOf(System.currentTimeMillis()).compareTo(BigInteger.valueOf(debTime).add(BigInteger.valueOf(this.sqlWaitTimeout))) > 0;
    }

    public void stopAction(Thread th) {
        block18: {
            this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.0"), 1, this.actionLevel, "DEBUG");
            this.setStoppingAction(true);
            try {
                if (this.sqlActionType != null) {
                    block19: {
                        if (this.sqlActionType.equals("DDL_DML") || this.sqlActionType.equals("SELECT") && this.sqlWaitData) {
                            this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.1"), 1, this.actionLevel, "DEBUG");
                            if (this.DMLStatement != null) {
                                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.2"), 1, this.actionLevel, "ERROR");
                                this.DMLStatement.cancel();
                                this.DMLStatement.close();
                                try {
                                    this.jdbcConnection.isClosed();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.3"), 1, this.actionLevel, "ERROR");
                                th.interrupt();
                                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.4"), 1, this.actionLevel, "ERROR");
                            } else {
                                th.interrupt();
                            }
                        }
                        if (this.sqlActionType.equals("DDL_DML")) break block18;
                        this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.5"), 1, this.actionLevel, "DEBUG");
                        if (this.actionContext.isSrcBindedAction()) {
                            IActionBind aBind = this.actionContext.getSrcBind(this.actionName);
                            if (aBind != null) {
                                aBind.setBindKilling(true);
                                aBind.notifyFetch();
                            }
                            th.interrupt();
                        } else if (this.actionContext.isTrgBindedAction()) {
                            th.interrupt();
                            try {
                                if (this.getCurrentRSet() == null) break block19;
                                ResultSet rs = this.getCurrentRSet();
                                rs.close();
                                try {
                                    this.jdbcConnection.isClosed();
                                }
                                catch (Exception exception) {
                                }
                            }
                            catch (Exception rs) {}
                        } else {
                            th.interrupt();
                        }
                    }
                    this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.6"), 1, this.actionLevel, "DEBUG");
                    break block18;
                }
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.7"), 1, this.actionLevel, "DEBUG");
                th.interrupt();
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.8"), 1, this.actionLevel, "ERROR");
                th.interrupt();
            }
            catch (Exception e) {
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.9"), 1, this.actionLevel, "ERROR");
            }
        }
    }

    public int prepareSetConnection(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        try {
            this.sqlTransName = this.getStringBindedParameter(rSet, String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
        }
        catch (NullPointerException e) {
            this.sqlTransName = "T1";
        }
        catch (EngineExceptionI e) {
            this.sqlTransName = "T1";
        }
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = this.getStringBindedParameter(rSet, String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_ISOLATION");
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (NullPointerException pTransIsolation) {
        }
        catch (EngineExceptionI pTransIsolation) {
            // empty catch block
        }
        this.setTransactionAndCommit(this.getLocalStringParameter("SQL_TRANSACTION_TYPE", null), this.sqlActionType.equals("SELECT"));
        try {
            this.sqlTransCommitNb = this.getIntegerBindedParameter(rSet, String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_COMMIT_NB");
        }
        catch (NullPointerException e) {
            this.sqlTransCommitNb = new Integer(-1);
        }
        catch (EngineExceptionI e) {
            this.sqlTransCommitNb = new Integer(-1);
        }
        return ret;
    }

    public int prepareSetConnection() throws EngineExceptionI {
        int ret = 0;
        this.setTransactionAndCommit(this.getLocalStringParameter("SQL_TRANSACTION_TYPE", null), this.sqlActionType.equals("SELECT"));
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_ISOLATION");
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (NullPointerException pTransIsolation) {
        }
        catch (EngineExceptionI pTransIsolation) {
            // empty catch block
        }
        try {
            this.sqlTransName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
        }
        catch (NullPointerException e) {
            this.sqlTransName = "T1";
        }
        catch (EngineExceptionI e) {
            this.sqlTransName = "T1";
        }
        if (this.sqlTransType.equals("AUTONOMOUS")) {
            this.sqlTransName = this.actionName;
        }
        try {
            this.sqlTransCommitNb = this.getIntegerParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_COMMIT_NB");
        }
        catch (NullPointerException e) {
            this.sqlTransCommitNb = new Integer(-1);
        }
        catch (EngineExceptionI e) {
            this.sqlTransCommitNb = new Integer(-1);
        }
        return ret;
    }

    public void finalizeBadDirectBindedFetch() throws EngineExceptionI {
        if (!this.sqlActionType.equals("DDL_DML")) {
            if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
                try {
                    if (this.jdbcConnection != null) {
                        this.jdbcConnection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.closeBatchStatement(true);
        }
        this.jdbcConnection = null;
    }

    private int executeUpdate() throws SQLException {
        this.toBatch = false;
        return this.batchPreparedStatement.executeUpdate();
    }

    private void addBatch() throws SQLException {
        this.batchPreparedStatement.addBatch();
        this.toBatch = true;
    }

    private int[] executeBatch() throws SQLException {
        if (this.toBatch) {
            this.toBatch = false;
            int[] ret = this.batchPreparedStatement.executeBatch();
            if (ret == null) {
                ret = new int[]{1};
            }
            return ret;
        }
        int[] ret = new int[1];
        return ret;
    }

    public int finalizeDirectBindedFetch(int numRecord, ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.write(this.sessionName, "JdbcActionCode=>finalizeDirectBindedFetch", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.10"), 1, this.actionLevel, "INFO");
        try {
            if (!this.sqlActionType.equals("DDL_DML")) {
                if (this.sqlBatchSize > 0 && numRecord >= this.batchSize && numRecord != 0 && this.batchPreparedStatement != null) {
                    int[] count;
                    int[] nArray = count = this.executeBatch();
                    int n = count.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int c = nArray[n2];
                        this.sqlNbRows += c == -2 ? 1 : c;
                        ++n2;
                    }
                }
                if ((this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) && this.sqlTransType.equals("COMMIT")) {
                    this.jdbcConnection.commit();
                }
                this.closeBatchStatement(false);
            }
            this._closeConnection(false);
        }
        catch (SQLException e) {
            this.jdbcConnection = null;
            this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>finalizeDirectBindedFetch, " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        this.jdbcConnection = null;
        this.write(this.sessionName, "JdbcActionCode=>finalizeDirectBindedFetch", String.valueOf(this.actionName) + " : OK", 1, this.actionLevel, "INFO");
        return ret;
    }

    int addStatementValue(int preparedStatementParamIndex, ResultSet rSet, PreparedStatement stmt, String sourceColumnName, ResultSetMetaData sourceRSMD) throws SQLException, EngineExceptionI {
        int ret = 0;
        int sourceColumnIndex = BindExpressionReplacer.bindedVariableMatchSessionVariablePattern((String)sourceColumnName) ? -1 : this.findColumn(preparedStatementParamIndex, sourceColumnName, rSet);
        Integer colType = sourceColumnIndex != -1 ? sourceRSMD.getColumnType(sourceColumnIndex) : -1;
        try {
            this.binder.write(preparedStatementParamIndex, rSet, sourceColumnIndex, stmt, colType, this.trgSQLTxtCode);
        }
        catch (Exception e) {
            this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.11")) + sourceColumnIndex + Messages.getString("JdbcActionCodeI.12") + preparedStatementParamIndex + ", " + e.getMessage(), "String", false);
            throw new EngineExceptionI(String.valueOf(Messages.getString("JdbcActionCodeI.13")) + sourceColumnIndex + Messages.getString("JdbcActionCodeI.14") + preparedStatementParamIndex, (Throwable)e);
        }
        return ret;
    }

    public void closeBatchStatement(boolean error) throws EngineExceptionI {
        if (this.batchPreparedStatement != null) {
            try {
                if (error) {
                    try {
                        this.batchPreparedStatement.cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.batchPreparedStatement.clearBatch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.batchPreparedStatement.close();
                this.batchPreparedStatement = null;
            }
            catch (Exception e2) {
                this.batchPreparedStatement = null;
                throw new EngineExceptionI((Throwable)e2);
            }
        }
    }

    private int findColumn(int i, String name, ResultSet sourceRSet) throws SQLException {
        if (this.index.length < i) {
            int[] _index = new int[i];
            int j = 0;
            while (j < this.index.length) {
                _index[j] = this.index[j];
                ++j;
            }
            try {
                _index[i - 1] = sourceRSet.findColumn(name);
            }
            catch (SQLException e) {
                try {
                    _index[i - 1] = sourceRSet.findColumn(name.toLowerCase());
                }
                catch (SQLException e2) {
                    _index[i - 1] = sourceRSet.findColumn(name.toUpperCase());
                }
            }
            this.index = _index;
        }
        return this.index[i - 1];
    }

    private int executeTrgDirectBindedInsert(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws Exception {
        int ret;
        block18: {
            ret = 0;
            Iterator lstCols = null;
            String colName = "";
            if (Thread.interrupted()) {
                this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.15"), 1, this.actionLevel, "ERROR");
                this.closeBatchStatement(true);
                throw new InterruptedException();
            }
            ++this.batchSize;
            ret = 0;
            int i = 1;
            if (this.lstColsToBind != null) {
                lstCols = this.lstColsToBind.iterator();
            }
            try {
                if (lstCols != null) {
                    while (lstCols.hasNext()) {
                        colName = (String)lstCols.next();
                        ret = 0;
                        ret = this.addStatementValue(i, sourceRSet, this.batchPreparedStatement, colName, sourceRSMD);
                        ++i;
                    }
                }
                if (this.sqlBatchSize == 0) {
                    this.sqlNbRows += this.executeUpdate();
                } else {
                    this.addBatch();
                }
                if (this.sqlTransType.equals("COMMIT") && this.sqlTransCommitNb != -1 && this.sqlTransCommitNb % this.batchSize == 0) {
                    this.jdbcConnection.commit();
                }
                if (numRecord % this.sqlBindingFetchSize == 0) {
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.16") + numRecord, 3, this.actionLevel, "INFO");
                }
                if (this.sqlBatchSize <= 0 || this.batchSize % this.sqlBatchSize != 0) break block18;
                this.publishCumulativeStatistiques(false);
                this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.17") + this.batchSize, 3, this.actionLevel, "INFO");
                try {
                    int[] count;
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.18"), 4, this.actionLevel, "INFO");
                    int[] nArray = count = this.executeBatch();
                    int n = count.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int c = nArray[n2];
                        this.sqlNbRows += c == -2 ? 1 : c;
                        ++n2;
                    }
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.19") + this.batchSize, 4, this.actionLevel, "INFO");
                }
                catch (BatchUpdateException e) {
                    ret = -1;
                    SQLException e2 = e.getNextException();
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.20") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    if (e2 != null) {
                        if (e2 instanceof SQLException) {
                            this.logSqlException(e2);
                        }
                        e2.printStackTrace();
                        this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "BatchUpdateException : " + e.getMessage() + "\n" + e2.getMessage(), "String", false);
                    } else {
                        this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "BatchUpdateException : " + e.getMessage(), "String", false);
                    }
                    this.closeBatchStatement(true);
                    throw new EngineExceptionI((Throwable)e);
                }
                catch (SQLException e) {
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.21") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "SQLException : " + e.getMessage(), "String", false);
                    ret = -1;
                    this.closeBatchStatement(true);
                    this.logSqlException(e);
                    throw new EngineExceptionI((Throwable)e);
                }
                catch (Exception e) {
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + " : Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                    ret = -1;
                    this.closeBatchStatement(true);
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.22") + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                ret = -1;
                this.closeBatchStatement(true);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return ret;
    }

    private void _closeConnection(boolean commit) {
        if (this.sqlTransType != null && !this.connectionName.isEmpty() && (this.sqlTransType.equals("AUTONOMOUS") || this.sqlTransType.equals("AUTOCOMMIT"))) {
            this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, commit);
        }
    }

    public int executeDDL_DML(String txtCode) throws InterruptedException, EngineExceptionI {
        int ret = 0;
        try {
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.23"), 2, this.actionLevel, "DEBUG");
            this.connectionName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
            try {
                this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                ret = 0;
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.24") + e.getMessage(), 0, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                ret = -1;
                throw new EngineExceptionI((Throwable)e);
            }
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.25"), 2, this.actionLevel, "DEBUG");
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.26"), 2, this.actionLevel, "DEBUG");
            if (this.isAutoCommit()) {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.27"), 2, this.actionLevel, "DEBUG");
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)true);
            } else {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.28"), 2, this.actionLevel, "DEBUG");
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)false);
            }
            if (!this.isEmptyCode) {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.29"), 2, this.actionLevel, "DEBUG");
                this.DMLStatement = this.jdbcConnection.createStatement();
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.30"), 2, this.actionLevel, "DEBUG");
                if (this.multiQuery.booleanValue()) {
                    String tmp = txtCode;
                    if (!tmp.trim().endsWith(this.multiQuerySeparators)) {
                        tmp = String.valueOf(tmp) + this.multiQuerySeparators;
                    }
                    int i = 1;
                    for (String query : SqlUtils.splitSqlScript((String)tmp, (String)this.multiQuerySeparators, (String[])this.multiQueryExclusionsRules.split(";"))) {
                        int _tmp = this.DMLStatement.executeUpdate(query);
                        if (this.sqlDisableNbRowsStatisticPosition.size() == 0 || !this.sqlDisableNbRowsStatisticPosition.contains(i)) {
                            this.sqlNbRows += _tmp;
                        }
                        ++i;
                    }
                } else {
                    int _tmp = this.DMLStatement.executeUpdate(txtCode);
                    if (this.sqlDisableNbRowsStatisticPosition.size() == 0 || !this.sqlDisableNbRowsStatisticPosition.contains(1)) {
                        this.sqlNbRows = _tmp;
                    }
                }
                if (this.sqlNbRows < 0) {
                    this.sqlNbRows = 0;
                }
                if (this.DMLStatement != null) {
                    try {
                        this.DMLStatement.close();
                        this.DMLStatement = null;
                    }
                    catch (Exception _tmp) {
                        // empty catch block
                    }
                }
            }
            if (this.sqlTransType.equals("COMMIT")) {
                this.jdbcConnection.commit();
            }
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.31"), 2, this.actionLevel, "DEBUG");
        }
        catch (SQLFeatureNotSupportedException e) {
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.32") + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.33")) + e.getMessage(), "String", false);
            if (!this.actionContext.getActionToleratedError() && !this.sqlTransType.equals("AUTOCOMMIT")) {
                try {
                    this.jdbcConnection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.DMLStatement != null) {
                try {
                    this.DMLStatement.close();
                    this.DMLStatement = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._closeConnection(true);
            ret = -1;
            throw new EngineExceptionI((Throwable)e);
        }
        catch (SQLException e) {
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.34") + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.35")) + e.getMessage(), "String", false);
            if (!this.actionContext.getActionToleratedError() && !this.sqlTransType.equals("AUTOCOMMIT")) {
                try {
                    this.jdbcConnection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.DMLStatement != null) {
                try {
                    this.DMLStatement.close();
                    this.DMLStatement = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._closeConnection(false);
            ret = -1;
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws Exception {
        int ret;
        block7: {
            ret = 0;
            if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
                return this.executeTrgDirectBindedInsert(numRecord, sourceRSet, sourceRSMD);
            }
            if (this.sqlActionType.equals("DDL_DML") && (ret = this.prepareSetConnection(sourceRSet)) == 0) {
                try {
                    String realCode = this.actionContext.executeSubstitutionScript(BindExpressionReplacer.replaceBindedExpressions((ResultSet)sourceRSet, (String)this.actionTxtCode, (String)this.objectStartDelimiter, (String)this.objectEndDelimiter, (ActionCodeTypeI)this), "b");
                    if (realCode == null) {
                        this.isEmptyCode = true;
                    } else if (realCode.equals("") || StringOperations.isEmptyOrComments((String)realCode)) {
                        this.isEmptyCode = true;
                    }
                    ret = this.executeDDL_DML(realCode);
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block7;
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        return ret;
    }

    int executeSrcBindedSelect() throws EngineExceptionI {
        int ret;
        block46: {
            ret = 0;
            try {
                IActionBind aBind;
                boolean canContinue = false;
                boolean timeoutPassed = false;
                long debTime = 0L;
                if (this.sqlWaitData) {
                    long nbRowsReturned = -1L;
                    if (this.sqlWaitCountSelect != null) {
                        debTime = System.currentTimeMillis();
                        this.DMLStatement = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);
                        while (!canContinue) {
                            ResultSet sourceRSet = this.DMLStatement.executeQuery(this.sqlWaitCountSelect);
                            if (sourceRSet.next()) {
                                try {
                                    nbRowsReturned = sourceRSet.getInt(1);
                                }
                                catch (Exception e) {
                                    throw new EngineExceptionI(String.valueOf(((Object)((Object)this)).getClass().getName()) + "=>executeSrcBindedSelect() : the select in the SQL_WAIT_COUNT_SELECT parameter should return a single numeric value");
                                }
                            } else {
                                throw new EngineExceptionI(String.valueOf(((Object)((Object)this)).getClass().getName()) + "=>executeSrcBindedSelect() : the select in the SQL_WAIT_COUNT_SELECT parameter should return a value");
                            }
                            if (nbRowsReturned >= (long)this.sqlWaitNbRows || this.isTimeOut(debTime)) {
                                canContinue = true;
                            } else {
                                try {
                                    Thread.sleep(this.sqlWaitPollint);
                                    sourceRSet.close();
                                    sourceRSet = null;
                                }
                                catch (InterruptedException e) {
                                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "executeSrcBindedSelect : Pollint not possible : " + e.getMessage(), "String", false);
                                    throw new EngineExceptionI(String.valueOf(((Object)((Object)this)).getClass().getName()) + "=>executeSrcBindedSelect() : Pollint not possible or interrupted", (Throwable)e);
                                }
                                catch (SQLException e) {
                                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "executeSrcBindedSelect : SQLException : " + e.getMessage(), "String", false);
                                    throw new EngineExceptionI(String.valueOf(((Object)((Object)this)).getClass().getName()) + "=>executeSrcBindedSelect() : SQLException", (Throwable)e);
                                }
                            }
                            if (!Thread.interrupted()) continue;
                            throw new InterruptedException(Messages.getString("JdbcActionCodeI.36"));
                        }
                        if (this.isTimeOut(debTime)) {
                            timeoutPassed = true;
                        }
                    } else {
                        debTime = System.currentTimeMillis();
                        try {
                            Statement stmtSelect = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);
                            while (!canContinue) {
                                if (Thread.interrupted()) {
                                    throw new InterruptedException(Messages.getString("JdbcActionCodeI.37"));
                                }
                                ResultSet sourceRSet = stmtSelect.executeQuery(this.actionTxtCode);
                                if (sourceRSet.getType() != 1003) {
                                    if (sourceRSet.absolute(this.sqlWaitNbRows) || this.isTimeOut(debTime)) {
                                        canContinue = true;
                                    }
                                } else {
                                    int i = 0;
                                    while (sourceRSet.next() && !canContinue) {
                                        if (++i < this.sqlWaitNbRows && !this.isTimeOut(debTime)) continue;
                                        canContinue = true;
                                    }
                                    if (!canContinue && this.isTimeOut(debTime)) {
                                        canContinue = true;
                                    }
                                }
                                if (canContinue) continue;
                                try {
                                    Thread.sleep(this.sqlWaitPollint);
                                    sourceRSet.close();
                                    sourceRSet = null;
                                }
                                catch (InterruptedException e) {
                                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.38")) + e.getMessage(), "String", false);
                                    throw new EngineExceptionI(String.valueOf(((Object)((Object)this)).getClass().getName()) + "=>executeSrcBindedSelect() : Pollint not possible or interrupted", (Throwable)e);
                                }
                                catch (SQLException e) {
                                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "executeSrcBindedSelect : SQLException : " + e.getMessage(), "String", false);
                                    throw new EngineExceptionI(String.valueOf(((Object)((Object)this)).getClass().getName()) + "=>executeSrcBindedSelect() : SQLException", (Throwable)e);
                                }
                            }
                            if (this.isTimeOut(debTime)) {
                                timeoutPassed = true;
                            }
                        }
                        catch (SQLException e) {
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                }
                if (this.sqlWaitData && timeoutPassed) {
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.39"));
                }
                if (this.sqlWaitData) {
                    this.publishVariable("SQL_WAIT_DATA_FIRED", "true", "Boolean");
                }
                if ((aBind = this.actionContext.getSrcBind(this.actionName)) != null) {
                    this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.40"), 3, this.actionLevel, "DEBUG");
                    try {
                        this.sqlBindingFetchSize = this.getIntegerParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_FETCH_SIZE");
                    }
                    catch (EngineExceptionI e) {
                        this.sqlBindingFetchSize = this.sqlServerFetchSize != -1 ? Integer.valueOf(this.sqlServerFetchSize) : this.runtimeContext.DEFAULT_FETCH_SIZE;
                        this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.41"), 3, this.actionLevel, "DEBUG");
                    }
                    catch (Exception e) {
                        this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", String.valueOf(this.actionName) + " : Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                        this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                        ret = -1;
                        throw new EngineExceptionI((Throwable)e);
                    }
                    if (ret != -1 && aBind.getBindType().equals("DirectBind")) {
                        this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.42"), 3, this.actionLevel, "INFO");
                        NotFetchedResultSetBindI rsb = new NotFetchedResultSetBindI(){
                            Map<String, Statement> statements = new HashMap<String, Statement>();
                            Map<String, ResultSet> resultSets = new HashMap<String, ResultSet>();

                            public synchronized ResultSet initResultSet(String id) throws SQLException {
                                try {
                                    Statement st = JdbcActionCodeI.this.jdbcConnection.createStatement();
                                    this.statements.put(id, st);
                                    try {
                                        Integer tmp = JdbcActionCodeI.this.sqlBindingFetchSize;
                                        if (JdbcActionCodeI.this.sqlBindingFetchSize == null) {
                                            tmp = JdbcActionCodeI.this.runtimeContext.DEFAULT_FETCH_SIZE;
                                        }
                                        st.setFetchSize(tmp);
                                    }
                                    catch (SQLException e) {
                                        JdbcActionCodeI.this.write(JdbcActionCodeI.this.sessionName, "JdbcActionCodeI=>NotFetchedResultSetBindI.initResultSet", String.valueOf(JdbcActionCodeI.this.actionName) + Messages.getString("JdbcActionCodeI.43") + e.getMessage(), 3, JdbcActionCodeI.this.actionLevel, "WARNING");
                                        JdbcActionCodeI.this.addVariableWithULog(String.valueOf(JdbcActionCodeI.this.runtimeContext.VAR_PREFIXE) + JdbcActionCodeI.this.actionName + JdbcActionCodeI.this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_WARNING.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.44")) + e.getMessage(), "String", false);
                                    }
                                    ResultSet rs = st.executeQuery(JdbcActionCodeI.this.actionTxtCode);
                                    this.resultSets.put(id, rs);
                                    return rs;
                                }
                                catch (SQLException t) {
                                    this.closeResultSet(JdbcActionCodeI.this.getActionContext().getActionId());
                                    throw t;
                                }
                            }

                            public synchronized void closeResultSet(String id) throws SQLException {
                                Statement st;
                                ResultSet rs = this.resultSets.get(id);
                                if (rs != null) {
                                    rs.close();
                                    this.resultSets.remove(id);
                                }
                                if ((st = this.statements.get(id)) != null) {
                                    st.close();
                                    this.statements.remove(id);
                                }
                            }

                            public synchronized ResultSet getResultSet(String id) {
                                return this.resultSets.get(id);
                            }
                        };
                        rsb.lstParameters.put("SQL_FETCH_SIZE", new Variable("SQL_FETCH_SIZE", String.valueOf(this.sqlBindingFetchSize), "Integer"));
                        rsb.lstParameters.put("SELECT_TXT_CODE", new Variable("SELECT_TXT_CODE", this.actionTxtCode, "String"));
                        if (this.getDateAsTimestamp) {
                            rsb.lstParameters.put("GET_DATE_AS_TIMESTAMP", new Variable("GET_DATE_AS_TIMESTAMP", "true", "Boolean"));
                        }
                        aBind.addBindedObject((Object)rsb);
                        aBind.setBindActif(true);
                        aBind.notifyFetch();
                        this.actionContext.notifyIsConnectedBindedAndRunning();
                        if (aBind.verifConsommation() == -1) {
                            ret = -1;
                        }
                        if (this.actionContext.getIsStopping()) {
                            throw new EngineExceptionI("Stopping Action...");
                        }
                    }
                    break block46;
                }
                if (this.sqlWaitData) break block46;
                Statement stmtSelect = null;
                ResultSet sourceRSet = null;
                try {
                    stmtSelect = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);
                    sourceRSet = stmtSelect.executeQuery(this.actionTxtCode);
                }
                finally {
                    if (sourceRSet != null) {
                        sourceRSet.close();
                    }
                    if (stmtSelect != null) {
                        stmtSelect.close();
                    }
                }
            }
            catch (EngineExceptionI e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (InterruptedException e) {
                this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", String.valueOf(this.actionName) + " : InterruptedException : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.45"), "String", false);
                throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.46"));
            }
            catch (Exception e) {
                this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", String.valueOf(this.actionName) + " : Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                ret = -1;
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return ret;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret;
        block12: {
            ret = 0;
            if (this.actionTxtCode == null) {
                this.isEmptyCode = true;
            } else if (this.actionTxtCode.equals("") || StringOperations.isEmptyOrComments((String)this.actionTxtCode)) {
                this.isEmptyCode = true;
            }
            try {
                if (this.sqlActionType.equals("DDL_DML")) {
                    try {
                        ret = this.prepareSetConnection();
                        if (ret == 0) {
                            ret = this.executeDDL_DML(this.actionTxtCode);
                        }
                        break block12;
                    }
                    catch (InterruptedException e) {
                        this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", String.valueOf(this.actionName) + " : Interrupted Exception" + e.getMessage(), 1, this.actionLevel, "ERROR");
                        this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                        ret = -1;
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                if (this.isEmptyCode && !this.sqlWaitData) {
                    this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.47"), 1, this.actionLevel, "ERROR");
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.48"));
                }
                if (this.sqlActionType.equals("SELECT")) {
                    ret = this.executeSrcBindedSelect();
                    break block12;
                }
                this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.49"), 1, this.actionLevel, "ERROR");
                throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.50"));
            }
            catch (EngineExceptionI e) {
                ret = -1;
                this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.51") + e.getMessage(), 1, this.actionLevel, "ERROR");
                if (!this.existsVariable(VariableType.CORE_RET_MESS.getName())) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.52")) + e.getMessage());
                }
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.jdbcConnection = null;
        return ret;
    }

    @Deprecated
    public int prepareDirectBindedFetch(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.prepare(rSet);
        if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
            try {
                this.sqlBatchSize = this.getIntegerParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_BATCH_SIZE");
            }
            catch (EngineExceptionI e) {
                this.sqlBatchSize = this.sqlServerBatchSize != -1 ? Integer.valueOf(this.sqlServerBatchSize) : this.runtimeContext.DEFAULT_BATCH_SIZE;
            }
            this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.53") + this.sqlBatchSize.toString(), 3, this.actionLevel, "INFO");
            this.batchSize = 0;
            this.lstColsToBind = this.getLstTxtCodeBindedParameters(this.actionTxtCode);
            try {
                if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
                    this.trgSQLTxtCode = BindExpressionReplacer.replaceBindedExpressions((String)this.actionTxtCode);
                    if (this.trgSQLTxtCode.getBindedExpression() == null) {
                        this.isEmptyCode = true;
                    } else if (this.trgSQLTxtCode.getBindedExpression().equals("") || StringOperations.isEmptyOrComments((String)this.trgSQLTxtCode.getBindedExpression())) {
                        this.isEmptyCode = true;
                    }
                    if (this.isEmptyCode) {
                        this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.54"), 1, this.actionLevel, "ERROR");
                        throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.55"));
                    }
                }
                try {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.batchPreparedStatement = this.jdbcConnection.prepareStatement(this.trgSQLTxtCode.getBindedExpression());
                try {
                    this.binder.setParameterMetadata(this.batchPreparedStatement.getParameterMetaData());
                }
                catch (Exception e) {
                    this.getActionCodeLogger().warn("JdbcActionCodeI getParameterMetaData function not Supported", (Throwable)e);
                }
                this.binder.setGetDateAsTimestamp(this.getDateAsTimestamp);
                this.binder.setSetNVarcharAsNVarchar(this.setNVarcharAsVarchar);
                this.binder.setDisableImplicitConversion(this.disableImplicitConversion);
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", String.valueOf(this.actionName) + " : SQL Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                ret = -1;
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", String.valueOf(this.actionName) + " : OK", 3, this.actionLevel, "INFO");
        return ret;
    }

    public int prepare(ResultSet rs) throws EngineExceptionI {
        this.multiQuery = this.getLocalBooleanBindedParameter(rs, "SQL_MULTI_QUERYS", this.getLocalBooleanBindedParameter(rs, "SQL_MULTI_QUERIES", false));
        this.multiQuerySeparators = this.getLocalStringBindedParameter(rs, "SQL_MULTI_QUERYS_SEPARATORS", ";");
        this.multiQueryExclusionsRules = this.getLocalStringBindedParameter(rs, "SQL_MULTI_QUERYS_EXCLUSION_PATTERNS", "--|\n;/\\*|\\*/;'");
        String tmp = this.getLocalStringBindedParameter(rs, "SQL_DISABLE_NB_ROWS_STATISTIC", "false");
        if (tmp.equals("false")) {
            this.sqlDisableNbRowsStatistic = false;
        } else if (tmp.equals("true")) {
            this.sqlDisableNbRowsStatistic = true;
        } else {
            this.sqlDisableNbRowsStatistic = false;
            try {
                String[] stringArray = tmp.split("[ ,;]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    int i = Integer.valueOf(str.trim());
                    this.sqlDisableNbRowsStatisticPosition.add(i);
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int prepareExecuteCode() throws EngineExceptionI {
        int ret = 0;
        this.prepare(null);
        this.typeStatistiques = this.getLocalStringBindedParameter(null, "SQL_ACTION_TYPE_STAT", null);
        try {
            this.sqlActionType = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_ACTION_TYPE");
        }
        catch (EngineExceptionI e) {
            this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.56") + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.57")) + e.getMessage(), "String", false);
            throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.58"), (Throwable)e);
        }
        if (!this.sqlActionType.equals("DDL_DML")) {
            block20: {
                this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.59") + this.sqlActionType, 2, this.actionLevel, "DEBUG");
                try {
                    this.connectionName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
                }
                catch (EngineExceptionI e) {
                    this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.60") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.61")) + e.getMessage(), "String", false);
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.62"), (Throwable)e);
                }
                try {
                    this.sqlWaitData = this.getBooleanParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_DATA");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.sqlWaitPollint = this.getLongParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_POLL_INTERVAL");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.sqlWaitTimeout = this.getLongParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_TIMEOUT");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.sqlWaitTimeout == -1L) {
                    this.sqlWaitTimeout = Long.MAX_VALUE;
                }
                try {
                    this.sqlWaitNbRows = this.getIntegerParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_NB_ROWS");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.sqlWaitCountSelect = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_COUNT_SELECT");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ret = this.prepareSetConnection();
                    if (ret != 0) break block20;
                    this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                    try {
                        ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.binder.setSetDateAsTimestamp(this.setDateAsTimestamp);
                    this.binder.setUseSetNullMethodOnly(this.useSetNullMethodOnly);
                    ret = 0;
                }
                catch (EngineExceptionI e) {
                    this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.63") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("JdbcActionCodeI.64")) + e.getMessage(), "String", false);
                    ret = -1;
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.65"), (Throwable)e);
                }
            }
            this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.66") + this.sqlActionType, 2, this.actionLevel, "DEBUG");
        }
        return ret;
    }

    public int finalizeExecuteCode(boolean withError) throws EngineExceptionI {
        int ret = 0;
        this._closeConnection(!withError);
        this.write(this.sessionName, "JdbcActionCode=>finalizeExecuteCode", String.valueOf(this.actionName) + Messages.getString("JdbcActionCodeI.67") + this.sqlNbRows, 1, this.actionLevel, "INFO");
        this.publishCumulativeStatistiques(true);
        if (this.binder != null) {
            this.binder.clear();
            this.binder = null;
        }
        this.jdbcConnection = null;
        return ret;
    }

    void publishCumulativeStatistiques(boolean last) {
        this.sqlNbRowsTotal += (long)this.sqlNbRows;
        this.sqlNbRows = 0;
        if (!this.sqlDisableNbRowsStatistic.booleanValue() && this.sqlActionType != null && !this.sqlActionType.equals("SELECT")) {
            this.publishStatistic("SQL_NB_ROWS", this.sqlNbRowsTotal, last);
        }
        if (this.typeStatistiques != null) {
            this.publishStatistic("SQL_STAT_" + this.typeStatistiques, this.sqlNbRowsTotal, last);
        }
    }

    public String getDefaultSemaphoreName() {
        String transactionType = "AUTOCOMMIT";
        try {
            transactionType = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_TYPE");
        }
        catch (EngineExceptionI engineExceptionI) {
            // empty catch block
        }
        if (KeyWord.COMMIT_MODE.COMMIT.name().equals(transactionType) || KeyWord.COMMIT_MODE.NOCOMMIT.name().equals(transactionType)) {
            String transactionName = "T1";
            try {
                transactionName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String connectionName = null;
            try {
                connectionName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
            }
            catch (EngineExceptionI engineExceptionI) {
                // empty catch block
            }
            return String.valueOf(connectionName) + "/" + transactionName;
        }
        return null;
    }
}

