/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MkDirActionCodeI
extends ActionCodeTypeI {
    String sDir;
    File dir;
    int num;
    Boolean failsOnError = false;

    public MkDirActionCodeI() {
        this.actionCodeName = "Make Dir Class";
        this.actionClassName = ((Object)((Object)this)).getClass().getName();
        this.bNullCodeAllowed = true;
        this.num = 0;
    }

    void insertFileInTable(int num, String pDir) throws EngineExceptionI {
        Statement sqlStatement = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        try {
            try {
                String txtCode = "INSERT into " + this.sqlSchemaName + "IND_SESSION_FILE_OP_LST (SESS_ID, SESS_NAME, ACT_ID, ACT_NAME, FILE_ID, FILE_OPERATION, FILE_DIR, FILE_OPERATION_DATE, ACT_ITER) " + " values (?,?,?,?,?,?,?,?,?) ";
                sqlStatement = this.jdbcConnection.prepareStatement(txtCode);
                this.debugLog("insertFileInTable", Messages.getString("MkDirActionCodeI.0"), 6, "DEBUG");
                sqlStatement.setString(1, this.actionContext.getSessionId());
                sqlStatement.setString(2, this.sessionName);
                sqlStatement.setString(3, this.actionContext.getActionId());
                sqlStatement.setString(4, this.actionContext.getActionName());
                sqlStatement.setInt(5, num);
                sqlStatement.setString(6, "Make Dir");
                sqlStatement.setString(7, pDir);
                sqlStatement.setString(8, dateFormat.format(new Date()));
                sqlStatement.setInt(9, this.actionContext.getNbExecution() + 1);
                sqlStatement.executeUpdate();
                this.debugLog("insertFileInTable", Messages.getString("MkDirActionCodeI.1"), 6, "DEBUG");
                this.commit();
            }
            catch (SQLException e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>insertFileInTable : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (sqlStatement != null) {
                try {
                    sqlStatement.close();
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
    }

    protected void commit() throws SQLException {
        if (this.sqlTransType.equals("COMMIT")) {
            this.jdbcConnection.commit();
        }
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        this.debugLog("executeSimpleCode", "Begin mkDir", 3, "DEBUG");
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("MkDirActionCodeI.2")) + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("MkDirActionCodeI.3"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
        }
        try {
            if (this.jdbcConnection != null) {
                if (this.sqlTransType.equals("AUTOCOMMIT") || this.sqlTransType.equals("AUTONOMOUS")) {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)true);
                } else {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)false);
                }
            }
            this.dir = new File(this.sDir);
            if (this.dir == null) {
                throw new EngineExceptionI(Messages.getString("MkDirActionCodeI.4"));
            }
            if (this.dir.isFile() && this.failsOnError.booleanValue()) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("MkDirActionCodeI.5")) + Messages.getString("MkDirActionCodeI.6") + this.dir.getAbsolutePath());
            }
            if (!this.dir.exists()) {
                boolean result = this.dir.mkdirs();
                if (!result) {
                    String msg = String.valueOf(Messages.getString("MkDirActionCodeI.7")) + this.dir.getAbsolutePath() + Messages.getString("MkDirActionCodeI.8");
                    throw new EngineExceptionI(msg);
                }
                ++this.num;
                if (this.jdbcConnection != null) {
                    this.insertFileInTableFile(1, this.dir.getCanonicalPath(), null, null, null, "MakeDir", this.dir, -1L);
                }
            } else if (this.failsOnError.booleanValue()) {
                String msg = String.valueOf(Messages.getString("MkDirActionCodeI.9")) + this.dir.getAbsolutePath() + Messages.getString("MkDirActionCodeI.10");
                throw new EngineExceptionI(msg);
            }
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return 0;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("MkDirActionCodeI.11"), 3, "DEBUG");
        this.sDir = this.getLocalStringBindedParameter(rSet, "FILE_DIR", null);
        if (this.sDir == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("MkDirActionCodeI.12"), "String", false);
            throw new EngineExceptionI(Messages.getString("MkDirActionCodeI.13"));
        }
        this.setStandardConnectionParameters(rSet);
        this.failsOnError = this.getLocalBooleanBindedParameter(rSet, "FILE_FAILS_ON_ERROR", false);
        this.debugLog("prepare", Messages.getString("MkDirActionCodeI.14"), 3, "DEBUG");
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

