/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.proxy.JCraftProxyFactory;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.sftp.SFtpSession;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SFtpExecActionCodeI
extends AntActionCodeTypeI {
    String sshCommand = null;
    String sshCommandFile = null;
    String sshOutputFile = null;
    Integer sshTimeout = null;
    ISecretValue sshHostname = null;
    ISecretValue sshPort = null;
    ISecretValue sshUser = null;
    ISecretValue sshPassword = null;
    Boolean sshTrust = true;
    String sshKnownHosts = null;
    String sshKeyFile = null;
    ISecretValue sshPassPhrase = null;
    protected static final int defaultProxyPort = 1080;
    protected ISecretValue proxyPort = null;
    protected ISecretValue proxyHost = null;
    protected ISecretValue proxyUser = null;
    protected ISecretValue proxyPassword = null;
    private Integer proxyProtocol;
    private Logger logger = null;
    static final Map<String, Integer> map = new HashMap<String, Integer>();

    static {
        map.put("SOCKS5", 0);
        map.put("SOCKS4", 1);
        map.put("SOCKS", 3);
        map.put("HTTP", 2);
        map.put("DISABLE", -1);
    }

    public SFtpExecActionCodeI() {
        this.actionCodeName = "SFTP Exec Class";
        this.actionClassName = "SFtpExecActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret;
        block2: {
            ret = 0;
            this.logger = LogManager.getLogger((String)this.runtimeContext.comIndyEngineActionCodes);
            this.write(this.sessionName, String.valueOf(this.actionClassName) + "=>prepareSimpleExecuteCode", String.valueOf(this.actionName) + Messages.getString("SFtpExecActionCodeI.0"), 3, this.actionLevel, "DEBUG");
            try {
                this.sshHostname = this.getLocalSecretBindedParameter(rSet, "SSH_HOST", null);
                this.sshUser = this.getLocalSecretBindedParameter(rSet, "SSH_USER", null);
            }
            catch (EngineExceptionI e) {
                if (this.sshHostname != null && this.sshUser != null) break block2;
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SFtpExecActionCodeI.1"), "String", false);
                throw new EngineExceptionI(Messages.getString("SFtpExecActionCodeI.2"));
            }
        }
        this.sshCommand = this.actionTxtCode != null && !this.actionTxtCode.equals("") ? this.getFinalBindedCode(rSet, this.actionTxtCode) : this.getLocalStringBindedParameter(rSet, "SSH_COMMAND", null);
        this.sshPassword = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD", null));
        this.sshTimeout = this.getLocalIntegerBindedParameter(rSet, "SSH_TIMEOUT", null);
        this.sshPort = this.getLocalSecretBindedParameter(rSet, "SSH_PORT", null);
        this.sshTrust = this.getLocalBooleanBindedParameter(rSet, "SSH_TRUST_HOSTS", true);
        this.sshKnownHosts = this.getLocalStringBindedParameter(rSet, "SSH_KNOWN_HOSTS_FILE", null);
        this.sshKeyFile = this.getLocalStringBindedParameter(rSet, "SSH_PRIVATE_KEY_FILE", this.getLocalStringBindedParameter(rSet, "SSH_PUBLIC_KEY_FILE", null));
        this.sshPassPhrase = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD_PHRASE", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD_PHRASE", null));
        this.proxyHost = this.getLocalSecretBindedParameter(rSet, "PROXY_HOST", null);
        this.proxyPort = this.getLocalSecretBindedParameter(rSet, "PROXY_PORT", String.valueOf(1080));
        this.proxyUser = this.getLocalSecretBindedParameter(rSet, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rSet, "PROXY_PASSWORD", this.getLocalStringBindedParameter(rSet, "PROXY_UNCRYPTED_PASSWORD", null));
        this.proxyProtocol = map.get(this.getLocalStringBindedParameter(rSet, "PROXY_PROTOCOL", "SOCKS5"));
        this.write(this.sessionName, String.valueOf(this.actionClassName) + "=>prepareSimpleExecuteCode", String.valueOf(this.actionName) + Messages.getString("SFtpExecActionCodeI.3"), 3, this.actionLevel, "DEBUG");
        return ret;
    }

    private ChannelSftp initSftp() throws JSchException, EngineExceptionI {
        final JSch jsch = new JSch();
        if (this.sshKnownHosts != null) {
            try {
                jsch.setKnownHosts(this.sshKnownHosts);
            }
            catch (JSchException e) {
                this.logger.error(Messages.getString("SFtpExecActionCodeI.4"));
            }
        }
        if (this.sshKeyFile != null) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    if (SFtpExecActionCodeI.this.sshPassPhrase != null) {
                        jsch.addIdentity(SFtpExecActionCodeI.this.sshKeyFile, SFtpExecActionCodeI.this.sshPassPhrase.decryptString(context));
                    } else {
                        jsch.addIdentity(SFtpExecActionCodeI.this.sshKeyFile);
                    }
                    SFtpExecActionCodeI.this.logger.info(Messages.getString("SFtpExecActionCodeI.5"));
                    return null;
                }
            });
        }
        final Session session = (Session)this.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                if (SFtpExecActionCodeI.this.sshPort != null) {
                    return jsch.getSession(SFtpExecActionCodeI.this.sshUser.getString(context), SFtpExecActionCodeI.this.sshHostname.getString(context), Integer.valueOf(SFtpExecActionCodeI.this.sshPort.getString(context)).intValue());
                }
                return jsch.getSession(SFtpExecActionCodeI.this.sshUser.getString(context), SFtpExecActionCodeI.this.sshHostname.getString(context));
            }
        });
        Properties config = new Properties();
        if (this.sshTrust.booleanValue()) {
            config.put("StrictHostKeyChecking", "no");
        }
        session.setConfig(config);
        if (this.sshPassword != null) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    session.setPassword(SFtpExecActionCodeI.this.sshPassword.decryptString(context));
                    return null;
                }
            });
        }
        if (this.sshTimeout != null) {
            session.setTimeout(this.sshTimeout.intValue());
        }
        this.setProxy(session);
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        return (ChannelSftp)channel;
    }

    private void setProxy(final Session session) throws EngineExceptionI {
        this.secret(new ISecretStatement(){

            public Object execute(ISecretContext context) throws Throwable {
                JCraftProxyFactory psf = null;
                if (SFtpExecActionCodeI.this.proxyHost != null && !SFtpExecActionCodeI.this.proxyHost.isNull() && SFtpExecActionCodeI.this.proxyProtocol != null && SFtpExecActionCodeI.this.proxyProtocol != -1) {
                    String tmp = SFtpExecActionCodeI.this.proxyPassword.decryptString(context);
                    psf = new JCraftProxyFactory(SFtpExecActionCodeI.this.proxyProtocol, SFtpExecActionCodeI.this.proxyHost.getString(context), SFtpExecActionCodeI.this.proxyPort.getInteger(context), SFtpExecActionCodeI.this.proxyUser.getString(context), tmp);
                    psf.setLogger(SFtpExecActionCodeI.this.logger);
                }
                if (psf != null) {
                    session.setProxy(psf.getProxy());
                }
                return null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int executeSimpleCode() throws EngineExceptionI {
        int ret;
        block16: {
            ret = 0;
            SFtpSession f = null;
            try {
                try {
                    void var7_11;
                    ChannelSftp c = this.initSftp();
                    f = new SFtpSession(null, c);
                    final HashMap statistics = new HashMap();
                    f.addListener(new FtpStatisticListener(){

                        public void statisticEvent(FtpStatisticListener.Statistic statistic, long value) {
                            String name = statistic.name();
                            long newValue = value;
                            if (statistics.containsKey(name)) {
                                newValue = (Long)statistics.get(name) + value;
                            }
                            statistics.put(name, newValue);
                        }
                    });
                    f.setRaiseException(true);
                    if (this.sshCommand == null || this.sshCommand.isEmpty()) break block16;
                    ArrayList<String> _cmds = new ArrayList<String>();
                    String[] stringArray = this.sshCommand.split("\n");
                    int n = stringArray.length;
                    boolean n2 = false;
                    while (var7_11 < n) {
                        String _cmd = stringArray[var7_11];
                        _cmds.add(_cmd);
                        ++var7_11;
                    }
                    StringBuilder msg = new StringBuilder("");
                    try {
                        for (String string : _cmds) {
                            msg.append(f.executeCommand(string));
                        }
                        this.publishVariable("RET_MESS", msg, "String");
                        if (statistics != null) {
                            for (Map.Entry entry : statistics.entrySet()) {
                                String name = (String)entry.getKey();
                                long value = (Long)entry.getValue();
                                this.publishCumulativeVariable(name, value, "Integer", false);
                            }
                        }
                    }
                    catch (FtpCommandException ftpCommandException) {
                        throw new EngineExceptionI((Throwable)ftpCommandException);
                    }
                }
                catch (Exception e) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>executeSimpleCode : " + e.getMessage(), "String", false);
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            finally {
                try {
                    if (f != null) {
                        f.dispose();
                    }
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        this.prepare(sourceRSet);
        int ret = 0;
        this.executeSimpleCode();
        return ret;
    }
}

