/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.AntScp;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class ScpGetActionCodeI
extends AntActionCodeTypeI {
    String scpLocalDir;
    String scpRemoteFile = null;
    Long sshTimeout = null;
    ISecretValue scpHostname = null;
    ISecretValue scpPort = null;
    ISecretValue scpUser = null;
    ISecretValue scpPassword = null;
    Boolean scpTrust = true;
    String scpKnownHosts = null;
    String scpKeyFile = null;
    ISecretValue scpPassPhrase = null;
    Boolean scpUseSFTP = false;
    Boolean scpPreserveFileDate = false;
    ISecretValue proxyPort = null;
    ISecretValue proxyHost = null;
    ISecretValue proxyUser = null;
    ISecretValue proxyPassword = null;
    String proxyProtocol = null;
    private boolean casesensitive;
    private boolean defaultExcludes;
    String additionalConnectionProperties = null;
    IPreparedStatementToResultSet jpstrs = null;

    public ScpGetActionCodeI() {
        this.actionCodeName = "Scp get File Class";
        this.actionClassName = "ScpGetActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("ScpGetActionCodeI.0"), 3, "DEBUG");
        this.scpHostname = this.getLocalSecretBindedParameter(rSet, "SSH_HOST", null);
        this.scpUser = this.getLocalSecretBindedParameter(rSet, "SSH_USER", null);
        this.scpRemoteFile = this.getLocalStringBindedParameter(rSet, "SCP_REMOTE_FILE", null);
        this.scpLocalDir = this.getLocalStringBindedParameter(rSet, "SCP_LOCAL_DIR", null);
        if (this.scpHostname.isNull() || this.scpUser.isNull() || this.scpRemoteFile == null || this.scpLocalDir == null) {
            this.addVariableWithULog(VariableType.CORE_RET_MESS.getName(), Messages.getString("ScpGetActionCodeI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("ScpGetActionCodeI.2"));
        }
        this.scpPassword = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD", null));
        this.sshTimeout = this.getLocalLongBindedParameter(rSet, "SSH_TIMEOUT", null);
        this.scpPort = this.getLocalSecretBindedParameter(rSet, "SSH_PORT", null);
        this.setStandardConnectionParameters(rSet);
        this.scpTrust = this.getLocalBooleanBindedParameter(rSet, "SSH_TRUST_HOSTS", true);
        this.scpUseSFTP = this.getLocalBooleanBindedParameter(rSet, "SCP_USE_SFTP", false);
        this.scpKnownHosts = this.getLocalStringBindedParameter(rSet, "SSH_KNOWN_HOSTS_FILE", null);
        this.scpKeyFile = this.getLocalStringBindedParameter(rSet, "SSH_PRIVATE_KEY_FILE", null);
        if (this.scpKeyFile == null) {
            this.scpKeyFile = this.getLocalStringBindedParameter(rSet, "SSH_PUBLIC_KEY_FILE", null);
        }
        this.scpPassPhrase = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD_PHRASE", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD_PHRASE", ""));
        this.proxyHost = this.getLocalSecretBindedParameter(rSet, "PROXY_HOST", null);
        this.proxyPort = this.getLocalSecretBindedParameter(rSet, "PROXY_PORT", "-1");
        this.proxyProtocol = this.getLocalStringBindedParameter(rSet, "PROXY_PROTOCOL", null);
        this.proxyUser = this.getLocalSecretBindedParameter(rSet, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rSet, "PROXY_PASSWORD", this.getLocalStringBindedParameter(rSet, "PROXY_UNCRYPTED_PASSWORD", ""));
        this.casesensitive = this.getLocalBooleanBindedParameter(rSet, "SCP_CASE_SENSITIVE", true);
        this.defaultExcludes = this.getLocalBooleanBindedParameter(rSet, "SCP_DEFAULT_EXLUDES", true);
        this.scpPreserveFileDate = this.getLocalBooleanBindedParameter(rSet, "SCP_PRESERVE_FILE_DATE", false);
        this.additionalConnectionProperties = this.getLocalStringBindedParameter(rSet, "SSH_ADDITIONAL_CONNECTION_PROPERTIES", null);
        this.write(this.sessionName, String.valueOf(this.actionClassName) + "=>prepareSimpleExecuteCode", String.valueOf(this.actionName) + Messages.getString("ScpGetActionCodeI.3"), 3, this.actionLevel, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        final AntScp antScpManager = new AntScp(this.casesensitive, this.defaultExcludes);
        antScpManager.setProject(this.project);
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("ScpGetActionCodeI.4")) + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("ScpGetActionCodeI.5"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
        }
        if (this.sshTimeout != null) {
            antScpManager.setTimeout(this.sshTimeout);
        }
        this.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                antScpManager.setRemoteFile(String.valueOf(ScpGetActionCodeI.this.scpUser.getString(context)) + (!ScpGetActionCodeI.this.scpPassword.isNull() ? ":" + ScpGetActionCodeI.this.scpPassword.decryptString(context) : "") + "@" + ScpGetActionCodeI.this.scpHostname.getString(context) + ":" + ScpGetActionCodeI.this.scpRemoteFile);
                return null;
            }
        });
        File fd = null;
        try {
            fd = new File(this.scpLocalDir);
            if (!fd.isDirectory()) {
                throw new EngineExceptionI(Messages.getString("ScpGetActionCodeI.6"));
            }
            antScpManager.setLocalTodir(this.scpLocalDir);
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        antScpManager.setSftp(this.scpUseSFTP);
        antScpManager.setTrust(this.scpTrust);
        antScpManager.setPreserveFileDate(this.scpPreserveFileDate);
        if (!this.scpPort.isNull()) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setPort(Integer.parseInt(ScpGetActionCodeI.this.scpPort.getString(context)));
                    return null;
                }
            });
        }
        if (this.scpKeyFile != null) {
            antScpManager.setKeyfile(this.scpKeyFile);
        }
        if (this.scpKnownHosts != null) {
            antScpManager.setKnownhosts(this.scpKnownHosts);
        }
        if (!this.scpPassPhrase.isNull()) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setPassphrase(ScpGetActionCodeI.this.scpPassPhrase.decryptString(context));
                    return null;
                }
            });
        }
        if (!this.proxyHost.isNull()) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setProxyHost(ScpGetActionCodeI.this.proxyHost.getString(context));
                    if (ScpGetActionCodeI.this.proxyPort.getInteger(context) != -1) {
                        antScpManager.setProxyPort(ScpGetActionCodeI.this.proxyPort.getInteger(context));
                    }
                    return null;
                }
            });
            if (this.proxyProtocol != null) {
                if (this.proxyProtocol.equals("SOCKS5")) {
                    antScpManager.setProxyProtocol(5);
                } else if (this.proxyProtocol.equals("SOCKS4")) {
                    antScpManager.setProxyProtocol(4);
                } else if (this.proxyProtocol.equals("HTTP")) {
                    antScpManager.setProxyProtocol(1);
                }
            }
            if (!this.proxyUser.isNull()) {
                this.secret((ISecretStatement)new ISecretStatement<Object>(){

                    public Object execute(ISecretContext context) throws Throwable {
                        antScpManager.setProxyUser(ScpGetActionCodeI.this.proxyUser.getString(context));
                        antScpManager.setProxyPassword(ScpGetActionCodeI.this.proxyPassword.decryptString(context));
                        return null;
                    }
                });
            }
        }
        String filePath = this.scpLocalDir;
        String fileName = "";
        fileName = this.scpRemoteFile.contains("\\") ? this.scpRemoteFile.substring(this.scpRemoteFile.lastIndexOf("\\")) : (this.scpRemoteFile.contains("/") ? this.scpRemoteFile.substring(this.scpRemoteFile.lastIndexOf("/")) : this.scpRemoteFile);
        filePath = String.valueOf(filePath) + fileName;
        File destFile = new File(filePath);
        if (this.isRdbmsLinked.booleanValue()) {
            try {
                this.insertFileInTableFile(1, this.scpRemoteFile.replace(fileName, ""), fileName, this.scpLocalDir, filePath, "ScpGet", destFile, fd != null ? fd.lastModified() : -1L);
            }
            catch (EngineExceptionI e) {
                e.printStackTrace();
            }
        }
        IActionBind aBind = this.getActionContext().getActionBind();
        try {
            if (aBind != null) {
                if (this.jpstrs == null) {
                    this.jpstrs = this.insertFileInTableFilePrepare();
                    this.getActionContext().bindWithTarget(((JdbcPreparedStatementToResultSet)this.jpstrs).getNotFetchedResultSetBindI());
                }
                if (fd != null) {
                    this.insertFileInTableFile((PreparedStatement)this.jpstrs, 1, this.scpRemoteFile.replace(fileName, ""), fileName, this.scpLocalDir, filePath, "ScpGet", destFile, fd != null ? fd.lastModified() : -1L);
                }
            }
        }
        catch (EngineExceptionI | InterruptedException | SQLException e) {
            e.printStackTrace();
        }
        if (this.additionalConnectionProperties != null && !this.additionalConnectionProperties.trim().isEmpty()) {
            Properties props = new Properties();
            try {
                props.load(new StringReader(this.additionalConnectionProperties));
            }
            catch (IOException e) {
                throw new EngineExceptionI(Messages.getString("ScpGetActionCodeI.7"), (Throwable)e);
            }
            antScpManager.setAdditionalConnectionProperties(props);
        }
        this.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                antScpManager.execute();
                return null;
            }
        });
        if (this.jpstrs != null) {
            try {
                this.jpstrs.end();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

