/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.file.jdbc.DelimitedRecordToResultSet;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StructuredDataReaderActionCodeI
extends ActionCodeTypeI {
    private String filePath;
    private String data;
    private String metadata;
    private DelimitedRecordToResultSet ftrs;
    private String encoding;

    public StructuredDataReaderActionCodeI() {
        this.actionCodeName = "FileToResultSetActionCodeI Class";
        this.actionClassName = "FileToResultSetActionCodeI";
        this.bNullCodeAllowed = true;
    }

    private void parse(String str, DelimitedRecordToResultSet ftrs) throws SAXException, IOException, ParserConfigurationException, SQLException {
        String _str = "<root>" + str + "</root>";
        ByteArrayInputStream is = new ByteArrayInputStream(_str.getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        Document doc = factory.newDocumentBuilder().parse(is);
        ((InputStream)is).close();
        Node root = doc.getFirstChild();
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeName().equals("column")) {
                Node attr = node.getAttributes().getNamedItem("name");
                String name = "F" + (i + 1);
                if (attr != null) {
                    name = attr.getNodeValue();
                }
                attr = node.getAttributes().getNamedItem("type");
                String type = "VARCHAR";
                if (attr != null) {
                    type = attr.getNodeValue();
                }
                attr = node.getAttributes().getNamedItem("precision");
                int precision = 255;
                if (attr != null) {
                    String tmp = attr.getNodeValue();
                    try {
                        precision = Integer.valueOf(tmp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                attr = node.getAttributes().getNamedItem("scale");
                int scale = 255;
                if (attr != null) {
                    String tmp = attr.getNodeValue();
                    try {
                        scale = Integer.valueOf(tmp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ftrs.addColumn(name, type, precision, scale);
            }
            ++i;
        }
    }

    public int executeSimpleCode() throws EngineExceptionI {
        InputStream is = null;
        try {
            try {
                IActionBind aBind = this.getActionContext().getActionBind();
                JdbcPreparedStatementToResultSet st = (JdbcPreparedStatementToResultSet)this.getActionContext().createBindePreparedStatement();
                if (st == null) {
                    throw new EngineExceptionI(Messages.getString("StructuredDataReaderActionCodeI.0"));
                }
                this.ftrs.setStatement(st);
                if (this.metadata != null) {
                    this.parse(this.metadata, this.ftrs);
                }
                if (aBind != null) {
                    NotFetchedResultSetBindI rsb = this.ftrs.getNotFetchedResultSetBindI();
                    this.getActionContext().bindWithTarget(rsb);
                }
                is = this.filePath != null ? new FileInputStream(this.filePath) : new ByteArrayInputStream(this.data.getBytes());
                this.ftrs.write(is, this.encoding);
            }
            catch (SQLException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (IOException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (SAXException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (ParseException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.ftrs != null) {
                try {
                    this.ftrs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        this.ftrs = new DelimitedRecordToResultSet(this.runtimeContext);
        this.metadata = this.getLocalStringBindedParameter(sourceRSet, "METADATA", null);
        this.encoding = this.getLocalStringBindedParameter(sourceRSet, "IN_FILE_ENCODING", "UTF-8");
        this.filePath = this.getLocalStringBindedParameter(sourceRSet, "IN_FILE_NAME", null);
        this.data = null;
        if (this.filePath == null && this.actionTxtCode != null && !this.actionTxtCode.equals("")) {
            if (sourceRSet != null) {
                try {
                    this.data = this.getFinalBindedCode(sourceRSet, this.actionTxtCode);
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            } else {
                this.data = this.actionTxtCode;
            }
        }
        if (this.filePath == null && (this.data == null || this.data.trim().isEmpty())) {
            throw new EngineExceptionI(Messages.getString("StructuredDataReaderActionCodeI.1"));
        }
        this.ftrs.setTimeStampPattern(this.getLocalStringBindedParameter(sourceRSet, "TIMESTAMP_FORMAT", this.runtimeContext.GLOBAL_DATE_FORMAT));
        this.ftrs.setDatePattern(this.getLocalStringBindedParameter(sourceRSet, "DATE_FORMAT", "yyyy/MM/dd"));
        this.ftrs.setSignPosition(this.getLocalStringBindedParameter(sourceRSet, "SIGN_POSITION", null));
        this.ftrs.setTimepattern(this.getLocalStringBindedParameter(sourceRSet, "TIME_FORMAT", "HH:mm:ss.SSS"));
        this.ftrs.setFieldSeparator(this.getLocalStringBindedParameter(sourceRSet, "FIELD_SEPARATOR", ","));
        String rowSeparator = StructuredDataReaderActionCodeI.decodeSpecialChar(this.getLocalStringBindedParameter(sourceRSet, "ROW_SEPARATOR", "\n"));
        this.ftrs.setRowSeparator(rowSeparator, null);
        String strdelimiter = StructuredDataReaderActionCodeI.decodeSpecialChar(this.getLocalStringBindedParameter(sourceRSet, "STRING_DELIMITER", "\""));
        this.ftrs.setStringDelimiter(strdelimiter, StructuredDataReaderActionCodeI.decodeSpecialChar(this.getLocalStringBindedParameter(sourceRSet, "STRING_DELIMITER_REPLACEMENT", String.valueOf(strdelimiter) + strdelimiter)));
        return 0;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }

    public static String decodeSpecialChar(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r").replace("\\f", "\f");
    }
}

