/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.Global;
import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.JdbcToXmlActionCodeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.IndyContentHandler;
import com.indy.engine.actionCodes.wsdl.HttpOperation;
import com.indy.engine.actionCodes.wsdl.HttpPort;
import com.indy.engine.actionCodes.wsdl.Operation;
import com.indy.engine.actionCodes.wsdl.Part;
import com.indy.engine.actionCodes.wsdl.Port;
import com.indy.engine.actionCodes.wsdl.SoapOperation;
import com.indy.engine.actionCodes.wsdl.SoapPort;
import com.indy.engine.actionCodes.wsdl.Wsdl;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.actionCodes.xml.unload.XmlWriterAPI;
import com.indy.engine.common.ntlm.NtlmMetadata;
import com.indy.engine.common.scripting.StbScriptEngineManager;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.indy.runtime.utils.SSLUtils;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlToWsdlActionCodeI
extends ActionCodeTypeI {
    static String xsiUri = JdbcToXmlActionCodeI.xsiUri;
    private static String mdPrefix = "md";
    private static String mdURI = "http://www.stambia.com/md";
    private String inputFile;
    private AbstractXmlWriterAPI xwa;
    private FileInputStream is;
    public int retryNumber;
    public int readTimeout;
    public int connectionTimeout;
    public int retryDelay;
    public int delayBetweenInvocation;
    public String encoding;
    public String urlEncoding;
    public String proxyHost;
    public int proxyPort;
    public String proxyUser;
    public ISecretValue proxyPassword;
    private Integer errorAcceptanceNumber;
    private File sentMessagesFolder;
    private File receivedMessagesFolder;
    public String soapStartMessageScript;
    public boolean activeScripting;
    public ScriptEngine engine;
    public Bindings bindings;
    private Map<String, String> headerParameters;
    private String WSSEUsernname;
    private String WSSEPassword;
    private String WSSEPasswordType;
    private String WSSERawContent;
    public Integer technicalErrorAcceptanceNumber;
    public Integer technicalErrorRetryNumber;
    public Integer technicalErrorRetryDelay;
    private NtlmMetadata ntlmMetadata = null;
    private boolean WSSEAddsANonce;
    private boolean WSSEAddsACreated;
    private Boolean encloseActionWithQuote = false;
    private Long WSSETimeToLive;
    private String tempFolder;
    private String attachmentsFolder;
    private String xmlVersion;
    private Operation currentOperation;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private boolean WSSE;
    public BidiMap<String, String> namespaces = new BidiMap();
    private String xsiPrefix = "xsi";
    public static String wsseUri = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static String wsuUri = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static String defaultWssePrefix = "wsse";
    public static String defaultWsuPrefix = "wsu";
    private MessageDigest digest;
    public String wssePrefix = defaultWssePrefix;
    public String wsuPrefix = defaultWsuPrefix;
    public Map<String, CompiledScript> compiledScripts;
    public String user;
    public ISecretValue password;
    private SecureRandom random;
    OAuth2Metadata oAuth2 = null;
    OAuthMetadata oAuth = null;

    public XmlToWsdlActionCodeI() {
        super("Xml To Wsdl Action Code", true);
    }

    public Proxy getProxy() {
        if (this.proxyHost != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        return null;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                parserFactory.setFeature("http://xml.org/sax/features/validation", false);
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                XMLReader saxReader = parser.getXMLReader();
                SimpleContentHandler sch = new SimpleContentHandler();
                saxReader.setContentHandler((ContentHandler)((Object)sch));
                if (this.actionTxtCode != null) {
                    this.actionTxtCode.trim().isEmpty();
                }
                this.is = new FileInputStream(this.inputFile);
                saxReader.parse(new InputSource(this.is));
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (this.xwa != null) {
                this.xwa.close();
            }
        }
        return 0;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return 0;
    }

    public int prepare(ResultSet rs) throws EngineExceptionI {
        String oauth1Token;
        this.attachmentsFolder = this.getLocalStringBindedParameter(rs, "RECEIVED_ATTACHMENTS_FOLDER", null);
        this.proxyHost = this.getLocalStringBindedParameter(rs, "PROXY_HOST", null);
        this.proxyPort = this.getLocalIntegerBindedParameter(rs, "PROXY_PORT", -1);
        this.proxyUser = this.getLocalStringBindedParameter(rs, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rs, "PROXY_PASSWORD", null);
        this.tempFolder = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + Constant.VAR_CORE_TEMPORARY_FOLDER);
        this.inputFile = this.getLocalStringBindedParameter(rs, "IN_FILE_NAME");
        if (this.inputFile.startsWith("<tempDir>")) {
            File _tempFolder = new File(this.tempFolder);
            if (!_tempFolder.exists()) {
                _tempFolder.mkdirs();
            }
            this.inputFile = _tempFolder + "/" + this.inputFile.substring(9);
        }
        File outFile = new File(this.inputFile);
        this.readTimeout = this.getLocalIntegerBindedParameter(rs, "READ_TIMEOUT", 0);
        this.connectionTimeout = this.getLocalIntegerBindedParameter(rs, "CONNECTION_TIMEOUT", 0);
        this.retryNumber = this.getLocalIntegerBindedParameter(rs, "RETRY_NUMBER", new Integer(0));
        this.retryDelay = this.getLocalIntegerBindedParameter(rs, "RETRY_DELAY", new Integer(0));
        this.delayBetweenInvocation = this.getLocalIntegerBindedParameter(rs, "DELAY_BETWEEN_INVOCATIONS", new Integer(0));
        String xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY", Global.defaultXmlOutputFactory);
        this.xmlVersion = this.getLocalStringBindedParameter(rs, "WRITE_XML_VERSION", "1.1");
        this.encoding = this.getLocalStringBindedParameter(rs, "OUT_FILE_ENCODING", null);
        this.urlEncoding = this.getLocalStringBindedParameter(rs, "URL_ENCODED_CHARSET", null);
        boolean writeXmlDeclaration = this.getLocalBooleanBindedParameter(rs, "WRITE_XML_DECLARATION", true);
        this.errorAcceptanceNumber = this.getLocalIntegerBindedParameter(rs, "ERROR_ACCEPTANCE_NUMBER", -1);
        this.technicalErrorAcceptanceNumber = this.getLocalIntegerBindedParameter(rs, "TECHNICAL_ERROR_ACCEPTANCE_NUMBER", 0);
        this.technicalErrorRetryNumber = this.getLocalIntegerBindedParameter(rs, "TECHNICAL_ERROR_RETRY_NUMBER", 0);
        this.technicalErrorRetryDelay = this.getLocalIntegerBindedParameter(rs, "TECHNICAL_ERROR_RETRY_DELAY", 0);
        String _tmp = this.getLocalStringBindedParameter(rs, "SENT_MESSAGES_FOLDER", null);
        if (_tmp != null && !_tmp.isEmpty()) {
            this.sentMessagesFolder = new File(_tmp);
            if (!this.sentMessagesFolder.exists()) {
                this.sentMessagesFolder.mkdirs();
            }
            if (!this.sentMessagesFolder.isDirectory()) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("XmlToWsdlActionCodeI.0")) + _tmp + Messages.getString("XmlToWsdlActionCodeI.1"));
            }
        }
        if ((_tmp = this.getLocalStringBindedParameter(rs, "RECEIVED_MESSAGES_FOLDER", null)) != null && !_tmp.isEmpty()) {
            this.receivedMessagesFolder = new File(_tmp);
            if (!this.receivedMessagesFolder.exists()) {
                this.receivedMessagesFolder.mkdirs();
            }
            if (!this.receivedMessagesFolder.isDirectory()) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("XmlToWsdlActionCodeI.2")) + _tmp + Messages.getString("XmlToWsdlActionCodeI.3"));
            }
        }
        this.xwa = new XmlWriterAPI(true, this.encoding, writeXmlDeclaration, this.xmlVersion, null, xmlOutPutFactoryClassName, outFile, true, this, AbstractXmlWriterAPI.NoDataBehaviour.deleteExistingFile, AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.replace, null, null){

            @Override
            public JdbcToXmlActionCodeI.IndyElement getRoot() {
                return null;
            }
        };
        this.soapStartMessageScript = this.getLocalStringBindedParameter(rs, "SOAP_START_MESSAGE_SCRIPT", null);
        this.activeScripting = this.getLocalBooleanBindedParameter(rs, "ACTIVE_SCRIPTING", false);
        if (this.activeScripting) {
            StbScriptEngineManager mgr = null;
            try {
                mgr = new StbScriptEngineManager(ClassLoaderServiceProvider.INSTANCE.getClassLoader("internal"));
            }
            catch (ClassLoaderServiceProvider.ClassLoaderServiceException ex) {
                throw new EngineExceptionI((Throwable)ex);
            }
            this.engine = mgr.getEngineByName("rhino");
            this.bindings = this.engine.getBindings(100);
        }
        TrustManager[] trustManagers = null;
        if (Boolean.TRUE.equals(this.getLocalBooleanBindedParameter(rs, "IGNORE_TRUST_STORE", false))) {
            X509TrustManager trustMgr = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            trustManagers = new TrustManager[]{trustMgr};
        } else {
            final String trustStore = this.getLocalStringBindedParameter(rs, "TRUST_STORE", null);
            if (trustStore != null) {
                final String keyStoreType = this.getLocalStringBindedParameter(rs, "TRUST_STORE_TYPE", "JKS");
                final ISecretValue keyStorePassword = this.getLocalSecretBindedParameter(rs, "TRUST_STORE_PASSWORD", "changeit");
                try {
                    trustManagers = (TrustManager[])this.secret((ISecretStatement)new ISecretStatement<TrustManager[]>(){

                        public TrustManager[] execute(ISecretContext context) throws Throwable {
                            return SSLUtils.loadTrustStore((String)trustStore, (String)keyStoreType, (String)keyStorePassword.decryptString(context));
                        }
                    });
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        if (Boolean.TRUE.equals(this.getLocalBooleanBindedParameter(rs, "IGNORE_HOSTNAME_VERIFIER", false))) {
            this.hostnameVerifier = (hostname, sslSession) -> true;
        }
        final String keyStore = this.getLocalStringBindedParameter(rs, "KEY_STORE", null);
        KeyManager[] keyManagers = null;
        if (keyStore != null) {
            final String keyStoreType = this.getLocalStringBindedParameter(rs, "KEY_STORE_TYPE", "JKS");
            final ISecretValue keyStorePassword = this.getLocalSecretBindedParameter(rs, "KEY_STORE_PASSWORD", "changeit");
            try {
                keyManagers = (KeyManager[])this.secret((ISecretStatement)new ISecretStatement<KeyManager[]>(){

                    public KeyManager[] execute(ISecretContext context) throws Throwable {
                        return SSLUtils.loadKeyStore((String)keyStore, (String)keyStoreType, (String)keyStorePassword.decryptString(context));
                    }
                });
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        if (keyManagers != null || trustManagers != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, null);
                this.sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (KeyManagementException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.user = this.getLocalStringBindedParameter(rs, "USER", null);
        this.password = this.getLocalSecretBindedParameter(rs, "PASSWORD", null);
        String httpHeaderParameterSeprator = this.getLocalStringBindedParameter(rs, "HTTP_HEADER_PARAMETER_SEPARATOR", "\n");
        String httpHeaderValueSeprator = this.getLocalStringBindedParameter(rs, "HTTP_HEADER_VALUE_SEPARATOR", ":");
        String httpHeaders = this.getLocalStringBindedParameter(rs, "HTTP_HEADER_PARAMETERS", null);
        this.headerParameters = new HashMap<String, String>();
        if (httpHeaders != null) {
            String str = "";
            Object[] objectArray = httpHeaderParameterSeprator.toCharArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = objectArray[n2];
                str = String.valueOf(str) + "\\" + c;
                ++n2;
            }
            String[] strs = httpHeaders.split(httpHeaderParameterSeprator);
            objectArray = strs;
            n = strs.length;
            n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                int index = ((String)(param = (Object)((String)param).trim())).indexOf(httpHeaderValueSeprator);
                if (index > -1) {
                    this.headerParameters.put(((String)param).substring(0, index), ((String)param).substring(index + 1));
                }
                ++n2;
            }
        }
        final String ntlmUser = this.getLocalStringBindedParameter(rs, "NTLM_USER", null);
        final String ntlmDomain = this.getLocalStringBindedParameter(rs, "NTLM_DOMAIN", null);
        final ISecretValue ntlmEncPassword = this.getLocalSecretBindedParameter(rs, "NTLM_PASSWORD", null);
        if (ntlmUser != null) {
            this.ntlmMetadata = (NtlmMetadata)this.secret((ISecretStatement)new ISecretStatement<NtlmMetadata>(){

                public NtlmMetadata execute(ISecretContext context) throws Throwable {
                    return new NtlmMetadata(ntlmUser, ntlmEncPassword.decryptString(context), ntlmDomain);
                }
            });
        }
        this.WSSEUsernname = this.getLocalStringBindedParameter(rs, "WSSE_USERNAME", null);
        this.WSSEPassword = this.getLocalPasswordParameter(rs, "WSSE_PASSWORD", "WSSE_UNCRYPTED_PASSWORD", null);
        this.WSSEPasswordType = this.getLocalStringBindedParameter(rs, "WSSE_PASSWORD_TYPE", "PasswordDigest");
        this.WSSETimeToLive = this.getLocalLongBindedParameter(rs, "WSSE_TIME_TO_LIVE", null);
        this.WSSEAddsACreated = this.getLocalBooleanBindedParameter(rs, "WSSE_ADDS_CREATED", false);
        this.WSSEAddsANonce = this.getLocalBooleanBindedParameter(rs, "WSSE_ADDS_NONCE", false);
        this.WSSERawContent = this.getLocalStringBindedParameter(rs, "WSSE_RAW_CONTENT", null);
        this.WSSE = this.WSSEUsernname != null && !this.WSSEUsernname.isEmpty() || this.WSSETimeToLive != null && this.WSSETimeToLive > 0L || this.WSSERawContent != null && !this.WSSERawContent.isEmpty();
        this.encloseActionWithQuote = this.getLocalBooleanBindedParameter(rs, "SOAP_ENCLOSE_ACTION_URI", false);
        String oauth2AccessToken = this.getLocalStringBindedParameter(rs, "OAUTH2_ACCESS_TOKEN", null);
        String oauth2RefreshToken = this.getLocalStringBindedParameter(rs, "OAUTH2_REFRESH_TOKEN", null);
        String oauth2FlowType = this.getLocalStringBindedParameter(rs, "OAUTH2_FLOW_TYPE", null);
        if (oauth2AccessToken != null || oauth2RefreshToken != null || oauth2FlowType != null) {
            this.oAuth2 = new OAuth2Metadata();
            OAuth2Utils.setLog4JLogger((OAuth2Metadata)this.oAuth2, (Logger)LogManager.getLogger((String)this.runtimeContext.comIndyEngineActionCodes));
            this.oAuth2.accessToken = oauth2AccessToken;
            this.oAuth2.proxyHost = this.proxyHost;
            this.oAuth2.proxyPort = this.proxyPort;
            this.oAuth2.proxyUser = this.proxyUser;
            this.oAuth2.proxyPassword = (String)this.secret((ISecretStatement)new ISecretStatement<String>(){

                public String execute(ISecretContext context) throws Throwable {
                    return XmlToWsdlActionCodeI.this.proxyPassword.decryptString(context);
                }
            });
            if (oauth2RefreshToken != null || oauth2FlowType != null) {
                this.oAuth2.refreshToken = oauth2RefreshToken;
                this.oAuth2.flowType = oauth2FlowType;
                this.oAuth2.tokenEndpoint = this.getLocalStringBindedParameter(rs, "OAUTH2_TOKEN_ENDPOINT", null);
                this.oAuth2.clientId = this.getLocalStringBindedParameter(rs, "OAUTH2_CLIENT_ID", null);
                this.oAuth2.clientSecret = this.getLocalPasswordParameter(rs, "OAUTH2_CLIENT_SECRET", "OAUTH2_UNCRYPTED_CLIENT_SECRET", null);
                this.oAuth2.expiresIn = this.getLocalLongBindedParameter(rs, "OAUTH2_EXPIRES_IN", 0L);
                this.oAuth2.numberOfAttempts = this.getLocalIntegerBindedParameter(rs, "OAUTH2_NUMBER_OF_ATTEMPTS", 1);
                this.oAuth2.connectionTimeout = this.getLocalIntegerBindedParameter(rs, "OAUTH2_CONNECTION_TIMEOUT", -1);
                boolean sendClientId = this.getLocalBooleanBindedParameter(rs, "OAUTH2_SEND_CLIENT_ID", false);
                boolean sendClientSecret = this.getLocalBooleanBindedParameter(rs, "OAUTH2_SEND_CLIENT_SECRET", false);
                String _credentialPolicy = this.getLocalStringBindedParameter(rs, "OAUTH2_SEND_CLIENT_CREDENTIALS_POLICY", null);
                OAuth2.CredentialMode credentialPolicy = OAuth2.CredentialMode.NONE;
                if (_credentialPolicy == null) {
                    if (sendClientId) {
                        credentialPolicy = sendClientSecret ? OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET : OAuth2.CredentialMode.PARAMETER_CLIENT_ID;
                    }
                } else {
                    credentialPolicy = OAuth2.CredentialMode.fromLabel((String)_credentialPolicy);
                    if (_credentialPolicy == null) {
                        throw new EngineExceptionI(String.format(Messages.getString("XmlToWsdlActionCodeI.4"), _credentialPolicy));
                    }
                }
                this.oAuth2.clientCredentialPolicy = credentialPolicy;
                this.oAuth2.tokenEndpointHttpMethod = this.getLocalStringBindedParameter(rs, "OAUTH2_TOKEN_ENDPOINT_HTTP_METHOD", "POST");
                this.oAuth2.login = this.getLocalStringBindedParameter(rs, "OAUTH2_USERNAME", null);
                this.oAuth2.scope = this.getLocalStringBindedParameter(rs, "OAUTH2_SCOPE", null);
                final ISecretValue password = this.getLocalSecretBindedParameter(rs, "OAUTH2_PASSWORD", null);
                this.oAuth2.password = (String)this.secret((ISecretStatement)new ISecretStatement<String>(){

                    public String execute(ISecretContext context) throws Throwable {
                        return password.decryptString(context);
                    }
                });
                String additionnalParameters = this.getLocalStringBindedParameter(rs, "OAUTH2_ADDITIONAL_PARAMETERS", null);
                if (additionnalParameters != null) {
                    Properties p = new Properties();
                    StringReader sr = new StringReader(additionnalParameters);
                    try {
                        p.load(sr);
                        this.oAuth2.additionnalParameters = p;
                    }
                    catch (IOException e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
            }
        }
        if ((oauth1Token = this.getLocalStringBindedParameter(rs, "OAUTH_TOKEN", null)) != null) {
            this.oAuth = new OAuthMetadata();
            this.oAuth.token = oauth1Token;
            this.oAuth.consumerKey = this.getLocalStringBindedParameter(rs, "OAUTH_CONSUMER_KEY");
            this.oAuth.consumerSecret = this.getLocalPasswordParameter(rs, "OAUTH_CONSUMER_SECRET", "OAUTH_UNCRYPTED_CONSUMER_SECRET");
            this.oAuth.signatureMethod = this.getLocalStringBindedParameter(rs, "OAUTH_SIGNATURE_METHOD");
            this.oAuth.tokenSecret = this.getLocalPasswordParameter(rs, "OAUTH_TOKEN_SECRET", "OAUTH_UNCRYPTED_TOKEN_SECRET");
            this.oAuth.version = "1.0";
        }
        return 0;
    }

    public String digest(String nonce, String created, byte[] password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String passwdDigest = null;
        byte[] b1 = nonce != null ? Base64.getDecoder().decode(nonce) : new byte[]{};
        byte[] b2 = created != null ? created.getBytes("UTF-8") : new byte[]{};
        byte[] b3 = password;
        byte[] b4 = new byte[b1.length + b2.length + b3.length];
        int offset = 0;
        System.arraycopy(b1, 0, b4, offset, b1.length);
        System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
        System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
        byte[] digestBytes = null;
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        digestBytes = this.digest.digest(b4);
        passwdDigest = Base64.getEncoder().encodeToString(digestBytes);
        return passwdDigest;
    }

    public byte[] nonce(int length) throws NoSuchAlgorithmException {
        if (this.random == null) {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        byte[] temp = new byte[length];
        this.random.nextBytes(temp);
        return temp;
    }

    public void stopAction(Thread th) {
        super.stopAction(th);
        if (this.currentOperation != null) {
            this.currentOperation.killOpenedConnections();
        }
    }

    public static void main(String[] args) {
        String contentType;
        int n;
        int n2;
        String[] stringArray;
        String bindingType;
        String[] _bt = new String[]{"mime:content", "mime:mimeXml", ""};
        String[] _ct = new String[]{"text/xml", ""};
        String[] stringArray2 = _bt;
        int n3 = _bt.length;
        int n4 = 0;
        while (n4 < n3) {
            bindingType = stringArray2[n4];
            stringArray = _ct;
            n2 = _ct.length;
            n = 0;
            while (n < n2) {
                contentType = stringArray[n];
                System.out.print("bt: " + bindingType + " ct: " + contentType + " ");
                System.out.println(bindingType.equals("mime:content") || bindingType.equals("mime:mimeXml") && contentType.startsWith("text/xml"));
                ++n;
            }
            ++n4;
        }
        stringArray2 = _bt;
        n3 = _bt.length;
        n4 = 0;
        while (n4 < n3) {
            bindingType = stringArray2[n4];
            stringArray = _ct;
            n2 = _ct.length;
            n = 0;
            while (n < n2) {
                contentType = stringArray[n];
                System.out.print("bt: " + bindingType + " ct: " + contentType + " ");
                System.out.println(bindingType.equals("mime:content") && (contentType.startsWith("text/xml") || contentType.startsWith("application/json")) || bindingType.equals("mime:mimeXml"));
                ++n;
            }
            ++n4;
        }
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public class SimpleContentHandler
    extends IndyContentHandler {
        int skipedElement = 0;
        int nbInvocation = 0;
        int previousNbInvocation = 0;
        int nbInvocationError = 0;
        int previousNbInvocationError = 0;
        String currentPath = "";
        Part currentPart;
        Port currentPort;
        Wsdl currentWsdl;
        Operation currentOperation;
        String currentStyle;
        private boolean isRoot = true;

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.currentWsdl != null) {
                this.currentWsdl.namespaces.put((Object)prefix, (Object)uri);
            } else {
                XmlToWsdlActionCodeI.this.namespaces.put((Object)prefix, (Object)uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.currentWsdl != null) {
                this.currentWsdl.namespaces.remove((Object)prefix);
            } else {
                XmlToWsdlActionCodeI.this.namespaces.remove((Object)prefix);
            }
        }

        public void endDocument() throws SAXException {
            try {
                XmlToWsdlActionCodeI.this.is.close();
                XmlToWsdlActionCodeI.this.xwa.endCurrentDocument(new File(XmlToWsdlActionCodeI.this.inputFile));
                XmlToWsdlActionCodeI.this.publishStatistic("WSDL_NB_ERROR", this.nbInvocationError, true);
                XmlToWsdlActionCodeI.this.publishStatistic("WSDL_NB_DONE", this.nbInvocation, true);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            super.endDocument();
        }

        public void startDocument() throws SAXException {
            try {
                XmlToWsdlActionCodeI.this.xwa.startNewDocument(false);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            super.startDocument();
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            try {
                if (this.currentOperation != null && this.currentOperation.inputPartState == Operation.PartState.OPEN) {
                    if (this.currentOperation instanceof SoapOperation) {
                        this.currentOperation.addText(new String(ch, start, end));
                    } else if (this.currentOperation instanceof HttpOperation) {
                        if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.Param) {
                            ((HttpOperation)this.currentOperation).addParameterValue(new String(ch, start, end));
                        } else if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.Xml) {
                            this.currentOperation.addText(new String(ch, start, end));
                        } else if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.Raw) {
                            this.currentOperation.addText(new String(ch, start, end));
                        }
                    }
                }
                ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeCharacters(ch, start, end);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private void debug(String message) {
            XmlToWsdlActionCodeI.this.getActionCodeLogger().debug(String.valueOf(this.currentPath) + " " + message);
        }

        private void closeHttpParameter(String nameSpaceURI, String localName, String rawName) throws SOAPException {
            ((HttpOperation)this.currentOperation).closeParameter(localName);
        }

        public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
            this.debug("endElement");
            try {
                XmlToWsdlActionCodeI.this.interruptedException();
            }
            catch (InterruptedException e1) {
                throw new SAXException(e1);
            }
            try {
                if (this.currentOperation != null && this.currentOperation.inputPartState == Operation.PartState.OPEN && !this.currentPart.path.equals(this.currentPath)) {
                    this.closeInputPartElement(nameSpaceURI, localName, rawName);
                }
                if (this.currentPort != null && this.currentPort.path.equals(this.currentPath)) {
                    this.closePort(nameSpaceURI, localName, rawName);
                } else if (this.currentOperation != null && this.currentOperation.path.equals(this.currentPath)) {
                    this.closeOperation(nameSpaceURI, localName, rawName);
                } else if (this.currentPart != null && this.currentPart.path.equals(this.currentPath)) {
                    if (this.currentOperation.inputPartState == Operation.PartState.OPEN) {
                        this.closeInputPart(nameSpaceURI, localName, rawName);
                    } else if (this.currentOperation.state == Operation.OperationState.OUTPUT) {
                        this.closeOutputPart(nameSpaceURI, localName, rawName);
                    } else if (this.currentOperation.state == Operation.OperationState.FAULT) {
                        this.closeFaultPart(nameSpaceURI, localName, rawName);
                    }
                    this.currentPart = null;
                    this.debug("Current Part is Reset");
                } else if (this.currentOperation != null && this.currentOperation.inputPath.equals(this.currentPath)) {
                    this.closeInput(nameSpaceURI, localName, rawName);
                } else if (this.currentOperation != null && this.currentOperation.outputPath.equals(this.currentPath)) {
                    this.closeOutput(nameSpaceURI, localName, rawName);
                } else if (this.currentOperation != null && this.currentOperation.faultPath.equals(this.currentPath)) {
                    this.closeFault(nameSpaceURI, localName, rawName);
                }
                this.closeCurrent(nameSpaceURI, localName, rawName);
                if (this.currentPath.contains("/")) {
                    this.currentPath = this.currentPath.substring(0, this.currentPath.lastIndexOf("/"));
                }
            }
            catch (Exception e) {
                throw new SAXException(String.valueOf(Messages.getString("XmlToWsdlActionCodeI.5")) + this.currentPath, e);
            }
        }

        private void closeFault(String nameSpaceURI, String localName, String rawName) {
        }

        private void closeOutput(String nameSpaceURI, String localName, String rawName) throws Exception {
            this.invoke();
            this.currentOperation.intoOutput = false;
            this.currentOperation.clear();
        }

        private void closeInput(String nameSpaceURI, String localName, String rawName) {
            this.currentOperation.inputPartState = Operation.PartState.CLOSE;
        }

        private void closeInputPart(String nameSpaceURI, String localName, String rawName) throws SOAPException {
            this.currentOperation.inputPartState = Operation.PartState.CLOSE;
            if (this.currentOperation instanceof HttpOperation) {
                if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.Param) {
                    this.closeHttpParameter(nameSpaceURI, localName, rawName);
                    ((HttpOperation)this.currentOperation).setInputMode(null);
                }
            } else if (this.currentOperation instanceof SoapOperation && this.currentPart.hasType) {
                ((SoapOperation)this.currentOperation).endElement();
            }
        }

        private void closePort(String nameSpaceURI, String localName, String rawName) {
            this.currentPort = null;
        }

        private void closeInputPartElement(String nameSpaceURI, String localName, String rawName) throws Exception {
            this.currentOperation.endElement();
        }

        private void closeCurrent(String nameSpaceURI, String localName, String rawName) throws XMLStreamException {
            if (this.skipedElement == 0) {
                ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeEndElement();
            } else {
                --this.skipedElement;
            }
        }

        private void closeOperation(String nameSpaceURI, String localName, String rawName) {
            this.currentOperation = null;
            XmlToWsdlActionCodeI.this.currentOperation = null;
        }

        private void closeFaultPart(String nameSpaceURI, String localName, String rawName) throws Exception {
            this.currentOperation.faultPartState = Operation.PartState.CLOSE;
            this.invoke();
            this.currentOperation.writeFault(XmlToWsdlActionCodeI.this.xwa);
            this.currentOperation.state = Operation.OperationState.NONE;
        }

        private void invoke() throws Exception {
            if (!this.currentOperation.isAlreadyInvokated) {
                if (this.currentOperation instanceof SoapOperation) {
                    SoapOperation so = (SoapOperation)this.currentOperation;
                    if (XmlToWsdlActionCodeI.this.ntlmMetadata != null) {
                        so.setNtlmMetadata(XmlToWsdlActionCodeI.this.ntlmMetadata);
                    }
                    so.attachmentsFolder = XmlToWsdlActionCodeI.this.attachmentsFolder;
                    if (so.inputPartState == Operation.PartState.CLOSE) {
                        int ret = so.invoke();
                        if (ret == 1) {
                            XmlToWsdlActionCodeI.this.publishStatistic("WSDL_NB_DONE", ++this.nbInvocation, false);
                        } else if (ret == -1) {
                            XmlToWsdlActionCodeI.this.publishStatistic("WSDL_NB_ERROR", ++this.nbInvocationError, false);
                        }
                        this.previousNbInvocation = this.nbInvocation;
                        this.previousNbInvocationError = this.nbInvocationError;
                    }
                } else if (this.currentOperation instanceof HttpOperation) {
                    HttpOperation ho = (HttpOperation)this.currentOperation;
                    ho.setOauth(XmlToWsdlActionCodeI.this.oAuth);
                    if (XmlToWsdlActionCodeI.this.ntlmMetadata != null) {
                        ho.setNtlmMetadata(XmlToWsdlActionCodeI.this.ntlmMetadata);
                    }
                    if (ho.inputPartState == Operation.PartState.CLOSE) {
                        int ret = ho.invoke();
                        ho.isAlreadyInvokated = true;
                        if (ret == 1) {
                            XmlToWsdlActionCodeI.this.publishStatistic("WSDL_NB_DONE", ++this.nbInvocation, false);
                        } else if (ret == -1) {
                            XmlToWsdlActionCodeI.this.publishStatistic("WSDL_NB_ERROR", ++this.nbInvocationError, false);
                        }
                    }
                    ho.setOauth(null);
                }
            }
        }

        private void closeOutputPart(String nameSpaceURI, String localName, String rawName) throws Exception {
            this.currentOperation.outputPartState = Operation.PartState.CLOSE;
            this.invoke();
            this.currentOperation.writeMessage(XmlToWsdlActionCodeI.this.xwa, localName, this.currentPart.firstOutputElementName);
            this.currentOperation.state = Operation.OperationState.FIRST_OUTPUT_DONE;
        }

        private void openPort(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws Exception {
            this.currentPort = null;
            String protocol = attributs.getValue("md:protocol");
            this.currentStyle = attributs.getValue("md:style");
            if (protocol != null) {
                if (protocol.equals("HTTP")) {
                    HttpPort hp = new HttpPort();
                    this.currentPort = hp;
                    hp.mainAdress = attributs.getValue("md:address");
                    String verb = attributs.getValue("md:verb");
                    if (verb != null) {
                        hp.verb = HttpOperation.HttpVerb.valueOf(verb);
                        if (hp.verb == null) {
                            throw new Exception("unknown HTTP Verb: " + verb);
                        }
                    }
                } else if (protocol.equals("SOAP")) {
                    SoapPort sp = new SoapPort();
                    this.currentPort = sp;
                    sp.address = attributs.getValue("md:address");
                    sp.transportURI = attributs.getValue("md:transportURI");
                }
            }
            if (this.currentPort != null) {
                this.currentPort.path = this.currentPath;
                this.currentPort.wsdl = this.currentWsdl;
            }
        }

        public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
            try {
                String typeNode;
                XmlToWsdlActionCodeI.this.interruptedException();
                this.currentPath = String.valueOf(this.currentPath) + "/" + localName;
                this.debug("startElement");
                this.openCurrent(nameSpaceURI, localName, rawName, attributs);
                if (this.isRoot) {
                    this.isRoot = false;
                    ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeNamespace(XmlToWsdlActionCodeI.this.xsiPrefix, xsiUri);
                    ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeNamespace(mdPrefix, mdURI);
                }
                if (this.currentPart != null) {
                    if (this.currentOperation.inputPartState == Operation.PartState.OPEN) {
                        this.openInputPartElement(nameSpaceURI, localName, rawName, attributs);
                    } else if (this.currentOperation.outputPartState == Operation.PartState.OPEN) {
                        this.openOutputPartElement(nameSpaceURI, localName, rawName, attributs);
                    } else if (this.currentOperation.faultPartState == Operation.PartState.OPEN) {
                        this.openFaultPartElement(nameSpaceURI, localName, rawName, attributs);
                    }
                }
                String string = typeNode = (typeNode = attributs.getValue("md:defType")) == null ? attributs.getValue("defType") : typeNode;
                if (typeNode != null) {
                    if (typeNode.equals("com.stambia.xml.namespace")) {
                        this.parseNamespace(nameSpaceURI, localName, rawName, attributs);
                    } else if (typeNode.equals("com.stambia.wsdl.wsdl")) {
                        this.openWsdl(nameSpaceURI, localName, rawName, attributs);
                    } else if (typeNode.equals("com.stambia.wsdl.port")) {
                        this.openPort(nameSpaceURI, localName, rawName, attributs);
                    } else if (typeNode.equals("com.stambia.wsdl.operation")) {
                        this.openOperation(nameSpaceURI, localName, rawName, attributs);
                    } else if (typeNode.equals("com.stambia.wsdl.input")) {
                        this.openInput(nameSpaceURI, localName, rawName, attributs);
                    } else if (typeNode.equals("com.stambia.wsdl.output")) {
                        this.openOutput(nameSpaceURI, localName, rawName, attributs);
                    } else if (typeNode.equals("com.stambia.wsdl.fault")) {
                        if (this.currentOperation != null) {
                            this.currentOperation.state = Operation.OperationState.FAULT;
                        }
                    } else if (typeNode.equals("com.stambia.wsdl.part")) {
                        if (this.currentOperation != null) {
                            if (this.currentOperation.state == Operation.OperationState.FIRST_OUTPUT_DONE) {
                                this.currentOperation.state = Operation.OperationState.OUTPUT;
                            }
                            if (this.currentOperation.state == Operation.OperationState.INPUT) {
                                this.openInputPart(nameSpaceURI, localName, rawName, attributs, false);
                            } else if (this.currentOperation.state == Operation.OperationState.OUTPUT) {
                                this.openOutputPart(nameSpaceURI, localName, rawName, attributs);
                            } else if (this.currentOperation.state == Operation.OperationState.FAULT) {
                                this.openFaultPart(nameSpaceURI, localName, rawName, attributs);
                            }
                        }
                    } else if (typeNode.equals("com.stambia.wsdl.headerPart") && this.currentOperation != null && this.currentOperation.state == Operation.OperationState.INPUT) {
                        this.openInputPart(nameSpaceURI, localName, rawName, attributs, true);
                    }
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private void openFaultPartElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws Exception {
            String typeNode = attributs.getValue("md:defType");
            if (typeNode != null && typeNode.startsWith("com.stambia.json.root")) {
                String encoding = attributs.getValue("md:encoding");
                if (encoding == null || encoding.isEmpty()) {
                    encoding = "UTF-8";
                }
                ((HttpOperation)this.currentOperation).setFaultEncoding(encoding);
                ((HttpOperation)this.currentOperation).setFaultType(HttpOperation.PartType.json);
            }
        }

        private void openOutputPartElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws Exception {
            String typeNode;
            if (this.currentPart.firstOutputElementName == null) {
                this.currentPart.firstOutputElementName = localName;
            }
            if ((typeNode = attributs.getValue("md:defType")) != null && typeNode.startsWith("com.stambia.json.root")) {
                String encoding = attributs.getValue("md:encoding");
                if (encoding == null || encoding.isEmpty()) {
                    encoding = "UTF-8";
                }
                ((HttpOperation)this.currentOperation).setOutputEncoding(encoding);
                ((HttpOperation)this.currentOperation).setOutputPartType(HttpOperation.PartType.json);
            }
        }

        private void openInputPartElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws Exception {
            String name = localName;
            String typeNode = attributs.getValue("md:defType");
            if (typeNode != null && typeNode.equals("com.stambia.wsdl.simpleType")) {
                name = this.currentPart.getName();
            } else if (typeNode != null && typeNode.startsWith("com.stambia.json.root")) {
                ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.json);
                String encoding = attributs.getValue("md:encoding");
                if (encoding == null || encoding.isEmpty()) {
                    encoding = "UTF-8";
                }
                ((HttpOperation)this.currentOperation).setInputEncoding(encoding);
            }
            if (this.currentPart.use != null && this.currentPart.use.equals("encoded")) {
                String type = attributs.getValue("md:originalType");
                Element elt = this.currentOperation.openElement(name, null);
                elt.setAttribute(String.valueOf(((SoapOperation)this.currentOperation).XSI_PREFIX) + ":type", type);
            } else {
                this.currentOperation.openElement(name, nameSpaceURI);
            }
            int i = 0;
            while (i < attributs.getLength()) {
                String _name = attributs.getQName(i);
                String value = attributs.getValue(i);
                if (value != null && _name != null && !_name.startsWith("md:")) {
                    this.currentOperation.setAttribute(_name, value);
                }
                ++i;
            }
        }

        private void openCurrent(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws XMLStreamException {
            if (this.currentOperation == null || !this.currentOperation.stopOpenOrClose()) {
                XmlToWsdlActionCodeI.this.xwa.writeStartElement(localName);
                int i = 0;
                while (i < attributs.getLength()) {
                    String _localName = attributs.getLocalName(i);
                    String _nameSpaceURI = attributs.getURI(i);
                    String value = attributs.getValue(i);
                    if (_localName != null && (_localName.equals("nil") || _localName.equals("type")) && _nameSpaceURI != null && _nameSpaceURI.equals(xsiUri)) {
                        ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeAttribute(XmlToWsdlActionCodeI.this.xsiPrefix, _nameSpaceURI, _localName, value);
                    } else if (_nameSpaceURI != null && _nameSpaceURI.equals(mdURI)) {
                        ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeAttribute(mdPrefix, mdURI, _localName, value);
                    } else {
                        ((XmlToWsdlActionCodeI)XmlToWsdlActionCodeI.this).xwa.xmlw.writeAttribute(_localName, value);
                    }
                    ++i;
                }
            } else {
                ++this.skipedElement;
            }
        }

        private void openOutput(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            if (this.currentOperation != null) {
                this.currentOperation.state = Operation.OperationState.OUTPUT;
                this.currentOperation.outputPath = this.currentPath;
                this.currentOperation.intoOutput = true;
            }
        }

        private void openInput(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws Exception {
            if (this.currentOperation != null) {
                this.currentOperation.state = Operation.OperationState.INPUT;
                this.currentOperation.inputPath = this.currentPath;
                if (this.currentOperation instanceof SoapOperation) {
                    ((SoapOperation)this.currentOperation).startMessage();
                    ((SoapOperation)this.currentOperation).setCurrentElementToBody();
                    if (XmlToWsdlActionCodeI.this.WSSE) {
                        ((SoapOperation)this.currentOperation).setCurrentElementToHeader();
                        this.addWSSE();
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).setCurrentElementToBody();
                    }
                } else if (this.currentOperation instanceof HttpOperation && XmlToWsdlActionCodeI.this.oAuth2 != null) {
                    ((HttpOperation)this.currentOperation).openParameter("Authorization", 3);
                    ((HttpOperation)this.currentOperation).addParameterValue("Bearer " + OAuth2.getToken((OAuth2Metadata)XmlToWsdlActionCodeI.this.oAuth2));
                    ((HttpOperation)this.currentOperation).closeParameter(null);
                }
            }
        }

        private void parseNamespace(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            if (this.currentWsdl != null) {
                String uri = attributs.getValue("md:name");
                String prefix = attributs.getValue("md:prefix");
                this.currentWsdl.namespaces.put((Object)prefix, (Object)uri);
            }
        }

        private void openWsdl(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            String targetNamespace;
            Wsdl wsdl = new Wsdl();
            wsdl.targetNamespace = targetNamespace = attributs.getValue("md:targetNamespace");
            String elementForm = attributs.getValue("md:prefixForElement");
            String attributeForm = attributs.getValue("md:prefixForAttribute");
            if (elementForm != null && elementForm.equals("qualified")) {
                wsdl.prefixElement = true;
            }
            if (attributeForm != null && attributeForm.equals("qualified")) {
                wsdl.prefixAttribute = true;
            }
            if (XmlToWsdlActionCodeI.this.WSSE) {
                int i = 1;
                String tmp = defaultWssePrefix;
                String str = null;
                do {
                    if ((str = (String)XmlToWsdlActionCodeI.this.namespaces.getFrom((Object)tmp)) != null && !str.equals(wsseUri)) {
                        tmp = String.valueOf(tmp) + XmlToWsdlActionCodeI.this.wssePrefix + "_" + i++;
                        continue;
                    }
                    str = null;
                } while (str != null);
                XmlToWsdlActionCodeI.this.wssePrefix = tmp;
                XmlToWsdlActionCodeI.this.namespaces.put((Object)XmlToWsdlActionCodeI.this.wssePrefix, (Object)wsseUri);
                i = 1;
                tmp = defaultWsuPrefix;
                str = null;
                do {
                    if ((str = (String)XmlToWsdlActionCodeI.this.namespaces.getFrom((Object)tmp)) != null && !str.equals(wsuUri)) {
                        tmp = String.valueOf(tmp) + XmlToWsdlActionCodeI.this.wsuPrefix + "_" + i++;
                        continue;
                    }
                    str = null;
                } while (str != null);
                XmlToWsdlActionCodeI.this.wsuPrefix = tmp;
                XmlToWsdlActionCodeI.this.namespaces.put((Object)XmlToWsdlActionCodeI.this.wsuPrefix, (Object)wsuUri);
            }
            wsdl.globalNamespaces = XmlToWsdlActionCodeI.this.namespaces;
            wsdl.errorAcceptanceNumber = XmlToWsdlActionCodeI.this.errorAcceptanceNumber;
            wsdl.sentMessagesFolder = XmlToWsdlActionCodeI.this.sentMessagesFolder;
            wsdl.receivedMessagesFolder = XmlToWsdlActionCodeI.this.receivedMessagesFolder;
            wsdl.headerParameters = XmlToWsdlActionCodeI.this.headerParameters;
            this.currentWsdl = wsdl;
        }

        private void openInputPart(String nameSpaceURI, String localName, String rawName, Attributes attributs, boolean headerPart) throws Exception {
            this.initPart();
            this.currentOperation.inputPartState = Operation.PartState.OPEN;
            if (this.currentOperation instanceof SoapOperation) {
                String typeOrElement;
                if (headerPart) {
                    ((SoapOperation)this.currentOperation).setCurrentElementToHeader();
                }
                this.currentPart.use = attributs.getValue("md:use");
                if (((SoapOperation)this.currentOperation).style == SoapOperation.SoapStyle.RPC && !((SoapOperation)this.currentOperation).RPCOperationISOpen) {
                    Element elt = ((SoapOperation)this.currentOperation).openElement(this.currentOperation.getName(), null);
                    if (this.currentPart.use != null && this.currentPart.use.equals("encoded")) {
                        String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                        ((SoapOperation)this.currentOperation).setAttribute("SOAP-ENV:encoding-style", encodingStyle);
                    }
                    ((SoapOperation)this.currentOperation).RPCOperationISOpen = true;
                }
                boolean bl = this.currentPart.hasType = (typeOrElement = attributs.getValue("md:typeOrElement")) != null && typeOrElement.equals("type");
                if (this.currentPart.hasType) {
                    Element elt = ((SoapOperation)this.currentOperation).openElement(localName, null);
                    if (((SoapOperation)this.currentOperation).style == SoapOperation.SoapStyle.RPC && this.currentPart.use != null && this.currentPart.use.equals("encoded")) {
                        String type = attributs.getValue("md:originalType");
                        elt.setAttribute(String.valueOf(((SoapOperation)this.currentOperation).XSI_PREFIX) + ":type", type);
                    }
                }
            } else if (this.currentOperation instanceof HttpOperation) {
                String type;
                String contentType = attributs.getValue("md:contentType");
                String bindingType = attributs.getValue("md:bindingType");
                HttpOperation.HttpVerb verb = ((HttpPort)((HttpOperation)this.currentOperation).port).verb;
                if (bindingType == null && verb != null) {
                    bindingType = verb == HttpOperation.HttpVerb.GET || verb == HttpOperation.HttpVerb.DELETE ? "http:urlEncoded" : "mime:content";
                }
                if (contentType == null) {
                    if (verb != null && verb != HttpOperation.HttpVerb.GET && verb != HttpOperation.HttpVerb.DELETE) {
                        if (bindingType.equals("mime:content")) {
                            contentType = "application/x-www-form-urlencoded";
                        } else if (bindingType.equals("mime:mimeXml")) {
                            contentType = "text/xml; charset=UTF-8";
                        }
                    }
                } else if (bindingType != null && bindingType.startsWith("http:")) {
                    contentType = null;
                }
                if (contentType != null) {
                    ((HttpOperation)this.currentOperation).setInputContentType(contentType);
                } else {
                    contentType = "";
                }
                String contentTypeLC = contentType.toLowerCase();
                if (contentTypeLC.contains(";")) {
                    contentTypeLC = contentTypeLC.substring(0, contentTypeLC.indexOf(";"));
                }
                if (bindingType.equals("http:urlEncoded")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Param);
                    ((HttpOperation)this.currentOperation).openParameter(localName, 1);
                } else if (bindingType.equals("mime:content") && contentType.equals("application/x-www-form-urlencoded")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Param);
                    ((HttpOperation)this.currentOperation).openParameter(localName, 2);
                } else if (bindingType.equals("http:urlReplacement")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Param);
                    ((HttpOperation)this.currentOperation).openParameter(localName, 4);
                } else if (bindingType.equals("http:urlReplacementNotEncoded")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Param);
                    ((HttpOperation)this.currentOperation).openParameter(localName, 9);
                } else if (bindingType.equals("mime:content") && (contentTypeLC.endsWith("/json") || contentTypeLC.endsWith("/xml") || contentTypeLC.endsWith("+json") || contentTypeLC.endsWith("+xml")) || bindingType.equals("mime:mimeXml")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Xml);
                    this.currentOperation.inputPartState = Operation.PartState.OPEN;
                } else if (bindingType.equals("http:header")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Param);
                    ((HttpOperation)this.currentOperation).openParameter(localName, 3);
                } else if (bindingType.equals("http:method")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Param);
                    ((HttpOperation)this.currentOperation).openParameter(localName, 8);
                } else if (bindingType.equals("mime:content") && (type = attributs.getValue("md:type")) != null) {
                    if (type.equals("string")) {
                        ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Raw);
                        ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.string);
                    } else if (type.equals("base64Binary")) {
                        ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Raw);
                        ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.binary);
                    } else if (type.equals("anyURI")) {
                        ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.Raw);
                        ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.uri);
                    }
                }
            }
        }

        private void addWSSE() throws Exception {
            if (XmlToWsdlActionCodeI.this.WSSE) {
                ((SoapOperation)this.currentOperation).openElement("Security", wsseUri);
                if (XmlToWsdlActionCodeI.this.WSSERawContent != null && !XmlToWsdlActionCodeI.this.WSSERawContent.isEmpty()) {
                    Document doc = UtilsService.getXmlUtils().getDocumentFromRawContent(XmlToWsdlActionCodeI.this.WSSERawContent, XmlToWsdlActionCodeI.this.runtimeContext.defaultDocumentBuilderFactoryClass);
                    ((SoapOperation)this.currentOperation).appendChild(doc.getChildNodes().item(0));
                } else {
                    String nonce;
                    long now = System.currentTimeMillis();
                    Calendar _now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    _now.setTimeInMillis(now);
                    String __created = DatatypeConverter.printDateTime((Calendar)_now);
                    try {
                        nonce = Base64.getEncoder().encodeToString(XmlToWsdlActionCodeI.this.nonce(16));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SOAPException((Throwable)e);
                    }
                    int id = 1;
                    if (XmlToWsdlActionCodeI.this.WSSETimeToLive != null && XmlToWsdlActionCodeI.this.WSSETimeToLive > 0L) {
                        Calendar _expires = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        _expires.setTimeInMillis(now + XmlToWsdlActionCodeI.this.WSSETimeToLive);
                        String expires = DatatypeConverter.printDateTime((Calendar)_expires);
                        SOAPElement timpestamp = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Timestamp", wsuUri);
                        timpestamp.addAttribute(new QName(wsuUri, "Id", XmlToWsdlActionCodeI.this.wsuPrefix), "id-" + id++);
                        ((SOAPElement)((SoapOperation)this.currentOperation).openElement("Created", wsuUri)).addTextNode(__created);
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).openElement("Expires", wsuUri, XmlToWsdlActionCodeI.this.wsuPrefix).addTextNode(expires);
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).endElement();
                    }
                    if (XmlToWsdlActionCodeI.this.WSSEUsernname != null && !XmlToWsdlActionCodeI.this.WSSEUsernname.isEmpty()) {
                        SOAPElement usernameToken = (SOAPElement)((SoapOperation)this.currentOperation).openElement("UsernameToken", wsseUri);
                        usernameToken.addAttribute(new QName(wsuUri, "Id", XmlToWsdlActionCodeI.this.wsuPrefix), "id-" + id++);
                        SOAPElement username = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Username", wsseUri);
                        username.addTextNode(XmlToWsdlActionCodeI.this.WSSEUsernname);
                        ((SoapOperation)this.currentOperation).endElement();
                        String _password = XmlToWsdlActionCodeI.this.WSSEPassword;
                        if (_password != null) {
                            if (XmlToWsdlActionCodeI.this.WSSEPasswordType.equals("PasswordDigest")) {
                                try {
                                    _password = XmlToWsdlActionCodeI.this.digest(XmlToWsdlActionCodeI.this.WSSEAddsANonce ? nonce : null, XmlToWsdlActionCodeI.this.WSSEAddsACreated ? __created : null, _password.getBytes("UTF-8"));
                                }
                                catch (UnsupportedEncodingException e1) {
                                    throw new SOAPException((Throwable)e1);
                                }
                                catch (NoSuchAlgorithmException e) {
                                    throw new SOAPException((Throwable)e);
                                }
                            }
                            SOAPElement password = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Password", wsseUri);
                            password.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#" + XmlToWsdlActionCodeI.this.WSSEPasswordType);
                            password.addTextNode(_password);
                            ((SoapOperation)this.currentOperation).endElement();
                        }
                        if (XmlToWsdlActionCodeI.this.WSSEAddsANonce) {
                            SOAPElement _nonce = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Nonce", wsseUri);
                            _nonce.addAttribute(new QName("EncodingType"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                            _nonce.addTextNode(nonce);
                            ((SoapOperation)this.currentOperation).endElement();
                        }
                        if (XmlToWsdlActionCodeI.this.WSSEAddsACreated) {
                            SOAPElement created = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Created", wsuUri);
                            created.addTextNode(__created);
                            ((SoapOperation)this.currentOperation).endElement();
                        }
                    }
                }
                ((SoapOperation)this.currentOperation).endElement();
            }
        }

        private void openOutputPart(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            this.initPart();
            if (attributs != null) {
                String bindingType;
                String outputContentType = attributs.getValue("md:contentType");
                if (outputContentType != null) {
                    try {
                        ((HttpOperation)this.currentOperation).setOutputContentType(outputContentType);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((bindingType = attributs.getValue("md:bindingType")) != null && this.currentOperation instanceof HttpOperation) {
                    String type = attributs.getValue("md:type");
                    if (type != null) {
                        if (type.equals("base64Binary")) {
                            ((HttpOperation)this.currentOperation).setOutputPartType(HttpOperation.PartType.binary);
                        } else if (type.equals("string")) {
                            ((HttpOperation)this.currentOperation).setOutputPartType(HttpOperation.PartType.string);
                        } else if (type.equals("anyURI")) {
                            ((HttpOperation)this.currentOperation).setOutputPartType(HttpOperation.PartType.uri);
                        }
                    }
                    if (bindingType.equals("http:responseCode")) {
                        ((HttpOperation)this.currentOperation).openParameter(localName, 5);
                        ((HttpOperation)this.currentOperation).closeParameter(localName);
                    } else if (bindingType.equals("http:header")) {
                        ((HttpOperation)this.currentOperation).openParameter(localName, 6);
                        ((HttpOperation)this.currentOperation).closeParameter(localName);
                    } else if (bindingType.equals("http:responseMessage")) {
                        ((HttpOperation)this.currentOperation).openParameter(localName, 7);
                        ((HttpOperation)this.currentOperation).closeParameter(localName);
                    } else if (bindingType.equals("error:technicalErrorMessage")) {
                        ((HttpOperation)this.currentOperation).openParameter(localName, 10);
                        ((HttpOperation)this.currentOperation).closeParameter(localName);
                    } else if (bindingType.equals("error:technicalErrorException")) {
                        ((HttpOperation)this.currentOperation).openParameter(localName, 11);
                        ((HttpOperation)this.currentOperation).closeParameter(localName);
                    }
                } else if (bindingType != null && this.currentOperation instanceof SoapOperation) {
                    if (bindingType.equals("error:technicalErrorMessage")) {
                        ((SoapOperation)this.currentOperation).errorMessageName = localName;
                    } else if (bindingType.equals("error:technicalErrorException")) {
                        ((SoapOperation)this.currentOperation).errorExceptionName = localName;
                    }
                }
            }
            this.currentOperation.outputPartState = Operation.PartState.OPEN;
        }

        private void openFaultPart(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            String type;
            String bindingType;
            this.initPart();
            if (this.currentOperation != null) {
                this.currentOperation.faultPartState = Operation.PartState.OPEN;
                this.currentOperation.faultPath = this.currentPath;
            }
            if ((bindingType = attributs.getValue("md:bindingType")) != null && this.currentOperation instanceof HttpOperation && (type = attributs.getValue("md:type")) != null) {
                if (type.equals("base64Binary")) {
                    ((HttpOperation)this.currentOperation).setFaultType(HttpOperation.PartType.binary);
                } else if (type.equals("string")) {
                    ((HttpOperation)this.currentOperation).setFaultType(HttpOperation.PartType.string);
                } else if (type.equals("anyURI")) {
                    ((HttpOperation)this.currentOperation).setFaultType(HttpOperation.PartType.uri);
                }
            }
        }

        private void initPart() {
            this.currentPart = new Part();
            this.currentPart.path = this.currentPath;
            this.currentPart.operation = this.currentOperation;
            this.debug("Current Part is Set");
        }

        private void openOperation(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            if (this.currentPort != null) {
                if (this.currentPort instanceof SoapPort) {
                    String actionURI;
                    SoapOperation so = new SoapOperation();
                    so.setEnloseActionByQUote(XmlToWsdlActionCodeI.this.encloseActionWithQuote);
                    this.currentOperation = so;
                    so.operationElementName = localName;
                    if (this.currentStyle != null) {
                        if (this.currentStyle.equals("document")) {
                            so.style = SoapOperation.SoapStyle.DOCUMENT;
                        } else if (this.currentStyle.equals("rpc")) {
                            so.style = SoapOperation.SoapStyle.RPC;
                        }
                    }
                    if ((actionURI = attributs.getValue("md:actionURI")) != null) {
                        so.actionURI = actionURI;
                    }
                } else if (this.currentPort instanceof HttpPort) {
                    HttpOperation ho = new HttpOperation(XmlToWsdlActionCodeI.this.runtimeContext);
                    ho.setTemporaryFolder(XmlToWsdlActionCodeI.this.tempFolder);
                    ho.setXmlVersion(XmlToWsdlActionCodeI.this.xmlVersion);
                    this.currentOperation = ho;
                    XmlToWsdlActionCodeI.this.currentOperation = this.currentOperation;
                    ho.methodAddress = attributs.getValue("md:address");
                }
            }
            if (this.currentOperation != null) {
                this.currentOperation.ctx = XmlToWsdlActionCodeI.this;
                this.currentOperation.path = this.currentPath;
                this.currentOperation.port = this.currentPort;
                if (this.currentOperation instanceof HttpOperation) {
                    ((HttpOperation)this.currentOperation).urlEncoding = XmlToWsdlActionCodeI.this.urlEncoding;
                }
            }
        }
    }
}

