/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPConnection;
import com.indy.engine.actionCodes.amqp.AMQPMessageReceiver;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.rabbitmq.client.Delivery;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AMQPFileReceiver
extends AMQPMessageReceiver {
    String receiveDirectory;
    String fileMask = "[" + AMQPUtils.AMQPProperty.AMQP_MESSAGE_NUMBER.name() + "].data";
    private int fileSize;

    public void setReceiveDirectory(String receiveDirectory) {
        this.receiveDirectory = receiveDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public void receive(AMQPConnection connection, final AMQPMessageReceiver.DeliveryListener listener) throws IOException, InterruptedException, TimeoutException {
        super.receive(connection, new AMQPMessageReceiver.DeliveryListener(){

            @Override
            public void handle(Delivery delivery, int messageNumber) throws IOException {
                String fileName;
                File directory = new File(AMQPFileReceiver.this.receiveDirectory);
                try {
                    fileName = AMQPFileReceiver.getFileName(delivery, AMQPFileReceiver.this.fileMask, messageNumber);
                }
                catch (SQLException e1) {
                    throw new IOException(e1);
                }
                File file = new File(directory, fileName);
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(file);
                        byte[] b = delivery.getBody();
                        AMQPFileReceiver.this.fileSize = b.length;
                        AMQPUtils.byteToOutputStream(b, fos, false);
                    }
                    catch (FileNotFoundException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                            if (listener != null) {
                                listener.handle(delivery, messageNumber);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        File directory = new File(this.receiveDirectory);
        if (!directory.exists()) {
            throw new IOException(String.format(Messages.getString("AMQP.ERROR_019"), this.receiveDirectory));
        }
        if (directory.isFile()) {
            throw new IOException(String.format(Messages.getString("AMQP.ERROR_020"), this.receiveDirectory));
        }
    }

    private static String getFileName(Delivery delivery, String fileMask, int number) throws SQLException, UnsupportedEncodingException {
        Pattern pattern = Pattern.compile("(\\[[A-Za-z0-9\\_]+\\])");
        Matcher matcher = pattern.matcher(fileMask);
        int last = 0;
        String ret = "";
        while (matcher.find()) {
            String word = matcher.group(1);
            if (word == null) continue;
            if (matcher.start(1) > last) {
                ret = String.valueOf(ret) + fileMask.substring(last, matcher.start(1));
            }
            ret = String.valueOf(ret) + AMQPFileReceiver.replaceWord(delivery, word, number);
            last = matcher.end(1);
        }
        if (last < fileMask.length()) {
            ret = String.valueOf(ret) + fileMask.substring(last);
        }
        return ret;
    }

    private static String replaceWord(Delivery delivery, String word, int number) throws SQLException, UnsupportedEncodingException {
        String _word = word.substring(1, word.length() - 1);
        if (delivery != null) {
            return AMQPUtils.getStringProperty(delivery, _word, number);
        }
        return null;
    }
}

