/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPConnection;
import com.indy.engine.actionCodes.amqp.AMQPMessageSender;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;

public class AMQPFileSender
extends AMQPMessageSender {
    String sendDirectory;
    String fileMask;
    String queueName = null;
    String routingKey = null;
    String exchangeName = "";
    List<File> sendFiles = new ArrayList<File>();

    public void setSendDirectory(String sendDirectory) {
        this.sendDirectory = sendDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public synchronized void deleteSendFiles() {
        for (File file : this.sendFiles) {
            file.delete();
        }
        this.sendFiles.clear();
    }

    public synchronized void send(AMQPConnection connection) throws IOException, InterruptedException, TimeoutException {
        AMQPUtils._assert(this.sendDirectory != null, Messages.getString("AMQP.ERROR_021"));
        AMQPUtils._assert(this.fileMask != null, Messages.getString("AMQP.ERROR_022"));
        File directory = new File(this.sendDirectory);
        if (!directory.exists()) {
            throw new IOException(String.format(Messages.getString("AMQP.ERROR_019"), this.sendDirectory));
        }
        if (directory.isFile()) {
            throw new IOException(String.format(Messages.getString("AMQP.ERROR_020"), this.sendDirectory));
        }
        File[] fileArray = directory.listFiles(new MyFileFilter(this.fileMask));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File _file = fileArray[n2];
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (_file.isFile()) {
                try (FileInputStream in = null;){
                    in = new FileInputStream(_file);
                    this.send(connection, AMQPUtils.fileToByteArray(_file));
                    this.sendFiles.add(_file);
                }
            }
            ++n2;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public synchronized void copySentFiles(String dir, boolean move) throws IOException {
        File _dir = new File(dir);
        if (!_dir.exists()) {
            _dir.mkdirs();
        }
        for (File file : this.sendFiles) {
            File dest = new File(_dir, file.getName());
            if (move) {
                dest.delete();
                file.renameTo(dest);
                continue;
            }
            FileInputStream is = null;
            OutputStream os = null;
            try {
                is = new FileInputStream(file);
                os = new FileOutputStream(dest);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.sendFiles.clear();
    }

    class MyFileFilter
    implements FilenameFilter {
        final String localMask;

        public MyFileFilter(String pFileMask) {
            this.localMask = StringOperations.replaceWildChars((String)pFileMask);
        }

        @Override
        public boolean accept(File pDir, String pFileName) {
            return pFileName.matches(this.localMask);
        }
    }
}

