/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file.jdbc;

import com.indy.engine.actionCodes.file.jdbc.Messages;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.indy.runtime.file.DelimitedFileReader;
import com.indy.runtime.file.DelimitedFileWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

public class DelimitedRecordToResultSet {
    JdbcPreparedStatementToResultSet statement;
    private String rowSeparator;
    private String fieldSeparator;
    private String stringDelimiter;
    private String rowSeparatorReplacment;
    private String stringDelimiterReplacment;
    private SimpleDateFormat timeStampFormat;
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat dateFormat;
    int i = 1;
    int signPosition = 0;

    public void setRowSeparator(String rowSeparator, String rowSeparatorReplacment) {
        this.rowSeparator = rowSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setStringDelimiter(String stringDelimiter, String stringDelimiterReplacment) {
        this.stringDelimiter = stringDelimiter;
        this.stringDelimiterReplacment = stringDelimiterReplacment;
    }

    public void setTimeStampPattern(String timeStampPattern) {
        this.timeStampFormat = new SimpleDateFormat(timeStampPattern);
    }

    public void setDatePattern(String datePattern) {
        this.dateFormat = new SimpleDateFormat(datePattern);
    }

    public void setTimepattern(String timepattern) {
        this.timeFormat = new SimpleDateFormat(timepattern);
    }

    public NotFetchedResultSetBindI getNotFetchedResultSetBindI() {
        return this.statement.getNotFetchedResultSetBindI();
    }

    public DelimitedRecordToResultSet(String ... ids) throws SQLException {
        this.statement = new JdbcPreparedStatementToResultSet();
        this.statement.setConsumers(false, ids);
    }

    public DelimitedRecordToResultSet(RuntimeContext rc) {
        this.setTimeStampPattern(rc.GLOBAL_DATE_FORMAT);
        this.setDatePattern("yyyy/MM/dd");
        this.setTimepattern("HH:mm:ss.SSS");
    }

    public void setStatement(JdbcPreparedStatementToResultSet statement) {
        this.statement = statement;
    }

    public void addColumn(String columnName, String sqlType, int precision, int scale) throws SQLException {
        this.statement.setColumn(this.i++, columnName, sqlType, precision);
    }

    public ResultSet getResultSet(String name) throws SQLException {
        return this.statement.getResultSet(name);
    }

    public void write(InputStream is, String encoding) throws SQLException, IOException, ParseException {
        DelimitedFileReader dfr = new DelimitedFileReader(is, encoding);
        dfr.setFieldSeparator(this.fieldSeparator);
        dfr.setRowSeparator(this.rowSeparator, this.rowSeparatorReplacment);
        dfr.setStringDelimiter(this.stringDelimiter, this.stringDelimiterReplacment);
        int columnCount = this.statement.getMetaData().getColumnCount();
        int rowCount = 0;
        while (!dfr.isEndOfFile()) {
            List list = dfr.readLine();
            if (columnCount == 0 && rowCount == 0) {
                int j = 1;
                for (String str : list) {
                    this.addColumn("F" + j++, "VARCHAR", 255, 0);
                }
                columnCount = this.statement.getMetaData().getColumnCount();
            }
            int i = 1;
            if (list.size() > 0) {
                for (String str : list) {
                    if (i <= columnCount) {
                        int type = this.statement.getMetaData().getColumnType(i);
                        switch (type) {
                            case -7: 
                            case -6: 
                            case 4: 
                            case 5: {
                                if (this.signPosition == 1) {
                                    if (str.endsWith("-")) {
                                        str = "-" + str.substring(0, str.length() - 1);
                                    } else if (str.endsWith("+")) {
                                        str = "+" + str.substring(0, str.length() - 1);
                                    }
                                }
                                this.statement.setInt(i, Integer.valueOf(str).intValue());
                                break;
                            }
                            case -5: {
                                if (this.signPosition == 1) {
                                    if (str.endsWith("-")) {
                                        str = "-" + str.substring(0, str.length() - 1);
                                    } else if (str.endsWith("+")) {
                                        str = "+" + str.substring(0, str.length() - 1);
                                    }
                                }
                                this.statement.setLong(i, Long.valueOf(str).longValue());
                                break;
                            }
                            case -16: 
                            case -15: 
                            case -9: 
                            case 1: 
                            case 12: 
                            case 1111: 
                            case 2005: 
                            case 2011: {
                                this.statement.setString(i, str);
                                break;
                            }
                            case 2: 
                            case 3: {
                                if (this.signPosition == 1) {
                                    if (str.endsWith("-")) {
                                        str = "-" + str.substring(0, str.length() - 1);
                                    } else if (str.endsWith("+")) {
                                        str = "+" + str.substring(0, str.length() - 1);
                                    }
                                }
                                this.statement.setBigDecimal(i, BigDecimal.valueOf(Double.valueOf(str)));
                                break;
                            }
                            case 8: {
                                if (this.signPosition == 1) {
                                    if (str.endsWith("-")) {
                                        str = "-" + str.substring(0, str.length() - 1);
                                    } else if (str.endsWith("+")) {
                                        str = "+" + str.substring(0, str.length() - 1);
                                    }
                                }
                                this.statement.setDouble(i, Double.valueOf(str).doubleValue());
                                break;
                            }
                            case 16: {
                                this.statement.setBoolean(i, Boolean.valueOf(str).booleanValue());
                                break;
                            }
                            case 91: {
                                this.statement.setDate(i, new Date(this.dateFormat.parse(str).getTime()));
                                break;
                            }
                            case 92: {
                                this.statement.setTime(i, new Time(this.timeFormat.parse(str).getTime()));
                                break;
                            }
                            case 93: {
                                this.statement.setTimestamp(i, new Timestamp(this.timeStampFormat.parse(str).getTime()));
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                this.statement.setBytes(i, str.getBytes());
                                break;
                            }
                            case -8: 
                            case 0: 
                            case 6: 
                            case 7: 
                            case 70: 
                            case 2000: 
                            case 2001: 
                            case 2002: 
                            case 2003: 
                            case 2004: 
                            case 2006: 
                            case 2009: {
                                throw new SQLFeatureNotSupportedException(String.valueOf(Messages.getString("DelimitedRecordToResultSet.0")) + type + Messages.getString("DelimitedRecordToResultSet.1"));
                            }
                        }
                    }
                    ++i;
                }
                this.statement.addBatch();
                this.statement.executeBatch();
            }
            ++rowCount;
        }
        this.statement.close();
    }

    public static void main(String[] args) throws IOException, SQLException {
        DelimitedFileWriter dfw = new DelimitedFileWriter((OutputStream)new FileOutputStream("d:/temp/test.txt"));
        int i = 0;
        while (i < 10) {
            dfw.writeString("test");
            dfw.writeString("10");
            dfw.writeString("test");
            dfw.writeString("test");
            dfw.endRecord();
            ++i;
        }
        dfw.close();
        final DelimitedRecordToResultSet ftac = new DelimitedRecordToResultSet("");
        ftac.addColumn("col1", "VARCHAR", 255, 0);
        ftac.addColumn("col2", "BIGINT", 10, 0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ftac.write(new FileInputStream("d:/temp/test.txt"), "UTF-8");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        ResultSet rs = ftac.getResultSet("");
        while (rs.next()) {
        }
    }

    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public void setSignPosition(String localStringBindedParameter) {
        this.signPosition = localStringBindedParameter != null && localStringBindedParameter.equals("end") ? 1 : 0;
    }
}

