/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file.jdbc;

import com.indy.engine.actionCodes.SqlFileExportActionCodeI;
import com.indy.engine.actionCodes.file.jdbc.FileWriter;
import com.indy.engine.actionCodes.file.jdbc.Messages;
import com.indy.engine.core.RuntimeContext;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;

public class VariableWriter
extends FileWriter {
    private AddDelimiterMode addDelimiterMode;
    String decimalSeparator = null;
    private boolean enableStringDelimiter;
    private boolean enableNumericDelimiter;
    private String stringDelimiter;
    private String stringDelimiterReplacment;
    private String fieldSep;
    private String rowSep;
    private String nullValueReplacement = "";
    private boolean addDelimiterToAll;
    private boolean addDelimiterToDate;
    private boolean addDelimiterToTimestamp;
    private boolean addDelimiterToTime;

    public VariableWriter(RuntimeContext rc, boolean booleanAsNumeric, String strTimestampFormat, String strDateFormat, String strTimeFormat, DecimalFormat decimalFormat, String stringDelimiter, boolean addRecordNumber, String fieldSep, String nullValueRemplacement, String stringDelimiterReplacment, String rowSep, boolean addDelimiterToAll) {
        super(rc, booleanAsNumeric, strTimestampFormat, strDateFormat, strTimeFormat, decimalFormat, addRecordNumber);
        this.stringDelimiter = stringDelimiter;
        this.fieldSep = fieldSep;
        this.rowSep = rowSep;
        this.nullValueReplacement = nullValueRemplacement != null ? nullValueRemplacement : "";
        if (stringDelimiter != null && !stringDelimiter.isEmpty()) {
            this.enableStringDelimiter = true;
            this.stringDelimiterReplacment = stringDelimiterReplacment != null ? stringDelimiterReplacment : String.valueOf(stringDelimiter) + stringDelimiter;
        }
        if (decimalFormat != null) {
            try {
                this.decimalSeparator = "" + decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
                if (fieldSep.length() == 1 && fieldSep.equals(this.decimalSeparator)) {
                    this.enableNumericDelimiter = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addDelimiterToTimestamp = this.enableStringDelimiter && this.strTimestampFormat != null && (this.strTimestampFormat.contains(fieldSep) || this.strTimestampFormat.contains(rowSep) || this.strTimestampFormat.contains(stringDelimiter));
        this.addDelimiterToTime = this.enableStringDelimiter && this.strTimeFormat != null && (this.strTimeFormat.contains(fieldSep) || this.strTimeFormat.contains(rowSep) || this.strTimeFormat.contains(stringDelimiter));
        this.addDelimiterToDate = this.enableStringDelimiter && this.strDateFormat != null && (this.strDateFormat.contains(fieldSep) || this.strDateFormat.contains(rowSep) || this.strDateFormat.contains(stringDelimiter));
        this.addDelimiterToAll = addDelimiterToAll;
    }

    @Override
    public void writeLine(Writer writer, ResultSet sourceRSet, SqlFileExportActionCodeI.FieldInfo[] fieldInfos) throws IOException, EngineExceptionI {
        ++this.numRecord;
        this.currentLineSize = 0L;
        SqlFileExportActionCodeI.FieldInfo[] fieldInfoArray = fieldInfos;
        int n = fieldInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            SqlFileExportActionCodeI.FieldInfo _currentFieldInfo;
            this.currentFieldInfo = _currentFieldInfo = fieldInfoArray[n2];
            if (this.addRecordNumber) {
                str = String.valueOf(this.numRecord);
                writer.write(str);
                this.currentLineSize += (long)str.length();
                writer.write(this.fieldSep);
                this.currentLineSize += (long)this.fieldSep.length();
            }
            str = this.formatVariableValue(this.getVariableValue(sourceRSet), this.currentFieldInfo.colType);
            this.currentLineSize += (long)str.length();
            writer.write(str);
            if (this.currentFieldInfo.index != fieldInfos.length) {
                writer.write(this.fieldSep);
                this.currentLineSize += (long)this.fieldSep.length();
            }
            ++n2;
        }
    }

    public static String getValWithDelimiter(String val, boolean wasNull, AddDelimiterMode mode, String delimiter, String ... exclude) {
        String ret = "";
        if (mode == AddDelimiterMode.AUTO && (exclude == null || exclude.length == 0)) {
            mode = AddDelimiterMode.ALWAYS;
        }
        if (mode == AddDelimiterMode.ALWAYS) {
            ret = delimiter;
        }
        if (val != null && !wasNull) {
            if (!val.isEmpty()) {
                boolean add;
                boolean bl = add = mode == AddDelimiterMode.NONEMPTY || mode == AddDelimiterMode.NONNULL;
                if (mode == AddDelimiterMode.AUTO) {
                    add = false;
                    String[] stringArray = exclude;
                    int n = exclude.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String _exclude = stringArray[n2];
                        if (val.contains(_exclude)) {
                            add = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (add) {
                    ret = String.valueOf(ret) + delimiter;
                }
                ret = String.valueOf(ret) + val;
                if (add) {
                    ret = String.valueOf(ret) + delimiter;
                }
            } else {
                if (mode == AddDelimiterMode.NONNULL) {
                    ret = String.valueOf(ret) + delimiter;
                }
                ret = String.valueOf(ret) + val;
                if (mode == AddDelimiterMode.NONNULL) {
                    ret = String.valueOf(ret) + delimiter;
                }
            }
        }
        return ret;
    }

    private boolean hasDecimalSeparator(StringBuilder value) {
        return this.enableNumericDelimiter && value.indexOf(this.decimalSeparator) > -1;
    }

    String getVariableValue(ResultSet sourceRSet) throws EngineExceptionI {
        String tmpStr = this.nullValueReplacement;
        int colType = 0;
        try {
            colType = this.currentFieldInfo.colType;
            int colNum = this.currentFieldInfo.index;
            switch (colType) {
                case -5: {
                    Long val = sourceRSet.getLong(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = Long.toString(val);
                    }
                    break;
                }
                case -7: 
                case 16: {
                    Boolean val = sourceRSet.getBoolean(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        if (this.booleanAsNumeric) {
                            tmpStr = val != false ? "1" : "0";
                            break;
                        }
                        tmpStr = Boolean.toString(val);
                    }
                    break;
                }
                case 2005: {
                    Clob val = sourceRSet.getClob(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = val.getSubString(1L, (int)val.length());
                        break;
                    }
                    tmpStr = this.nullValueReplacement;
                    break;
                }
                case 2011: {
                    NClob val = sourceRSet.getNClob(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = val.getSubString(1L, (int)val.length());
                        break;
                    }
                    tmpStr = this.nullValueReplacement;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String val = sourceRSet.getString(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = val;
                        break;
                    }
                    tmpStr = this.nullValueReplacement;
                    break;
                }
                case -16: 
                case -15: 
                case -9: {
                    String val = sourceRSet.getNString(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = val;
                        break;
                    }
                    tmpStr = this.nullValueReplacement;
                    break;
                }
                case 91: {
                    java.util.Date dt = null;
                    dt = this.getDateAsTimeStamp ? sourceRSet.getTimestamp(colNum) : sourceRSet.getDate(colNum);
                    if (dt != null && !sourceRSet.wasNull()) {
                        if (this.getDateAsTimeStamp) {
                            tmpStr = this.timestampFormat.format(dt);
                            break;
                        }
                        tmpStr = this.dateFormat.format(dt);
                    }
                    break;
                }
                case 3: {
                    BigDecimal val = sourceRSet.getBigDecimal(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = this.decimalFormat.format(val);
                    }
                    break;
                }
                case 8: {
                    Double val = sourceRSet.getDouble(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = this.decimalFormat.format(val);
                    }
                    break;
                }
                case 6: {
                    Float val = Float.valueOf(sourceRSet.getFloat(colNum));
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = this.decimalFormat.format(val);
                    }
                    break;
                }
                case 4: {
                    int integer = sourceRSet.getInt(colNum);
                    if (!sourceRSet.wasNull()) {
                        tmpStr = Integer.toString(integer);
                    }
                    break;
                }
                case 2: {
                    BigDecimal val = sourceRSet.getBigDecimal(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = this.decimalFormat.format(val);
                    }
                    break;
                }
                case 7: {
                    Float val = Float.valueOf(sourceRSet.getFloat(colNum));
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = this.decimalFormat.format(val);
                    }
                    break;
                }
                case 5: {
                    Short val = sourceRSet.getShort(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = Short.toString(val);
                    }
                    break;
                }
                case 92: {
                    Time val = sourceRSet.getTime(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        if (this.timeFormat != null) {
                            tmpStr = this.timeFormat.format((Object)val);
                            break;
                        }
                        tmpStr = val.toString();
                    }
                    break;
                }
                case -102: 
                case -101: 
                case 93: {
                    Timestamp val = sourceRSet.getTimestamp(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = this.timestampFormat.format(new Date(val.getTime()));
                    }
                    break;
                }
                case -6: {
                    Short val = sourceRSet.getShort(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = Short.toString(val);
                    }
                    break;
                }
                default: {
                    Object val = sourceRSet.getObject(colNum);
                    if (val != null && !sourceRSet.wasNull()) {
                        tmpStr = val.toString();
                    }
                    break;
                }
            }
        }
        catch (NullPointerException e) {
            tmpStr = this.nullValueReplacement;
        }
        catch (SQLException e) {
            String colName = this.currentFieldInfo.name;
            throw new EngineExceptionI(String.valueOf(Messages.getString("VariableWriter.0")) + colName, (Throwable)e);
        }
        catch (Exception e) {
            String colName = this.currentFieldInfo.name;
            throw new EngineExceptionI(String.valueOf(Messages.getString("VariableWriter.1")) + colName, (Throwable)e);
        }
        return tmpStr;
    }

    void addStringDelimiter(StringBuilder builder) {
        if (this.enableStringDelimiter) {
            if (this.stringDelimiterReplacment != null && !this.stringDelimiterReplacment.isEmpty()) {
                VariableWriter.replaceString(builder, this.stringDelimiter, this.stringDelimiterReplacment);
            }
            builder.append(this.stringDelimiter);
            builder.insert(0, this.stringDelimiter);
        }
    }

    public static void replaceString(StringBuilder sb, String toReplace, String replacement) {
        int index = -1;
        int previousIndex = 0;
        while ((index = sb.indexOf(toReplace, previousIndex)) != -1) {
            sb.replace(index, index + toReplace.length(), replacement);
            previousIndex = index + replacement.length();
        }
    }

    private boolean isEmptyNullOrReplacement(String val) {
        return val == null || val.isEmpty() || val.contentEquals(this.nullValueReplacement);
    }

    String formatVariableValue(String val, int colType) {
        boolean delimitedField;
        StringBuilder builder = new StringBuilder(val);
        if (!this.addDelimiterToAll) {
            switch (colType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    delimitedField = !this.isEmptyNullOrReplacement(val);
                    break;
                }
                case 91: {
                    delimitedField = this.addDelimiterToDate && !this.isEmptyNullOrReplacement(val);
                    break;
                }
                case -102: 
                case -101: 
                case 93: {
                    delimitedField = this.addDelimiterToTimestamp && !this.isEmptyNullOrReplacement(val);
                    break;
                }
                case 92: {
                    delimitedField = this.addDelimiterToTime && !this.isEmptyNullOrReplacement(val);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    delimitedField = this.hasDecimalSeparator(builder);
                    break;
                }
                default: {
                    delimitedField = false;
                    break;
                }
            }
        } else {
            delimitedField = true;
        }
        if (delimitedField) {
            this.addStringDelimiter(builder);
        }
        return builder.toString();
    }

    public void setAddDelimiterToAll(boolean addDelimiterToAll) {
        this.addDelimiterToAll = addDelimiterToAll;
    }

    static enum AddDelimiterMode {
        NONEMPTY,
        NONNULL,
        ALWAYS,
        AUTO;

    }
}

