/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.ftp;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.FtpPutActionCodeI;
import com.indy.engine.actionCodes.ftp.Messages;
import com.indy.engine.actionCodes.proxy.JCraftProxyFactory;
import com.indy.engine.actionCodes.proxy.MyFtpClient;
import com.indy.engine.actionCodes.proxy.MyFtpsClient;
import com.indy.engine.actionCodes.proxy.ProxySocketFactory;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.indy.runtime.utils.SSLUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.ftp.SSLSessionReuseFTPSClient;
import java.io.IOException;
import java.net.Proxy;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;

public class FtpActionCodeI
extends ActionCodeTypeI {
    protected FTPClient ftp;
    protected String FTPSProtocol = "NONE";
    protected static final int defaultProxyPort = 1080;
    protected ISecretValue proxyPort = null;
    protected ISecretValue proxyHost = null;
    protected ISecretValue proxyUser = null;
    protected ISecretValue proxyPassword = null;
    private Integer proxyProtocol;
    private String proxySocketFactory;
    protected Boolean implicitFTPS = true;
    TrustManager trustManager;
    KeyManager keyManager = null;
    protected static final int defaultFtpPort = 21;
    protected static final int defaultSecureFtpPort = 990;
    protected ISecretValue ftpHostname;
    protected ISecretValue ftpUser;
    protected ISecretValue ftpPassword;
    protected ISecretValue ftpPort;
    protected Boolean ftpPassiveMode;
    protected String ftpMode;
    protected String ftpTimezone;
    @Deprecated
    protected Integer socketTimeout;
    protected Integer connectionTimeout;
    protected Integer datatimeout;
    protected boolean encryptChannelData = false;
    private Boolean disableLogin;
    private Long protectionBufferSize;
    private String ftpSystemType;

    protected void setProxySocketFactory() throws NoSuchAlgorithmException, EngineExceptionI {
        if (!this.FTPSProtocol.equals("NONE")) {
            this.ftp = new MyFtpsClient(this.FTPSProtocol, this.implicitFTPS);
            if (this.trustManager != null) {
                ((MyFtpsClient)this.ftp).setTrustManager(this.trustManager);
            }
            if (this.keyManager != null) {
                ((MyFtpsClient)this.ftp).setKeyManager(this.keyManager);
            }
        } else {
            this.ftp = new MyFtpClient();
        }
        this.secret(new ISecretStatement(){

            public Object execute(ISecretContext context) throws Throwable {
                SocketFactory psf = null;
                if (FtpActionCodeI.this.proxyHost != null && !FtpActionCodeI.this.proxyHost.isNull() && FtpActionCodeI.this.proxyProtocol != null && FtpActionCodeI.this.proxyProtocol != -1) {
                    String tmp = FtpActionCodeI.this.proxyPassword.decryptString(context);
                    if (FtpActionCodeI.this.proxySocketFactory.equals("jcraft")) {
                        FtpActionCodeI.this.ftp.setRemoteVerificationEnabled(false);
                        psf = new JCraftProxyFactory(FtpActionCodeI.this.proxyProtocol, FtpActionCodeI.this.proxyHost.getString(context), FtpActionCodeI.this.proxyPort.getInteger(context), FtpActionCodeI.this.proxyUser.getString(context), tmp);
                        psf.setLogger(FtpActionCodeI.this.logger);
                    } else {
                        Proxy.Type type = null;
                        if (FtpActionCodeI.this.proxyProtocol.equals(1) || FtpActionCodeI.this.proxyProtocol.equals(0)) {
                            type = Proxy.Type.SOCKS;
                        } else if (FtpActionCodeI.this.proxyProtocol.equals(2)) {
                            type = Proxy.Type.HTTP;
                        }
                        if (type == null) {
                            throw new EngineExceptionI(Messages.getString("FtpActionCodeI.0"));
                        }
                        psf = FtpActionCodeI.this.proxyUser != null && FtpActionCodeI.this.proxyUser.isNotEmpty() ? new ProxySocketFactory(FtpActionCodeI.this.proxyHost.getString(context), FtpActionCodeI.this.proxyPort.getInteger(context), FtpActionCodeI.this.proxyUser.getString(context), tmp, type) : new ProxySocketFactory(FtpActionCodeI.this.proxyHost.getString(context), FtpActionCodeI.this.proxyPort.getInteger(context), type);
                    }
                }
                if (psf != null) {
                    FtpActionCodeI.this.ftp.setSocketFactory(psf);
                }
                return null;
            }
        });
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        ISecretValue keyStorePassword;
        String keyStoreType;
        this.proxyHost = this.getLocalSecretBindedParameter(rSet, "PROXY_HOST", null);
        this.proxyPort = this.getLocalSecretBindedParameter(rSet, "PROXY_PORT", String.valueOf(1080));
        this.proxyUser = this.getLocalSecretBindedParameter(rSet, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rSet, "PROXY_PASSWORD", this.getLocalStringBindedParameter(rSet, "PROXY_UNCRYPTED_PASSWORD", null));
        this.proxyProtocol = FtpPutActionCodeI.map.get(this.getLocalStringBindedParameter(rSet, "PROXY_PROTOCOL", "SOCKS5"));
        this.debugLog("prepare", String.valueOf(this.actionName) + Messages.getString("FtpActionCodeI.1"), 3, "DEBUG");
        this.proxySocketFactory = this.getLocalStringBindedParameter(rSet, "PROXY_SOCKET_FACTORY", "jcraft");
        this.connectionTimeout = this.getLocalIntegerBindedParameter(rSet, "CONNECTION_TIMEOUT", null);
        this.socketTimeout = this.getLocalIntegerBindedParameter(rSet, "SOCKET_TIMEOUT", this.getLocalIntegerBindedParameter(rSet, "TIMEOUT", null));
        this.datatimeout = this.getLocalIntegerBindedParameter(rSet, "DATA_TIMEOUT", null);
        this.encryptChannelData = this.getLocalBooleanBindedParameter(rSet, "FTP_ENCRYPT_CHANNEL_DATA", false);
        if (!this.encryptChannelData) {
            this.encryptChannelData = this.getLocalBooleanBindedParameter(rSet, "ENCRYPT_CHANNEL_DATA", false);
        }
        if (this.getLocalBooleanBindedParameter(rSet, "IGNORE_TRUST_STORE", false).booleanValue()) {
            this.trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
        } else {
            final String trustStore = this.getLocalStringBindedParameter(rSet, "TRUST_STORE", null);
            if (trustStore != null) {
                keyStoreType = this.getLocalStringBindedParameter(rSet, "TRUST_STORE_TYPE", "JKS");
                keyStorePassword = this.getLocalSecretBindedParameter(rSet, "TRUST_STORE_PASSWORD", "");
                try {
                    this.trustManager = (TrustManager)this.secret((ISecretStatement)new ISecretStatement<TrustManager>(){

                        public TrustManager execute(ISecretContext context) throws Throwable {
                            TrustManager[] trustManagers = SSLUtils.loadTrustStore((String)trustStore, (String)keyStoreType, (String)keyStorePassword.decryptString(context));
                            if (trustManagers != null && trustManagers.length > 0) {
                                return trustManagers[0];
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        final String keyStore = this.getLocalStringBindedParameter(rSet, "KEY_STORE", null);
        if (keyStore != null) {
            keyStoreType = this.getLocalStringBindedParameter(rSet, "KEY_STORE_TYPE", "JKS");
            keyStorePassword = this.getLocalSecretBindedParameter(rSet, "KEY_STORE_PASSWORD", "");
            try {
                this.keyManager = (KeyManager)this.secret((ISecretStatement)new ISecretStatement<KeyManager>(){

                    public KeyManager execute(ISecretContext context) throws Throwable {
                        KeyManager[] keyManagers = SSLUtils.loadKeyStore((String)keyStore, (String)keyStoreType, (String)keyStorePassword.decryptString(context));
                        if (keyManagers != null && keyManagers.length > 0) {
                            return keyManagers[0];
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.disableLogin = this.getLocalBooleanBindedParameter(rSet, "FTP_DISABLE_LOGIN", false);
        this.protectionBufferSize = this.getLocalLongBindedParameter(rSet, "FTP_PROTECTION_BUFFER_SIZE", null);
        this.ftpSystemType = this.getLocalStringBindedParameter(rSet, "FTP_SYSTEM_TYPE", null);
        return 0;
    }

    public boolean connect() throws SocketException, IOException, EngineExceptionI {
        if (this.connectionTimeout != null) {
            this.ftp.setConnectTimeout(this.connectionTimeout.intValue());
        }
        if (this.datatimeout != null) {
            this.ftp.setDataTimeout(this.datatimeout.intValue());
        }
        if (this.socketTimeout != null) {
            this.ftp.setDefaultTimeout(this.socketTimeout.intValue());
        }
        this.secret(new ISecretStatement(){

            public Object execute(ISecretContext context) throws Throwable {
                String tmp = FtpActionCodeI.this.ftpHostname.getString(context);
                FtpActionCodeI.this.ftp.setDefaultPort(FtpActionCodeI.this.ftpPort.getInteger(context).intValue());
                FtpActionCodeI.this.ftp.connect(FtpActionCodeI.this.ftpHostname.getString(context).startsWith("ftp://") ? tmp.substring(6) : tmp, FtpActionCodeI.this.ftpPort.getInteger(context).intValue());
                return null;
            }
        });
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.ftp.logout();
            this.ftp.disconnect();
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpActionCodeI.2"), "String", false);
            throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpActionCodeI.3"));
        }
        if (!this.disableLogin.booleanValue()) {
            this.secret(new ISecretStatement(){

                public Object execute(ISecretContext context) throws Throwable {
                    String tmp = FtpActionCodeI.this.ftpPassword.decryptString(context);
                    if (!FtpActionCodeI.this.ftp.login(FtpActionCodeI.this.ftpUser.getString(context), tmp)) {
                        FtpActionCodeI.this.ftp.logout();
                        FtpActionCodeI.this.ftp.disconnect();
                        FtpActionCodeI.this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(FtpActionCodeI.this.actionClassName) + Messages.getString("FtpActionCodeI.4"), "String", false);
                        throw new EngineExceptionI(String.valueOf(FtpActionCodeI.this.actionClassName) + Messages.getString("FtpActionCodeI.5"));
                    }
                    return null;
                }
            });
        }
        if (this.ftp instanceof MyFtpsClient) {
            if (this.protectionBufferSize != null) {
                ((SSLSessionReuseFTPSClient)this.ftp).execPBSZ(this.protectionBufferSize.longValue());
            }
            if (this.encryptChannelData) {
                ((SSLSessionReuseFTPSClient)this.ftp).execPROT("P");
            }
        }
        if (this.ftpMode != null) {
            if (this.ftpMode.equals("binary")) {
                this.ftp.setFileType(2);
            } else {
                this.ftp.setFileType(0);
            }
        }
        if (this.ftpPassiveMode.booleanValue()) {
            this.ftp.enterLocalPassiveMode();
        }
        if (this.ftpSystemType != null) {
            FTPClientConfig conf = new FTPClientConfig(this.ftpSystemType);
            this.ftp.configure(conf);
        }
        return true;
    }
}

