/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.JMSConnection;
import com.indy.engine.actionCodes.jms.JMSUtils;
import com.indy.engine.actionCodes.jms.Messages;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;

public class JMSFileSender {
    String sendDirectory;
    String fileMask;
    String sessionName;
    String destinationName;
    List<File> sendFiles = new ArrayList<File>();
    private JMSMessageType messageType = JMSMessageType.BytesMessage;
    List<UserDefinedParameter> userDefinedParameters = new ArrayList<UserDefinedParameter>();
    List<JMSPropertySetter> JMSPropertySetters = new ArrayList<JMSPropertySetter>();

    public void setSendDirectory(String sendDirectory) {
        this.sendDirectory = sendDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setMessageType(JMSMessageType messageType) {
        this.messageType = messageType;
    }

    public synchronized void deleteSendFiles() {
        for (File file : this.sendFiles) {
            file.delete();
        }
        this.sendFiles.clear();
    }

    public void addUserDefinedParmater(String name, String value, String type) {
        UserDefinedParameter parameter = new UserDefinedParameter();
        parameter.name = name;
        parameter.stringValue = value;
        parameter.parameterType = TypeParameter.valueOf(type == null ? "STRING" : type.toUpperCase());
        this.userDefinedParameters.add(parameter);
    }

    private Message createNewMessage(Session session) throws JMSException {
        if (this.messageType == JMSMessageType.TextMessage) {
            return session.createTextMessage();
        }
        if (this.messageType == JMSMessageType.BytesMessage) {
            return session.createBytesMessage();
        }
        if (this.messageType == JMSMessageType.StreamMessage) {
            return session.createStreamMessage();
        }
        throw new JMSException(Messages.getString("JMSFileSender.0"));
    }

    public synchronized void send(JMSConnection connection) throws JMSException, NamingException, IOException, InterruptedException {
        assert (this.sendDirectory != null) : Messages.getString("JMSFileSender.1");
        assert (this.fileMask != null) : Messages.getString("JMSFileSender.2");
        assert (this.sessionName != null) : Messages.getString("JMSFileSender.3");
        assert (this.destinationName != null) : Messages.getString("JMSFileSender.4");
        File directory = new File(this.sendDirectory);
        if (!directory.exists()) {
            throw new JMSException(String.valueOf(Messages.getString("JMSFileSender.6")) + this.sendDirectory + Messages.getString("JMSFileSender.5"));
        }
        if (directory.isFile()) {
            throw new JMSException(String.valueOf(Messages.getString("JMSFileSender.7")) + this.sendDirectory + Messages.getString("JMSFileSender.8"));
        }
        try {
            MessageProducer producer = connection.createMessageProducer(this.sessionName, this.destinationName);
            Session session = connection.getSession(this.sessionName);
            File[] fileArray = directory.listFiles(new MyFileFilter(this.fileMask));
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File _file = fileArray[n2];
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (_file.isFile()) {
                    try (FileInputStream in = null;){
                        in = new FileInputStream(_file);
                        Message message = this.createNewMessage(session);
                        for (JMSPropertySetter setter : this.JMSPropertySetters) {
                            setter.setProperty(message);
                        }
                        for (UserDefinedParameter parameter : this.userDefinedParameters) {
                            parameter.addToMessage(message);
                        }
                        JMSUtils.inputStreamToMessage(in, message);
                        producer.send(message);
                        this.sendFiles.add(_file);
                    }
                }
                ++n2;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        finally {
            this.closeMessageProducer(connection);
        }
    }

    public void closeMessageProducer(JMSConnection connection) throws JMSException, NamingException {
        if (connection != null) {
            connection.closeMessageProducer(this.sessionName, this.destinationName);
        }
    }

    public synchronized void copySentFiles(String dir, boolean move) throws IOException {
        File _dir = new File(dir);
        if (!_dir.exists()) {
            _dir.mkdirs();
        }
        for (File file : this.sendFiles) {
            File dest = new File(_dir, file.getName());
            if (move) {
                dest.delete();
                file.renameTo(dest);
                continue;
            }
            FileInputStream is = null;
            OutputStream os = null;
            try {
                is = new FileInputStream(file);
                os = new FileOutputStream(dest);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.sendFiles.clear();
    }

    public void addJMSpropertySetter(JMSPropertySetter setter) {
        this.JMSPropertySetters.add(setter);
    }

    public static enum JMSMessageType {
        BytesMessage,
        TextMessage,
        StreamMessage;

    }

    public static interface JMSPropertySetter {
        public void setProperty(Message var1) throws JMSException, NamingException;
    }

    class MyFileFilter
    implements FilenameFilter {
        final String localMask;

        public MyFileFilter(String pFileMask) {
            this.localMask = StringOperations.replaceWildChars((String)pFileMask);
        }

        @Override
        public boolean accept(File pDir, String pFileName) {
            return pFileName.matches(this.localMask);
        }
    }

    public static enum TypeParameter {
        LONG,
        BOOLEAN,
        INT,
        OBJECT,
        STRING,
        DOUBLE,
        FLOAT,
        BYTE,
        SHORT;

    }

    public static class UserDefinedParameter {
        public String name;
        public TypeParameter parameterType = TypeParameter.STRING;
        public int sqlType;
        public String stringValue;
        public String alias;

        void addToMessage(Message message) throws JMSException {
            if (this.parameterType == TypeParameter.STRING) {
                message.setStringProperty(this.name, this.stringValue);
            } else if (this.parameterType == TypeParameter.INT) {
                message.setIntProperty(this.name, Integer.valueOf(this.stringValue).intValue());
            } else if (this.parameterType == TypeParameter.BOOLEAN) {
                message.setBooleanProperty(this.name, Boolean.valueOf(this.stringValue).booleanValue());
            } else if (this.parameterType == TypeParameter.DOUBLE) {
                message.setDoubleProperty(this.name, Double.valueOf(this.stringValue).doubleValue());
            } else if (this.parameterType == TypeParameter.LONG) {
                message.setLongProperty(this.name, Long.valueOf(this.stringValue).longValue());
            } else if (this.parameterType == TypeParameter.FLOAT) {
                message.setFloatProperty(this.name, Float.valueOf(this.stringValue).floatValue());
            } else if (this.parameterType == TypeParameter.BYTE) {
                message.setByteProperty(this.name, Byte.valueOf(this.stringValue).byteValue());
            } else if (this.parameterType == TypeParameter.SHORT) {
                message.setShortProperty(this.name, Short.valueOf(this.stringValue).shortValue());
            }
        }

        public void addToPreparedStatement(int index, PreparedStatement st, Message message) throws SQLException, JMSException {
            if (this.parameterType == TypeParameter.STRING) {
                st.setString(index, message.getStringProperty(this.name));
            } else if (this.parameterType == TypeParameter.INT) {
                st.setInt(index, message.getIntProperty(this.name));
            } else if (this.parameterType == TypeParameter.BOOLEAN) {
                st.setBoolean(index, message.getBooleanProperty(this.name));
            } else if (this.parameterType == TypeParameter.DOUBLE) {
                st.setDouble(index, message.getDoubleProperty(this.name));
            } else if (this.parameterType == TypeParameter.LONG) {
                st.setLong(index, message.getLongProperty(this.name));
            } else if (this.parameterType == TypeParameter.FLOAT) {
                st.setFloat(index, message.getFloatProperty(this.name));
            } else if (this.parameterType == TypeParameter.BYTE) {
                st.setByte(index, message.getByteProperty(this.name));
            } else if (this.parameterType == TypeParameter.SHORT) {
                st.setShort(index, message.getShortProperty(this.name));
            }
        }
    }
}

