/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.mail;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.mail.Messages;
import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;

public class MailActionCode
extends ActionCodeTypeI {
    private int mailTableVersion;
    protected String mailExtraProperties;
    protected String oauth2JsonString;
    int num = 0;

    public int getFileTableVersion() {
        if (this.mailTableVersion == 0) {
            this.mailTableVersion = CommonUtils.existsField((Connection)this.jdbcConnection, (String)this.sqlSchemaName, (String)"IND_SESSION_MAIL_HEADER", (String)"MAIL_ACT_TYPE") ? 2 : 1;
        }
        return this.mailTableVersion;
    }

    protected void appendSessionExtraProperties(Properties sessionProps) throws IOException {
        if (this.mailExtraProperties != null && !this.mailExtraProperties.trim().isEmpty()) {
            Properties p = new Properties();
            Throwable throwable = null;
            Object var4_5 = null;
            try (StringReader sr = new StringReader(this.mailExtraProperties);){
                p.load(sr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            sessionProps.putAll((Map<?, ?>)p);
        }
    }

    protected void createMailTables() throws EngineExceptionI {
        if (!this.existsTable(null, null, "IND_SESSION_MAIL_HEADER") || !this.existsTable(null, null, "IND_SESSION_MAIL_LST_INFO")) {
            this.debugLog("executeSimpleCode", Messages.getString("MailActionCode.0"), 3, "DEBUG");
            try {
                Statement DMLStatement = this.jdbcConnection.createStatement();
                this.debugLog("createTables", Messages.getString("MailActionCode.1"), 2, "DEBUG");
                String txtCode = "DROP TABLE " + this.sqlSchemaName + "IND_SESSION_MAIL_HEADER";
                try {
                    DMLStatement.execute(txtCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                txtCode = "DROP TABLE " + this.sqlSchemaName + "IND_SESSION_MAIL_LST_INFO";
                try {
                    DMLStatement.execute(txtCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.debugLog("createTables", "Drop OK", 2, "DEBUG");
                txtCode = "CREATE TABLE " + this.sqlSchemaName + "IND_SESSION_MAIL_HEADER " + "(\t" + "SESS_ID           " + this.varcharType + "(50), " + "SESS_NAME         " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "ACT_ID            " + this.varcharType + "(50), " + "ACT_NAME          " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "MAIL_ID           " + this.numericType + "(10), " + "MAIL_SUBJECT      " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "MAIL_FROM         " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "MAIL_FOLDER       " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "MAIL_ATT_PREFIX   " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "MAIL_MSG_PREFIX   " + this.varcharType + "(" + String.valueOf(this.varcharSize) + "), " + "MAIL_SENT_DATE  \t" + this.varcharType + "(25), " + "MAIL_RECEIVED_DATE  " + this.varcharType + "(25), " + "MAIL_ACT_TYPE\t\t" + this.varcharType + "(25) " + ")";
                DMLStatement.execute(txtCode);
                txtCode = "CREATE TABLE " + this.sqlSchemaName + "IND_SESSION_MAIL_LST_INFO " + "( " + "SESS_ID     " + this.varcharType + "(50), " + "ACT_ID      " + this.varcharType + "(50), " + "MAIL_ID     " + this.numericType + "(10), " + "INFO_ID     " + this.numericType + "(10), " + "INFO_TYPE   " + this.varcharType + "(35), " + "INFO_VALUE  " + this.varcharType + "(" + String.valueOf(this.varcharSize) + ") " + ") ";
                DMLStatement.execute(txtCode);
            }
            catch (SQLException e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "ReadMailActionCodeI=>createTables : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            this.debugLog("createTables", Messages.getString("MailActionCode.2"), 2, "DEBUG");
        }
    }

    protected void insertHeaderDataInTables(Message msg, String mailFolder, String attPrefix, String msgPrefix, boolean send) throws EngineExceptionI {
        Statement sqlStatement = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        try {
            try {
                int version = this.getFileTableVersion();
                String txtCode = "INSERT into " + this.sqlSchemaName + "IND_SESSION_MAIL_HEADER (SESS_ID, SESS_NAME, ACT_ID, ACT_NAME, MAIL_ID, MAIL_SUBJECT, MAIL_FROM, MAIL_FOLDER, MAIL_ATT_PREFIX, MAIL_MSG_PREFIX, MAIL_SENT_DATE, MAIL_RECEIVED_DATE" + (version == 1 ? "" : ", MAIL_ACT_TYPE") + ")" + " values (?,?,?,?,?,?,?,?,?,?,?,?" + (version == 1 ? "" : ",?") + ") ";
                sqlStatement = this.jdbcConnection.prepareStatement(txtCode);
                this.debugLog("insertHeaderDataInTables", "Statement prepared", 3, "DEBUG");
                int i = 1;
                ++this.num;
                sqlStatement.setString(i++, this.actionContext.getSessionId());
                sqlStatement.setString(i++, this.sessionName);
                sqlStatement.setString(i++, this.actionContext.getActionId());
                sqlStatement.setString(i++, this.actionContext.getActionName());
                sqlStatement.setInt(i++, this.num);
                sqlStatement.setString(i++, msg.getSubject());
                String sFrom = this.getFromString(msg);
                sqlStatement.setString(i++, sFrom);
                sqlStatement.setString(i++, mailFolder);
                sqlStatement.setString(i++, attPrefix);
                sqlStatement.setString(i++, msgPrefix);
                if (!send) {
                    sqlStatement.setString(i++, dateFormat.format(msg.getSentDate()));
                    sqlStatement.setString(i++, dateFormat.format(new Date()));
                } else {
                    sqlStatement.setString(i++, dateFormat.format(new Date()));
                    sqlStatement.setString(i++, null);
                }
                if (version >= 2) {
                    sqlStatement.setString(i++, send ? "SEND" : "RECEIVE");
                }
                sqlStatement.execute();
                sqlStatement.close();
                this.debugLog("insertHeaderDataInTables", "Header OK", 3, "DEBUG");
                Address[] lstAddr = msg.getRecipients(Message.RecipientType.TO);
                if (lstAddr != null && lstAddr.length > 0) {
                    int k = 0;
                    while (k < lstAddr.length) {
                        this.insertInfoDataInTables(k + 1, "To", lstAddr[k].toString());
                        ++k;
                    }
                }
                Enumeration en = msg.getAllHeaders();
                while (en.hasMoreElements()) {
                    Header head = (Header)en.nextElement();
                    if (head.getName().equals("Sender")) {
                        this.insertInfoDataInTables(1, "Sender", head.getValue());
                    }
                    if (!head.getName().equals("From")) continue;
                    this.insertInfoDataInTables(1, "From", head.getValue());
                }
                lstAddr = msg.getRecipients(Message.RecipientType.CC);
                if (lstAddr != null && lstAddr.length > 0) {
                    int k = 0;
                    while (k < lstAddr.length) {
                        this.insertInfoDataInTables(k + 1, "CC", lstAddr[k].toString());
                        ++k;
                    }
                }
                try {
                    lstAddr = msg.getRecipients(Message.RecipientType.BCC);
                    if (lstAddr != null && lstAddr.length > 0) {
                        int k = 0;
                        while (k < lstAddr.length) {
                            this.insertInfoDataInTables(k + 1, "BCC", lstAddr[k].toString());
                            ++k;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.commit();
            }
            catch (Exception e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "ReadMailActionCodeI=>insertHeaderDataInTables : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (sqlStatement != null) {
                try {
                    sqlStatement.close();
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
    }

    protected void insertInfoDataInTables(int id, String infoType, String infoValue) throws EngineExceptionI {
        Statement sqlStatement = null;
        try {
            try {
                String txtCode = "INSERT into " + this.sqlSchemaName + "IND_SESSION_MAIL_LST_INFO (SESS_ID, ACT_ID, MAIL_ID, INFO_ID, INFO_TYPE, INFO_VALUE ) " + " values (?,?,?,?,?,?) ";
                sqlStatement = this.jdbcConnection.prepareStatement(txtCode);
                sqlStatement.setString(1, this.actionContext.getSessionId());
                sqlStatement.setString(2, this.actionContext.getActionId());
                sqlStatement.setInt(3, this.num);
                sqlStatement.setInt(4, id);
                sqlStatement.setString(5, infoType);
                sqlStatement.setString(6, infoValue);
                sqlStatement.executeUpdate();
                this.commit();
            }
            catch (SQLException e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "ReadMailActionCodeI=>insertInfoDataInTables : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (sqlStatement != null) {
                try {
                    sqlStatement.close();
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
    }

    protected void commit() throws SQLException {
        if (this.sqlTransType.equals("COMMIT")) {
            this.jdbcConnection.commit();
        }
    }

    protected String getAddressesInString(Address[] lstAddr) throws MessagingException {
        String ret = "";
        ret = "";
        if (lstAddr != null && lstAddr.length > 0) {
            int i = 0;
            while (i < lstAddr.length) {
                ret = i == 0 ? String.valueOf(ret) + lstAddr[i].toString() : String.valueOf(ret) + ";" + lstAddr[i].toString();
                ++i;
            }
        }
        return ret;
    }

    protected String getCCString(Message msg) throws MessagingException {
        return this.getAddressesInString(msg.getRecipients(Message.RecipientType.CC));
    }

    protected String getToString(Message msg) throws MessagingException {
        return this.getAddressesInString(msg.getRecipients(Message.RecipientType.TO));
    }

    protected String getFromString(Message msg) throws MessagingException {
        return this.getAddressesInString(msg.getFrom());
    }
}

