/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.wsdl;

import com.indy.engine.actionCodes.utils.XmlReaderToWriter;
import com.indy.engine.actionCodes.wsdl.HttpPort;
import com.indy.engine.actionCodes.wsdl.Messages;
import com.indy.engine.actionCodes.wsdl.Operation;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.common.ntlm.NtlmMetadata;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.base.core.auth.OAuth;
import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.net.proxy.URLUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpOperation
extends Operation {
    String uuid = UUID.randomUUID().toString();
    public String methodAddress;
    private Param currentParam;
    private InputStream is;
    private InputStream err;
    public String urlEncoding;
    InputMode inputMode = null;
    RuntimeContext rc;
    private Set<HttpURLConnection> openedHttpConnections = Collections.synchronizedSet(new HashSet());
    boolean disableParamsEncoding = false;
    Params contentEncodedParams = new Params();
    Params queryEncodedParams = new Params();
    Params queryReplacementParams = new Params();
    Params headerParams = new Params();
    Set<String> outputHeaderParamsName = new HashSet<String>();
    String responseCodeName = null;
    String errorExceptionName = null;
    String errorMessageName = null;
    boolean parameterStatus = true;
    private String responseMessage;
    private String msgName;
    OAuthMetadata oauth;
    private NtlmMetadata ntlmMetadata = null;
    private int responseCode;
    private String responseMessageName;
    private Param method;
    private HttpURLConnection conn;
    IOException exception;
    String inputContentType = null;
    PartType inputType;
    PartType outputType;
    PartType faultType;
    private String xmlVersion = "1.0";
    int fileConunter = 0;
    XMLInputFactory factory = XMLInputFactory.newInstance();
    String lastQueryString = null;
    Element currentElement;
    Document document;
    Element rootElement;
    private StringBuffer text;
    Transformer transformer;
    String outputContentType;
    String outputEncoding;
    String inputEncoding;
    String faultEncoding;
    String tempFolder;

    public HttpOperation(RuntimeContext rc) {
        this.rc = rc;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(InputMode inputMode) {
        this.inputMode = inputMode;
    }

    public void openParameter(String localName, int paramType) {
        this.parameterStatus = false;
        if (this.currentParam == null) {
            this.currentParam = new Param(localName);
            if (paramType == 1) {
                this.queryEncodedParams.add(this.currentParam);
            } else if (paramType == 2) {
                this.contentEncodedParams.add(this.currentParam);
            } else if (paramType == 3) {
                this.headerParams.add(this.currentParam);
            } else if (paramType == 4 || paramType == 9) {
                this.queryReplacementParams.add(this.currentParam);
                if (paramType == 9) {
                    this.currentParam.setEncode(false);
                }
            } else if (paramType == 5) {
                this.responseCodeName = localName;
            } else if (paramType == 6) {
                this.outputHeaderParamsName.add(localName);
            } else if (paramType == 7) {
                this.responseMessageName = localName;
            } else if (paramType == 8) {
                this.method = this.currentParam;
            } else if (paramType == 10) {
                this.errorMessageName = localName;
            } else if (paramType == 11) {
                this.errorExceptionName = localName;
            }
        }
    }

    public void closeParameter(String localName) {
        this.currentParam = null;
        this.parameterStatus = true;
    }

    public void addParameterValue(String string) {
        this.currentParam.setValue(string);
    }

    public void setOauth(OAuthMetadata oauth) {
        this.oauth = oauth;
    }

    public void setNtlmMetadata(NtlmMetadata ntlmMetadata) {
        this.ntlmMetadata = ntlmMetadata;
    }

    private void setRequestMethod(HttpURLConnection c, String value) {
        try {
            Object target;
            if (c.getClass().getName() == "sun.net.www.protocol.https.HttpsURLConnectionImpl") {
                Field delegate = c.getClass().getDeclaredField("delegate");
                delegate.setAccessible(true);
                target = delegate.get(c);
            } else {
                target = c;
            }
            Field f = HttpURLConnection.class.getDeclaredField("method");
            f.setAccessible(true);
            f.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (NoSuchFieldException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    HttpURLConnection getConnection() throws Exception {
        String urlString = this.getUrlString();
        URL url = this.initURL(urlString);
        Proxy proxy = this.ctx.getProxy();
        final HttpURLConnection localConn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (localConn instanceof HttpsURLConnection) {
            if (this.ctx.getHostnameVerifier() != null) {
                ((HttpsURLConnection)localConn).setHostnameVerifier(this.ctx.getHostnameVerifier());
            }
            if (this.ctx.getSslSocketFactory() != null) {
                ((HttpsURLConnection)localConn).setSSLSocketFactory(this.ctx.getSslSocketFactory());
            }
        }
        this.ctx.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                URLUtil.setUserHeader((URLConnection)localConn, (String)HttpOperation.this.ctx.user, (String)HttpOperation.this.ctx.password.decryptString(context), (String)HttpOperation.this.ctx.proxyUser, (String)HttpOperation.this.ctx.proxyPassword.decryptString(context));
                return null;
            }
        });
        String verb = null;
        verb = this.method != null && this.method.value != null ? this.method.value.toUpperCase() : ((HttpPort)this.port).verb.name();
        localConn.setReadTimeout(this.ctx.readTimeout);
        localConn.setConnectTimeout(this.ctx.connectionTimeout);
        if (this.ntlmMetadata != null) {
            this.addNtlmAuthenticator();
        }
        if (this.oauth != null) {
            String oauthHeader = null;
            TreeMap<String, String> parameters = new TreeMap<String, String>();
            if (this.queryEncodedParams.params != null) {
                for (Param param : this.queryEncodedParams.params) {
                    parameters.put(param.name, param.value);
                }
            }
            if (this.contentEncodedParams.params != null) {
                for (Param param : this.contentEncodedParams.params) {
                    parameters.put(param.name, param.value);
                }
            }
            oauthHeader = OAuth.generateHeader((String)urlString, (String)verb, (OAuthMetadata)this.oauth, parameters);
            localConn.setRequestProperty("Authorization", oauthHeader);
        }
        if (this.headerParams.params != null) {
            for (Param param : this.headerParams.params) {
                localConn.setRequestProperty(param.name, param.value);
            }
        }
        if (verb.equals("PATCH")) {
            this.setRequestMethod(localConn, verb);
        } else {
            localConn.setRequestMethod(verb);
        }
        this.addHeader(localConn);
        return localConn;
    }

    private void addNtlmAuthenticator() throws Exception {
        try {
            Method setAuthMethod = this.conn.getClass().getMethod("setAuthenticator", Authenticator.class);
            setAuthMethod.invoke((Object)this.conn, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(HttpOperation.this.ntlmMetadata.getFullNtlmUser(), HttpOperation.this.ntlmMetadata.getNtlmPassword().toCharArray());
                }
            });
        }
        catch (NoSuchMethodException e) {
            throw new EngineExceptionI(Messages.getString("HttpOperation.0"));
        }
    }

    int call(HttpURLConnection conn) throws IOException {
        this.openedHttpConnections.add(conn);
        this.exception = null;
        this.responseMessage = null;
        this.responseCode = 0;
        this.conn = conn;
        try {
            this.serializeUrl(conn.getURL());
            this.is = conn.getInputStream();
            this.is = this.serializeInput(this.is);
            this.responseMessage = conn.getResponseMessage();
            this.responseCode = conn.getResponseCode();
            return 1;
        }
        catch (IOException e) {
            this.err = conn.getErrorStream();
            this.err = this.serializeInput(this.err);
            this.exception = e;
            try {
                this.responseMessage = conn.getResponseMessage();
                this.responseCode = conn.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
        finally {
            this.openedHttpConnections.remove(conn);
            try {
                this.serializeResponseHeader(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int getInvoke() throws Exception {
        HttpURLConnection conn = this.getConnection();
        conn.setDoOutput(true);
        return this.call(conn);
    }

    public void setFaultType(PartType faultType) {
        this.faultType = faultType;
    }

    public void setOutputPartType(PartType type) {
        this.outputType = type;
    }

    public void setInputContentType(String inputContentType) throws Exception {
        if (this.inputContentType != null && inputContentType != null && !this.inputContentType.equals(inputContentType)) {
            throw new Exception(String.valueOf(Messages.getString("HttpOperation.1")) + this.inputContentType + Messages.getString("HttpOperation.2") + inputContentType);
        }
        this.inputContentType = inputContentType;
    }

    private String getUrlString() throws UnsupportedEncodingException {
        String _methoddAdress = this.methodAddress;
        if (this.queryReplacementParams != null) {
            _methoddAdress = this.queryReplacementParams.replace(this.methodAddress, true);
        }
        return String.valueOf(((HttpPort)this.port).mainAdress) + _methoddAdress;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    private URL initURL(String urlString) throws UnsupportedEncodingException, MalformedURLException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        this.lastQueryString = this.queryEncodedParams.encode();
        String sUrl = null;
        sUrl = urlString.contains("?") ? String.valueOf(urlString) + (this.lastQueryString != null ? "&" + this.lastQueryString : "") : String.valueOf(urlString) + (this.lastQueryString != null ? "?" + this.lastQueryString : "");
        this.msgName = new Long(System.currentTimeMillis()).toString();
        return new URL(sUrl);
    }

    private int postInvoke() throws Exception, IOException {
        HttpURLConnection conn = null;
        try {
            conn = this.getConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            this.lastQueryString = this.contentEncodedParams.encode();
            if (this.lastQueryString != null) {
                conn.setRequestProperty("Content-Type", this.inputContentType);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                if (this.lastQueryString != null) {
                    wr.write(this.lastQueryString);
                    wr.flush();
                }
            } else if (this.document != null || this.inputType != null) {
                InputStream fis;
                block37: {
                    if (this.inputContentType != null) {
                        conn.setRequestProperty("Content-Type", this.inputContentType);
                    }
                    this.serializeRequestHeader(conn);
                    if (this.port.wsdl.sentMessagesFolder != null) {
                        try (FileOutputStream fos = null;){
                            InputStream fis2;
                            fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, String.valueOf(this.msgName) + ".content.in"));
                            if (this.document != null) {
                                if (this.inputType == PartType.json) {
                                    this.transformXmlToJson(fos, this.ctx.encoding, this.inputEncoding);
                                } else {
                                    this.transformDocumentToOutputStream(fos);
                                }
                                break block37;
                            }
                            if (this.inputType == PartType.string) {
                                fis2 = new ByteArrayInputStream(this.text.toString().getBytes());
                                IOUtils.copy((InputStream)fis2, (OutputStream)fos);
                                fis2.close();
                                break block37;
                            }
                            if (this.inputType == PartType.binary) {
                                fis2 = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)this.text.toString()));
                                IOUtils.copy((InputStream)fis2, (OutputStream)fos);
                                fis2.close();
                                break block37;
                            }
                            if (this.inputType != PartType.uri) break block37;
                            fis2 = null;
                            try {
                                fis2 = new FileInputStream(new File(new URI(this.text.toString())));
                                IOUtils.copy((InputStream)fis2, (OutputStream)fos);
                            }
                            finally {
                                if (fis2 != null) {
                                    fis2.close();
                                }
                            }
                        }
                    }
                }
                if (this.document != null) {
                    if (this.inputType == null || this.inputType != PartType.json) {
                        this.transformDocumentToOutputStream(conn.getOutputStream());
                    } else {
                        this.transformXmlToJson(conn.getOutputStream(), this.ctx.encoding, this.inputEncoding);
                    }
                } else if (this.inputType == PartType.string) {
                    fis = new ByteArrayInputStream(this.text.toString().getBytes());
                    this.text = null;
                    IOUtils.copy((InputStream)fis, (OutputStream)conn.getOutputStream());
                    fis.close();
                } else if (this.inputType == PartType.binary) {
                    fis = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)this.text.toString()));
                    this.text = null;
                    IOUtils.copy((InputStream)fis, (OutputStream)conn.getOutputStream());
                    fis.close();
                } else if (this.inputType == PartType.uri) {
                    fis = null;
                    try {
                        fis = new FileInputStream(new File(new URI(this.text.toString())));
                        this.text = null;
                        IOUtils.copy((InputStream)fis, (OutputStream)conn.getOutputStream());
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                this.text = null;
            }
            return this.call(conn);
        }
        catch (IOException e) {
            this.exception = e;
            if (conn != null) {
                this.err = conn.getErrorStream();
                this.err = this.serializeInput(this.err);
                try {
                    this.responseMessage = conn.getResponseMessage();
                    this.responseCode = conn.getResponseCode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    private int invoke2(boolean isOnFail) throws Exception {
        this.is = null;
        this.err = null;
        int ret = 0;
        if (this.ctx.delayBetweenInvocation > 0 && !isOnFail) {
            Thread.sleep(this.ctx.delayBetweenInvocation);
        }
        ret = this.isGetOrDeleteVerb() ? this.getInvoke() : this.postInvoke();
        return ret;
    }

    public HttpVerb getVerb() {
        if (this.method != null && this.method.value != null) {
            return HttpVerb.valueOf(this.method.value.toUpperCase());
        }
        return ((HttpPort)this.port).verb;
    }

    public boolean isGetOrDeleteVerb() {
        HttpVerb verb = this.getVerb();
        return verb == HttpVerb.GET || verb == HttpVerb.DELETE;
    }

    @Override
    public void clear() {
        this.queryEncodedParams = new Params();
        this.contentEncodedParams = new Params();
        this.headerParams = new Params();
        this.queryReplacementParams = new Params();
        this.outputHeaderParamsName.clear();
        this.responseCodeName = null;
        this.responseMessageName = null;
        this.errorExceptionName = null;
        this.errorMessageName = null;
        this.inputContentType = null;
        this.lastQueryString = null;
        this.method = null;
        this.conn = null;
    }

    @Override
    public int invoke() throws Exception {
        if (this.parameterStatus) {
            int technicalErrorCount = 0;
            int functionalErrorCount = 0;
            while (technicalErrorCount <= this.ctx.technicalErrorRetryNumber && functionalErrorCount <= this.ctx.retryNumber) {
                int ret = this.invoke2(technicalErrorCount + functionalErrorCount > 0);
                if (ret == 1) {
                    return 1;
                }
                if (this.responseCode == 0) {
                    if (this.ctx.technicalErrorRetryDelay <= 0 || ++technicalErrorCount > this.ctx.technicalErrorRetryNumber) continue;
                    Thread.sleep(this.ctx.technicalErrorRetryDelay.intValue());
                    continue;
                }
                if (this.ctx.retryDelay <= 0 || ++functionalErrorCount > this.ctx.retryNumber) continue;
                Thread.sleep(this.ctx.retryDelay);
            }
        }
        if (this.responseCode == 0 && this.responseMessage == null) {
            ++this.port.wsdl.technicalErrorNumber;
            if (this.ctx.technicalErrorAcceptanceNumber > -1 && this.port.wsdl.technicalErrorNumber > this.ctx.technicalErrorAcceptanceNumber) {
                throw this.exception;
            }
        } else {
            ++this.port.wsdl.errorNumber;
        }
        if (this.port.wsdl.errorAcceptanceNumber > -1 && this.port.wsdl.errorAcceptanceNumber < this.port.wsdl.errorNumber) {
            throw new IOException(String.valueOf(Messages.getString("HttpOperation.3")) + this.port.wsdl.errorNumber + ")", this.exception);
        }
        return -1;
    }

    @Override
    public void writeMessage(AbstractXmlWriterAPI xwa, String localName, String firstLocalName) throws EngineExceptionI {
        block40: {
            if (this.outputHeaderParamsName.contains(localName) && this.conn != null) {
                try {
                    String header = this.conn.getHeaderField(localName);
                    if (header != null) {
                        xwa.xmlw.writeCharacters(header);
                    }
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            } else if (this.responseCodeName != null && this.responseCodeName.equals(localName)) {
                try {
                    xwa.xmlw.writeCharacters(String.valueOf(this.responseCode));
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            } else if (this.responseMessageName != null && this.responseMessageName.equals(localName) && this.responseMessage != null) {
                try {
                    xwa.xmlw.writeCharacters(this.responseMessage);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            } else if (this.errorMessageName != null && this.errorMessageName.equals(localName)) {
                try {
                    if (this.exception != null) {
                        xwa.xmlw.writeCharacters(this.exception.getLocalizedMessage());
                    }
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            } else if (this.errorExceptionName != null && this.errorExceptionName.equals(localName)) {
                try {
                    if (this.exception != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        this.exception.printStackTrace(pw);
                        xwa.xmlw.writeCharacters(sw.toString());
                    }
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            } else if (this.is != null) {
                try {
                    if (this.outputType == PartType.binary) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)this.is, (OutputStream)baos);
                        xwa.xmlw.writeCharacters(DatatypeConverter.printBase64Binary((byte[])baos.toByteArray()));
                        break block40;
                    }
                    if (this.outputType == PartType.string) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)this.is, (OutputStream)baos);
                        xwa.xmlw.writeCharacters(DatatypeConverter.printString((String)new String(baos.toByteArray(), "UTF-8")));
                        break block40;
                    }
                    if (this.outputType == PartType.uri) {
                        File file = new File(String.valueOf(this.tempFolder) + File.separator + this.uuid + "_" + this.fileConunter++ + ".data");
                        try (FileOutputStream os = null;){
                            os = new FileOutputStream(file);
                            IOUtils.copy((InputStream)this.is, (OutputStream)os);
                            xwa.xmlw.writeCharacters(file.toURI().toASCIIString());
                            break block40;
                        }
                    }
                    InputStream _is = this.is;
                    if (this.outputType == PartType.json) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        JsonUtils.convertJsonToXml((InputStream)this.is, (OutputStream)baos, (String)this.outputEncoding, (String)this.ctx.encoding, (boolean)false, (boolean)true, null, (String)this.xmlVersion);
                        _is = new ByteArrayInputStream(baos.toByteArray());
                    }
                    XMLStreamReader xsr = this.factory.createXMLStreamReader(_is, this.ctx.encoding);
                    XmlReaderToWriter xw = XmlReaderToWriter.createInstance();
                    if (this.outputType == PartType.json) {
                        xw.setSkipProof(1);
                    }
                    xw.writeAll(xsr, xwa.xmlw);
                }
                catch (Exception e) {
                    InputStreamReader isr = new InputStreamReader(this.is);
                    StringBuffer sb = new StringBuffer();
                    int c = -1;
                    do {
                        if (c != -1) {
                            sb.append((char)c);
                        }
                        try {
                            c = isr.read();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } while (c != -1);
                    if (this.lastQueryString != null) {
                        throw new EngineExceptionI("Query: " + this.lastQueryString + "\n" + "Response: " + sb, (Throwable)e);
                    }
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean stopOpenOrClose() {
        return this.state == Operation.OperationState.OUTPUT && this.outputPartState == Operation.PartState.OPEN || this.state == Operation.OperationState.FAULT && this.faultPartState == Operation.PartState.OPEN;
    }

    @Override
    public void writeFault(AbstractXmlWriterAPI xwa) throws EngineExceptionI {
        block13: {
            if (this.err != null) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                try {
                    if (this.faultType == PartType.binary) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)this.err, (OutputStream)baos);
                        xwa.xmlw.writeCharacters(DatatypeConverter.printBase64Binary((byte[])baos.toByteArray()));
                        break block13;
                    }
                    if (this.faultType == PartType.string) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)this.err, (OutputStream)baos);
                        xwa.xmlw.writeCharacters(DatatypeConverter.printString((String)new String(baos.toByteArray(), "UTF-8")));
                        break block13;
                    }
                    if (this.faultType == PartType.uri) {
                        File file = new File(String.valueOf(this.tempFolder) + File.separator + this.uuid + "_" + this.fileConunter++ + ".data");
                        try (FileOutputStream os = null;){
                            os = new FileOutputStream(file);
                            IOUtils.copy((InputStream)this.err, (OutputStream)os);
                            xwa.xmlw.writeCharacters(file.toURI().toASCIIString());
                            break block13;
                        }
                    }
                    InputStream _is = this.err;
                    if (this.faultType == PartType.json) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        JsonUtils.convertJsonToXml((InputStream)this.err, (OutputStream)baos, (String)this.outputEncoding, (String)this.ctx.encoding, (boolean)false, (boolean)true, null, (String)this.xmlVersion);
                        _is = new ByteArrayInputStream(baos.toByteArray());
                    }
                    XMLStreamReader xsr = factory.createXMLStreamReader(_is, this.ctx.encoding);
                    XmlReaderToWriter xw = XmlReaderToWriter.createInstance();
                    if (this.faultType == PartType.json) {
                        xw.setSkipProof(1);
                    }
                    int nbelt = xw.writeAll(xsr, xwa.xmlw);
                    xwa.incNbOpenedElement(nbelt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.responseMessage != null) {
                        throw new EngineExceptionI(this.responseMessage, (Throwable)this.exception);
                    }
                    throw new EngineExceptionI((Throwable)this.exception);
                }
            }
        }
    }

    public String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    private void addHeader(HttpURLConnection conn) {
        if (this.port.wsdl.headerParameters != null) {
            for (String key : this.port.wsdl.headerParameters.keySet()) {
                String value = this.port.wsdl.headerParameters.get(key);
                conn.addRequestProperty(key, value);
            }
        }
    }

    private void serializeUrl(URL url) throws IOException {
        if (this.port.wsdl.sentMessagesFolder != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, String.valueOf(this.msgName) + ".in"));
            fos.write(url.toString().getBytes());
            fos.close();
        }
    }

    private void serializeRequestHeader(HttpURLConnection conn) throws IOException {
        if (this.port.wsdl.sentMessagesFolder != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, String.valueOf(this.msgName) + ".header.in"));
            Map<String, List<String>> header = conn.getRequestProperties();
            if (header != null) {
                for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                    for (String value : entry.getValue()) {
                        if (entry.getKey() != null) {
                            fos.write(entry.getKey().getBytes());
                            fos.write(": ".getBytes());
                        }
                        if (value == null) continue;
                        fos.write(value.getBytes());
                        fos.write("\n".getBytes());
                    }
                }
            }
            fos.close();
        }
    }

    private InputStream serializeInput(InputStream is) throws IOException {
        if (this.port.wsdl.receivedMessagesFolder != null && is != null) {
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(new File(this.port.wsdl.receivedMessagesFolder, String.valueOf(this.msgName) + ".out"));
                ByteArrayInputStream byteArrayInputStream = HttpOperation.transformToByteArrayInputStream(is, fos);
                return byteArrayInputStream;
            }
        }
        return is;
    }

    private InputStream serializeResponseHeader(HttpURLConnection conn) throws IOException {
        if (this.port.wsdl.receivedMessagesFolder != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.receivedMessagesFolder, String.valueOf(this.msgName) + ".header.out"));
            Map<String, List<String>> header = conn.getHeaderFields();
            if (header != null) {
                for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                    for (String value : entry.getValue()) {
                        if (entry.getKey() != null) {
                            fos.write(entry.getKey().getBytes());
                            fos.write(": ".getBytes());
                        }
                        if (value == null) continue;
                        fos.write(value.getBytes());
                        fos.write("\n".getBytes());
                    }
                }
            }
            fos.close();
        }
        return this.is;
    }

    private static ByteArrayInputStream transformToByteArrayInputStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
            os.write(buffer, 0, n);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public Element openElement(String localName, String nameSpaceURI, String forcePrefix) throws Exception {
        Element newElement;
        if (this.text != null) {
            this.text = null;
        }
        if (this.currentElement == null) {
            this.initInputDocument();
        }
        if ((nameSpaceURI == null || nameSpaceURI.isEmpty()) && this.port.wsdl.prefixElement && this.port.wsdl.targetNamespace != null) {
            nameSpaceURI = this.port.wsdl.targetNamespace;
        }
        if (nameSpaceURI != null && !nameSpaceURI.isEmpty()) {
            if (forcePrefix != null && !forcePrefix.isEmpty()) {
                newElement = this.document.createElementNS(nameSpaceURI, String.valueOf(forcePrefix) + ":" + localName);
            } else {
                String prefix = (String)this.port.wsdl.namespaces.getFrom((Object)nameSpaceURI);
                if (prefix == null) {
                    prefix = (String)this.port.wsdl.globalNamespaces.getFrom((Object)nameSpaceURI);
                }
                newElement = prefix != null ? this.document.createElementNS(nameSpaceURI, String.valueOf(prefix) + ":" + localName) : this.document.createElement(localName);
            }
        } else {
            newElement = this.document.createElement(localName);
        }
        if (this.currentElement == null) {
            if (this.rootElement != null) {
                this.rootElement.appendChild(newElement);
            } else {
                this.document.appendChild(newElement);
            }
        } else if (newElement != null) {
            this.currentElement.appendChild(newElement);
        }
        this.currentElement = newElement;
        return this.currentElement;
    }

    private void initInputDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
        if (this.inputType == PartType.json) {
            this.rootElement = this.document.createElement("superRoot");
            this.rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.document.appendChild(this.rootElement);
        }
    }

    @Override
    public void setAttribute(String _name, String value) throws Exception {
        this.currentElement.setAttribute(_name, value);
    }

    @Override
    public void addText(String text) throws Exception {
        if (this.text == null) {
            this.text = new StringBuffer();
        }
        this.text.append(text);
    }

    @Override
    public void endElement() throws Exception {
        if (this.text != null) {
            if (this.getInputMode() == InputMode.Xml) {
                this.currentElement.appendChild(this.document.createTextNode(this.text.toString()));
                this.text = null;
            } else {
                this.getInputMode();
            }
        }
        if (this.currentElement.getParentNode() instanceof Element) {
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
    }

    private void transformXmlToJson(OutputStream out, String inEncoding, String outEncoding) throws XMLStreamException, IOException, TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformDocumentToOutputStream(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        JsonUtils.convertXmlToJson((InputStream)bais, (OutputStream)out, (String)inEncoding, (String)outEncoding, (int)1);
    }

    private void transformDocumentToOutputStream(OutputStream out) throws IOException, XMLStreamException, TransformerException {
        DOMSource source = new DOMSource(this.document);
        if (this.transformer == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            this.transformer = tFactory.newTransformer();
        }
        StreamResult result = new StreamResult(out);
        this.transformer.transform(source, result);
    }

    public void setOutputContentType(String outputContentType) throws Exception {
        if (this.outputContentType != null && outputContentType != null && !this.outputContentType.equals(outputContentType)) {
            throw new Exception(String.valueOf(Messages.getString("HttpOperation.4")) + this.outputContentType + Messages.getString("HttpOperation.5") + outputContentType);
        }
        this.outputContentType = outputContentType;
    }

    public void setOutputEncoding(String outputEncoding) throws IllegalArgumentException {
        if (this.outputEncoding != null && outputEncoding != null && !this.outputEncoding.equals(outputEncoding)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("HttpOperation.6")) + this.outputEncoding + Messages.getString("HttpOperation.7") + outputEncoding);
        }
        this.outputEncoding = outputEncoding;
    }

    public void setInputEncoding(String inputEncoding) throws IllegalArgumentException {
        if (this.inputEncoding != null && inputEncoding != null && !this.inputEncoding.equals(inputEncoding)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("HttpOperation.8")) + this.inputEncoding + Messages.getString("HttpOperation.9") + inputEncoding);
        }
        this.inputEncoding = inputEncoding;
    }

    public void setFaultEncoding(String faultEncoding) throws IllegalArgumentException {
        if (this.faultEncoding != null && faultEncoding != null && !this.faultEncoding.equals(faultEncoding)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("HttpOperation.10")) + this.faultEncoding + Messages.getString("HttpOperation.11") + faultEncoding);
        }
        this.faultEncoding = faultEncoding;
    }

    public void setInputPartType(PartType type) {
        this.inputType = type;
    }

    public void setTemporaryFolder(String tempFolder) {
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killOpenedConnections() {
        Set<HttpURLConnection> set = this.openedHttpConnections;
        synchronized (set) {
            for (HttpURLConnection c : this.openedHttpConnections) {
                try {
                    c.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.openedHttpConnections.clear();
        }
    }

    public static enum HttpVerb {
        GET,
        DELETE,
        POST,
        PUT,
        PATCH;

    }

    public static enum InputMode {
        Param,
        Xml,
        Header,
        Raw;

    }

    public class Param {
        boolean encode = true;
        String name;
        String value;

        public Param(String localName) {
            this.name = localName;
        }

        public void setEncode(boolean encode) {
            this.encode = encode;
        }

        public String getEncodedValue() throws UnsupportedEncodingException {
            if (this.encode) {
                if (HttpOperation.this.urlEncoding != null) {
                    return URLEncoder.encode(this.value, HttpOperation.this.urlEncoding);
                }
                return URLEncoder.encode(this.value);
            }
            return this.value;
        }

        public void setValue(String value) {
            this.value = this.value == null ? value : String.valueOf(this.value) + value;
        }
    }

    private class Params {
        List<Param> params;

        private Params() {
        }

        private void add(Param add) {
            if (this.params == null) {
                this.params = new ArrayList<Param>();
            }
            this.params.add(add);
        }

        private String encode() throws UnsupportedEncodingException {
            String queryString = null;
            if (this.params != null) {
                for (Param param : this.params) {
                    if (param == null || param.name == null || param.value == null) continue;
                    queryString = queryString == null ? "" : String.valueOf(queryString) + "&";
                    String name = param.name;
                    if (name.startsWith("_.") && name.endsWith("._")) {
                        name = name.substring(2, name.length() - 2);
                        name = JsonUtils.decodeHexString((String)name);
                        if (!HttpOperation.this.disableParamsEncoding) {
                            name = HttpOperation.this.urlEncoding != null ? URLEncoder.encode(name, HttpOperation.this.urlEncoding) : URLEncoder.encode(name);
                        }
                    }
                    queryString = String.valueOf(queryString) + name + "=" + param.getEncodedValue();
                }
                return queryString;
            }
            return null;
        }

        public String replace(String methodAddress, boolean replacePlus) throws UnsupportedEncodingException {
            String _methodAddress = methodAddress;
            if (this.params != null && this.params.size() > 0) {
                for (Param param : this.params) {
                    String replace = param.getEncodedValue();
                    if (replacePlus) {
                        replace = replace.replace("+", "%20");
                    }
                    _methodAddress = _methodAddress.replace("{" + param.name + "}", replace);
                }
                return _methodAddress;
            }
            return methodAddress;
        }
    }

    public static enum PartType {
        binary,
        string,
        json,
        uri;

    }
}

