/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.wsdl;

import com.indy.engine.actionCodes.wsdl.Messages;
import com.indy.engine.actionCodes.wsdl.Operation;
import com.indy.engine.actionCodes.wsdl.SoapPort;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.common.ntlm.NtlmMetadata;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.net.proxy.URLUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapOperation
extends Operation {
    public String operationElementName;
    public SoapStyle style;
    public String actionURI;
    public String attachmentsFolder;
    public SOAPConnection connection;
    public SOAPMessage message;
    public SOAPElement currentElement;
    private StringBuffer text;
    public SOAPMessage reply;
    public int partType;
    public SOAPEnvelope envelope;
    private static SOAPConnectionFactory factory;
    public String errorMessageName;
    public String errorExceptionName;
    private Exception exception;
    public static final int InputPartType = 1;
    public static final int HeaderPartType = 2;
    public static final String XSI_STD_PREFIX = "xsi";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public String XSI_PREFIX = "xsi";
    public boolean RPCOperationISOpen = false;
    boolean enloseActionByQUote = false;
    private NtlmMetadata ntlmMetadata;
    public static final String invoke = "SoapOperation.invoke";
    public static final String startMessage = "SoapOperation.startMessage";
    int i = 0;

    public void startMessage() throws SOAPException, ScriptException {
        if (this.currentElement == null) {
            if (this.ctx.activeScripting && this.ctx.soapStartMessageScript != null) {
                this.ctx.bindings.put("operation", (Object)this);
                if (this.ctx.compiledScripts != null && this.ctx.engine instanceof Compilable) {
                    Object compilingEngine;
                    CompiledScript script = this.ctx.compiledScripts.get("soapStartMessageScript");
                    if (script == null) {
                        compilingEngine = (Compilable)((Object)this.ctx.engine);
                        script = compilingEngine.compile(this.ctx.soapStartMessageScript);
                        this.ctx.compiledScripts.put("soapStartMessageScript", script);
                    }
                    compilingEngine = script.eval(this.ctx.bindings);
                } else {
                    Object script = this.ctx.engine.eval(this.ctx.soapStartMessageScript);
                }
            } else {
                if (factory == null) {
                    factory = SOAPConnectionFactory.newInstance();
                }
                this.connection = factory.createConnection();
                MessageFactory messageFactory = MessageFactory.newInstance();
                this.message = messageFactory.createMessage();
                SOAPPart soapPart = this.message.getSOAPPart();
                this.envelope = soapPart.getEnvelope();
                String xsiPrefix = null;
                boolean xsiPrefixAlread = false;
                for (Object prefix : this.port.wsdl.globalNamespaces.keySet()) {
                    String uri = (String)this.port.wsdl.globalNamespaces.get(prefix);
                    this.envelope.addNamespaceDeclaration((String)prefix, uri);
                    if (uri.equals(XSI_URI)) {
                        xsiPrefix = (String)prefix;
                    }
                    if (!prefix.equals(XSI_STD_PREFIX)) continue;
                    xsiPrefixAlread = true;
                }
                if (xsiPrefix == null) {
                    if (xsiPrefixAlread) {
                        this.XSI_PREFIX = "xsiStb";
                    }
                    this.envelope.addNamespaceDeclaration(this.XSI_PREFIX, XSI_URI);
                }
            }
        }
    }

    public void setCurrentElementToBody() throws SOAPException {
        this.currentElement = this.envelope.getBody();
    }

    public void setCurrentElementToHeader() throws SOAPException {
        this.currentElement = this.envelope.getHeader();
    }

    public SOAPElement openElement(String localName, String nameSpaceURI, String forcePrefix) throws SOAPException {
        this.text = null;
        if ((nameSpaceURI == null || nameSpaceURI.isEmpty()) && (this.currentElement instanceof SOAPBody || this.port.wsdl.prefixElement) && this.port.wsdl.targetNamespace != null) {
            nameSpaceURI = this.port.wsdl.targetNamespace;
        }
        if (nameSpaceURI != null && !nameSpaceURI.isEmpty()) {
            if (forcePrefix != null && !forcePrefix.isEmpty()) {
                this.currentElement = this.currentElement.addChildElement(localName, forcePrefix, nameSpaceURI);
            } else {
                String prefix = (String)this.port.wsdl.namespaces.getFrom((Object)nameSpaceURI);
                if (prefix == null) {
                    prefix = (String)this.port.wsdl.globalNamespaces.getFrom((Object)nameSpaceURI);
                }
                this.currentElement = prefix != null ? this.currentElement.addChildElement(localName, prefix, nameSpaceURI) : this.currentElement.addChildElement(localName);
            }
        } else {
            this.currentElement = this.currentElement.addChildElement(localName);
        }
        return this.currentElement;
    }

    @Override
    public void addText(String text) throws SOAPException {
        if (this.text == null) {
            this.text = new StringBuffer();
        }
        this.text.append(text);
    }

    @Override
    public void setAttribute(String name, String value) throws SOAPException {
        this.currentElement.setAttribute(name, value);
    }

    @Override
    public void endElement() throws SOAPException {
        if (this.text != null) {
            this.currentElement.addTextNode(this.text.toString());
            this.text = null;
        }
        this.currentElement = this.currentElement.getParentElement();
    }

    public void addContent() throws SOAPException {
    }

    public void setEnloseActionByQUote(boolean enloseActionByQUote) {
        this.enloseActionByQUote = enloseActionByQUote;
    }

    public void setNtlmMetadata(NtlmMetadata ntlmMetadata) {
        this.ntlmMetadata = ntlmMetadata;
    }

    public void addHeader() throws SOAPException {
        MimeHeaders headers = this.message.getMimeHeaders();
        if (this.actionURI != null && !this.actionURI.isEmpty()) {
            if (headers.getHeader("SOAPAction") != null) {
                headers.removeHeader("SOAPAction");
            }
            if (this.enloseActionByQUote) {
                headers.addHeader("SOAPAction", "\"" + this.actionURI + "\"");
            } else {
                headers.addHeader("SOAPAction", this.actionURI);
            }
        }
        this.message.saveChanges();
    }

    private SOAPMessage _invoke(URL url, String msgName, Boolean isOnRetry) throws InterruptedException, SOAPException, IOException {
        SOAPMessage reply = null;
        if (this.ctx.delayBetweenInvocation > 0 && !isOnRetry.booleanValue()) {
            Thread.sleep(this.ctx.delayBetweenInvocation);
        }
        reply = this.connection.call(this.message, (Object)url);
        if (this.port.wsdl.receivedMessagesFolder != null && reply != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.receivedMessagesFolder, String.valueOf(msgName) + ".out"));
            reply.writeTo((OutputStream)fos);
            fos.close();
        }
        return reply;
    }

    @Override
    public int invoke() throws Exception {
        this.isAlreadyInvokated = true;
        this.addHeader();
        try {
            String msgName = new Long(System.currentTimeMillis()).toString();
            if (this.port.wsdl.sentMessagesFolder != null) {
                FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, String.valueOf(msgName) + ".in"));
                this.message.writeTo((OutputStream)fos);
                fos.close();
            }
            final Proxy proxy = this.ctx.getProxy();
            URL url = (URL)this.ctx.secret((ISecretStatement)new ISecretStatement<URL>(){

                public URL execute(ISecretContext context) throws Throwable {
                    URL url = SoapOperation.this.ntlmMetadata != null ? URLUtil.createURL((String)((SoapPort)SoapOperation.this.port).address, (URLUtil.AuthenticationType)URLUtil.AuthenticationType.NTLM, (String)SoapOperation.this.ntlmMetadata.getFullNtlmUser(), (String)SoapOperation.this.ntlmMetadata.getNtlmPassword(), (Proxy)proxy, (String)SoapOperation.this.ctx.proxyUser, (String)SoapOperation.this.ctx.proxyPassword.decryptString(context)) : URLUtil.createURL((String)((SoapPort)SoapOperation.this.port).address, (URLUtil.AuthenticationType)URLUtil.AuthenticationType.BASIC, (String)SoapOperation.this.ctx.user, (String)SoapOperation.this.ctx.password.decryptString(context), (Proxy)proxy, (String)SoapOperation.this.ctx.proxyUser, (String)SoapOperation.this.ctx.proxyPassword.decryptString(context));
                    return url;
                }
            });
            this.exception = null;
            this.reply = null;
            int technicalErrorCount = 0;
            int functionalErrorCount = 0;
            while (technicalErrorCount <= this.ctx.technicalErrorRetryNumber && functionalErrorCount <= this.ctx.retryNumber) {
                try {
                    this.reply = null;
                    this.reply = this._invoke(url, msgName, technicalErrorCount + functionalErrorCount > 0);
                    if (this.reply == null || this.reply != null && this.reply.getSOAPBody().getFault() == null) break;
                    if (this.reply != null && this.reply.getSOAPBody().getFault() != null && this.ctx.retryDelay > 0 && ++functionalErrorCount <= this.ctx.retryNumber) {
                        Thread.sleep(this.ctx.retryDelay);
                    }
                    this.exception = null;
                }
                catch (Exception e2) {
                    this.exception = e2;
                    if (this.ctx.technicalErrorRetryDelay <= 0 || ++technicalErrorCount > this.ctx.technicalErrorRetryNumber) continue;
                    Thread.sleep(this.ctx.technicalErrorRetryDelay.intValue());
                }
            }
            if (this.exception != null) {
                ++this.port.wsdl.technicalErrorNumber;
                if (this.ctx.technicalErrorAcceptanceNumber > -1 && this.port.wsdl.technicalErrorNumber > this.ctx.technicalErrorAcceptanceNumber) {
                    throw this.exception;
                }
            }
            if (this.reply != null && this.reply.getSOAPBody().getFault() != null) {
                ++this.port.wsdl.errorNumber;
                if (this.port.wsdl.errorAcceptanceNumber > -1 && this.port.wsdl.errorAcceptanceNumber < this.port.wsdl.errorNumber) {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    this.reply.writeTo((OutputStream)outStream);
                    throw new EngineExceptionI(String.valueOf(Messages.getString("SoapOperation.0")) + this.port.wsdl.errorNumber + ")" + "\n" + outStream.toString());
                }
                return -1;
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void writeMessage(AbstractXmlWriterAPI xwa, String localName, String firstLocalName) throws EngineExceptionI {
        try {
            if (this.reply != null) {
                SOAPBody _body = this.reply.getSOAPBody();
                if (_body.getFault() == null) {
                    Iterator it = _body.getChildElements();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        if (node.getLocalName() != null) {
                            if (this.style == SoapStyle.RPC && node.getChildNodes().getLength() > 0) {
                                node = this.findFirstElementNode(node.getChildNodes(), localName);
                            } else if (firstLocalName == null || !node.getLocalName().equals(firstLocalName)) {
                                node = null;
                            }
                        } else {
                            node = null;
                        }
                        if (node == null) continue;
                        int nbelt = this.writeMessage(xwa.xmlw, node);
                        xwa.incNbOpenedElement(nbelt);
                    }
                }
            } else if (this.exception != null) {
                if (localName.equals(this.errorExceptionName)) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    this.exception.printStackTrace(pw);
                    xwa.xmlw.writeCharacters(sw.toString());
                } else if (localName.equals(this.errorMessageName)) {
                    xwa.xmlw.writeCharacters(this.exception.getMessage());
                }
            }
        }
        catch (SOAPException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private Node findFirstElementNode(NodeList list, String localName) {
        Node node = null;
        int i = 0;
        while (i < list.getLength()) {
            node = list.item(i);
            if (node.getNodeType() == 1 && node.getLocalName().equals(localName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int writeMessage(XMLStreamWriter xmlw, Node node) throws XMLStreamException, IOException {
        int ret = 0;
        if (node != null) {
            if (this.attachmentsFolder != null) {
                if (!new File(this.attachmentsFolder).exists()) {
                    throw new FileNotFoundException(String.valueOf(Messages.getString("SoapOperation.1")) + this.attachmentsFolder + Messages.getString("SoapOperation.2"));
                }
                if (!new File(this.attachmentsFolder).canWrite()) {
                    throw new IOException(String.valueOf(Messages.getString("SoapOperation.3")) + this.attachmentsFolder + ".");
                }
                Iterator it = this.reply.getAttachments();
                while (it.hasNext()) {
                    AttachmentPart part = (AttachmentPart)it.next();
                    String filename = part.getContentId();
                    FileOutputStream fos = null;
                    File f = new File(String.valueOf(this.attachmentsFolder) + "/" + filename.replaceAll("[\\\\/:*?\"<>|]", ""));
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    try {
                        try {
                            fos = new FileOutputStream(f);
                            IOUtils.copy((InputStream)part.getRawContent(), (OutputStream)fos);
                        }
                        catch (FileNotFoundException e) {
                            throw new IOException(String.valueOf(Messages.getString("SoapOperation.4")) + f.getAbsolutePath());
                        }
                        catch (Exception e) {
                            throw new IOException(String.valueOf(Messages.getString("SoapOperation.5")) + f.getAbsolutePath());
                        }
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                }
            }
            try {
                Node refItem;
                if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://www.w3.org/2004/08/xop/include") && node.getLocalName().equals("Include") && (refItem = node.getAttributes().getNamedItem("href")) != null) {
                    String str = refItem.getNodeValue();
                    URI uri = URI.create(str).normalize();
                    str = "<" + URLDecoder.decode(uri.toString(), "UTF-8") + ">";
                    Iterator it = this.reply.getAttachments();
                    while (it.hasNext()) {
                        InputStream input;
                        AttachmentPart part = (AttachmentPart)it.next();
                        String str2 = part.getContentId().replaceFirst("<", "<cid:");
                        if (!str2.equals(str) || (input = part.getBase64Content()) == null) continue;
                        byte[] buffer = new byte[1024];
                        int bytesRead;
                        while ((bytesRead = input.read(buffer)) != -1) {
                            if (bytesRead < 1024) {
                                xmlw.writeCharacters(new String(Arrays.copyOf(buffer, bytesRead), "UTF-8"));
                                continue;
                            }
                            xmlw.writeCharacters(new String(buffer, "UTF-8"));
                        }
                        return 0;
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(Messages.getString("SoapOperation.6"), e);
            }
            xmlw.writeStartElement(node.getLocalName());
            ret = 1;
            int i = 0;
            while (node.getAttributes().getLength() > i) {
                Node attr = node.getAttributes().item(i);
                String name = attr.getLocalName();
                if (name == null) {
                    name = attr.getNodeName();
                }
                if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().isEmpty() && attr.getNamespaceURI().equals(XSI_URI)) {
                    xmlw.writeAttribute(attr.getNamespaceURI(), name, attr.getNodeValue());
                } else {
                    xmlw.writeAttribute(name, attr.getNodeValue());
                }
                ++i;
            }
            i = 0;
            while (node.getChildNodes().getLength() > i) {
                Node child = node.getChildNodes().item(i);
                if (child.getNodeType() == 4) {
                    xmlw.writeCData(((CharacterData)child).getData());
                } else if (child.getNodeType() == 3) {
                    String data = ((CharacterData)child).getData();
                    xmlw.writeCharacters(data);
                } else {
                    ret += this.writeMessage(xmlw, child);
                }
                ++i;
            }
            xmlw.writeEndElement();
        }
        return ret;
    }

    @Override
    public boolean stopOpenOrClose() {
        return this.state == Operation.OperationState.OUTPUT && this.outputPartState == Operation.PartState.OPEN || this.state == Operation.OperationState.FAULT && this.faultPartState == Operation.PartState.OPEN || this.intoOutput && this.style == SoapStyle.RPC;
    }

    @Override
    public void writeFault(AbstractXmlWriterAPI xwa) throws EngineExceptionI {
        if (this.reply == null) {
            return;
        }
        try {
            SOAPBody _body = this.reply.getSOAPBody();
            if (_body.getFault() != null) {
                if (_body.getFault().getFaultCode() != null) {
                    xwa.writeStartElement("faultcode");
                    xwa.xmlw.writeCharacters(_body.getFault().getFaultCode());
                    xwa.xmlw.writeEndElement();
                }
                if (_body.getFault().getFaultActor() != null) {
                    xwa.writeStartElement("faultactor");
                    xwa.xmlw.writeCharacters(_body.getFault().getFaultActor());
                    xwa.xmlw.writeEndElement();
                }
                if (_body.getFault().getFaultString() != null) {
                    xwa.writeStartElement("faultstring");
                    xwa.xmlw.writeCharacters(_body.getFault().getFaultString());
                    xwa.xmlw.writeEndElement();
                }
                if (_body.getFault() != null && _body.getFault().getDetail() != null) {
                    Iterator it = _body.getFault().getDetail().getChildElements();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        int nbElt = this.writeMessage(xwa.xmlw, node);
                        xwa.incNbOpenedElement(nbElt);
                    }
                } else {
                    int nbElt = this.writeMessage(xwa.xmlw, (Node)_body.getFault());
                    xwa.incNbOpenedElement(nbElt);
                }
            }
        }
        catch (SOAPException e) {
            new EngineExceptionI((Throwable)e);
        }
        catch (XMLStreamException e) {
            new EngineExceptionI((Throwable)e);
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    @Override
    public void clear() {
    }

    public void appendChild(Node doc) {
        this.currentElement.getOwnerDocument().adoptNode(doc);
        this.currentElement.appendChild(doc);
    }

    @Override
    public void killOpenedConnections() {
    }

    public static enum SoapStyle {
        DOCUMENT,
        RPC;

    }
}

