/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.engine;

import com.indy.a.PasswordManagerI;
import com.indy.engine.core.classloader.IClassLoader;
import com.indy.engine.log.AbstractLog;
import com.indy.engine.log.EngineSessionManager;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.engine.log.object.IEngineActionHeader;
import com.indy.engine.log.object.IEngineLogHeader;
import com.indy.engine.log.object.IEngineSessionHeader;
import com.indy.engine.log.object.impl.ActionList;
import com.indy.engine.log.rdbms.RdbmsLog;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.net.URI;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EngineLog
extends AbstractLog {
    String host;
    int port;
    private AnalyticsEngineWrapper engine;
    RdbmsLog rdbmsLog;
    private String id;
    private EngineSessionManager.ObjectReader objectReader;
    private String logDirectory;
    private String name;
    private IClassLoader jdbcClassLoader;
    private Map<String, Object> versions;
    private String version;
    private String user;
    private String password;
    EngineRegistry eRegistry;

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public EngineLog(String name, String host, int port, String user, String password, String id, String logDirectory, IClassLoader jdbcClassLoader) {
        this.host = host;
        this.port = port;
        this.id = id;
        this.logDirectory = logDirectory;
        this.name = name;
        this.jdbcClassLoader = jdbcClassLoader;
        this.user = user;
        this.password = password;
    }

    public EngineLog(String name, AnalyticsEngineWrapper engine, String id, String host, Integer port, String user, String password, String logDirectory, IClassLoader jdbcClassLoader) {
        this(name, host, port, user, password, id, logDirectory, jdbcClassLoader);
        this.engine = engine;
        this.jdbcClassLoader = jdbcClassLoader;
    }

    public static boolean test(String host, int port, String user, String password, String logDirectory, IClassLoader jdbcClassLoader) throws Exception {
        EngineLog elog = null;
        try {
            elog = new EngineLog(host, host, port, user, password, null, logDirectory, jdbcClassLoader);
            boolean bl = elog.connect();
            return bl;
        }
        finally {
            if (elog != null) {
                elog.clear();
            }
        }
    }

    @Override
    public boolean connect(boolean notifyUI) throws Exception {
        if (this.engine != null) {
            try {
                EngineRegistry.isConnected(this.engine);
            }
            catch (Exception e) {
                this.engine = null;
            }
        }
        try {
            if (this.engine == null) {
                this.engine = EngineRegistry.getDefault().getEngine(this.host, this.port, this.user, this.password);
                this.versions = this.engine.getVersion();
                if (this.versions != null) {
                    this.version = (String)this.versions.get("runtime");
                }
                EngineRegistry.isConnected(this.engine);
            }
            if (this.rdbmsLog == null) {
                Map<String, Object> properties = this.engine.getLogProperties(null);
                String url = (String)properties.get("userLogRdbmsUrl");
                String cleanUrl = url.substring(8);
                URI urlDefault = URI.create(cleanUrl);
                Integer stringPort = urlDefault.getPort();
                URI runtimeUrl = URI.create(this.host);
                String cleanHost = "";
                if (this.host.startsWith("http")) {
                    if (this.host.startsWith("https")) {
                        cleanHost = String.valueOf(runtimeUrl.getHost()) + ":" + stringPort.toString() + (runtimeUrl.getPath() != null ? runtimeUrl.getPath() : "");
                        url = url.replace(":" + stringPort.toString(), "");
                        url = url.replace("localhost", cleanHost);
                    } else if (this.host.startsWith("http")) {
                        cleanHost = String.valueOf(runtimeUrl.getHost()) + ":" + stringPort.toString() + (runtimeUrl.getPath() != null ? runtimeUrl.getPath() : "");
                        url = url.replace(":" + stringPort.toString(), "");
                        url = url.replace("localhost", cleanHost);
                    }
                }
                String password = "";
                password = properties.containsKey("userLogRdbmsEncryptedPassword") ? EngineLog.testConnection2((String)properties.get("userLogRdbmsEncryptedPassword")) : (String)properties.get("userLogRdbmsPassword");
                this.rdbmsLog = new RdbmsLog(this.name, url, (String)properties.get("userLogRdbmsDriver"), (String)properties.get("userLogRdbmsUser"), password, (String)properties.get("userLogRdbmsSchemaName"), (String)properties.get("userLogRdbmsTablePrefix"), (String)properties.get("userLogRdbmsTimestampQuery"), null, this.logDirectory, this.jdbcClassLoader, true){

                    @Override
                    public String getLogId() {
                        return EngineLog.this.getLogId();
                    }
                };
                this.rdbmsLog.setObjectReader(this.objectReader);
            }
            this.connectionException = null;
            if (notifyUI) {
                this.notifyAllListener();
            }
        }
        catch (Exception e) {
            this.connectionException = e;
            if (notifyUI) {
                this.notifyAllListener();
            }
            throw e;
        }
        return this.rdbmsLog.connect(notifyUI);
    }

    @Override
    public boolean connect() throws Exception {
        return this.connect(true);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, IEngineActionHeader> refreshActionHeader(Map<String, Object> criteria) throws Exception {
        return this.rdbmsLog.refreshActionHeader(criteria);
    }

    @Override
    public Map<String, IEngineSessionHeader> refreshSessionHeader(Map<String, Object> criteria, boolean allIteration) throws Exception {
        return this.rdbmsLog.refreshSessionHeader(criteria, allIteration);
    }

    @Override
    public String getLogId() {
        return this.id;
    }

    @Override
    public Map<String, Map<String, Object>> refreshSessionVariable(Map<String, Integer> sessions, Map<String, Object> criteria) throws Exception {
        return this.rdbmsLog.refreshSessionVariable(sessions, criteria);
    }

    @Override
    public Map<String, Map<String, Object>> refreshSessionStatistics(Map<String, Integer> sessions, Map<String, Object> criteria, Set<String> statisticsName) throws Exception {
        return this.rdbmsLog.refreshSessionStatistics(sessions, criteria, statisticsName);
    }

    @Override
    public Map<String, Map<Integer, Map<String, Long>>> refreshSessionStatistics2(Map<String, Object> criteria, Set<String> statisticsName) throws Exception {
        return this.rdbmsLog.refreshSessionStatistics2(criteria, statisticsName);
    }

    @Override
    public Map<String, Map<String, Map<String, Object>>> refreshSessionErrorAndWarning(Map<String, Integer> sessions, Map<String, Object> criteria) throws Exception {
        return this.rdbmsLog.refreshSessionErrorAndWarning(sessions, criteria);
    }

    @Override
    public Map<String, Map<String, Object>> refreshActionVariable(Set<String> actions, String sessionId, int sessionIter, String deliveryId, String version, ActionList list) throws Exception {
        return this.rdbmsLog.refreshActionVariable(actions, sessionId, sessionIter, deliveryId, version, list);
    }

    @Override
    public Map<String, Map<String, Long>> refreshActionStatistic(Map<String, IEngineActionHeader> actions, String sessionId, int sessionIter, Set<String> statisticsName, String version) throws Exception {
        return this.rdbmsLog.refreshActionStatistic(actions, sessionId, sessionIter, statisticsName, version);
    }

    @Override
    public EngineSessionManager.ObjectReader getObjectReader() {
        return this.objectReader;
    }

    @Override
    public void setObjectReader(EngineSessionManager.ObjectReader objectReader) {
        this.objectReader = objectReader;
    }

    @Override
    public void clear() throws SQLException {
        this.engine = null;
        this.host = null;
        this.objectReader = null;
        if (this.rdbmsLog != null) {
            this.rdbmsLog.clear();
        }
        this.rdbmsLog = null;
    }

    @Override
    public Map<String, Object> refreshRuntimes() throws Exception {
        return this.rdbmsLog.refreshRuntimes();
    }

    @Override
    public Map<String, Object> getDeliveries() throws SQLException {
        return this.rdbmsLog.getDeliveries();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void refreshDeliveriesAndConfigurations() throws Exception {
        this.rdbmsLog.refreshDeliveriesAndConfigurations();
    }

    @Override
    public Set<String> getConfigurations() throws Exception {
        return this.rdbmsLog.getConfigurations();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Exception getConnectionException() {
        return this.connectionException;
    }

    @Override
    public Boolean isConnected() {
        if (this.rdbmsLog != null && this.rdbmsLog.isConnected().booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Map<String, IEngineActionHeader> refreshActionHeader2(String sessionId, String maxBeginActionDate, String maxEndActionDate, String version, Integer iter) throws Exception {
        return this.rdbmsLog.refreshActionHeader2(sessionId, maxBeginActionDate, maxEndActionDate, version, iter);
    }

    @Override
    public Map<Integer, IEngineLogHeader> refreshLogHeader(String sessionId, int lastNum) throws Exception {
        return this.rdbmsLog.refreshLogHeader(sessionId, lastNum);
    }

    @Override
    public Map<String, Map<String, Object>> refreshStaticActionVariable(String deliveryId) throws Exception {
        return this.rdbmsLog.refreshStaticActionVariable(deliveryId);
    }

    public static String testConnection(String str) {
        try {
            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            return semaphoreManager.setSemaphore(true, str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encrypt(KeyStore ks, String alias, String keystorePassword, String toEncrypt, String blockCipherModeOperation) throws OtherExceptionI, EngineExceptionI {
        PasswordManagerI manager = new PasswordManagerI(ks, alias, keystorePassword, blockCipherModeOperation);
        return manager.encryptPassword(toEncrypt);
    }

    public static String decrypt(KeyStore ks, String alias, String keystorePassword, String toDecrypt, String blockCipherModeOperation) throws OtherExceptionI, EngineExceptionI {
        PasswordManagerI manager = new PasswordManagerI(ks, alias, keystorePassword, blockCipherModeOperation);
        return manager.decryptPassword(toDecrypt);
    }

    public static String testConnection2(String str) {
        try {
            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            String str2 = semaphoreManager.getStringAsciiInfo(str);
            return str2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Map<String, Map<String, String>> refreshAltIds(String deliveryId) throws Exception {
        return this.rdbmsLog.refreshAltIds(deliveryId);
    }

    @Override
    public Set<String> getSessionExecutedByAction(String sessionId, String actionId) throws Exception {
        return this.rdbmsLog.getSessionExecutedByAction(sessionId, actionId);
    }

    @Override
    public List<IEngineSessionHeader> getSessionChildSession(String sessionId) throws Exception {
        return this.rdbmsLog.getSessionChildSession(sessionId);
    }
}

