/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.engine;

import com.healthmarketscience.rmiio.DirectRemoteInputStream;
import com.healthmarketscience.rmiio.GZIPRemoteInputStream;
import com.indy.engine.core.common.FunctionType;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.log.EngineSessionManager;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineFactory;
import com.indy.engine.log.exchange.DeliveryMapWrapper;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineRegistry {
    static EngineRegistry INSTANCE = new EngineRegistry();
    private static Logger logger = LoggerFactory.getLogger(EngineSessionManager.class);
    Map<String, LocalSession> engines = new HashMap<String, LocalSession>();

    private EngineRegistry() {
    }

    public static EngineRegistry getDefault() {
        return INSTANCE;
    }

    private void logException(Exception e) {
        logger.debug(e.getMessage());
    }

    private static String computeId(String host, Integer port, String user, String password) {
        return String.valueOf(host) + ":" + port + ":" + user + ":" + password;
    }

    public synchronized LocalSession getLocalSession(String host, Integer port, String user, String password) throws Exception {
        AnalyticsEngineWrapper e = this.getEngine(host, port, user, password);
        if (e != null) {
            String id = EngineRegistry.computeId(host, port, user, password);
            return this.engines.get(id);
        }
        return null;
    }

    public static boolean isConnected(AnalyticsEngineWrapper iEngineClient) throws Exception {
        return iEngineClient.isConnected();
    }

    public synchronized AnalyticsEngineWrapper getEngine(String host, Integer port, String user, String password) throws Exception {
        String id = EngineRegistry.computeId(host, port, user, password);
        LocalSession engine = this.engines.get(id);
        AnalyticsEngineWrapper wrappedEngine = null;
        Exception e1 = null;
        if (engine != null) {
            try {
                wrappedEngine = new AnalyticsEngineWrapper(engine.getRemoteObject());
                if (!EngineRegistry.isConnected(wrappedEngine)) {
                    engine = null;
                }
            }
            catch (Exception e) {
                e1 = e;
                engine = null;
            }
        }
        if (engine == null) {
            try {
                HashMap<String, String> credentials = new HashMap<String, String>();
                if (user != null && !user.isEmpty()) {
                    credentials.put("user", user);
                    credentials.put("password", password);
                }
                engine = EngineFactory.INSTANCE.create(host, port, credentials);
                wrappedEngine = new AnalyticsEngineWrapper(engine.getRemoteObject());
                EngineRegistry.isConnected(wrappedEngine);
            }
            catch (Exception e) {
                e1 = e;
                engine = null;
                this.logException(e);
            }
        }
        if (engine != null) {
            this.engines.put(id, engine);
        } else if (e1 != null) {
            throw e1;
        }
        return wrappedEngine;
    }

    public void resumeTrigger(String host, Integer port, String user, String password, String triggerName, String triggerGroup) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("triggerName", triggerName);
            if (this.isRuntimes17_1_16(host, port)) {
                parameters.put("triggerGroupName", triggerGroup);
                EngineRegistry.getDefault().getEngine(host, port, user, password).resumeTrigger(parameters);
            } else if (this.isRuntimes17_1_14(host, port, user, password)) {
                parameters.put("triggerGroupName", "Cron Expression");
                EngineRegistry.getDefault().getEngine(host, port, user, password).resumeTrigger(parameters);
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void pauseTrigger(String host, Integer port, String user, String password, String triggerName, String triggerGroup) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("triggerName", triggerName);
            if (this.isRuntimes17_1_16(host, port)) {
                parameters.put("triggerGroupName", triggerGroup);
                EngineRegistry.getDefault().getEngine(host, port, user, password).pauseTrigger(parameters);
            } else if (this.isRuntimes17_1_14(host, port, user, password)) {
                parameters.put("triggerGroupName", "Cron Expression");
                EngineRegistry.getDefault().getEngine(host, port, user, password).pauseTrigger(parameters);
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void removeJobTrigger(String host, Integer port, String user, String password, String triggerName, String triggerGroup) {
        try {
            this.getEngine(host, port, user, password).removeJobTrigger(triggerName);
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public boolean isQuartz2(String host, Integer port, String user, String password) {
        try {
            Map<String, Object> versions = this.getEngine(host, port, user, password).getVersion();
            return versions != null && versions.containsKey("scheduler_quartz") && ((String)versions.get("scheduler_quartz")).compareTo("2.1.6") >= 0;
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
    }

    public List<String> getLstDeliveries(String host, Integer port, String user, String password, Boolean includeWsdl) throws Exception {
        AnalyticsEngineWrapper engine = this.getEngine(host, port, user, password);
        HashMap<String, String> params = null;
        if (includeWsdl != null && includeWsdl.booleanValue()) {
            params = new HashMap<String, String>();
            params.put("dir", "wsdl");
        }
        return engine.getLstDeliveries(params);
    }

    public Map<String, Object> getDeliveryParameters(String host, Integer port, String deliveryName, String triggerName, String user, String password) {
        Map deliveryParams;
        Map<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, String> mapDeliv = new HashMap<String, String>();
        HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
        Map<String, Object> mapAnswer = null;
        mapDeliv.put("name", deliveryName);
        mapDeliv.put("trigger", triggerName);
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            try {
                mapQuestion.put(FunctionType.getDeliveryParams.name(), mapDeliv);
                mapAnswer = engine.get(mapQuestion);
            }
            catch (Exception e) {
                mapQuestion = new HashMap();
                mapQuestion.put(FunctionType.getDeliveryParams.name(), deliveryName);
                mapAnswer = engine.get(mapQuestion);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (mapAnswer != null && (deliveryParams = (Map)mapAnswer.get(FunctionType.getDeliveryParams.name())).containsKey("parameters")) {
            parameters = (Map)deliveryParams.get("parameters");
        }
        return parameters;
    }

    public Map<String, Object> getTriggerDetails(String host, Integer port, String user, String password, String triggerName, String triggerGroup) {
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            return engine.getTriggerDetail(triggerName);
        }
        catch (Exception e) {
            this.logException(e);
            return Collections.emptyMap();
        }
    }

    private boolean isRuntimesXXX(Map<String, Object> versions, int[] v) {
        int index;
        String version = versions.get("runtime").toString();
        if ((version = version.toLowerCase()).startsWith("s")) {
            version = version.substring(1);
        }
        if ((index = version.indexOf("_")) > -1) {
            version = version.substring(0, index);
        }
        int i = 0;
        String[] stringArray = version.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            int a = v[i];
            int b = Integer.valueOf(str);
            ++i;
            if (b > a) {
                return true;
            }
            if (b != a) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isRuntimes17_4_2(String host, Integer port, String user, String password) {
        try {
            Map<String, Object> versions = this.getEngine(host, port, user, password).getVersion();
            return this.isRuntimesXXX(versions, new int[]{17, 4, 2});
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
    }

    public void deleteDelivery(String host, Integer port, String user, String password, String delivName, String repo) throws Exception {
        AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
        HashMap<String, Object> deleteMap = new HashMap<String, Object>();
        deleteMap.put("name", delivName);
        deleteMap.put("dir", repo);
        engine.removeDelivery(deleteMap);
    }

    public boolean isRuntimes17_1_14(String host, Integer port, String user, String password) {
        try {
            Map<String, Object> versions = this.getEngine(host, port, user, password).getVersion();
            return this.isRuntimesXXX(versions, new int[]{17, 1, 14});
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
    }

    public boolean isRuntimes17_3_0(String host, Integer port, String user, String password) {
        try {
            Map<String, Object> versions = this.getEngine(host, port, user, password).getVersion();
            int[] nArray = new int[3];
            nArray[0] = 17;
            nArray[1] = 3;
            return this.isRuntimesXXX(versions, nArray);
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
    }

    public boolean isRuntimes17_2_16(String host, Integer port, String user, String password) {
        try {
            Map<String, Object> versions = this.getEngine(host, port, user, password).getVersion();
            return this.isRuntimesXXX(versions, new int[]{17, 2, 16});
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
    }

    public boolean isRuntimes17_1_16(String host, Integer port) {
        return false;
    }

    public List<String> getAllPurge(String host, Integer port, String user, String password) {
        ArrayList<String> purgesName = new ArrayList<String>();
        try {
            List<String> triggers;
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            if (engine != null && !(triggers = engine.getLstTriggers()).isEmpty()) {
                for (String trigger : triggers) {
                    try {
                        if (!trigger.startsWith("CRON_SystemPurgeOperation")) continue;
                        purgesName.add(trigger);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        return purgesName;
    }

    public DeliveryMapWrapper getDelivery(String host, Integer port, String user, String password, String deliveryName, String id, boolean isWsdl) throws Exception {
        AnalyticsEngineWrapper engine = this.getEngine(host, port, user, password);
        return this.getDelivery(engine, deliveryName, id, isWsdl);
    }

    public DeliveryMapWrapper getDelivery(AnalyticsEngineWrapper engine, String deliveryName, String id, boolean isWsdl) throws Exception {
        Map<String, Map<String, Object>> deliverysMap;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            params.put("ids", ids);
        }
        if (isWsdl) {
            params.put("dir", "wsdl");
        }
        if ((deliverysMap = engine.getDeliveries(params)).containsKey(deliveryName)) {
            return new DeliveryMapWrapper(deliveryName, deliverysMap.get(deliveryName));
        }
        return null;
    }

    public DeliveryMapWrapper getDelivery(String host, Integer port, String user, String password, String deliveryName, String dir) throws Exception {
        AnalyticsEngineWrapper engine = this.getEngine(host, port, user, password);
        HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
        HashMap<String, Object> mapDeliv = new HashMap<String, Object>();
        mapDeliv.put("name", deliveryName);
        mapDeliv.put("noScheduleInfo", true);
        mapDeliv.put("dir", dir);
        Map<String, Object> mapAnswer = null;
        try {
            mapQuestion.put(FunctionType.getDeliveryParams.name(), mapDeliv);
            mapAnswer = engine.get(mapQuestion);
        }
        catch (Exception e) {
            mapQuestion = new HashMap();
            mapQuestion.put(FunctionType.getDeliveryParams.name(), deliveryName);
            mapAnswer = engine.get(mapQuestion);
        }
        return new DeliveryMapWrapper(deliveryName, (Map)mapAnswer.get(FunctionType.getDeliveryParams.name()));
    }

    public synchronized void publishDelivery(String host, Integer port, String user, String password, InputStream in, String name, Boolean asWsdl) throws Exception {
        boolean isHttp;
        LocalSession ls = this.getLocalSession(host, port, user, password);
        AnalyticsEngineWrapper engine = new AnalyticsEngineWrapper(ls.getRemoteObject());
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> wsdlParams = null;
        params.put("name", name);
        if (asWsdl != null && asWsdl.booleanValue()) {
            params.put("toDir", "wsdl");
            wsdlParams = new HashMap<String, Object>();
            wsdlParams.put("action", "build");
        }
        String version = engine.getApiVersion();
        Map connectionInfo = null;
        if (version.compareTo("s17.6.3") >= 0) {
            connectionInfo = ls.getConnectionInformation();
        }
        boolean bl = isHttp = connectionInfo != null && connectionInfo.get("protocol") != null && connectionInfo.get("protocol").equals("http");
        if (isHttp) {
            engine.putDelivery(in, params);
        } else {
            Object istream = version.compareTo("1.6.0.3") >= 0 ? new DirectRemoteInputStream((InputStream)new BufferedInputStream(in), true) : new GZIPRemoteInputStream((InputStream)new BufferedInputStream(in));
            engine.putDelivery(istream, params);
        }
        if (wsdlParams != null) {
            engine.soapServerAction(wsdlParams);
        }
    }

    public boolean isConnected(String host, int port, String user, String password) throws Exception {
        AnalyticsEngineWrapper engine = this.getEngine(host, port, user, password);
        return EngineRegistry.isConnected(engine);
    }

    public List<Map<String, Object>> getLstSchedules(String host, Integer port, String user, String password, String name) {
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            if (this.isRuntimes17_3_0(host, port, user, password)) {
                name = null;
            }
            return engine.getLstSchedules(name);
        }
        catch (Exception e) {
            this.logException(e);
            return null;
        }
    }

    public boolean isSchedulePaused(String host, int port, String user, String password, String triggerName, String deliveryTriggerGroup) {
        block4: {
            Object triggerState;
            block5: {
                AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
                Map<String, Object> triggerDetail = engine.getTriggerDetail(triggerName);
                if (triggerDetail == null || !triggerDetail.containsKey("triggerState")) break block4;
                triggerState = triggerDetail.get("triggerState");
                if (!(triggerState instanceof String) || !((String)triggerDetail.get("triggerState")).equalsIgnoreCase("PAUSED")) break block5;
                return true;
            }
            try {
                if (triggerState instanceof Integer && (Integer)triggerState == 1) {
                    return true;
                }
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        return false;
    }

    public boolean isExternalizedDelivery(String host, int port, String user, String password, String deliveryName, String repoDir, String logLevel) {
        boolean externalized = false;
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            HashMap<String, Object> mapDeliv = new HashMap<String, Object>();
            mapDeliv.put("name", deliveryName);
            mapDeliv.put("noScheduleInfo", true);
            mapDeliv.put("dir", repoDir);
            mapDeliv.put("logLevel", logLevel);
            Map<String, Object> mapAnswer = null;
            HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
            mapQuestion.put(FunctionType.getDeliveryParams.name(), mapDeliv);
            mapAnswer = engine.get(mapQuestion);
            Map mapDeliveryParams = (Map)mapAnswer.get(FunctionType.getDeliveryParams.name());
            if (mapDeliveryParams.containsKey("externalized")) {
                externalized = (Boolean)mapDeliveryParams.get("externalized");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return externalized;
    }

    public String[] getDeliveryConfiguration(String host, int port, String user, String password, String deliveryName, String repoDir, String logLevel) {
        String configurations = null;
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            HashMap<String, Object> mapDeliv = new HashMap<String, Object>();
            mapDeliv.put("name", deliveryName);
            mapDeliv.put("noScheduleInfo", true);
            mapDeliv.put("dir", repoDir);
            mapDeliv.put("logLevel", logLevel);
            Map<String, Object> mapAnswer = null;
            HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
            mapQuestion.put(FunctionType.getDeliveryParams.name(), mapDeliv);
            mapAnswer = engine.get(mapQuestion);
            Map mapDeliveryParams = (Map)mapAnswer.get(FunctionType.getDeliveryParams.name());
            if (mapDeliveryParams.containsKey("configurationCode")) {
                configurations = (String)mapDeliveryParams.get("configurationCode");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return configurations == null ? null : configurations.split(" ");
    }

    public void executeDelivery(String host, int port, String user, String password, String deliveryName, String sessionName, Map<String, Object> variables, String configuration, String repoDir, String logLevel) throws RuntimeException, Exception {
        try {
            HashMap<String, Object> outParameters = new HashMap<String, Object>();
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            if (sessionName != null && !sessionName.isEmpty()) {
                outParameters.put("sessName", sessionName);
            }
            if (variables != null && !variables.isEmpty()) {
                outParameters.put("variables", variables);
            }
            if (configuration != null) {
                outParameters.put(ParameterType.configuration.name(), configuration);
            }
            if (logLevel != null) {
                outParameters.put("logLevel", logLevel);
            }
            outParameters.put("launchMode", "WEB_INTERACTIVE");
            outParameters.put("executionMode", "MEMORY");
            outParameters.put("dir", repoDir);
            outParameters.put("guestHost", InetAddress.getLocalHost().getHostName());
            engine.executeDelivery(deliveryName, outParameters);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

