/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.engine;

import com.indy.engine.common.IEngineConnection;
import com.indy.engine.common.IEngineServerAPIV1_2;
import com.indy.engine.common.IRemoteSessionV01;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.engine.log.engine.Engine;
import com.indy.engine.log.engine.EngineFactory;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.ParseException;
import java.util.Map;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class RmiEngine
implements Engine {
    private String host;
    private int port;
    private Map<String, String> credentials;
    private EngineFactory.Protocol protocol;

    public RmiEngine(String host, int port, Map<String, String> credentials, EngineFactory.Protocol protocol) {
        this.host = host;
        this.port = port;
        this.credentials = credentials;
        this.protocol = protocol;
    }

    @Override
    public LocalSession getEngine() throws Exception {
        return RmiEngine.getRmiEngine(this.host, this.port, this.credentials, this.protocol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalSession getRmiEngine(String host, int port, Map<String, String> credentials, EngineFactory.Protocol protocol) throws Exception {
        Remote remote;
        if (protocol == EngineFactory.Protocol.rmis) {
            host = host.replace("rmis://", "");
        } else if (protocol == EngineFactory.Protocol.rmi) {
            host = host.replace("rmi://", "");
        }
        RemoteHolder remoteHolder = null;
        try {
            remoteHolder = RmiEngine.getRemote(host, port, protocol);
            remote = remoteHolder.remote;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        IEngineServerAPIV1_2 engine = null;
        if (remote instanceof IEngineConnection) {
            Object o = ((IEngineConnection)remote).logIn(null, credentials);
            if (!(o instanceof IEngineClient)) throw new RemoteException(o.getClass() + "EngineFactory.3");
            engine = (IEngineClient)o;
        } else {
            if (!(remote instanceof IEngineServerAPIV1_2)) throw new RemoteException(remote.getClass() + "EngineFactory.4");
            engine = (IEngineServerAPIV1_2)remote;
        }
        RemoteSessionInfo rsi = null;
        if (!(engine instanceof IEngineClient)) return new LocalSession(host, port, Boolean.valueOf(remoteHolder.isSSL), null, (IEngineClient)engine, rsi);
        if (!(engine instanceof IRemoteSessionV01)) return new LocalSession(host, port, Boolean.valueOf(remoteHolder.isSSL), null, (IEngineClient)engine, rsi);
        try {
            rsi = RemoteSessionInfo.parse(((IRemoteSessionV01)engine).getRemoteSessionInfo());
            return new LocalSession(host, port, Boolean.valueOf(remoteHolder.isSSL), null, (IEngineClient)engine, rsi);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new LocalSession(host, port, Boolean.valueOf(remoteHolder.isSSL), null, (IEngineClient)engine, rsi);
    }

    private static RemoteHolder getRemote(String host, int port, EngineFactory.Protocol protocol) throws Exception {
        if (protocol == EngineFactory.Protocol.rmis) {
            Registry registry = LocateRegistry.getRegistry(host, port, new SslRMIClientSocketFactory());
            return new RemoteHolder(registry.lookup("EngineServerAPI"), true);
        }
        try {
            Registry registry = LocateRegistry.getRegistry(host, new Integer(port));
            Remote obj = registry.lookup("EngineServerAPI");
            return new RemoteHolder(registry.lookup("EngineServerAPI"), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (protocol == EngineFactory.Protocol.auto) {
                Registry registry = LocateRegistry.getRegistry(host, port, new SslRMIClientSocketFactory());
                return new RemoteHolder(registry.lookup("EngineServerAPI"), true);
            }
            throw ex;
        }
    }

    private static class RemoteHolder {
        Remote remote;
        boolean isSSL;

        RemoteHolder(Remote remote, boolean isSSL) {
            this.remote = remote;
            this.isSSL = isSSL;
        }
    }
}

