/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.object;

import com.indy.engine.log.object.Criteria;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class SessionCriteria
extends Criteria {
    private SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public SessionCriteria(Map<String, Object> map) {
        super(map);
    }

    public Set<String> getSessionIds() {
        return this.get("sessionId", String.class);
    }

    public String getFilter() {
        return (String)this.map.get("filter");
    }

    public Set<Integer> getStatusList() {
        return this.get("statusList", Integer.class);
    }

    public int getNbSesions() {
        int nbSessions;
        int n = nbSessions = this.map != null && this.map.get("nbSessions") != null ? (Integer)this.map.get("nbSessions") : -1;
        if (nbSessions == -1) {
            nbSessions = this.getSessionIds().size() == 1 ? -2 : 20;
        }
        return nbSessions;
    }

    public Set<String> getConfigurations() {
        return this.get("configurations", String.class);
    }

    public Set<String> getSessionNames() {
        return this.get("sessionNames", String.class);
    }

    public Set<String> getDeliveryNames() {
        return this.get("deliveries", String.class);
    }

    public Set<String> getDeliveryIds() {
        return this.get("deliveryIds", String.class);
    }

    public Set<String> getPackageIds() {
        return this.get("packageIds", String.class);
    }

    public Set<String> getProcessIds() {
        return this.get("processIds", String.class);
    }

    public Set<String> getRuntimes() {
        return this.get("runtimes", String.class);
    }

    public Set<String> getGuestHosts() {
        return this.get("guestHosts", String.class);
    }

    public Set<String> getLaunchMode() {
        return this.get("launchModes", String.class);
    }

    public Set<String> getExecMode() {
        return this.get("execModes", String.class);
    }

    public Date getMinDate() {
        Date date = (Date)this.map.get("beginDate");
        if (date != null) {
            try {
                date = this.sd.parse(this.sd.format(date));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }

    public Date getMaxDate() {
        Date date = (Date)this.map.get("endDate");
        if (date != null) {
            try {
                date = new Date(this.sd.parse(this.sd.format(date)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }

    public String getMinDuration() {
        return (String)this.map.get("minDuration");
    }

    public String getMaxDuration() {
        return (String)this.map.get("maxDuration");
    }

    public Date getMinDateTime() {
        return (Date)this.map.get("beginDateTime");
    }

    public Date getMaxDateTime() {
        Date date = (Date)this.map.get("endDateTime");
        return date;
    }

    public Long getMinDurationMs() {
        return (Long)this.map.get("minDurationMs");
    }

    public Long getMaxDurationMs() {
        return (Long)this.map.get("maxDurationMs");
    }

    public boolean isSessionNamesCaseSensitiv() {
        if (this.map.containsKey("sessNamesCaseSensitiv")) {
            return (Boolean)this.map.get("sessNamesCaseSensitiv");
        }
        return false;
    }

    public boolean isSessionChildStandalone() {
        if (this.map.containsKey("sessionChildStandalone")) {
            return (Boolean)this.map.get("sessionChildStandalone");
        }
        return false;
    }

    public String getBoundaryMode() {
        return (String)this.map.get("boundaryMode");
    }
}

