/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.object.impl;

import com.indy.engine.log.object.IEngineActionHeader;
import com.indy.engine.log.reader.IActionHeaderReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EngineActionHeader
implements IEngineActionHeader {
    private Object data;
    private String id;
    private int iter;
    private String name;
    private String parentId;
    private int parentIter = 1;
    private int sessIter;
    private String strEndDate;
    private String strBeginDate;
    private String realName;
    private String version;
    private int nbExecution;
    private int nbBindExecution;
    private Date endDate;
    private Date beginDate;
    int status;
    public SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    @Override
    public int getParentIter() {
        return this.parentIter;
    }

    @Override
    public void setParentIter(int parentIter) {
        this.parentIter = parentIter;
    }

    public EngineActionHeader(IActionHeaderReader reader) {
        try {
            this.id = reader.getId();
            this.iter = reader.getIter();
            this.strEndDate = reader.getStrEndDate();
            this.strBeginDate = reader.getStrBeginDate();
            this.name = reader.getName();
            this.parentId = reader.getParentId();
            this.sessIter = reader.getSessIter();
            this.realName = reader.getRealName();
            this.status = reader.getState();
            this.nbExecution = reader.getNbExecution();
            this.nbBindExecution = reader.getNbBindExecution();
            if (this.realName == null) {
                int index = this.name.lastIndexOf("/");
                this.realName = index > -1 ? this.name.substring(index + 1) : this.name;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getIter() {
        return this.iter;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public int getSessionIter() {
        return this.sessIter;
    }

    @Override
    public String getUUID() {
        return String.valueOf(this.getSessionIter()) + "|" + this.getId() + "." + this.getIter();
    }

    @Override
    public String getParentUUID() {
        return String.valueOf(this.getSessionIter()) + "|" + this.getParentId() + "." + this.getParentIter();
    }

    @Override
    public String getStrEndDate() {
        return this.strEndDate;
    }

    @Override
    public String getStrBeginDate() {
        return this.strBeginDate;
    }

    @Override
    public String getRealName() {
        return this.realName;
    }

    @Override
    public Date getBeginDate() {
        if (this.beginDate == null && this.strBeginDate != null) {
            try {
                this.beginDate = this.sdf.parse(this.strBeginDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return this.beginDate;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null && this.strEndDate != null) {
            try {
                this.endDate = this.sdf.parse(this.strEndDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return this.endDate;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public int getNbExecution() {
        return this.nbExecution;
    }
}

