/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.object.impl;

import com.indy.engine.log.object.IEngineSessionHeader;
import com.indy.engine.log.reader.ISessionHeaderReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class EngineSessionHeader
implements IEngineSessionHeader {
    private Object data;
    protected int status;
    private String idLog;
    protected String strBeginDate;
    protected String strEndDate;
    protected String id;
    protected int iter;
    protected String parentId;
    protected long offset;
    public SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public EngineSessionHeader(ISessionHeaderReader rshr, String idLog) {
        this.idLog = idLog;
        try {
            this.id = rshr.getId();
            this.iter = rshr.getIter();
            this.status = rshr.getStatus();
            this.strBeginDate = rshr.getStrBeginDate();
            this.strEndDate = rshr.getStrEndDate();
            this.parentId = rshr.getParentSessionId();
            this.offset = rshr.getOffset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EngineSessionHeader() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getEndDate() {
        if (this.strEndDate != null) {
            try {
                return this.sdf.parse(this.strEndDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Date getBeginDate() {
        if (this.strBeginDate != null) {
            try {
                return this.sdf.parse(this.strBeginDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void setIdLog(String reportLog) {
        this.idLog = reportLog;
    }

    @Override
    public String getIdLog() {
        return this.idLog;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void clear() {
        this.dispose();
        this.data = null;
        this.id = null;
        this.idLog = null;
        this.strBeginDate = null;
        this.strEndDate = null;
    }

    public abstract void dispose();

    @Override
    public int getIter() {
        return this.iter;
    }

    @Override
    public String getParentSessionId() {
        return this.parentId;
    }

    @Override
    public String getUUID() {
        return String.valueOf(this.id) + "." + this.iter;
    }

    @Override
    public String getStrEndDate() {
        return this.strEndDate;
    }

    @Override
    public String getStrBeginDate() {
        return this.strBeginDate;
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }
}

