/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.internal;

import com.indy.addons.internal.Messages;
import com.indy.engine.core.externalvalueresolver.ExternalValueResolverManager;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.osgihook.utils.JavaProps;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.semarchy.xdi.designer.core.services.IModuleClassLoaderProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={IExternalValueResolver.class})
public class ComponentExternalValueResolver
implements IExternalValueResolver {
    private ExternalValueResolverManager resolver;
    @Reference
    private IModuleClassLoaderProvider moduleClProvider;
    private Watcher watcher;

    private String getRuntimePath() {
        String runtimePath = Activator.getDefault().readProperty(JavaProps.RUNTIME_HOME);
        return runtimePath;
    }

    private void createResolver() throws ResolverInitialisationException {
        String runtimePath = this.getRuntimePath();
        File confFile = new File(String.valueOf(runtimePath) + "/properties/engineParameters.xml");
        ExternalValueResolverManager resolver = new ExternalValueResolverManager(){
            IPluginFactory.IRelativePathResolver relativePathResolver;
            {
                this.relativePathResolver = new RelativePathResolver();
            }

            protected ClassLoader getConfigurationClassLoader() throws Exception {
                return ((BundleWiring)Platform.getBundle((String)"com.indy.engine.core").adapt(BundleWiring.class)).getClassLoader();
            }

            protected ClassLoader getModuleClassLoader(String moduleName) throws ClassLoaderServiceProvider.ClassLoaderServiceException, Exception {
                ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                return ComponentExternalValueResolver.this.moduleClProvider.getClassLoader(ccl, moduleName, null);
            }

            protected IPluginFactory.IRelativePathResolver getRelativePathResolver() {
                return this.relativePathResolver;
            }
        };
        try {
            resolver.init(String.valueOf(runtimePath) + "/properties/engineParameters.xml");
        }
        catch (Exception t) {
            throw new ResolverInitialisationException(String.format(Messages.ComponentExternalValueResolver_11, confFile.getAbsolutePath(), t.getMessage()), t);
        }
        try {
            this.watcher = new Watcher(confFile.toPath());
            this.watcher.watchConfigurationFile();
        }
        catch (Exception ex) {
            throw new ResolverInitialisationException(ex);
        }
        this.resolver = resolver;
    }

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
        if (this.watcher != null) {
            this.watcher.th.interrupt();
            this.watcher = null;
        }
    }

    private void unregisterComponent() {
        if (this.watcher != null) {
            this.watcher.th.interrupt();
            this.watcher = null;
        }
        this.resolver = null;
    }

    private ExternalValueResolverManager getResolver() throws Exception {
        if (this.resolver == null) {
            this.createResolver();
        }
        return this.resolver;
    }

    public String resolve(String value) throws Exception {
        return this.getResolver().replace(value);
    }

    public void executeSecured(IExternalValueResolver.SecuredRunner runnable) throws Exception {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            throw this.handleException(t, runnable.getFailure());
        }
    }

    public <T> T executeSecured(IExternalValueResolver.SecuredRunnerWithResut<T> runnable) throws Exception {
        try {
            return (T)runnable.runWithResult();
        }
        catch (Throwable t) {
            throw this.handleException(t, runnable.getFailure());
        }
    }

    private Exception handleException(Throwable executionException, Exception resultingException) {
        if (executionException instanceof IExternalValueResolverPlugin.ExternalValueResolverException) {
            return (Exception)executionException;
        }
        if (executionException instanceof ResolverInitialisationException) {
            return (Exception)((ResolverInitialisationException)executionException).getCause();
        }
        return resultingException;
    }

    public boolean needResolution(String ... value) {
        return ExternalValueResolverManager.needResolution((String[])value);
    }

    private class RelativePathResolver
    implements IPluginFactory.IRelativePathResolver {
        private RelativePathResolver() {
        }

        public String resolve(String path) {
            block4: {
                try {
                    if (path != null) break block4;
                    return null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return path;
                }
            }
            Path p = Paths.get(path, new String[0]);
            if (p.toFile().isAbsolute()) {
                return path;
            }
            p = Paths.get(ComponentExternalValueResolver.this.getRuntimePath(), path);
            return p.toFile().getAbsolutePath();
        }
    }

    private class ResolverInitialisationException
    extends Exception {
        public ResolverInitialisationException(Exception ex) {
            super(ex);
        }

        public ResolverInitialisationException(String message, Throwable t) {
            super(message, t);
        }
    }

    private class Watcher {
        Thread th;
        WatchService watchService = FileSystems.getDefault().newWatchService();
        boolean waiting = true;

        Watcher(Path configurationFilePath) throws IOException {
            configurationFilePath.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        void processEvents() throws InterruptedException {
            WatchKey key;
            while (this.waiting && (key = this.watchService.take()) != null) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path p = (Path)event.context();
                    if (!p.getName(0).toString().equals("engineParameters.xml")) continue;
                    this.waiting = false;
                }
                key.reset();
            }
        }

        private void watchConfigurationFile() {
            this.th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Watcher.this.processEvents();
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                Watcher.this.watchService.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (!Watcher.this.waiting) {
                                ComponentExternalValueResolver.this.unregisterComponent();
                            }
                        }
                    }
                    finally {
                        try {
                            Watcher.this.watchService.close();
                        }
                        catch (IOException iOException) {}
                        if (!Watcher.this.waiting) {
                            ComponentExternalValueResolver.this.unregisterComponent();
                        }
                    }
                }
            }, "Configuration Watcher");
            this.th.setDaemon(true);
            this.th.start();
        }
    }
}

