/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.xml.wizard;

import com.indy.addons.xml.XmlStreamReverser;
import com.indy.addons.xml.XmlUtil;
import com.indy.addons.xml.wizard.Messages;
import com.indy.addons.xml.wizard.XmlBeanWizard;
import com.semarchy.xdi.designer.core.utils.EnvironmentVariableHelper;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class XmlWizardControler {
    private static final String P_XML_PATH = "xmlPath";
    private static final String P_XSD_PATH = "xsdPath";
    private static final String P_USER_JSON_FORMAT = "useJsonFormat";
    private static final String LVL_ROOT = "com.stambia.xml.xsd";
    private XmlBeanWizard bean;
    private MdNode reversedMdNode;
    private MdNode createdNode;
    private String[] rootXSDElements = null;

    public XmlWizardControler(MdNode reversedNode) {
        this.reversedMdNode = reversedNode;
        this.bean = new XmlBeanWizard(this);
        this.initialize();
    }

    private void initialize() {
        try {
            this.bean.setXmlPath(MdAttributeReader.readAttribute((String)P_XML_PATH, (MdNode)this.reversedMdNode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.setXsdPath(MdAttributeReader.readAttribute((String)P_XSD_PATH, (MdNode)this.reversedMdNode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.setUseJsonFormat(Boolean.valueOf(MdAttributeReader.readAttribute((String)P_USER_JSON_FORMAT, (MdNode)this.reversedMdNode)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MdNode getReversedMd() {
        return this.reversedMdNode;
    }

    public XmlBeanWizard getBean() {
        return this.bean;
    }

    public MdNode createNewMd() {
        return this.createdNode;
    }

    public String[] getXsdRootElementNames() {
        return this.rootXSDElements;
    }

    protected String getReverseXMLNodeDefType() {
        return "com.stambia.xml.root";
    }

    private MdNode internalReverseXML(InputStream is) throws Exception {
        MdNode dummyNode = this.getReversedMd().copy(1);
        dummyNode.setSubstituteContainer(this.getReversedMd().eContainer());
        dummyNode.setAttribute(P_XSD_PATH, this.getBean().getXsdPath(), false);
        dummyNode.setAttribute(P_XML_PATH, this.getBean().getXmlPath(), false);
        HashMap<String, String> prefixByURI = new HashMap<String, String>();
        for (MdNode n : this.getReversedMd().getNodeByCode("com.stambia.xml.namespace")) {
            prefixByURI.put(n.getName(), n.getAttributeValueByShortCode("prefix"));
        }
        XmlStreamReverser streamReverser = new XmlStreamReverser(prefixByURI);
        MdNode node = null;
        node = streamReverser.reverse(this.getReversedMd(), is);
        Attribute originalType = node.getAttributeByShortCode("originalType");
        node.setDefType(this.getReverseXMLNodeDefType());
        node.unsetLevel();
        if (originalType != null) {
            originalType.setDefType(String.valueOf(this.getReverseXMLNodeDefType()) + ".originalType");
        }
        node.setSubstituteContainer(null);
        dummyNode.getNode().add((Object)node);
        for (MdNode n : new ArrayList(node.getNodeByCode("com.stambia.xml.namespace"))) {
            node.getNode().remove((Object)n);
            dummyNode.getNode().add((Object)n);
        }
        dummyNode.setSubstituteContainer(this.getReversedMd().eContainer());
        return dummyNode;
    }

    public void reverseClipboard() throws Exception {
        if (this.createdNode != null) {
            return;
        }
        byte[] content = this.getBean().getClipboardContent();
        if (content == null) {
            throw new Exception(Messages.XmlWizardControler_6);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.getBean().getClipboardContent());){
            MdNode dummyNode;
            this.createdNode = dummyNode = this.internalReverseXML(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void reverseXML() throws Exception {
        if (this.createdNode != null) {
            return;
        }
        File xmlFile = this.getXMLFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(xmlFile);){
            MdNode dummyNode = this.internalReverseXML(fis);
            if (dummyNode.getName() == null || dummyNode.getName().isEmpty()) {
                String fName = xmlFile.getName();
                if (fName.contains(".")) {
                    fName = fName.substring(0, fName.lastIndexOf("."));
                }
                dummyNode.setName(fName);
            }
            this.createdNode = dummyNode;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void reverseXSD() throws Exception {
        if (this.createdNode != null) {
            return;
        }
        MdNode dummyNode = this.getReversedMd().copy(1);
        dummyNode.setSubstituteContainer(this.getReversedMd().getSubstituteContainer());
        dummyNode.setAttribute(P_XSD_PATH, this.getBean().getXsdPath(), false);
        dummyNode.setAttribute(P_XML_PATH, this.getBean().getXmlPath(), false);
        File xsdFile = this.getXSDFile();
        if (xsdFile == null) {
            throw new Exception(Messages.XmlWizardControler_11);
        }
        String rootName = this.handleVariableEnvironment(EnvironmentVariableHelper.resolveEnvironmentVariables((String)this.getBean().getXsdRootElement(), (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel));
        MdNode node = XmlUtil.reverse(xsdFile.getAbsolutePath(), rootName, dummyNode, this.getBean().getXsdRecursivityDepth(), true, false);
        node.setSubstituteContainer(this.getReversedMd().getSubstituteContainer());
        if (node.getName() == null || node.getName().isEmpty()) {
            String fName = xsdFile.getName();
            if (fName.contains(".")) {
                fName = fName.substring(0, fName.lastIndexOf("."));
            }
            node.setName(fName);
        }
        this.createdNode = node;
    }

    protected String handleVariableEnvironment(String val) throws Exception {
        HashSet missingVar = new HashSet();
        String res = val;
        try {
            res = EnvironmentVariableHelper.resolveEnvironmentVariables((String)res, (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel);
        }
        catch (EnvironmentVariableHelper.MissingEnvironmentVariableException e) {
            missingVar.addAll(e.getMissingVariableName());
        }
        if (!missingVar.isEmpty() && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.XmlWizardControler_14, (String)Messages.XmlWizardControler_15)) {
            ArrayList<IValueVariable> l = new ArrayList<IValueVariable>();
            for (String s : missingVar) {
                l.add(VariablesPlugin.getDefault().getStringVariableManager().newValueVariable(s, null));
            }
            try {
                VariablesPlugin.getDefault().getStringVariableManager().addVariables(l.toArray(new IValueVariable[l.size()]));
            }
            catch (Exception ex) {
                ex.getStackTrace();
            }
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"com.indy.ui.custom.out.StringVariablePreferencePage", (String[])new String[]{"com.indy.ui.custom.out.StringVariablePreferencePage"}, null);
            dialog.open();
            res = EnvironmentVariableHelper.resolveEnvironmentVariables((String)res, (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel);
            return res;
        }
        return res;
    }

    public void refreshXSDRootElement() throws Exception {
        if (this.rootXSDElements != null) {
            return;
        }
        try {
            File f = null;
            try {
                f = this.getXSDFile();
            }
            catch (Exception ex) {
                f = new File(this.getBean().getXsdPath());
            }
            if (f == null) {
                throw new Exception(Messages.XmlWizardControler_16);
            }
            List<String> list = XmlUtil.getRootElementName(f.getAbsolutePath());
            String[] tmp = new String[list.size()];
            this.rootXSDElements = list.toArray(tmp);
        }
        catch (Exception ex) {
            this.rootXSDElements = new String[0];
            throw ex;
        }
    }

    void handleXSDChanged() {
        this.rootXSDElements = null;
    }

    void handleBeanChanged() {
        this.createdNode = null;
    }

    public File getXSDFile() throws Exception {
        MdNode dummyNode = this.getReversedMd().copy(1);
        dummyNode.setSubstituteContainer(this.getReversedMd().eContainer());
        dummyNode.setAttribute(P_XSD_PATH, this.getBean().getXsdPath(), false);
        String xmlPath = this.handleVariableEnvironment(EnvironmentVariableHelper.resolveEnvironmentVariables((String)MdAttributeReader.readAttribute((String)P_XSD_PATH, (MdNode)dummyNode), (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel));
        if (xmlPath == null || xmlPath.isEmpty()) {
            return null;
        }
        return new File(xmlPath);
    }

    public File getXMLFile() throws Exception {
        MdNode dummyNode = this.getReversedMd().copy(1);
        dummyNode.setSubstituteContainer(this.getReversedMd().eContainer());
        dummyNode.setAttribute(P_XSD_PATH, this.getBean().getXsdPath(), false);
        dummyNode.setAttribute(P_XML_PATH, this.getBean().getXmlPath(), false);
        String xmlPath = this.handleVariableEnvironment(EnvironmentVariableHelper.resolveEnvironmentVariables((String)MdAttributeReader.readAttribute((String)P_XML_PATH, (MdNode)dummyNode), (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel));
        return new File(xmlPath);
    }
}

