/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file;

import com.indy.addons.Messages;
import com.indy.file.FieldDescriptor;
import com.indy.jdbc.editor.Activator;
import com.indy.ui.custom.out.Util;
import com.indy.xsl.global.Strings;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.StambiaBufferedReaderI;
import com.stambia.jdbc.driver.file.fileManagment.TransformInputStreamWithScript;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilter;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilterSet;
import com.stambia.jdbc.driver.file.tools.DelimitedLineParser;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class FileUtil {
    public static String XPATH_EXPRESSION_PATH = "INTERNAL_PATH";
    private static final Logger LOGGER = LogManager.getLogger(FileUtil.class);
    private static final String IS_ENCLOSE_BY_DELIMITER = "\ufffd\ufffdstr\ufffd\ufffd";
    static FileUtil INSTANCE = new FileUtil();

    private static MdNode getMdFile(MdNode node) throws XPathExpressionException {
        return (MdNode)node.evaluateMdNode("ancestor-or-self::file[1]");
    }

    private static String getFieldSeparator(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@fieldSeparator");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String getDecimalSeparator(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@decimalSeparator");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String formatFields(List<String> fields, List<FieldDescriptor> list) {
        int i = 0;
        String result = "";
        for (String field : fields) {
            FieldDescriptor fd;
            if (list.size() <= i) continue;
            if ((fd = list.get(i++)) != null) {
                field = String.valueOf(Util.rightPad((String)field, (int)fd.size));
            }
            result = String.valueOf(result) + field;
        }
        return result;
    }

    private static String getFieldDelimiter(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@stringDelimiter");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static int getLineToSkip(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            String str = file.evaluateMdString("@lineToSkip");
            return str != null && !str.equals("") && str.matches("[0-9]*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    private static String getEscapeChar(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@escapeChar");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String getFieldFormat(MdNode node) {
        try {
            return node.evaluateMdString("@format");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static int getFieldDecimal(MdNode node) {
        try {
            String str = node.evaluateMdString("@decimal");
            return str != null && !str.equals("") && str.matches("[0-9]*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    public static void synchronizeFieldDescriptor(FieldDescriptor fd, MdNode node) {
        fd.name = node.getName();
        fd.position = node.getPosition().intValue();
        fd.format = FileUtil.getFieldFormat(node);
        fd.decimal = FileUtil.getFieldDecimal(node);
        fd.size = FileUtil.getFieldSize(node);
        fd.type = FileUtil.getFieldType(node);
    }

    public static String getType(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            String result = file.evaluateMdString("@type");
            return result == null ? "" : result;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String getFieldType(MdNode node) {
        try {
            String result = node.evaluateMdString("@type");
            return result == null ? "" : result;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static int getFieldSize(MdNode node) {
        try {
            String str = node.evaluateMdString("@size");
            return str != null && !str.equals("") && str.matches("[0-9]*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    private static List<String> parseDelimitedLine(String line, String fieldSeparator, String fieldDelimiter) {
        try {
            DelimitedLineParser dlp = new DelimitedLineParser(fieldSeparator, fieldDelimiter, null);
            dlp.parse(line);
            ArrayList<String> list = new ArrayList<String>();
            while (dlp.hasNext()) {
                list.add(dlp.next().getData());
            }
            return list;
        }
        catch (NoClassDefFoundError e) {
            return FileUtil.parseDelimitedLine2(line, fieldSeparator, fieldDelimiter);
        }
    }

    private static List<String> parseDelimitedLine2(String line, String fieldSeparator, String fieldDelimiter) {
        ArrayList<String> result = new ArrayList<String>();
        boolean end = false;
        int i = -1;
        int mode = 1;
        String endFieldSeparator = fieldSeparator;
        String buffer = fieldSeparator;
        int istart = 0;
        int iend = 0;
        while (line.length() > ++i) {
            char c = line.charAt(i);
            if (i == line.length() - 1) {
                end = true;
            }
            buffer = String.valueOf(buffer) + c;
            if (mode < 2 && fieldDelimiter != null && !fieldDelimiter.isEmpty() && buffer.endsWith(String.valueOf(fieldSeparator) + fieldDelimiter)) {
                endFieldSeparator = String.valueOf(fieldDelimiter) + fieldSeparator;
                istart = i + 1;
                mode = 2;
                buffer = "";
            } else if (end || buffer.endsWith(endFieldSeparator)) {
                iend = i;
                String str = "";
                if (end && mode == 2) {
                    str = line.substring(istart, iend - fieldDelimiter.length() + 1).replace(String.valueOf(fieldDelimiter) + fieldDelimiter, fieldDelimiter);
                } else if (end) {
                    if (!buffer.endsWith(fieldSeparator)) {
                        str = line.substring(istart, iend + 1);
                    }
                } else {
                    str = mode == 2 ? line.substring(istart, iend - endFieldSeparator.length() + 1).replace(String.valueOf(fieldDelimiter) + fieldDelimiter, fieldDelimiter) : line.substring(istart, iend - endFieldSeparator.length() + 1);
                }
                result.add(str);
                mode = 1;
                endFieldSeparator = fieldSeparator;
                istart = i + 1;
            }
            if (i == line.length() - 1 && buffer.endsWith(endFieldSeparator)) {
                result.add("");
                continue;
            }
            line.length();
        }
        return result;
    }

    public static List<FieldDescriptor> getDelimitedFieldDescriptor(MdNode node, int limit, int stringMinSize, int stringSafetyMargin, boolean determineDataType, int numericMinSize, int numericSafetyMargin) throws XPathExpressionException, IOException, ReverseException {
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            FileUtil fileUtil = INSTANCE;
            fileUtil.getClass();
            try (ReaderWrapper reader = fileUtil.new ReaderWrapper(node, false, limit);){
                ArrayList<FieldDescriptor> result = null;
                int headerPosition = FileUtil.getHeaderPosition(node);
                Strings.decodeHexString((String)"");
                String fieldSeparator = Strings.decodeSpecialChar((String)Strings.decodeHexString((String)FileUtil.getFieldSeparator(node)));
                String fieldDelimiter = Strings.decodeSpecialChar((String)Strings.decodeHexString((String)FileUtil.getFieldDelimiter(node)));
                String decimalSeparator = FileUtil.getDecimalSeparator(node);
                if (fieldSeparator != null) {
                    String headerLine = reader.headerLine;
                    String line = reader.readLine();
                    String string = headerLine = headerLine == null ? line : headerLine;
                    if (headerLine != null) {
                        List<String> split = FileUtil.parseDelimitedLine(headerLine, fieldSeparator, fieldDelimiter);
                        int index = 0;
                        result = new ArrayList<FieldDescriptor>(split.size());
                        while (line != null && (index < limit || limit == -1)) {
                            ++index;
                            if (!line.isEmpty()) {
                                List<String> split2 = FileUtil.parseDelimitedLine(line, fieldSeparator, fieldDelimiter);
                                int j = 0;
                                for (String name : split) {
                                    if (j >= result.size()) {
                                        result.add(new FieldDescriptor());
                                    }
                                    FieldDescriptor fd = (FieldDescriptor)result.get(j);
                                    if (fd.position == -1) {
                                        fd.position = j + 1;
                                    }
                                    if (fd.name == null || fd.name.isEmpty()) {
                                        if (headerPosition > 0 && split.size() > j && name != null && !name.isEmpty()) {
                                            String tmp = name;
                                            if (tmp.startsWith(IS_ENCLOSE_BY_DELIMITER)) {
                                                tmp = tmp.substring(IS_ENCLOSE_BY_DELIMITER.length());
                                            }
                                            tmp = tmp.replace(".", "_");
                                            tmp = tmp.replace("'", "_");
                                            if (!(tmp = FileUtil.deAccent(tmp)).substring(0, 1).matches("[A-Za-z]")) {
                                                tmp = "A" + tmp;
                                            }
                                            fd.name = tmp.trim();
                                            fd.noName = false;
                                        } else {
                                            fd.name = "F" + (j + 1);
                                        }
                                    }
                                    if (split2.size() > j) {
                                        String data = split2.get(j);
                                        data = data == null ? "" : data;
                                        String forceType = null;
                                        if (data != null && data.startsWith(IS_ENCLOSE_BY_DELIMITER)) {
                                            data = data.substring(IS_ENCLOSE_BY_DELIMITER.length());
                                            forceType = "String";
                                        }
                                        FileUtil.updateFieldDescriptor(fd, data, decimalSeparator, forceType, stringMinSize, stringSafetyMargin, determineDataType, numericMinSize, numericSafetyMargin);
                                    } else {
                                        FileUtil.updateFieldDescriptor(fd, "", decimalSeparator, null, stringMinSize, stringSafetyMargin, determineDataType, numericMinSize, numericSafetyMargin);
                                    }
                                    ++j;
                                }
                            }
                            line = reader.readLine();
                        }
                        for (FieldDescriptor fd : result) {
                            if (fd.type.equals("Empty")) {
                                fd.type = "String";
                            }
                            if (fd.size != 0 || !fd.type.equals("String")) continue;
                            fd.size = stringMinSize > 0 ? Integer.valueOf(stringMinSize) : Integer.valueOf(50);
                        }
                    }
                }
                return result;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    private static int getHeaderPosition(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            String str = file.evaluateMdString("@header");
            return str != null && !str.equals("") && str.matches("[0-9]*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    public static void updateFieldDescriptor(FieldDescriptor fd, String str2, String decimalSeparator, String forceType, int stringMinSize, int stringSafetyMargin, boolean determineDataType, int numericMinSize, int numericSafetyMargin) {
        String trim = str2.trim();
        String _decimalSeparator = null;
        try {
            _decimalSeparator = Strings.decodeHexString((String)decimalSeparator);
            _decimalSeparator = _decimalSeparator.replaceAll("\\.", "\\\\\\\\.");
        }
        catch (UnsupportedEncodingException e) {
            Activator.error("Error during hexa decoding: " + decimalSeparator, e);
            return;
        }
        if (!determineDataType) {
            fd.type = "String";
        } else if (forceType == null) {
            String tmpFormat = null;
            String tmpType = "Empty";
            String dateFormat = "(";
            dateFormat = String.valueOf(dateFormat) + "(19|20)";
            dateFormat = String.valueOf(dateFormat) + "(\\d\\d)";
            dateFormat = String.valueOf(dateFormat) + "([- /.])";
            dateFormat = String.valueOf(dateFormat) + "(0[1-9]|1[012])";
            dateFormat = String.valueOf(dateFormat) + "([- /.])";
            dateFormat = String.valueOf(dateFormat) + "(0[1-9]|[12][0-9]|3[01])";
            dateFormat = String.valueOf(dateFormat) + ")";
            dateFormat = String.valueOf(dateFormat) + "(";
            dateFormat = String.valueOf(dateFormat) + "([- /.T])";
            dateFormat = String.valueOf(dateFormat) + "([01][0-9]|2[0-3])";
            dateFormat = String.valueOf(dateFormat) + "([:.])";
            dateFormat = String.valueOf(dateFormat) + "([0-5][0-9])";
            dateFormat = String.valueOf(dateFormat) + "(";
            dateFormat = String.valueOf(dateFormat) + "([:.])";
            dateFormat = String.valueOf(dateFormat) + "([0-5][0-9])";
            dateFormat = String.valueOf(dateFormat) + ")?";
            dateFormat = String.valueOf(dateFormat) + "(";
            dateFormat = String.valueOf(dateFormat) + "([:. ])";
            dateFormat = String.valueOf(dateFormat) + "([0-9])";
            dateFormat = String.valueOf(dateFormat) + "([0-9])?";
            dateFormat = String.valueOf(dateFormat) + "([0-9])?";
            dateFormat = String.valueOf(dateFormat) + ")?";
            dateFormat = String.valueOf(dateFormat) + ")?";
            if (fd.type == null || !fd.type.equals("String")) {
                if (trim.isEmpty()) {
                    tmpType = "Empty";
                } else if (trim.matches("[-]?[0-9]*[" + _decimalSeparator + "]?[0-9]*")) {
                    tmpType = "Numeric";
                } else if (trim.matches(dateFormat)) {
                    tmpType = "Date";
                    Pattern datePatt = Pattern.compile(dateFormat);
                    Matcher m = datePatt.matcher(trim);
                    m.matches();
                    tmpFormat = "yyyy" + m.group(4) + "MM" + m.group(6) + "dd";
                    if (m.group(8) != null) {
                        tmpType = "Timestamp";
                        tmpFormat = String.valueOf(tmpFormat) + m.group(9) + "HH" + m.group(11) + "mm";
                        if (m.group(13) != null) {
                            tmpFormat = String.valueOf(tmpFormat) + m.group(14) + "ss";
                            if (m.group(16) != null) {
                                tmpFormat = String.valueOf(tmpFormat) + m.group(17);
                                if (m.group(18) != null) {
                                    tmpFormat = String.valueOf(tmpFormat) + "S";
                                }
                                if (m.group(19) != null) {
                                    tmpFormat = String.valueOf(tmpFormat) + "S";
                                }
                                if (m.group(20) != null) {
                                    tmpFormat = String.valueOf(tmpFormat) + "S";
                                }
                            }
                        }
                    }
                } else {
                    tmpType = "String";
                }
            }
            if (fd.type == null) {
                fd.type = tmpType;
                fd.format = tmpFormat;
            } else if (!tmpType.equals("Empty") && !fd.type.equals(tmpType)) {
                fd.type = "String";
            }
        } else {
            fd.type = forceType;
        }
        Integer _size = fd.size == null ? 0 : fd.size;
        Integer tmpSize = str2.length();
        if (fd.type.equals("Numeric")) {
            tmpSize = tmpSize + numericSafetyMargin;
            if (numericMinSize > 0 && numericMinSize > tmpSize) {
                tmpSize = numericMinSize;
            }
        } else if (fd.type.equals("String")) {
            tmpSize = tmpSize + stringSafetyMargin;
            if (stringMinSize > 0 && stringMinSize > tmpSize) {
                tmpSize = stringMinSize;
            }
        }
        Integer n = fd.size = _size > tmpSize ? _size : tmpSize;
        if (fd.type.equals("Numeric")) {
            if (trim.matches("[-]?[0-9]*[" + _decimalSeparator + "][0-9]+")) {
                int _decimal = trim.substring(trim.indexOf(_decimalSeparator) + 1).length();
                if (fd.decimal == null || _decimal > fd.decimal) {
                    fd.decimal = _decimal;
                }
            }
        } else {
            fd.decimal = null;
        }
    }

    public static List<FieldDescriptor> getPositionalFieldDescriptor(MdNode node, int limit, boolean determineDataType) throws XPathExpressionException, IOException, ReverseException {
        int j;
        ReaderWrapper reader;
        ArrayList<FieldDescriptor> result = null;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int header = FileUtil.getHeaderPosition(node);
        String decimalSeparator = FileUtil.getDecimalSeparator(node);
        Throwable throwable = null;
        Object var8_10 = null;
        try {
            FileUtil fileUtil = INSTANCE;
            fileUtil.getClass();
            reader = fileUtil.new ReaderWrapper(node, false, limit);
            try {
                String line = reader.readLine();
                if (line == null) {
                    return result;
                }
                int index = 1;
                while (line != null) {
                    j = 0;
                    int precChar = 32;
                    while (j < line.length()) {
                        char c = line.charAt(j);
                        if (index == 1) {
                            if (c != ' ' && precChar == 32) {
                                positions.add(new Integer(j));
                            }
                        } else if (c == ' ' || precChar != 32) {
                            positions.remove(new Integer(j));
                        }
                        ++j;
                        precChar = c;
                    }
                    line = reader.readLine();
                    ++index;
                }
                if (!positions.contains(0)) {
                    positions.add(0);
                }
                Collections.sort(positions);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var8_10 = null;
        try {
            FileUtil fileUtil = INSTANCE;
            fileUtil.getClass();
            reader = fileUtil.new ReaderWrapper(node, false, limit);
            try {
                String headerLine = reader.headerLine;
                String line = reader.readLine();
                headerLine = headerLine == null ? line : headerLine;
                result = new ArrayList<FieldDescriptor>(positions.size());
                while (line != null) {
                    j = 0;
                    for (Integer position : positions) {
                        int start = position;
                        if (line.length() > start) {
                            String str = "";
                            str = j + 1 < positions.size() ? line.substring(start, (Integer)positions.get(j + 1)) : line.substring(start);
                            if (j >= result.size()) {
                                result.add(new FieldDescriptor());
                            }
                            FieldDescriptor fd = (FieldDescriptor)result.get(j);
                            if (fd.position == -1) {
                                fd.position = j + 1;
                            }
                            if (fd.name == null) {
                                if (header > 0) {
                                    String name = null;
                                    name = j + 1 < positions.size() ? headerLine.substring(start, (Integer)positions.get(j + 1)) : headerLine.substring(start);
                                    String tmp = name.replace(".", "_");
                                    tmp = tmp.replace("'", "_");
                                    fd.name = tmp = FileUtil.deAccent(tmp);
                                    fd.noName = false;
                                } else {
                                    fd.name = "F" + (j + 1);
                                }
                            }
                            FileUtil.updateFieldDescriptor(fd, str, decimalSeparator, null, 0, 0, determineDataType, 0, 0);
                        } else {
                            LOGGER.warn("erreur de taille de ligne");
                        }
                        ++j;
                    }
                    line = reader.readLine();
                }
                for (FieldDescriptor fd : result) {
                    if (!fd.type.equals("Empty")) continue;
                    fd.type = "String";
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return result;
    }

    public static void reverseWithFileDescriptor(List<FieldDescriptor> fieldDescriptorList, MdNode file, boolean updateName, boolean updateSize, boolean updateType, boolean updatePhysicalName, boolean positionMode) {
        ArrayList<MdNode> newNode = new ArrayList<MdNode>();
        HashMap<String, Integer> alreadeyNamed = new HashMap<String, Integer>();
        HashMap<String, Integer> alreadeyNamed2 = new HashMap<String, Integer>();
        boolean noName = false;
        if (fieldDescriptorList != null) {
            int precPosition = 1;
            int position = 1;
            for (FieldDescriptor fd : fieldDescriptorList) {
                Integer already;
                position = precPosition;
                String _name = fd.name.trim();
                noName = fd.noName;
                if (_name.startsWith("\"")) {
                    _name = _name.substring(1);
                }
                if (_name.endsWith("\"")) {
                    _name = _name.substring(0, _name.length() - 1);
                }
                if ((already = (Integer)alreadeyNamed.get(_name = _name.trim())) != null) {
                    int i = already;
                    alreadeyNamed.put(_name, ++i);
                    _name = String.valueOf(_name) + "_" + i;
                    alreadeyNamed.put(_name, 1);
                } else {
                    alreadeyNamed.put(_name, 1);
                }
                MdNode _field = MdFactoryHelper.createMdNode((String)"com.stambia.file.field");
                _field.setName(_name);
                _field.setSubstituteContainer((EObject)file);
                for (Property prop : _field.getLevel().getAttribute()) {
                    String value = prop.getDefaultValue();
                    if (prop.getCode().equals("size")) {
                        value = fd.size.toString();
                    } else if (prop.getCode().equals("type")) {
                        value = fd.type;
                    } else if (prop.getCode().equals("decimal")) {
                        value = fd.decimal != null ? fd.decimal.toString() : null;
                    } else if (prop.getCode().equals("format")) {
                        value = fd.format;
                    }
                    if (value == null || value.equals("")) continue;
                    Attribute attr = MdFactoryHelper.createAttribute((String)prop.getFullCode());
                    attr.setValue(value);
                    _field.getAttribute().add((Object)attr);
                }
                if (positionMode) {
                    _field.setPosition(BigInteger.valueOf(precPosition));
                } else {
                    _field.setPosition(BigInteger.valueOf(fd.position));
                }
                precPosition += fd.size.intValue();
                Attribute attr = MdFactoryHelper.createAttribute((String)"com.stambia.file.field.physicalName");
                _field.getAttribute().add((Object)attr);
                String temp = FileUtil.deAccent(_name);
                String pname = temp.replaceAll("[^A-Z^a-z^0-9^_]", "_");
                pname = pname.toUpperCase();
                already = (Integer)alreadeyNamed2.get(pname);
                if (already != null) {
                    int i = already;
                    alreadeyNamed2.put(pname, ++i);
                    pname = String.valueOf(pname) + "_" + i;
                    alreadeyNamed2.put(pname, 1);
                } else {
                    alreadeyNamed2.put(pname, 1);
                }
                attr.setValue(pname);
                newNode.add(_field);
            }
        }
        try {
            ArrayList<String> excludeAttributeToUpdate = new ArrayList<String>();
            if (!updatePhysicalName) {
                excludeAttributeToUpdate.add("com.stambia.file.field.physicalName");
            }
            if (!updateSize) {
                excludeAttributeToUpdate.add("com.stambia.file.field.size");
                excludeAttributeToUpdate.add("com.stambia.file.field.decimal");
            }
            if (!updateType) {
                excludeAttributeToUpdate.add("com.stambia.file.field.type");
            }
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            for (MdNode n : newNode) {
                reversedMap.put(n, noName ? file.getNodeByPosition(n.getDefType(), newNode.indexOf(n)) : file.getNodeByName(n.getDefType(), n.getName()));
            }
            IncrementalReverser reverser = new IncrementalReverser((EObject)file, reversedMap, excludeAttributeToUpdate, updateName, null, null, (IncrementalReverser.IReverseMatchingStrategy)(noName ? IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition : IncrementalReverser.DefaulteverseMatchingStrategy.ByName), null, true);
            reverser.reverse();
        }
        catch (ReverseException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
    }

    private static MetadataFilterSet getFilterSet2(MdNode node, MetadataFilterSet parent) throws XPathExpressionException {
        List mdChildren;
        Object o;
        MetadataFilterSet filterSet = new MetadataFilterSet(new IReadContext(){

            public int position() {
                return 0;
            }

            public long startTimeStamp() {
                return 0L;
            }
        });
        filterSet.setName(node.getName());
        try {
            filterSet.setAncestorLevel(Integer.valueOf(node.evaluateMdString("@ancestorLevel")).intValue());
        }
        catch (Exception e) {
            filterSet.setAncestorLevel(0);
        }
        try {
            filterSet.setOccurenceNumber(Integer.valueOf(node.evaluateMdString("@occurenceNumber")).intValue());
        }
        catch (Exception e) {
            filterSet.setOccurenceNumber(-1);
        }
        try {
            filterSet.setOccurenceSize(Integer.valueOf(node.evaluateMdString("@occurenceSize")).intValue());
        }
        catch (Exception e) {
            filterSet.setOccurenceSize(-1);
        }
        try {
            filterSet.setOccurenceStart(Integer.valueOf(node.evaluateMdString("@occurenceStart")).intValue());
        }
        catch (Exception e) {
            filterSet.setOccurenceStart(-1);
        }
        if (parent != null) {
            filterSet.setParent(parent);
            parent.addChildren(node.getName(), filterSet);
        }
        if ((o = node.evaluateMdSet("filter")) instanceof List) {
            ArrayList<MetadataFilter> filters = new ArrayList<MetadataFilter>();
            for (Object _filter : (List)o) {
                MdNode filter = (MdNode)_filter;
                String value = filter.evaluateMdString("@value");
                MetadataFilter MdFilter = new MetadataFilter();
                MdFilter.setTest(value);
                try {
                    MetadataFilter.Operator op = MetadataFilter.Operator.valueOf((String)filter.evaluateMdString("@operator"));
                    MdFilter.setOperator(op);
                }
                catch (Exception e) {
                    MdFilter.setOperator(MetadataFilter.Operator.StartsWith);
                }
                try {
                    MdFilter.setStartsAt(Integer.valueOf(filter.evaluateMdString("@start")).intValue());
                }
                catch (Exception e) {
                    MdFilter.setStartsAt(1);
                }
                try {
                    MdFilter.setLength(Integer.valueOf(filter.evaluateMdString("@length")).intValue());
                }
                catch (Exception e) {
                    MdFilter.setLength(-1);
                }
                try {
                    MdFilter.setNot(Boolean.valueOf(filter.evaluateMdString("@not")).booleanValue());
                }
                catch (Exception e) {
                    MdFilter.setNot(false);
                }
                try {
                    MdFilter.setAncestorLevel(Integer.valueOf(filter.evaluateMdString("@ancestorLevel")).intValue());
                }
                catch (Exception e) {
                    MdFilter.setAncestorLevel(0);
                }
                filters.add(MdFilter);
            }
            filterSet.addFilter(filters);
        }
        if ((mdChildren = (List)node.evaluateMdSet("*[name()='record' or name()='file']")) != null) {
            for (MdNode child : mdChildren) {
                FileUtil.getFilterSet2(child, filterSet);
            }
        }
        return filterSet;
    }

    private static StambiaBufferedReaderI getReader2(MdNode node, boolean disableFilter) throws XPathExpressionException, IOException {
        MdNode fileMdNode = FileUtil.getMdFile(node);
        String path = fileMdNode.evaluateXpathExpression(XPATH_EXPRESSION_PATH);
        String lineSeparator = fileMdNode.evaluateMdString("@lineSeparator");
        String stringDelimiter = fileMdNode.evaluateMdString("@stringDelimiter");
        String lineSize = fileMdNode.evaluateMdString("@lineSize");
        stringDelimiter = stringDelimiter != null ? Strings.decodeHexString((String)stringDelimiter) : null;
        String charsetName = fileMdNode.evaluateMdString("@charsetName");
        String script = fileMdNode.evaluateMdString("@transformScript");
        String scriptLanguage = fileMdNode.evaluateMdString("@transformScriptLanguage");
        String escapeChar = fileMdNode.evaluateMdString("@escapeChar");
        String lastLineToSkip = fileMdNode.evaluateMdString("@lastLineToSkip");
        charsetName = charsetName == null || charsetName.isEmpty() ? Charset.defaultCharset().displayName() : charsetName;
        lineSeparator = lineSeparator != null ? Strings.decodeHexString((String)lineSeparator) : null;
        lineSeparator = Strings.decodeSpecialChar((String)lineSeparator);
        File file = new File(path);
        if (file.exists()) {
            int readerBufferSize = 8192;
            InputStream is = null;
            if (!(script == null || script.isEmpty() || scriptLanguage != null && scriptLanguage.equals("disable"))) {
                try {
                    is = TransformInputStreamWithScript.transform((InputStream)new FileInputStream(file), (String)script, (String)scriptLanguage);
                }
                catch (Exception e) {
                    LOGGER.warn("Unexpected", (Throwable)e);
                }
            }
            StambiaBufferedReaderI reader = new StambiaBufferedReaderI((Reader)new InputStreamReader((InputStream)(is == null ? new FileInputStream(file) : is), charsetName), readerBufferSize);
            try {
                String lineScript = fileMdNode.evaluateMdString("@transformLineScript");
                String lineScriptLanguage = fileMdNode.evaluateMdString("@transformLineScriptLanguage");
                reader.setLineTransformLanguage(lineScriptLanguage);
                reader.setLineTransformScript(lineScript);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
            try {
                reader.setLastLinePosition(Integer.parseInt(lastLineToSkip));
                reader.setMaxLasLineToBuffer(Integer.parseInt(lastLineToSkip));
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
            reader.setLineSeparator(lineSeparator);
            try {
                reader.setLineSize(Integer.parseInt(lineSize));
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
            try {
                reader.setLineSize(lineSize);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
            if (!disableFilter) {
                try {
                    reader.setFilterSet(FileUtil.getFilterSet2(fileMdNode, null));
                }
                catch (Exception e) {
                    LOGGER.warn("Unexpected", (Throwable)e);
                }
            }
            try {
                reader.setMonoSourceName(node.getName());
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
            reader.setStringDelimiter(stringDelimiter);
            reader.setEscapeChar(escapeChar);
            return reader;
        }
        throw new FileNotFoundException(Messages.bind((String)Messages.FileUtil_2, (Object)path));
    }

    public static String getPreviewData(MdNode node, int limit, boolean disableFilter) throws XPathExpressionException, IOException {
        String result = "";
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            FileUtil fileUtil = INSTANCE;
            fileUtil.getClass();
            try (ReaderWrapper reader = fileUtil.new ReaderWrapper(node, disableFilter, limit);){
                String escapeChar = FileUtil.getEscapeChar(node);
                escapeChar = escapeChar.replaceAll("\\\\", "\\\\\\\\");
                if (reader != null) {
                    String line = reader.readLine();
                    while (line != null) {
                        String replacer = "\u0000";
                        result = String.valueOf(result) + line.replaceAll("\\p{C}", replacer).replace("\t", replacer).replace("\n", replacer).replace("\r", replacer) + "\n";
                        if (!escapeChar.isEmpty()) {
                            result = result.replaceAll(escapeChar, replacer);
                        }
                        line = reader.readLine();
                    }
                }
                return result;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFormatedData(MdNode node, int limit, List<FieldDescriptor> list) throws XPathExpressionException, ReverseException, IOException {
        StringBuilder result = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileUtil fileUtil = INSTANCE;
            fileUtil.getClass();
            try (ReaderWrapper reader = fileUtil.new ReaderWrapper(node, false, limit);){
                String fieldSeparator = Strings.decodeSpecialChar((String)Strings.decodeHexString((String)FileUtil.getFieldSeparator(node)));
                String sringDelimiter = Strings.decodeSpecialChar((String)Strings.decodeHexString((String)FileUtil.getFieldDelimiter(node)));
                String line = reader.readLine();
                while (line != null) {
                    List<String> fields = FileUtil.parseDelimitedLine(line, fieldSeparator, sringDelimiter);
                    String line2 = FileUtil.formatFields(fields, list);
                    result.append(line2);
                    result.append("\n");
                    line = reader.readLine();
                }
                return result.toString();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    class ReaderWrapper
    implements AutoCloseable {
        StambiaBufferedReaderI reader;
        String headerLine;
        String[] lines;
        int limit = -1;
        int index = 0;

        public ReaderWrapper(MdNode node, boolean disableFilter, int limit) throws XPathExpressionException, IOException {
            this.reader = FileUtil.getReader2(node, disableFilter);
            int headerPosition = FileUtil.getHeaderPosition(node);
            int lineToSkip = FileUtil.getLineToSkip(node);
            if (lineToSkip < headerPosition) {
                lineToSkip = headerPosition;
            }
            try {
                this.reader.setRowsLimit(limit);
            }
            catch (Exception e) {
                this.limit = limit;
            }
            boolean setLineToSkipBeforeUnexist = false;
            if (headerPosition > 0) {
                try {
                    this.reader.setLineToSkipBefore(headerPosition - 1);
                    this.headerLine = this.reader.readLine();
                }
                catch (Throwable e) {
                    setLineToSkipBeforeUnexist = true;
                    String line = null;
                    int i = 0;
                    do {
                        line = this.reader.readLine();
                        if (++i != headerPosition) continue;
                        this.headerLine = line;
                    } while (line != null && i < lineToSkip);
                }
            }
            if (!setLineToSkipBeforeUnexist && lineToSkip > 0) {
                this.reader.setLineToSkipBefore(lineToSkip);
            }
        }

        public String readLine() throws IOException {
            if (this.limit > -1 && this.index >= this.limit) {
                return null;
            }
            String line = this.reader.readLine();
            if (line != null) {
                ++this.index;
            }
            return line;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

