/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.composite;

import com.indy.addons.Messages;
import com.indy.file.FileUtil;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdAttributeReader;
import java.io.File;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class DirectoryComposite
extends Composite {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private MdControlManager mcm;
    private Text nameField;
    private Text directoryPath;
    private boolean nameIsSet = false;
    private boolean pathIsSet = false;

    public DirectoryComposite(Composite parent, int style) {
        super(parent, style);
        DirectoryComposite composite = this;
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        composite.setFont(parent.getFont());
        Composite nameGroup = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameGroup.setLayoutData((Object)data);
        this.mcm = new MdControlManager();
        Label label = new Label(nameGroup, 64);
        label.setText("Name");
        this.nameField = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.nameField, this.getDirectory(), null, 3, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        label = new Label(nameGroup, 64);
        this.mcm.addControl((Control)label, this.getDirectory(), "path", 0, false, false);
        this.directoryPath = new Text(nameGroup, 2048);
        this.directoryPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.mcm.addControl((Control)this.directoryPath, this.getDirectory(), "path", 1, true, true);
        data = new GridData(768);
        data.widthHint = 250;
        this.directoryPath.setLayoutData((Object)data);
        Button browse = new Button(nameGroup, 0);
        browse.setText(Messages.DirectoryComposite_2);
        browse.setLayoutData((Object)new GridData(768));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String curentPath = null;
                EObject o = DirectoryComposite.this.getDirectory().eContainer();
                File parentFile = null;
                File currentFile = null;
                boolean hasParent = false;
                if (o instanceof MdNode && ((MdNode)o).getDefType().equals(DirectoryComposite.this.getDirectory().getDefType())) {
                    try {
                        curentPath = DirectoryComposite.this.getDirectory().evaluateXpathExpression(FileUtil.XPATH_EXPRESSION_PATH);
                        currentFile = new File(curentPath);
                        hasParent = true;
                        parentFile = new File(((MdNode)o).evaluateXpathExpression(FileUtil.XPATH_EXPRESSION_PATH));
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        curentPath = DirectoryComposite.this.getDirectory().evaluateXpathExpression(FileUtil.XPATH_EXPRESSION_PATH);
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                }
                DirectoryDialog fdlg = new DirectoryDialog(DirectoryComposite.this.getShell());
                if (currentFile != null && currentFile.exists()) {
                    fdlg.setFilterPath(currentFile.getAbsolutePath());
                } else if (parentFile != null && parentFile.exists()) {
                    fdlg.setFilterPath(parentFile.getAbsolutePath());
                } else {
                    fdlg.setFilterPath(curentPath);
                }
                String file = fdlg.open();
                if (file != null) {
                    File f = new File(file);
                    if (hasParent) {
                        if (f.getParentFile().getAbsolutePath().toUpperCase().equals(parentFile.getAbsolutePath().toUpperCase())) {
                            DirectoryComposite.this.directoryPath.setText(f.getName());
                        } else {
                            MessageDialog.openInformation((Shell)DirectoryComposite.this.getShell(), (String)Messages.DirectoryComposite_0, (String)Messages.bind((String)Messages.DirectoryComposite_1, (Object)parentFile.getAbsolutePath()));
                        }
                    } else {
                        try {
                            DirectoryComposite.this.directoryPath.setText(MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)DirectoryComposite.this.getDirectory(), (String)MdAttributeReader.readAttribute((String)"path", (MdNode)DirectoryComposite.this.getDirectory()), (String)f.getAbsolutePath()));
                        }
                        catch (Exception e) {
                            DirectoryComposite.this.directoryPath.setText(f.getAbsolutePath());
                        }
                    }
                }
            }
        });
        this.mcm.init();
        this.mcm.addListener(new MdControlManager.MdControlListener(){

            public void modifyValue(MdControlManager.MdControlEvent event) {
                DirectoryComposite.this.handleIsComplete(DirectoryComposite.this.isComplete());
            }
        });
    }

    public abstract MdNode getDirectory();

    public boolean isComplete() {
        return !this.directoryPath.getText().isEmpty() && !this.nameField.getText().isEmpty();
    }

    public abstract void handleIsComplete(boolean var1);

    public static class FolderDialog
    extends Dialog {
        TableViewer viewer;
        File baseFolder;
        File selectedFile;

        protected FolderDialog(Shell parentShell, File baseFolder) {
            super(parentShell);
            this.baseFolder = baseFolder;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            this.viewer.setInput((Object)this.baseFolder.listFiles());
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }

        protected Control createDialogArea(Composite parent) {
            this.viewer = new TableViewer(parent, 68352);
            this.viewer.getControl().setLayoutData((Object)new GridData(1808));
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((File)element).getName();
                }

                public Image getImage(Object element) {
                    return super.getImage(element);
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!event.getSelection().isEmpty()) {
                        this.getButton(0).setEnabled(true);
                        selectedFile = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
                    } else {
                        this.getButton(0).setEnabled(false);
                        selectedFile = null;
                    }
                }
            });
            return this.viewer.getControl();
        }

        public File getSelectedFile() {
            return this.selectedFile;
        }
    }
}

