/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.composite;

import com.indy.addons.Messages;
import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.file.FieldDescriptor;
import com.indy.file.FileUtil;
import com.indy.file.composite.FileUiUtil;
import com.indy.jdbc.editor.Activator;
import com.indy.md.ui.edit.custom.MdTableViewer;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class FileFieldPropertiesComposite
extends Composite {
    private static final Color ALTERNATE_1 = new Color((Device)Display.getDefault(), 163, 186, 211);
    private static final Color ALTERNATE_2 = new Color((Device)Display.getDefault(), 147, 186, 120);
    private static final Color ERROR = new Color((Device)Display.getDefault(), 255, 170, 85);
    private boolean autoRefreshMode = false;
    private MdControlManager mcm;
    private MdTableViewer tv;
    private Text nbAnalyzeRows;
    private Integer[] startPositions;
    private PaintListener paintListener;
    private TextViewer sourceViewer;
    private List<FieldDescriptor> fieldDescriptorList;
    private Button chkName;
    private Button chkPhysicalName;
    private Button chkSize;
    private Button chkType;
    private Button chkPositionIfSize;
    private Text nbRefreshRows;
    private Integer[] endPositions;
    private Text stringMinSize;
    private Text stringSafetyMarginSize;
    private Button determineDatatype;
    private Text numericMinSize;
    private Text numericSafetyMarginSize;
    private Group refresGroup;
    private Regioner regioner = new Regioner();
    List<FieldDescriptor> fieldDescriptorHelper = new ArrayList<FieldDescriptor>();
    List<FieldDescriptor> tmpFieldDescriptorHelper;

    public boolean isComplete() {
        return true;
    }

    private void refreshTable(boolean loadFile) {
        int nb = 0;
        String type = null;
        try {
            nb = this.nbRefreshRows.getText().equals("") ? 0 : Integer.valueOf(this.nbRefreshRows.getText());
            type = this.getFile().evaluate("ancestor-or-self::file/@type");
            if (loadFile) {
                String tmp = "";
                if (type.equals("POSITIONAL")) {
                    tmp = FileUtil.getPreviewData(this.getFile(), nb, false);
                    this.regioner.init();
                } else {
                    tmp = FileUtil.getFormatedData(this.getFile(), nb, this.fieldDescriptorList);
                    this.regioner.disable();
                }
                if (this.sourceViewer.getDocument() != null) {
                    this.sourceViewer.getDocument().set(tmp);
                } else {
                    this.sourceViewer.setDocument((IDocument)new Document(tmp));
                }
            } else if (type.equals("POSITIONAL")) {
                this.regioner.init();
                this.sourceViewer.refresh();
                this.regioner.init();
            } else {
                this.regioner.disable();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.FileFieldPropertiesComposite_5, (String)ex.getMessage());
        }
    }

    public void reverseFile() {
        final boolean delimited = FileUtil.getType(this.getFile()).equals("DELIMITED");
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        int limit = 10;
                        try {
                            limit = new Integer(FileFieldPropertiesComposite.this.nbAnalyzeRows.getText());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            limit = 10;
                        }
                        boolean positionMode = false;
                        if (FileFieldPropertiesComposite.this.fieldDescriptorHelper != null && FileFieldPropertiesComposite.this.fieldDescriptorHelper.size() > 0) {
                            FileFieldPropertiesComposite.this.fieldDescriptorList = new ArrayList();
                            int i = 0;
                            while (i < FileFieldPropertiesComposite.this.fieldDescriptorHelper.size()) {
                                FieldDescriptor _fd = FileFieldPropertiesComposite.this.fieldDescriptorHelper.get(i);
                                FieldDescriptor fd = new FieldDescriptor();
                                FileFieldPropertiesComposite.this.fieldDescriptorList.add(fd);
                                fd.name = _fd.name;
                                fd.noName = _fd.noName;
                                fd.decimal = _fd.decimal;
                                fd.format = _fd.format;
                                fd.position = _fd.position;
                                fd.type = _fd.type;
                                fd.size = _fd.size;
                                if (!delimited) {
                                    if (fd.position == -1 && fd.size == null) {
                                        throw new Exception("Helper Error no position and no size for field: " + i);
                                    }
                                } else {
                                    fd.position = i + 1;
                                    if (fd.size == null) {
                                        throw new Exception("Helper Error no size for field: " + i);
                                    }
                                }
                                if (fd.type == null) {
                                    fd.type = "String";
                                }
                                if (fd.name == null) {
                                    throw new Exception("Helper Error no name for field: " + i);
                                }
                                if (!delimited) {
                                    if (fd.position == -1) {
                                        try {
                                            fd.position = i > 0 ? ((FieldDescriptor)((FileFieldPropertiesComposite)FileFieldPropertiesComposite.this).fieldDescriptorList.get((int)(i - 1))).position + ((FieldDescriptor)((FileFieldPropertiesComposite)FileFieldPropertiesComposite.this).fieldDescriptorList.get((int)(i - 1))).size : 1;
                                        }
                                        catch (Exception e) {
                                            throw new Exception("Helper Error impossible to determine position of field: " + i);
                                        }
                                    }
                                    if (fd.size == null) {
                                        try {
                                            int followPosition = 0;
                                            followPosition = FileFieldPropertiesComposite.this.fieldDescriptorList.size() > i + 1 ? ((FieldDescriptor)((FileFieldPropertiesComposite)FileFieldPropertiesComposite.this).fieldDescriptorList.get((int)(i + 1))).position : fd.position + 50;
                                            if (followPosition > -1) {
                                                fd.size = followPosition - fd.position;
                                            }
                                        }
                                        catch (Exception e) {
                                            throw new Exception("Helper Error impossible to determine size of field: " + i);
                                        }
                                    }
                                }
                                ++i;
                            }
                        } else if (FileUtil.getType(FileFieldPropertiesComposite.this.getFile()).equals("DELIMITED")) {
                            FileFieldPropertiesComposite.this.fieldDescriptorList = FileUtil.getDelimitedFieldDescriptor(FileFieldPropertiesComposite.this.getFile(), limit, Integer.valueOf(FileFieldPropertiesComposite.this.stringMinSize.getText()), Integer.valueOf(FileFieldPropertiesComposite.this.stringSafetyMarginSize.getText()), FileFieldPropertiesComposite.this.determineDatatype.getSelection(), Integer.valueOf(FileFieldPropertiesComposite.this.numericMinSize.getText()), Integer.valueOf(FileFieldPropertiesComposite.this.numericSafetyMarginSize.getText()));
                        } else {
                            FileFieldPropertiesComposite.this.fieldDescriptorList = FileUtil.getPositionalFieldDescriptor(FileFieldPropertiesComposite.this.getFile(), limit, FileFieldPropertiesComposite.this.determineDatatype.getSelection());
                            positionMode = true;
                        }
                        FileUtil.reverseWithFileDescriptor(FileFieldPropertiesComposite.this.fieldDescriptorList, FileFieldPropertiesComposite.this.getFile(), FileFieldPropertiesComposite.this.chkName.getSelection(), FileFieldPropertiesComposite.this.chkSize.getSelection(), FileFieldPropertiesComposite.this.chkType.getSelection(), FileFieldPropertiesComposite.this.chkPhysicalName.getSelection(), positionMode);
                        FileFieldPropertiesComposite.this.tv.setInput((Object)FileFieldPropertiesComposite.this.getFile());
                        FileFieldPropertiesComposite.this.refreshPosition();
                        FileFieldPropertiesComposite.this.refreshTable(true);
                    }
                    catch (Exception e2) {
                        String message = "Error during reverse";
                        MessageDialog.openError((Shell)FileFieldPropertiesComposite.this.getShell(), (String)Messages.FileFieldPropertiesComposite_15, (String)e2.getMessage());
                        Activator.error(message, e2);
                    }
                    catch (Error e2) {
                        String message = "Error during reverse";
                        MessageDialog.openError((Shell)FileFieldPropertiesComposite.this.getShell(), (String)Messages.FileFieldPropertiesComposite_0, (String)e2.getMessage());
                        Activator.error(message, e2);
                    }
                }
            });
        }
        catch (InvocationTargetException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public FileFieldPropertiesComposite(Composite parent, int style) {
        super(parent, style);
        FileFieldPropertiesComposite composite = this;
        composite.setLayout((Layout)new FormLayout());
        Group reverseGroup = new Group((Composite)composite, 0);
        reverseGroup.setText(Messages.FileFieldPropertiesComposite_18);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 10;
        reverseGroup.setLayout((Layout)layout);
        Label label = new Label((Composite)reverseGroup, 0);
        label.setText(Messages.FileFieldPropertiesComposite_19);
        this.nbAnalyzeRows = new Text((Composite)reverseGroup, 2048);
        this.nbAnalyzeRows.setText("1000");
        GridData _gd = new GridData();
        _gd.grabExcessHorizontalSpace = false;
        _gd.grabExcessVerticalSpace = false;
        _gd.horizontalAlignment = 4;
        _gd.verticalAlignment = 4;
        _gd.widthHint = 30;
        _gd.minimumWidth = 30;
        this.nbAnalyzeRows.setLayoutData((Object)_gd);
        VerifyListener numericVerif = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[\\-]?[0-9]*");
            }
        };
        this.nbAnalyzeRows.addVerifyListener(numericVerif);
        Button reverse = new Button((Composite)reverseGroup, 0);
        reverse.setText(Messages.FileFieldPropertiesComposite_22);
        GridData data = new GridData(768);
        reverse.setLayoutData((Object)data);
        reverse.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                FileFieldPropertiesComposite.this.reverseFile();
            }
        });
        Button paste = new Button((Composite)reverseGroup, 8);
        paste.setText(Messages.FileFieldPropertiesComposite_23);
        Clipboard cb = new Clipboard(this.getDisplay());
        paste.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new DialogHelper(FileFieldPropertiesComposite.this.getDisplay().getActiveShell()).open();
            }
        });
        Group reverseOptionGroup = new Group((Composite)reverseGroup, 0);
        reverseOptionGroup.setText(Messages.FileFieldPropertiesComposite_24);
        layout = new GridLayout();
        layout.numColumns = 10;
        reverseOptionGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.minimumHeight = 50;
        reverseOptionGroup.setLayoutData((Object)data);
        this.chkName = new Button((Composite)reverseOptionGroup, 32);
        this.chkName.setSelection(true);
        this.chkName.setText(Messages.FileFieldPropertiesComposite_25);
        this.chkPhysicalName = new Button((Composite)reverseOptionGroup, 32);
        this.chkPhysicalName.setSelection(true);
        this.chkPhysicalName.setText(Messages.FileFieldPropertiesComposite_26);
        this.chkSize = new Button((Composite)reverseOptionGroup, 32);
        this.chkSize.setSelection(true);
        this.chkSize.setText(Messages.FileFieldPropertiesComposite_27);
        this.chkType = new Button((Composite)reverseOptionGroup, 32);
        this.chkType.setSelection(true);
        this.chkType.setText(Messages.FileFieldPropertiesComposite_28);
        Group sizeManagement = new Group((Composite)reverseGroup, 0);
        sizeManagement.setText(Messages.FileFieldPropertiesComposite_29);
        layout = new GridLayout();
        layout.numColumns = 6;
        sizeManagement.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.minimumHeight = 50;
        sizeManagement.setLayoutData((Object)data);
        new Label((Composite)sizeManagement, 0).setText(Messages.FileFieldPropertiesComposite_30);
        new Label((Composite)sizeManagement, 0).setText(Messages.FileFieldPropertiesComposite_31);
        this.stringMinSize = new Text((Composite)sizeManagement, 0);
        this.stringMinSize.setText("50");
        this.stringMinSize.addVerifyListener(numericVerif);
        this.stringMinSize.addFocusListener((FocusListener)new NumericFocusListener(this.stringMinSize));
        GridData gd = new GridData();
        gd.minimumWidth = 40;
        gd.grabExcessHorizontalSpace = true;
        this.stringMinSize.setLayoutData((Object)gd);
        new Label((Composite)sizeManagement, 0).setText(Messages.FileFieldPropertiesComposite_33);
        this.stringSafetyMarginSize = new Text((Composite)sizeManagement, 0);
        this.stringSafetyMarginSize.addVerifyListener(numericVerif);
        this.stringSafetyMarginSize.setText("50");
        this.stringSafetyMarginSize.addFocusListener((FocusListener)new NumericFocusListener(this.stringSafetyMarginSize));
        gd = new GridData();
        gd.minimumWidth = 40;
        gd.grabExcessHorizontalSpace = true;
        this.stringSafetyMarginSize.setLayoutData((Object)gd);
        this.determineDatatype = new Button((Composite)sizeManagement, 32);
        this.determineDatatype.setText(Messages.FileFieldPropertiesComposite_35);
        this.determineDatatype.setSelection(true);
        this.determineDatatype.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (FileFieldPropertiesComposite.this.determineDatatype.getSelection()) {
                    FileFieldPropertiesComposite.this.numericMinSize.setEnabled(true);
                    FileFieldPropertiesComposite.this.numericSafetyMarginSize.setEnabled(true);
                } else {
                    FileFieldPropertiesComposite.this.numericMinSize.setEnabled(false);
                    FileFieldPropertiesComposite.this.numericSafetyMarginSize.setEnabled(false);
                }
            }
        });
        new Label((Composite)sizeManagement, 0).setText(Messages.FileFieldPropertiesComposite_36);
        new Label((Composite)sizeManagement, 0).setText(Messages.FileFieldPropertiesComposite_37);
        this.numericMinSize = new Text((Composite)sizeManagement, 0);
        this.numericMinSize.addVerifyListener(numericVerif);
        this.numericMinSize.setText("12");
        this.numericMinSize.addFocusListener((FocusListener)new NumericFocusListener(this.numericMinSize));
        gd = new GridData();
        gd.minimumWidth = 40;
        gd.grabExcessHorizontalSpace = true;
        this.numericMinSize.setLayoutData((Object)gd);
        new Label((Composite)sizeManagement, 0).setText(Messages.FileFieldPropertiesComposite_39);
        this.numericSafetyMarginSize = new Text((Composite)sizeManagement, 0);
        this.numericSafetyMarginSize.setText("0");
        this.numericSafetyMarginSize.addFocusListener((FocusListener)new NumericFocusListener(this.numericSafetyMarginSize));
        this.numericSafetyMarginSize.addVerifyListener(numericVerif);
        gd = new GridData();
        gd.minimumWidth = 40;
        gd.grabExcessHorizontalSpace = true;
        this.numericSafetyMarginSize.setLayoutData((Object)gd);
        new Label((Composite)sizeManagement, 0);
        this.chkPositionIfSize = new Button((Composite)reverseOptionGroup, 32);
        this.chkPositionIfSize.setSelection(true);
        this.chkPositionIfSize.setText(Messages.FileFieldPropertiesComposite_41);
        this.createTable((Composite)reverseGroup);
        this.refresGroup = new Group((Composite)composite, 0);
        this.refresGroup.setText(Messages.FileFieldPropertiesComposite_42);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 10;
        this.refresGroup.setLayout((Layout)layout);
        label = new Label((Composite)this.refresGroup, 0);
        label.setText(Messages.FileFieldPropertiesComposite_43);
        this.nbRefreshRows = new Text((Composite)this.refresGroup, 2048);
        this.nbRefreshRows.setText("100");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 30;
        gd.minimumWidth = 30;
        this.nbRefreshRows.setLayoutData((Object)gd);
        Button refresh = new Button((Composite)this.refresGroup, 0);
        refresh.setText(Messages.FileFieldPropertiesComposite_45);
        data = new GridData(768);
        refresh.setLayoutData((Object)data);
        Button autoRefresh = new Button((Composite)this.refresGroup, 32);
        autoRefresh.setText(Messages.FileFieldPropertiesComposite_46);
        autoRefresh.setLayoutData((Object)new GridData(3, 2, false, false));
        autoRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileFieldPropertiesComposite.this.autoRefreshMode = ((Button)e.widget).getSelection();
            }
        });
        this.nbRefreshRows.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        this.sourceViewer = new TextViewer((Composite)this.refresGroup, 68362);
        this.sourceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.sourceViewer.getControl().setFont(FileUiUtil.get_Font());
        this.sourceViewer.setDocument((IDocument)new Document());
        this.sourceViewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                Vector<StyleRange> styles = new Vector<StyleRange>(FileFieldPropertiesComposite.this.regioner.ordered.size());
                if (!FileFieldPropertiesComposite.this.regioner.isEnabled()) {
                    event.styles = null;
                    return;
                }
                Color last = null;
                for (Region r : FileFieldPropertiesComposite.this.regioner.ordered) {
                    if (FileFieldPropertiesComposite.this.regioner.isOverlap(r)) {
                        styles.add(new StyleRange(event.lineOffset + r.getOffset() - 1, r.getLength(), null, ERROR));
                        continue;
                    }
                    last = last == null || last == ALTERNATE_2 ? ALTERNATE_1 : ALTERNATE_2;
                    styles.add(new StyleRange(event.lineOffset + r.getOffset() - 1, r.getLength(), null, last));
                }
                event.styles = new StyleRange[styles.size()];
                styles.copyInto(event.styles);
            }
        });
        this.refreshPosition();
        refresh.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                try {
                    FileFieldPropertiesComposite.this.refreshTable(true);
                }
                catch (Exception e2) {
                    String message = "Error during reverse";
                    MessageDialog.openError((Shell)FileFieldPropertiesComposite.this.getShell(), (String)Messages.FileFieldPropertiesComposite_49, (String)e2.getMessage());
                    Activator.error(message, e2);
                }
            }
        });
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean positionMode;
                boolean bl = positionMode = !FileUtil.getType(FileFieldPropertiesComposite.this.getFile()).equals("DELIMITED");
                if (positionMode && FileFieldPropertiesComposite.this.startPositions != null) {
                    int i = 0;
                    while (i < FileFieldPropertiesComposite.this.startPositions.length) {
                        Integer cfr_ignored_0 = FileFieldPropertiesComposite.this.startPositions[i];
                        ++i;
                    }
                }
            }
        };
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(65, 0);
        reverseGroup.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)reverseGroup, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.refresGroup.setLayoutData((Object)fd);
    }

    public abstract MdNode getFile();

    private List<MdNode> getFields() {
        try {
            List fields = (List)this.getFile().evaluateMdSet("field[not(@ancestorLevel>'0') and not(@expression!='')]");
            Collections.sort(fields, new Comparator<MdNode>(){

                @Override
                public int compare(MdNode arg0, MdNode arg1) {
                    return arg0.compare((Configuration)arg1);
                }
            });
            return fields;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void refreshPosition() {
        boolean positionMode = !FileUtil.getType(this.getFile()).equals("DELIMITED");
        List<MdNode> fields = this.getFields();
        this.startPositions = new Integer[fields.size() > 0 ? fields.size() + 1 : 0];
        this.endPositions = new Integer[this.startPositions.length];
        int i = 0;
        this.fieldDescriptorList = new ArrayList<FieldDescriptor>();
        int position = 0;
        for (MdNode node : fields) {
            if (node.getPosition() != null) {
                position += node.getPosition().intValue();
                FieldDescriptor fd = null;
                fd = new FieldDescriptor();
                this.fieldDescriptorList.add(fd);
                FileUtil.synchronizeFieldDescriptor(fd, node);
                String strPosition = "0";
                strPosition = positionMode ? node.getPosition().toString() : new Integer(position).toString();
                String size = node.getAttributeValueByShortCode("size");
                if (strPosition != null && size != null) {
                    this.startPositions[i] = new Integer(strPosition);
                    this.endPositions[i] = this.startPositions[i] + new Integer(size);
                }
            }
            ++i;
        }
    }

    public void createTable(Composite comp) {
        int style = 101124;
        this.tv = new MdTableViewer(comp, style, this.getFile(), "com.stambia.file.field"){

            public Object[] getElements() {
                List fields = FileFieldPropertiesComposite.this.getFields();
                if (fields != null) {
                    return fields.toArray();
                }
                return null;
            }

            public void handleModification(MdNode node, String property, Object newValue, Object oldValue) {
                FileFieldPropertiesComposite.this.refreshPosition();
                if (("size".equals(property) || "position".equals(property)) && FileFieldPropertiesComposite.this.autoRefreshMode) {
                    FileFieldPropertiesComposite.this.refreshTable(false);
                }
                if (property.equals("name")) {
                    String physical = node.getAttributeValueByShortCode("physicalName");
                    if (physical.equals(oldValue)) {
                        node.setAttribute("physicalName", newValue.toString(), true);
                    }
                } else if (FileFieldPropertiesComposite.this.chkPositionIfSize.getSelection() && property.equals("size") && FileUtil.getType(FileFieldPropertiesComposite.this.getFile()).equals("POSITIONAL")) {
                    int oldPosition = new Integer(oldValue.toString());
                    int diff = new Integer(newValue.toString()) - new Integer(oldValue.toString());
                    if (diff != 0) {
                        try {
                            List list = (List)FileFieldPropertiesComposite.this.getFile().evaluate("field", XPathConstants.NODESET);
                            Collections.sort(list, new Comparator<MdNode>(){

                                @Override
                                public int compare(MdNode o1, MdNode o2) {
                                    return o1.compare((Configuration)o2);
                                }
                            });
                            boolean start = false;
                            boolean ok = true;
                            for (MdNode _node : list) {
                                int newV;
                                if (_node == node) {
                                    start = true;
                                    continue;
                                }
                                if (!start || !ok) continue;
                                boolean bl = ok = oldPosition < _node.getPosition().intValue();
                                if (!ok || (newV = _node.getPosition().intValue() + diff) < 1) continue;
                                _node.setPosition(new BigInteger(new Integer(newV).toString()));
                            }
                        }
                        catch (XPathExpressionException e) {
                            e.printStackTrace();
                        }
                    }
                }
                FileFieldPropertiesComposite.this.refreshPosition();
                if (("size".equals(property) || "position".equals(property)) && FileFieldPropertiesComposite.this.autoRefreshMode) {
                    FileFieldPropertiesComposite.this.refreshTable(false);
                }
            }

            public void handleSelection(SelectionEvent e) {
            }

            public void handleAddNode(MdNode node) {
                MdNode previous;
                if (FileUtil.getType(FileFieldPropertiesComposite.this.getFile()).equals("POSITIONAL") && (previous = node.getPreviousNode()) != null) {
                    BigInteger big = new BigInteger(new Integer(previous.getPosition().intValue() + new Integer(previous.getAttributeValueByShortCode("size"))).toString());
                    node.setPositionWithTransaction(big);
                    FileFieldPropertiesComposite.this.tv.refresh();
                }
                FileFieldPropertiesComposite.this.refreshPosition();
                if (FileFieldPropertiesComposite.this.autoRefreshMode) {
                    FileFieldPropertiesComposite.this.refreshTable(false);
                }
            }

            public void handleMoveNode(MdNode node, MdNode permut) {
                FileFieldPropertiesComposite.this.refreshPosition();
                if (FileFieldPropertiesComposite.this.autoRefreshMode) {
                    FileFieldPropertiesComposite.this.refreshTable(false);
                }
            }

            public void handleRemoveNode(MdNode node) {
                FileFieldPropertiesComposite.this.refreshPosition();
                if (FileFieldPropertiesComposite.this.autoRefreshMode) {
                    FileFieldPropertiesComposite.this.refreshTable(false);
                }
            }
        };
        GridData data = new GridData(4);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 120;
        this.tv.getTable().setLayoutData((Object)data);
        MdTableViewer mdTableViewer = this.tv;
        mdTableViewer.getClass();
        this.tv.setSorter((ViewerSorter)new MdTableViewer.MdSorter(mdTableViewer, "position"));
        Composite compTable = new Composite(comp, 0);
        compTable.setLayout((Layout)new GridLayout());
        compTable.setLayoutData((Object)new GridData(3, 2, false, true));
        Button delete = new Button(compTable, 0);
        this.tv.addDeletetButton(delete);
        Button add = new Button(compTable, 0);
        this.tv.addNewButton(add);
        Button up = new Button(compTable, 0);
        this.tv.addUpButton(up);
        Button down = new Button(compTable, 0);
        this.tv.addDownButton(down);
        this.tv.setDefaultLabelProvider();
        this.tv.setInput((Object)this.getFile());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setHelpers();
            if (FileUtil.getType(this.getFile()).equals("DELIMITED")) {
                this.chkPositionIfSize.setEnabled(false);
                this.stringMinSize.setEnabled(true);
                this.stringSafetyMarginSize.setEnabled(true);
                this.numericMinSize.setEnabled(true);
                this.numericSafetyMarginSize.setEnabled(true);
            } else {
                this.chkPositionIfSize.setEnabled(true);
                this.stringMinSize.setEnabled(false);
                this.stringSafetyMarginSize.setEnabled(false);
                this.numericMinSize.setEnabled(false);
                this.numericSafetyMarginSize.setEnabled(false);
            }
        }
        super.setVisible(visible);
    }

    private void updateHelper(String data, int mode, List<FieldDescriptor> list) {
        String tmp = data;
        tmp = tmp.isEmpty() ? null : tmp;
        String[] helper = tmp != null ? tmp.split("\n|;") : new String[]{};
        int _index = 0;
        while (_index < helper.length) {
            FieldDescriptor item = null;
            if (list.size() > _index) {
                item = list.get(_index);
            }
            if (item == null) {
                item = new FieldDescriptor();
                list.add(item);
            }
            if (mode == 0) {
                try {
                    item.name = helper[_index].trim();
                    item.noName = false;
                }
                catch (Exception e) {
                    item.name = null;
                    item.noName = true;
                }
            }
            if (mode == 1) {
                try {
                    item.position = Integer.valueOf(helper[_index].trim());
                }
                catch (Exception e) {
                    item.position = -1;
                }
            }
            if (mode == 2) {
                try {
                    item.size = Integer.valueOf(helper[_index].trim());
                }
                catch (Exception e) {
                    item.size = null;
                }
            }
            if (mode == 3) {
                try {
                    item.type = helper[_index].trim();
                }
                catch (Exception e) {
                    item.type = null;
                }
            }
            if (mode == 4) {
                try {
                    item.decimal = Integer.valueOf(helper[_index].trim());
                }
                catch (Exception e) {
                    item.decimal = null;
                }
            }
            if (mode == 5) {
                try {
                    item.format = helper[_index].trim();
                }
                catch (Exception e) {
                    item.format = null;
                }
            }
            ++_index;
        }
    }

    private void setHelpers() {
        try {
            this.updateHelper(this.getFile().evaluate("@nameHelper"), 0, this.fieldDescriptorHelper);
            this.updateHelper(this.getFile().evaluate("@positionHelper"), 1, this.fieldDescriptorHelper);
            this.updateHelper(this.getFile().evaluate("@sizeHelper"), 2, this.fieldDescriptorHelper);
            this.updateHelper(this.getFile().evaluate("@typeHelper"), 3, this.fieldDescriptorHelper);
            this.updateHelper(this.getFile().evaluate("@decimalHelper"), 4, this.fieldDescriptorHelper);
            this.updateHelper(this.getFile().evaluate("@formatHelper"), 5, this.fieldDescriptorHelper);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void recordHelper() {
        String fieldNameHelper = "";
        String fieldPositionHelper = "";
        String fieldSizeHelper = "";
        String fieldPrecisionHelper = "";
        String fieldTypeHelper = "";
        String fieldFormatHelper = "";
        if (this.fieldDescriptorHelper.size() > 0) {
            String sep = "";
            int i = 0;
            while (i < this.fieldDescriptorHelper.size()) {
                FieldDescriptor ti = this.fieldDescriptorHelper.get(i);
                if (i > 0) {
                    sep = ";";
                }
                fieldNameHelper = ti.name != null ? String.valueOf(fieldNameHelper) + sep + ti.name : String.valueOf(fieldNameHelper) + sep;
                fieldPositionHelper = ti.position > -1 ? String.valueOf(fieldPositionHelper) + sep + ti.position : String.valueOf(fieldPositionHelper) + sep;
                fieldSizeHelper = ti.size != null ? String.valueOf(fieldSizeHelper) + sep + ti.size : String.valueOf(fieldSizeHelper) + sep;
                fieldPrecisionHelper = ti.decimal != null ? String.valueOf(fieldPrecisionHelper) + sep + ti.decimal : String.valueOf(fieldPrecisionHelper) + sep;
                fieldTypeHelper = ti.type != null ? String.valueOf(fieldTypeHelper) + sep + ti.type : String.valueOf(fieldTypeHelper) + sep;
                fieldFormatHelper = ti.format != null ? String.valueOf(fieldFormatHelper) + sep + ti.format : String.valueOf(fieldFormatHelper) + sep;
                ++i;
            }
            if (fieldNameHelper.length() == this.fieldDescriptorHelper.size() - 1) {
                fieldNameHelper = null;
            }
            if (fieldPositionHelper.length() == this.fieldDescriptorHelper.size() - 1) {
                fieldPositionHelper = null;
            }
            if (fieldSizeHelper.length() == this.fieldDescriptorHelper.size() - 1) {
                fieldSizeHelper = null;
            }
            if (fieldPrecisionHelper.length() == this.fieldDescriptorHelper.size() - 1) {
                fieldPrecisionHelper = null;
            }
            if (fieldTypeHelper.length() == this.fieldDescriptorHelper.size() - 1) {
                fieldTypeHelper = null;
            }
            if (fieldFormatHelper.length() == this.fieldDescriptorHelper.size() - 1) {
                fieldFormatHelper = null;
            }
        } else {
            fieldNameHelper = null;
            fieldPositionHelper = null;
            fieldSizeHelper = null;
            fieldPrecisionHelper = null;
            fieldTypeHelper = null;
            fieldFormatHelper = null;
        }
        this.getFile().setAttribute("nameHelper", fieldNameHelper, true);
        this.getFile().setAttribute("positionHelper", fieldPositionHelper, true);
        this.getFile().setAttribute("sizeHelper", fieldSizeHelper, true);
        this.getFile().setAttribute("decimalHelper", fieldPrecisionHelper, true);
        this.getFile().setAttribute("typeHelper", fieldTypeHelper, true);
        this.getFile().setAttribute("formatHelper", fieldFormatHelper, true);
    }

    public abstract void handleModification();

    class DialogHelper
    extends Dialog {
        private Table table;
        boolean delimited;

        protected DialogHelper(Shell parentShell) {
            super(parentShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            FileFieldPropertiesComposite.this.fieldDescriptorHelper = FileFieldPropertiesComposite.this.tmpFieldDescriptorHelper;
            FileFieldPropertiesComposite.this.recordHelper();
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            this.delimited = FileUtil.getType(FileFieldPropertiesComposite.this.getFile()).equals("DELIMITED");
            FileFieldPropertiesComposite.this.tmpFieldDescriptorHelper = new ArrayList<FieldDescriptor>(FileFieldPropertiesComposite.this.fieldDescriptorHelper);
            ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
            Composite composite = new Composite((Composite)scrolled, 0);
            GridData gd = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)gd);
            composite.setLayout((Layout)new GridLayout());
            Button clear = new Button(composite, 0);
            clear.setText(Messages.FileFieldPropertiesComposite_57);
            this.table = new Table(composite, 0);
            final TableViewer tableViewer = new TableViewer(this.table);
            clear.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    ((DialogHelper)DialogHelper.this).FileFieldPropertiesComposite.this.tmpFieldDescriptorHelper.clear();
                    tableViewer.refresh();
                }
            });
            gd = new GridData(4, 4, true, true);
            this.table.setLayoutData((Object)gd);
            TableLayout tableLayout = new TableLayout();
            this.table.setLayout((Layout)tableLayout);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            Clipboard cb = new Clipboard(FileFieldPropertiesComposite.this.getDisplay());
            TableColumn objectColumn = new TableColumn(this.table, 0);
            objectColumn.addSelectionListener((SelectionListener)new HelperListener(0, (Viewer)tableViewer, cb));
            objectColumn.setText(Messages.FileFieldPropertiesComposite_58);
            objectColumn.setWidth(100);
            if (!this.delimited) {
                objectColumn = new TableColumn(this.table, 0);
                objectColumn.addSelectionListener((SelectionListener)new HelperListener(1, (Viewer)tableViewer, cb));
                objectColumn.setWidth(60);
                objectColumn.setText(Messages.FileFieldPropertiesComposite_59);
            }
            objectColumn = new TableColumn(this.table, 0);
            objectColumn.addSelectionListener((SelectionListener)new HelperListener(2, (Viewer)tableViewer, cb));
            objectColumn.setWidth(50);
            objectColumn.setText(Messages.FileFieldPropertiesComposite_60);
            objectColumn = new TableColumn(this.table, 0);
            objectColumn.addSelectionListener((SelectionListener)new HelperListener(3, (Viewer)tableViewer, cb));
            objectColumn.setWidth(70);
            objectColumn.setText(Messages.FileFieldPropertiesComposite_61);
            objectColumn = new TableColumn(this.table, 0);
            objectColumn.addSelectionListener((SelectionListener)new HelperListener(4, (Viewer)tableViewer, cb));
            objectColumn.setWidth(70);
            objectColumn.setText(Messages.FileFieldPropertiesComposite_62);
            objectColumn = new TableColumn(this.table, 0);
            objectColumn.addSelectionListener((SelectionListener)new HelperListener(5, (Viewer)tableViewer, cb));
            objectColumn.setWidth(70);
            objectColumn.setText(Messages.FileFieldPropertiesComposite_63);
            ScrolledCompositeWizardHelper.adaptToContent(scrolled, composite);
            tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return ((DialogHelper)DialogHelper.this).FileFieldPropertiesComposite.this.tmpFieldDescriptorHelper.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    int offset;
                    int n = offset = DialogHelper.this.delimited ? 1 : 0;
                    if (columnIndex == 0 && ((FieldDescriptor)element).name != null) {
                        return ((FieldDescriptor)element).name;
                    }
                    if (!DialogHelper.this.delimited && columnIndex == 1 && ((FieldDescriptor)element).position > -1) {
                        return String.valueOf(((FieldDescriptor)element).position);
                    }
                    if (columnIndex == 2 - offset && ((FieldDescriptor)element).size != null) {
                        return String.valueOf(((FieldDescriptor)element).size);
                    }
                    if (columnIndex == 3 - offset && ((FieldDescriptor)element).type != null) {
                        return ((FieldDescriptor)element).type;
                    }
                    if (columnIndex == 4 - offset && ((FieldDescriptor)element).decimal != null) {
                        return String.valueOf(((FieldDescriptor)element).decimal);
                    }
                    if (columnIndex == 5 - offset && ((FieldDescriptor)element).format != null) {
                        return String.valueOf(((FieldDescriptor)element).format);
                    }
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            tableViewer.setInput(FileFieldPropertiesComposite.this.tmpFieldDescriptorHelper);
            return composite;
        }
    }

    class HelperListener
    implements SelectionListener {
        Viewer viewer;
        Clipboard cb;
        int index;

        public HelperListener(int index, Viewer viewer, Clipboard cb) {
            this.cb = cb;
            this.index = index;
            this.viewer = viewer;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TextTransfer transfer = TextTransfer.getInstance();
            String data = (String)this.cb.getContents((Transfer)transfer);
            FileFieldPropertiesComposite.this.updateHelper(data, this.index, FileFieldPropertiesComposite.this.tmpFieldDescriptorHelper);
            this.viewer.refresh();
        }
    }

    class NumericFocusListener
    implements FocusListener {
        Text text;

        private NumericFocusListener(Text text) {
            this.text = text;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (this.text.getText().isEmpty()) {
                this.text.setText("0");
            }
        }
    }

    private class Regioner {
        private boolean enabled = false;
        private List<Region> overlapping = new ArrayList<Region>();
        private List<Region> normals = new ArrayList<Region>();
        private List<Region> ordered = new ArrayList<Region>();

        private Regioner() {
        }

        public boolean isOverlap(Region r) {
            return this.overlapping.contains(r);
        }

        void init() {
            this.overlapping = new ArrayList<Region>();
            this.normals = new ArrayList<Region>();
            this.ordered = new ArrayList<Region>();
            ArrayList<Region> regions = new ArrayList<Region>();
            int i = 0;
            while (i < FileFieldPropertiesComposite.this.startPositions.length) {
                Region r = null;
                if (FileFieldPropertiesComposite.this.startPositions[i] != null) {
                    r = FileFieldPropertiesComposite.this.endPositions[i] == null ? new Region(FileFieldPropertiesComposite.this.startPositions[i].intValue(), -1) : new Region(FileFieldPropertiesComposite.this.startPositions[i].intValue(), FileFieldPropertiesComposite.this.endPositions[i] - FileFieldPropertiesComposite.this.startPositions[i]);
                    regions.add(r);
                }
                ++i;
            }
            ArrayList original = new ArrayList(regions);
            boolean overlaping = true;
            block1: while (overlaping && regions.size() > 0) {
                for (Region r : regions) {
                    for (Region r2 : regions) {
                        if (r == r2) continue;
                        if (r.equals((Object)r2)) {
                            overlaping = true;
                            this.normals.remove(r);
                            this.normals.remove(r2);
                            this.addOverlap(r);
                            continue;
                        }
                        overlaping = this.isOverlaping(r, r2);
                        if (!overlaping) continue;
                        this.normals.remove(r);
                        this.normals.remove(r2);
                        this.overlapping.remove(r);
                        this.overlapping.remove(r2);
                        regions.remove(r2);
                        regions.remove(r);
                        Region[] rr = this.desoverlap(r, r2);
                        int i2 = 0;
                        while (i2 < rr.length) {
                            if (i2 == rr.length - 1) {
                                this.addOverlap(rr[i2]);
                            } else {
                                this.addNormal(rr[i2]);
                            }
                            boolean contains = false;
                            for (Region _r : regions) {
                                if (!_r.equals((Object)rr[i2])) continue;
                                contains = true;
                                break;
                            }
                            if (!contains) {
                                regions.add(rr[i2]);
                            }
                            ++i2;
                        }
                        break block3;
                    }
                    if (overlaping) {
                        if (regions.size() != 1) continue block1;
                        overlaping = false;
                        this.addNormal(r);
                        continue block1;
                    }
                    this.addNormal(r);
                }
            }
            this.ordered.addAll(this.normals);
            this.ordered.addAll(this.overlapping);
            for (Region o : this.ordered) {
                int countRegion = 0;
                for (Region r : original) {
                    if (!this.isOverlaping(r, o)) continue;
                    ++countRegion;
                }
                if (countRegion <= true) continue;
                this.normals.remove(o);
                this.addOverlap(o);
            }
            this.enabled = true;
        }

        private void addNormal(Region region) {
            for (Region o : this.normals) {
                if (!o.equals((Object)region)) continue;
                return;
            }
            for (Region r : this.overlapping) {
                if (!r.equals((Object)region)) continue;
                return;
            }
            this.normals.add(region);
        }

        private void addOverlap(Region region) {
            for (Region o : this.overlapping) {
                if (!o.equals((Object)region)) continue;
                return;
            }
            this.overlapping.add(region);
        }

        Region[] desoverlap(Region r1, Region r2) {
            if (r1.equals((Object)r2)) {
                return new Region[]{r1};
            }
            ArrayList<Region> l = new ArrayList<Region>();
            l.add(r1);
            l.add(r2);
            Region _min = this.findMin(l);
            l.remove(_min);
            Region _other = (Region)l.get(0);
            int max = -1;
            max = _min.getOffset() + _min.getLength() > _other.getOffset() + _other.getLength() ? _min.getOffset() + _min.getLength() : _other.getOffset() + _other.getLength();
            int currentPos = _min.getOffset();
            ArrayList<Point> normal = new ArrayList<Point>();
            ArrayList<Point> overlap = new ArrayList<Point>();
            Point current = null;
            boolean overlaping = false;
            while (currentPos < max) {
                if (currentPos > _min.getOffset() + _min.getLength() && currentPos < _other.getOffset() || currentPos > _min.getOffset() + _min.getLength() && currentPos > _other.getOffset() + _other.getLength() || currentPos < _min.getOffset()) {
                    if (overlaping) {
                        if (current != null) {
                            overlap.add(current);
                        }
                        current = null;
                        overlaping = false;
                    }
                } else if (currentPos == _other.getOffset() && currentPos < _min.getOffset() + _min.getLength()) {
                    if (current != null) {
                        normal.add(current);
                    }
                    current = new Point();
                    current.x = currentPos;
                    overlaping = true;
                } else if (overlaping && (currentPos == _min.getOffset() + _min.getLength() || currentPos == _other.getOffset() + _other.getLength())) {
                    overlap.add(current);
                    overlaping = false;
                    current = new Point();
                    current.x = currentPos;
                } else if (current == null) {
                    current = new Point();
                    current.x = currentPos;
                }
                if (current != null) {
                    ++current.y;
                }
                ++currentPos;
            }
            if (current != null) {
                if (!overlaping) {
                    normal.add(current);
                } else {
                    overlap.add(current);
                }
            }
            ArrayList<Region> _l = new ArrayList<Region>();
            for (Point p : normal) {
                _l.add(new Region(p.x, p.y));
            }
            _l.add(new Region(((Point)overlap.get((int)0)).x, ((Point)overlap.get((int)0)).y));
            return _l.toArray(new Region[_l.size()]);
        }

        boolean isOverlaping(Region r, Region r2) {
            if (r.getOffset() < r2.getOffset()) {
                return r.getOffset() + r.getLength() > r2.getOffset();
            }
            if (r2.getOffset() < r.getOffset()) {
                return r2.getOffset() + r2.getLength() > r.getOffset();
            }
            return true;
        }

        Region findMin(List<Region> l) {
            Region current = null;
            for (Region r : l) {
                if (current == null || r.getOffset() < current.getOffset()) {
                    current = r;
                }
                if (current.getOffset() != r.getOffset() || r.getLength() >= current.getOffset()) continue;
                current = r;
            }
            return current;
        }

        public void disable() {
            this.enabled = false;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return ((MdNode)obj).getName();
            }
            if (index == 1) {
                return ((MdNode)obj).getPosition() == null ? null : ((MdNode)obj).getPosition().toString();
            }
            int _index = index - 2;
            Level level = ((MdNode)obj).getLevel();
            boolean i = false;
            Property p = (Property)level.getAttribute().get(_index);
            try {
                String value = ((MdNode)obj).evaluateMdString("@" + p.getXmlName());
                return value;
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

