/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.composite;

import com.indy.addons.Messages;
import com.indy.file.FileUtil;
import com.indy.file.composite.FileUiUtil;
import com.indy.jdbc.editor.Activator;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.indy.xsl.global.Strings;
import com.stambia.md.MdNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class FilePropertiesComposite
extends Composite {
    public static Image infoImage;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private MdControlManager mcm;
    private Text nameField;
    private Text fileName;
    private Combo type;
    private int flag;

    static {
        try {
            infoImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract MdNode getFile();

    public boolean isComplete() {
        return this.mcm.isComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public FilePropertiesComposite(Composite parent, int style) {
        super(parent, style);
        Text lineSize;
        Label labelLineSize;
        FilePropertiesComposite composite = this;
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        composite.setFont(parent.getFont());
        Composite nameGroup = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameGroup.setLayoutData((Object)data);
        this.mcm = new MdControlManager();
        Label label = new Label(nameGroup, 64);
        label.setText("Name");
        this.nameField = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.nameField, this.getFile(), null, 3, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        label = new Label(nameGroup, 64);
        this.mcm.addControl((Control)label, this.getFile(), "physicalName", 0, false, false);
        this.fileName = new Text(nameGroup, 2048);
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.mcm.addControl((Control)this.fileName, this.getFile(), "physicalName", 1, true, true);
        data = new GridData(768);
        data.widthHint = 250;
        this.fileName.setLayoutData((Object)data);
        Button browse = new Button(nameGroup, 0);
        browse.setText(Messages.FilePropertiesComposite_2);
        browse.setLayoutData((Object)new GridData(768));
        label = new Label(nameGroup, 64);
        this.mcm.addControl((Control)label, this.getFile(), "type", 0, false, false);
        this.type = new Combo(nameGroup, 2060);
        this.mcm.addControl((Control)this.type, this.getFile(), "type", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.type.setLayoutData((Object)data);
        if (this.getFile().getLevel().getAttributeByXmlName("charsetName") != null) {
            label = new Label(nameGroup, 64);
            Combo comboEncoding = new Combo(nameGroup, 2048);
            new Label(nameGroup, 0);
            this.addComboText(nameGroup, "charsetName", label, comboEncoding, null, false);
        }
        this.addComboText(nameGroup, "lineSeparator", null, null, null, true);
        label = new Label(nameGroup, 64);
        final Combo comboFieldSeparator = new Combo(nameGroup, 2048);
        final Text fieldSeparator = new Text(nameGroup, 2048);
        String region = com.indy.ui.custom.out.Activator.getDefault().readProperty("osgi.nl");
        if (region != null && region.startsWith("fr_")) {
            this.addComboText(nameGroup, "fieldSeparator", label, comboFieldSeparator, fieldSeparator, true, "3B");
        } else {
            this.addComboText(nameGroup, "fieldSeparator", label, comboFieldSeparator, fieldSeparator, true);
        }
        if (FileUtil.getType(this.getFile()).equals("POSITIONAL")) {
            comboFieldSeparator.setEnabled(false);
            fieldSeparator.setEnabled(false);
        }
        label = new Label(nameGroup, 64);
        final Combo comboStringDelimiter = new Combo(nameGroup, 2048);
        final Text stringDelimiter = new Text(nameGroup, 2048);
        this.addComboText(nameGroup, "stringDelimiter", label, comboStringDelimiter, stringDelimiter, true);
        if (FileUtil.getType(this.getFile()).equals("POSITIONAL")) {
            comboStringDelimiter.setEnabled(false);
            stringDelimiter.setEnabled(false);
        }
        this.addComboText(nameGroup, "decimalSeparator", null, null, null, true);
        Label labelEscapeChar = new Label(nameGroup, 0);
        ControlDecoration deco = new ControlDecoration((Control)labelEscapeChar, 0x1020000);
        deco.setDescriptionText(Messages.FilePropertiesComposite_61);
        deco.setImage(infoImage);
        deco.setShowHover(true);
        deco.setShowOnlyOnFocus(false);
        this.mcm.addControl((Control)labelEscapeChar, this.getFile(), "escapeChar", 0, false, false);
        Text escapeChar = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)escapeChar, this.getFile(), "escapeChar", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        escapeChar.setLayoutData((Object)data);
        VerifyListener numericVerif = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[\\-]?[0-9]*");
            }
        };
        if (this.getFile().getLevel().getAttributeByXmlName("lineToSkip") != null) {
            Label labelLineToSkip = new Label(nameGroup, 0);
            this.mcm.addControl((Control)labelLineToSkip, this.getFile(), "lineToSkip", 0, false, false);
            Text nbLineToSkip = new Text(nameGroup, 2048);
            this.mcm.addControl((Control)nbLineToSkip, this.getFile(), "lineToSkip", 1, true, false);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 250;
            nbLineToSkip.setLayoutData((Object)data);
            nbLineToSkip.addVerifyListener(numericVerif);
        }
        if (this.getFile().getLevel().getAttributeByXmlName("lastLineToSkip") != null) {
            labelLineSize = new Label(nameGroup, 0);
            this.mcm.addControl((Control)labelLineSize, this.getFile(), "lastLineToSkip", 0, false, false);
            lineSize = new Text(nameGroup, 2048);
            this.mcm.addControl((Control)lineSize, this.getFile(), "lastLineToSkip", 1, true, false);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 250;
            lineSize.setLayoutData((Object)data);
        }
        if (this.getFile().getLevel().getAttributeByXmlName("lineSize") != null) {
            labelLineSize = new Label(nameGroup, 0);
            this.mcm.addControl((Control)labelLineSize, this.getFile(), "lineSize", 0, false, false);
            lineSize = new Text(nameGroup, 2048);
            this.mcm.addControl((Control)lineSize, this.getFile(), "lineSize", 1, true, false);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 250;
            lineSize.setLayoutData((Object)data);
        }
        Label labelHeader = new Label(nameGroup, 0);
        this.mcm.addControl((Control)labelHeader, this.getFile(), "header", 0, false, false);
        Text nbHeader = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)nbHeader, this.getFile(), "header", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        nbHeader.setLayoutData((Object)data);
        nbHeader.addVerifyListener(numericVerif);
        Group previouGroup = new Group((Composite)composite, 0);
        previouGroup.setText(Messages.FilePropertiesComposite_26);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        previouGroup.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        previouGroup.setLayoutData((Object)data);
        Label labelNbPreview = new Label((Composite)previouGroup, 0);
        labelNbPreview.setText(Messages.FilePropertiesComposite_27);
        final Text nbLine = new Text((Composite)previouGroup, 2048);
        nbLine.setText("100");
        Button refresh = new Button((Composite)previouGroup, 0);
        refresh.setText(Messages.FilePropertiesComposite_29);
        data = new GridData(768);
        refresh.setLayoutData((Object)data);
        final TextViewer preview = new TextViewer((Composite)previouGroup, 68378);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        data.heightHint = 75;
        preview.getControl().setLayoutData((Object)data);
        preview.getControl().setFont(FileUiUtil.get_Font());
        preview.setDocument((IDocument)new Document());
        this.mcm.init();
        this.mcm.addListener(new MdControlManager.MdControlListener(){

            public void modifyValue(MdControlManager.MdControlEvent event) {
                FilePropertiesComposite.this.handleModification(event);
            }
        });
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String currentPath = null;
                EObject o = FilePropertiesComposite.this.getFile().eContainer();
                File parentFile = null;
                try {
                    currentPath = FilePropertiesComposite.this.getFile().evaluateXpathExpression(FileUtil.XPATH_EXPRESSION_PATH);
                    parentFile = new File(((MdNode)o).evaluateXpathExpression(FileUtil.XPATH_EXPRESSION_PATH));
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
                File curFile = new File(currentPath);
                String filter = null;
                filter = curFile.exists() && curFile.isFile() ? currentPath : (parentFile != null ? parentFile.getAbsolutePath() : currentPath);
                FileDialog fdlg = new FileDialog(FilePropertiesComposite.this.getShell(), 4096);
                fdlg.setFilterPath(filter);
                String file = fdlg.open();
                if (file != null) {
                    File f = new File(file);
                    if (f.getParentFile().getAbsolutePath().toUpperCase().equals(parentFile.getAbsolutePath().toUpperCase())) {
                        if (FilePropertiesComposite.this.nameField.getText() == null || FilePropertiesComposite.this.nameField.getText().equals("")) {
                            String tmp = f.getName();
                            int index = tmp.lastIndexOf(".");
                            int length = tmp.length() - index - 1;
                            if (index > 0 && length <= 4) {
                                tmp = tmp.substring(0, index);
                            }
                            if (tmp.substring(0, 1).matches("[0-9]")) {
                                tmp = "A" + tmp;
                            }
                            tmp = tmp.replaceAll(" ", "_");
                            tmp = Normalizer.normalize(tmp, Normalizer.Form.NFD);
                            tmp = tmp.replaceAll("[^\\p{ASCII}]", "");
                            tmp = tmp.replaceAll("[^A-Z^a-z^0-9^_]", "_");
                            FilePropertiesComposite.this.nameField.setText(tmp);
                        }
                        FilePropertiesComposite.this.fileName.setText(f.getName());
                    } else {
                        MessageDialog.openInformation((Shell)FilePropertiesComposite.this.getShell(), (String)Messages.FilePropertiesComposite_4, (String)Messages.bind((String)Messages.FilePropertiesComposite_5, (Object)currentPath));
                    }
                }
            }
        });
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilePropertiesComposite.this.handleModification(e);
            }
        });
        nbLine.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        refresh.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                preview.getDocument().set("");
                try {
                    int nb = nbLine.getText().equals("") ? 0 : Integer.valueOf(nbLine.getText());
                    String tmp = FileUtil.getPreviewData(FilePropertiesComposite.this.getFile(), nb, true);
                    preview.getControl().setFont(FileUiUtil.get_Font());
                    preview.getDocument().set(tmp);
                }
                catch (Exception e2) {
                    String message = "Error during refresh";
                    MessageDialog.openError((Shell)FilePropertiesComposite.this.getShell(), (String)Messages.FilePropertiesComposite_48, (String)e2.getMessage());
                    Activator.error(message, e2);
                }
            }
        });
        this.mcm.addListener(new MdControlManager.MdControlListener(){

            public void modifyValue(MdControlManager.MdControlEvent event) {
                if (event.control.equals(FilePropertiesComposite.this.type)) {
                    try {
                        String str = event.node.evaluate("@type");
                        if (str != null && str.equals("DELIMITED")) {
                            comboFieldSeparator.setEnabled(true);
                            fieldSeparator.setEnabled(true);
                            comboStringDelimiter.setEnabled(true);
                            stringDelimiter.setEnabled(true);
                        } else {
                            comboFieldSeparator.setEnabled(false);
                            fieldSeparator.setEnabled(false);
                            comboStringDelimiter.setEnabled(false);
                            stringDelimiter.setEnabled(false);
                        }
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public Text getNameField() {
        return this.nameField;
    }

    public void addComboText(Composite composite, String name, Label _label, Combo _combo, Text _text, boolean hexa) {
        this.addComboText(composite, name, _label, _combo, _text, hexa, null);
    }

    private void addComboText(Composite composite, String name, Label _label, Combo _combo, Text _text, boolean hexa, String defaultValue) {
        Label label = _label != null ? _label : new Label(composite, 64);
        final Combo combo = _combo != null ? _combo : new Combo(composite, 2048);
        this.mcm.addControl((Control)label, this.getFile(), name, 0, false, false);
        try {
            String xpath = this.getFile().getLevel().getAttributeByXmlName(name).getMdXpathAccess();
            Object list = this.getFile().evaluateMdSet(xpath);
            if (list instanceof List) {
                for (Object str : (List)list) {
                    if (hexa) {
                        try {
                            combo.add(Strings.decodeHexString((String)str.toString()));
                        }
                        catch (UnsupportedEncodingException e) {
                            Activator.error("Error during hexa decoding: " + str.toString(), e);
                        }
                        continue;
                    }
                    combo.add(str.toString());
                }
            }
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        GridData data = new GridData(768);
        data.widthHint = 250;
        combo.setLayoutData((Object)data);
        if (hexa) {
            final Text text = _text != null ? _text : new Text(composite, 2048);
            text.setLayoutData((Object)new GridData(768));
            this.mcm.addControl((Control)text, this.getFile(), name, 1, true, defaultValue, false);
            final Flag flag = new Flag();
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (flag.flag > 0) {
                        flag.flag = -1;
                    } else {
                        flag.flag = 1;
                        try {
                            combo.setText(Strings.decodeHexString((String)text.getText()));
                        }
                        catch (UnsupportedEncodingException e1) {
                            Activator.error("Error during hexa decoding: " + text.getText(), e1);
                        }
                    }
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (flag.flag > 0) {
                        flag.flag = -1;
                    } else {
                        flag.flag = 1;
                        try {
                            text.setText(Strings.encodeHexString((String)combo.getText()));
                        }
                        catch (UnsupportedEncodingException e1) {
                            Activator.error("Error during hexa decoding: " + text.getText(), e1);
                        }
                    }
                }
            });
        } else {
            this.mcm.addControl((Control)combo, this.getFile(), name, 1, true, false);
        }
    }

    public abstract void handleModification(Object var1);

    public String isNameValid() {
        String tmp = this.nameField.getText();
        if (tmp != null && !tmp.isEmpty()) {
            if (!tmp.substring(0, 1).matches("[A-Za-z]")) {
                return Messages.FilePropertiesComposite_55;
            }
            if (tmp.matches("[^\\p{ASCII}]")) {
                return Messages.FilePropertiesComposite_57;
            }
            if (!tmp.matches("[A-Za-z0-9_]*")) {
                return Messages.FilePropertiesComposite_59;
            }
            return null;
        }
        return Messages.FilePropertiesComposite_60;
    }

    class Flag {
        int flag = 0;

        Flag() {
        }
    }
}

