/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.composite;

import com.indy.addons.Messages;
import com.indy.file.FileUtil;
import com.indy.file.composite.FileUiUtil;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.stambia.md.MdNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class FileTransformationComposite
extends Composite {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private MdControlManager mcm;

    public abstract MdNode getFile();

    public boolean isComplete() {
        return this.mcm.isComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public FileTransformationComposite(Composite parent, int style, String xpathScriptAccess) {
        super(parent, style);
        FileTransformationComposite composite = this;
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        composite.setFont(parent.getFont());
        SashForm form = new SashForm((Composite)composite, 512);
        form.setLayout((Layout)new FillLayout());
        form.setLayoutData((Object)new GridData(1808));
        form.setFont(parent.getFont());
        Composite nameGroup = new Composite((Composite)form, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        nameGroup.setLayoutData((Object)data);
        Text script = new Text(nameGroup, 2834);
        Font font = new Font((Device)this.getShell().getDisplay(), new FontData("Lucida Console", 9, 0));
        script.setFont(font);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        data.heightHint = 300;
        script.setLayoutData((Object)data);
        this.mcm = new MdControlManager();
        this.mcm.addControl((Control)script, this.getFile(), xpathScriptAccess, 1, true, false);
        Group previouGroup = new Group((Composite)form, 0);
        previouGroup.setText(Messages.FileTransformationComposite_1);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        previouGroup.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        previouGroup.setLayoutData((Object)data);
        Label labelNbPreview = new Label((Composite)previouGroup, 0);
        labelNbPreview.setText(Messages.FileTransformationComposite_2);
        final Text nbLine = new Text((Composite)previouGroup, 2048);
        nbLine.setText("100");
        Button refresh = new Button((Composite)previouGroup, 0);
        refresh.setText(Messages.FileTransformationComposite_4);
        data = new GridData(768);
        refresh.setLayoutData((Object)data);
        final TextViewer preview = new TextViewer((Composite)previouGroup, 68378);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        preview.getControl().setLayoutData((Object)data);
        preview.getControl().setFont(FileUiUtil.get_Font());
        preview.setDocument((IDocument)new Document());
        this.mcm.init();
        this.mcm.addListener(new MdControlManager.MdControlListener(){

            public void modifyValue(MdControlManager.MdControlEvent event) {
                FileTransformationComposite.this.handleModification(event);
            }
        });
        refresh.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                preview.getDocument().set("");
                try {
                    int nb = nbLine.getText().equals("") ? 0 : Integer.valueOf(nbLine.getText());
                    String tmp = FileUtil.getPreviewData(FileTransformationComposite.this.getFile(), nb, true);
                    preview.getControl().setFont(FileUiUtil.get_Font());
                    preview.getDocument().set(tmp);
                }
                catch (Exception e2) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons", Messages.FileTransformationComposite_3, e2.getCause()), 2);
                }
            }
        });
    }

    public abstract void handleModification(Object var1);

    class Flag {
        int flag = 0;

        Flag() {
        }
    }
}

