/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlFormater {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public String format(InputStream is) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = factory.createXMLEventReader(is);
            XMLEventFactory ef = XMLEventFactory.newInstance();
            int prevType = 0;
            int offset = 0;
            boolean skippedEvent = false;
            while (reader.hasNext()) {
                XMLEvent event = (XMLEvent)reader.next();
                skippedEvent = false;
                if (event.isStartDocument()) {
                    String encoding = null;
                    try {
                        Method meth = event.getClass().getMethod("getCharacterEncodingScheme", new Class[0]);
                        encoding = (String)meth.invoke((Object)event, new Object[0]);
                    }
                    catch (Exception t) {
                        this.logger.debug("Exception !", (Throwable)t);
                    }
                    writer = encoding == null ? XMLOutputFactory.newInstance().createXMLEventWriter(bos) : XMLOutputFactory.newInstance().createXMLEventWriter(bos, encoding);
                    writer.add(event);
                    writer.add(ef.createSpace("\n"));
                } else if (event.isStartElement()) {
                    if (prevType == 2) {
                        writer.add(ef.createSpace("\n"));
                        ++offset;
                    }
                    writer.add(ef.createSpace(this.getOffset(offset)));
                    writer.add(event);
                } else if (event.isEndElement()) {
                    if (prevType == 1) {
                        writer.add(ef.createSpace(this.getOffset(--offset)));
                    }
                    writer.add(event);
                    writer.add(ef.createSpace("\n"));
                } else if (event.isCharacters()) {
                    if (!event.asCharacters().isWhiteSpace()) {
                        writer.add(event);
                    } else {
                        skippedEvent = true;
                    }
                } else {
                    writer.add(event);
                }
                if (skippedEvent) continue;
                prevType = event.isEndElement() ? 1 : (event.isStartElement() ? 2 : 0);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return bos.toString();
    }

    private String getOffset(int offset) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < offset) {
            buf.append("\t");
            ++i;
        }
        return buf.toString();
    }
}

